/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.TexturesModel;

public final class Textures {

    public static class RemoveTexture
    extends AbstractCall<String> {
        public static final String API_TYPE = "Textures.RemoveTexture";

        public RemoveTexture(Integer n) {
            this.addParameter("textureid", n);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.getTextValue();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetTextures
    extends AbstractCall<TexturesModel.TextureDetail> {
        public static final String API_TYPE = "Textures.GetTextures";
        public static final String RESULT = "textures";

        public GetTextures(ListModel.TextureFilter textureFilter, String ... stringArray) {
            this.addParameter("filter", (AbstractModel)textureFilter);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<TexturesModel.TextureDetail> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<TexturesModel.TextureDetail> arrayList = new ArrayList<TexturesModel.TextureDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new TexturesModel.TextureDetail((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<TexturesModel.TextureDetail>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }
}

