/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;

public final class ListModel {

    public static interface OperatorFilters {
        public static final String CONTAINS = "contains";
        public static final String DOESNOTCONTAIN = "doesnotcontain";
        public static final String IS = "is";
        public static final String ISNOT = "isnot";
        public static final String STARTSWITH = "startswith";
        public static final String ENDSWITH = "endswith";
        public static final String GREATERTHAN = "greaterthan";
        public static final String LESSTHAN = "lessthan";
        public static final String AFTER = "after";
        public static final String BEFORE = "before";
        public static final String INTHELAST = "inthelast";
        public static final String NOTINTHELAST = "notinthelast";
        public static final String TRUE = "true";
        public static final String FALSE = "false";
        public static final String BETWEEN = "between";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("contains", "doesnotcontain", "is", "isnot", "startswith", "endswith", "greaterthan", "lessthan", "after", "before", "inthelast", "notinthelast", "true", "false", "between"));
    }

    public static interface TextureFilterFields {
        public static final String TEXTUREID = "textureid";
        public static final String URL = "url";
        public static final String CACHEDURL = "cachedurl";
        public static final String LASTHASHCHECK = "lasthashcheck";
        public static final String IMAGEHASH = "imagehash";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String USECOUNT = "usecount";
        public static final String LASTUSED = "lastused";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("textureid", "url", "cachedurl", "lasthashcheck", "imagehash", "width", "height", "usecount", "lastused"));
    }

    public static interface TVShowFilterFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String STATUS = "status";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String YEAR = "year";
        public static final String GENRE = "genre";
        public static final String DIRECTOR = "director";
        public static final String ACTOR = "actor";
        public static final String NUMEPISODES = "numepisodes";
        public static final String NUMWATCHED = "numwatched";
        public static final String PLAYCOUNT = "playcount";
        public static final String PATH = "path";
        public static final String STUDIO = "studio";
        public static final String MPAARATING = "mpaarating";
        public static final String DATEADDED = "dateadded";
        public static final String LASTPLAYED = "lastplayed";
        public static final String INPROGRESS = "inprogress";
        public static final String TAG = "tag";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "status", "votes", "rating", "year", "genre", "director", "actor", "numepisodes", "numwatched", "playcount", "path", "studio", "mpaarating", "dateadded", "lastplayed", "inprogress", "tag", "playlist", "virtualfolder"));
    }

    public static interface SongFilterFields {
        public static final String GENRE = "genre";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String TITLE = "title";
        public static final String YEAR = "year";
        public static final String TIME = "time";
        public static final String TRACKNUMBER = "tracknumber";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String RATING = "rating";
        public static final String COMMENT = "comment";
        public static final String MOODS = "moods";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "title", "year", "time", "tracknumber", "filename", "path", "playcount", "lastplayed", "rating", "comment", "moods", "playlist", "virtualfolder"));
    }

    public static interface MusicVideoFilterFields {
        public static final String TITLE = "title";
        public static final String GENRE = "genre";
        public static final String ALBUM = "album";
        public static final String YEAR = "year";
        public static final String ARTIST = "artist";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String TIME = "time";
        public static final String DIRECTOR = "director";
        public static final String STUDIO = "studio";
        public static final String PLOT = "plot";
        public static final String TAG = "tag";
        public static final String DATEADDED = "dateadded";
        public static final String VIDEORESOLUTION = "videoresolution";
        public static final String AUDIOCHANNELS = "audiochannels";
        public static final String VIDEOCODEC = "videocodec";
        public static final String AUDIOCODEC = "audiocodec";
        public static final String AUDIOLANGUAGE = "audiolanguage";
        public static final String SUBTITLELANGUAGE = "subtitlelanguage";
        public static final String VIDEOASPECT = "videoaspect";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "album", "year", "artist", "filename", "path", "playcount", "lastplayed", "time", "director", "studio", "plot", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
    }

    public static interface MovieFilterFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String TAGLINE = "tagline";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String TIME = "time";
        public static final String WRITERS = "writers";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String INPROGRESS = "inprogress";
        public static final String GENRE = "genre";
        public static final String COUNTRY = "country";
        public static final String YEAR = "year";
        public static final String DIRECTOR = "director";
        public static final String ACTOR = "actor";
        public static final String MPAARATING = "mpaarating";
        public static final String TOP250 = "top250";
        public static final String STUDIO = "studio";
        public static final String HASTRAILER = "hastrailer";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String SET = "set";
        public static final String TAG = "tag";
        public static final String DATEADDED = "dateadded";
        public static final String VIDEORESOLUTION = "videoresolution";
        public static final String AUDIOCHANNELS = "audiochannels";
        public static final String VIDEOCODEC = "videocodec";
        public static final String AUDIOCODEC = "audiocodec";
        public static final String AUDIOLANGUAGE = "audiolanguage";
        public static final String SUBTITLELANGUAGE = "subtitlelanguage";
        public static final String VIDEOASPECT = "videoaspect";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "tagline", "votes", "rating", "time", "writers", "playcount", "lastplayed", "inprogress", "genre", "country", "year", "director", "actor", "mpaarating", "top250", "studio", "hastrailer", "filename", "path", "set", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
    }

    public static interface EpisodeFilterFields {
        public static final String TITLE = "title";
        public static final String TVSHOW = "tvshow";
        public static final String PLOT = "plot";
        public static final String VOTES = "votes";
        public static final String RATING = "rating";
        public static final String TIME = "time";
        public static final String WRITERS = "writers";
        public static final String AIRDATE = "airdate";
        public static final String PLAYCOUNT = "playcount";
        public static final String LASTPLAYED = "lastplayed";
        public static final String INPROGRESS = "inprogress";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String DIRECTOR = "director";
        public static final String ACTOR = "actor";
        public static final String EPISODE = "episode";
        public static final String SEASON = "season";
        public static final String FILENAME = "filename";
        public static final String PATH = "path";
        public static final String STUDIO = "studio";
        public static final String MPAARATING = "mpaarating";
        public static final String DATEADDED = "dateadded";
        public static final String TAG = "tag";
        public static final String VIDEORESOLUTION = "videoresolution";
        public static final String AUDIOCHANNELS = "audiochannels";
        public static final String VIDEOCODEC = "videocodec";
        public static final String AUDIOCODEC = "audiocodec";
        public static final String AUDIOLANGUAGE = "audiolanguage";
        public static final String SUBTITLELANGUAGE = "subtitlelanguage";
        public static final String VIDEOASPECT = "videoaspect";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "tvshow", "plot", "votes", "rating", "time", "writers", "airdate", "playcount", "lastplayed", "inprogress", "genre", "year", "director", "actor", "episode", "season", "filename", "path", "studio", "mpaarating", "dateadded", "tag", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
    }

    public static interface ArtistFilterFields {
        public static final String ARTIST = "artist";
        public static final String GENRE = "genre";
        public static final String MOODS = "moods";
        public static final String STYLES = "styles";
        public static final String INSTRUMENTS = "instruments";
        public static final String BIOGRAPHY = "biography";
        public static final String BORN = "born";
        public static final String BANDFORMED = "bandformed";
        public static final String DISBANDED = "disbanded";
        public static final String DIED = "died";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("artist", "genre", "moods", "styles", "instruments", "biography", "born", "bandformed", "disbanded", "died", "playlist", "virtualfolder"));
    }

    public static interface AlbumFilterFields {
        public static final String GENRE = "genre";
        public static final String ALBUM = "album";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String YEAR = "year";
        public static final String REVIEW = "review";
        public static final String THEMES = "themes";
        public static final String MOODS = "moods";
        public static final String STYLES = "styles";
        public static final String TYPE = "type";
        public static final String LABEL = "label";
        public static final String RATING = "rating";
        public static final String PLAYCOUNT = "playcount";
        public static final String PLAYLIST = "playlist";
        public static final String VIRTUALFOLDER = "virtualfolder";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "year", "review", "themes", "moods", "styles", "type", "label", "rating", "playcount", "playlist", "virtualfolder"));
    }

    public static interface FileFields {
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String ALBUM = "album";
        public static final String TRACK = "track";
        public static final String DURATION = "duration";
        public static final String COMMENT = "comment";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String DIRECTOR = "director";
        public static final String TRAILER = "trailer";
        public static final String TAGLINE = "tagline";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String LASTPLAYED = "lastplayed";
        public static final String WRITER = "writer";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String PREMIERED = "premiered";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RUNTIME = "runtime";
        public static final String SET = "set";
        public static final String SHOWLINK = "showlink";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String TOP250 = "top250";
        public static final String VOTES = "votes";
        public static final String FIRSTAIRED = "firstaired";
        public static final String SEASON = "season";
        public static final String EPISODE = "episode";
        public static final String SHOWTITLE = "showtitle";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String ARTISTID = "artistid";
        public static final String ALBUMID = "albumid";
        public static final String TVSHOWID = "tvshowid";
        public static final String SETID = "setid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String DISC = "disc";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String GENREID = "genreid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String DESCRIPTION = "description";
        public static final String THEME = "theme";
        public static final String MOOD = "mood";
        public static final String STYLE = "style";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String SORTTITLE = "sorttitle";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String UNIQUEID = "uniqueid";
        public static final String DATEADDED = "dateadded";
        public static final String SIZE = "size";
        public static final String LASTMODIFIED = "lastmodified";
        public static final String MIMETYPE = "mimetype";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "artist", "albumartist", "genre", "year", "rating", "album", "track", "duration", "comment", "lyrics", "musicbrainztrackid", "musicbrainzartistid", "musicbrainzalbumid", "musicbrainzalbumartistid", "playcount", "fanart", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "premiered", "productioncode", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "firstaired", "season", "episode", "showtitle", "thumbnail", "file", "resume", "artistid", "albumid", "tvshowid", "setid", "watchedepisodes", "disc", "tag", "art", "genreid", "displayartist", "albumartistid", "description", "theme", "mood", "style", "albumlabel", "sorttitle", "episodeguide", "uniqueid", "dateadded", "size", "lastmodified", "mimetype", "specialsortseason", "specialsortepisode"));
    }

    public static interface AllFields {
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUMARTIST = "albumartist";
        public static final String GENRE = "genre";
        public static final String YEAR = "year";
        public static final String RATING = "rating";
        public static final String ALBUM = "album";
        public static final String TRACK = "track";
        public static final String DURATION = "duration";
        public static final String COMMENT = "comment";
        public static final String LYRICS = "lyrics";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String PLAYCOUNT = "playcount";
        public static final String FANART = "fanart";
        public static final String DIRECTOR = "director";
        public static final String TRAILER = "trailer";
        public static final String TAGLINE = "tagline";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String LASTPLAYED = "lastplayed";
        public static final String WRITER = "writer";
        public static final String STUDIO = "studio";
        public static final String MPAA = "mpaa";
        public static final String CAST = "cast";
        public static final String COUNTRY = "country";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String PREMIERED = "premiered";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RUNTIME = "runtime";
        public static final String SET = "set";
        public static final String SHOWLINK = "showlink";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String TOP250 = "top250";
        public static final String VOTES = "votes";
        public static final String FIRSTAIRED = "firstaired";
        public static final String SEASON = "season";
        public static final String EPISODE = "episode";
        public static final String SHOWTITLE = "showtitle";
        public static final String THUMBNAIL = "thumbnail";
        public static final String FILE = "file";
        public static final String RESUME = "resume";
        public static final String ARTISTID = "artistid";
        public static final String ALBUMID = "albumid";
        public static final String TVSHOWID = "tvshowid";
        public static final String SETID = "setid";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String DISC = "disc";
        public static final String TAG = "tag";
        public static final String ART = "art";
        public static final String GENREID = "genreid";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String DESCRIPTION = "description";
        public static final String THEME = "theme";
        public static final String MOOD = "mood";
        public static final String STYLE = "style";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String SORTTITLE = "sorttitle";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String UNIQUEID = "uniqueid";
        public static final String DATEADDED = "dateadded";
        public static final String CHANNEL = "channel";
        public static final String CHANNELTYPE = "channeltype";
        public static final String HIDDEN = "hidden";
        public static final String LOCKED = "locked";
        public static final String CHANNELNUMBER = "channelnumber";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String COMPILATION = "compilation";
        public static final String RELEASETYPE = "releasetype";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "artist", "albumartist", "genre", "year", "rating", "album", "track", "duration", "comment", "lyrics", "musicbrainztrackid", "musicbrainzartistid", "musicbrainzalbumid", "musicbrainzalbumartistid", "playcount", "fanart", "director", "trailer", "tagline", "plot", "plotoutline", "originaltitle", "lastplayed", "writer", "studio", "mpaa", "cast", "country", "imdbnumber", "premiered", "productioncode", "runtime", "set", "showlink", "streamdetails", "top250", "votes", "firstaired", "season", "episode", "showtitle", "thumbnail", "file", "resume", "artistid", "albumid", "tvshowid", "setid", "watchedepisodes", "disc", "tag", "art", "genreid", "displayartist", "albumartistid", "description", "theme", "mood", "style", "albumlabel", "sorttitle", "episodeguide", "uniqueid", "dateadded", "channel", "channeltype", "hidden", "locked", "channelnumber", "starttime", "endtime", "specialsortseason", "specialsortepisode", "compilation", "releasetype", "albumreleasetype"));
    }

    public static class Sort
    extends AbstractModel {
        public static final String API_TYPE = "List.Sort";
        public static final String IGNOREARTICLE = "ignorearticle";
        public static final String METHOD = "method";
        public static final String ORDER = "order";
        public final Boolean ignorearticle;
        public final String method;
        public final String order;

        public Sort(Boolean bl, String string, String string2) {
            this.ignorearticle = bl;
            this.method = string;
            this.order = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(IGNOREARTICLE, this.ignorearticle);
            objectNode.put(METHOD, this.method);
            objectNode.put(ORDER, this.order);
            return objectNode;
        }

        public static interface Method {
            public static final String NONE = "none";
            public static final String LABEL = "label";
            public static final String DATE = "date";
            public static final String SIZE = "size";
            public static final String FILE = "file";
            public static final String PATH = "path";
            public static final String DRIVETYPE = "drivetype";
            public static final String TITLE = "title";
            public static final String TRACK = "track";
            public static final String TIME = "time";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String ALBUMTYPE = "albumtype";
            public static final String GENRE = "genre";
            public static final String COUNTRY = "country";
            public static final String YEAR = "year";
            public static final String RATING = "rating";
            public static final String VOTES = "votes";
            public static final String TOP250 = "top250";
            public static final String PROGRAMCOUNT = "programcount";
            public static final String PLAYLIST = "playlist";
            public static final String EPISODE = "episode";
            public static final String SEASON = "season";
            public static final String TOTALEPISODES = "totalepisodes";
            public static final String WATCHEDEPISODES = "watchedepisodes";
            public static final String TVSHOWSTATUS = "tvshowstatus";
            public static final String TVSHOWTITLE = "tvshowtitle";
            public static final String SORTTITLE = "sorttitle";
            public static final String PRODUCTIONCODE = "productioncode";
            public static final String MPAA = "mpaa";
            public static final String STUDIO = "studio";
            public static final String DATEADDED = "dateadded";
            public static final String LASTPLAYED = "lastplayed";
            public static final String PLAYCOUNT = "playcount";
            public static final String LISTENERS = "listeners";
            public static final String BITRATE = "bitrate";
            public static final String RANDOM = "random";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("none", "label", "date", "size", "file", "path", "drivetype", "title", "track", "time", "artist", "album", "albumtype", "genre", "country", "year", "rating", "votes", "top250", "programcount", "playlist", "episode", "season", "totalepisodes", "watchedepisodes", "tvshowstatus", "tvshowtitle", "sorttitle", "productioncode", "mpaa", "studio", "dateadded", "lastplayed", "playcount", "listeners", "bitrate", "random"));
        }

        public static interface Order {
            public static final String ASCENDING = "ascending";
            public static final String DESCENDING = "descending";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("ascending", "descending"));
        }
    }

    public static class LimitsReturned
    extends AbstractModel {
        public static final String API_TYPE = "List.LimitsReturned";
        public static final String END = "end";
        public static final String START = "start";
        public static final String TOTAL = "total";
        public final Integer end;
        public final Integer start;
        public final Integer total;

        public LimitsReturned(Integer n, Integer n2, Integer n3) {
            this.end = n;
            this.start = n2;
            this.total = n3;
        }

        public LimitsReturned(JsonNode jsonNode) {
            this.end = LimitsReturned.parseInt(jsonNode, END);
            this.start = LimitsReturned.parseInt(jsonNode, START);
            this.total = jsonNode.get(TOTAL).getIntValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(END, this.end);
            objectNode.put(START, this.start);
            objectNode.put(TOTAL, this.total);
            return objectNode;
        }

        static List<LimitsReturned> getListModelLimitsReturnedList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<LimitsReturned> arrayList = new ArrayList<LimitsReturned>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new LimitsReturned(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<LimitsReturned>(0);
        }
    }

    public static class Limits
    extends AbstractModel {
        public static final String API_TYPE = "List.Limits";
        public static final String END = "end";
        public static final String START = "start";
        public final Integer end;
        public final Integer start;

        public Limits(Integer n, Integer n2) {
            this.end = n;
            this.start = n2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(END, this.end);
            objectNode.put(START, this.start);
            return objectNode;
        }
    }

    public static class SourceItem
    extends ItemModel.BaseDetail {
        public static final String FILE = "file";
        public final String file;

        public SourceItem(JsonNode jsonNode) {
            super(jsonNode);
            this.file = jsonNode.get(FILE).getTextValue();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FILE, this.file);
            return objectNode;
        }

        static List<SourceItem> getListModelSourceItemList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SourceItem> arrayList = new ArrayList<SourceItem>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SourceItem(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SourceItem>(0);
        }
    }

    public static class FileItem
    extends BaseItem {
        public static final String API_TYPE = "List.Item.File";
        public static final String FILE = "file";
        public static final String FILETYPE = "filetype";
        public static final String LASTMODIFIED = "lastmodified";
        public static final String MIMETYPE = "mimetype";
        public static final String SIZE = "size";
        public final String file;
        public final String filetype;
        public final String lastmodified;
        public final String mimetype;
        public final Integer size;

        public FileItem(JsonNode jsonNode) {
            super(jsonNode);
            this.file = jsonNode.get(FILE).getTextValue();
            this.filetype = FileItem.parseString(jsonNode, FILETYPE);
            this.lastmodified = FileItem.parseString(jsonNode, LASTMODIFIED);
            this.mimetype = FileItem.parseString(jsonNode, MIMETYPE);
            this.size = FileItem.parseInt(jsonNode, SIZE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FILE, this.file);
            objectNode.put(FILETYPE, this.filetype);
            objectNode.put(LASTMODIFIED, this.lastmodified);
            objectNode.put(MIMETYPE, this.mimetype);
            objectNode.put(SIZE, this.size);
            return objectNode;
        }

        static List<FileItem> getListModelFileItemList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<FileItem> arrayList = new ArrayList<FileItem>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new FileItem(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<FileItem>(0);
        }

        public static interface Filetype {
            public static final String FILE = "file";
            public static final String DIRECTORY = "directory";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("file", "directory"));
        }
    }

    public static class BaseItem
    extends AbstractModel {
        public static final String API_TYPE = "List.Item.Base";
        public static final String ALBUM = "album";
        public static final String ALBUMARTIST = "albumartist";
        public static final String ALBUMARTISTID = "albumartistid";
        public static final String ALBUMID = "albumid";
        public static final String ALBUMLABEL = "albumlabel";
        public static final String ALBUMRELEASETYPE = "albumreleasetype";
        public static final String ART = "art";
        public static final String ARTIST = "artist";
        public static final String ARTISTID = "artistid";
        public static final String CAST = "cast";
        public static final String COMMENT = "comment";
        public static final String COMPILATION = "compilation";
        public static final String COUNTRY = "country";
        public static final String DATEADDED = "dateadded";
        public static final String DESCRIPTION = "description";
        public static final String DIRECTOR = "director";
        public static final String DISC = "disc";
        public static final String DISPLAYARTIST = "displayartist";
        public static final String DURATION = "duration";
        public static final String EPISODE = "episode";
        public static final String EPISODEGUIDE = "episodeguide";
        public static final String FANART = "fanart";
        public static final String FILE = "file";
        public static final String FIRSTAIRED = "firstaired";
        public static final String GENRE = "genre";
        public static final String GENREID = "genreid";
        public static final String ID = "id";
        public static final String IMDBNUMBER = "imdbnumber";
        public static final String LABEL = "label";
        public static final String LASTPLAYED = "lastplayed";
        public static final String LYRICS = "lyrics";
        public static final String MOOD = "mood";
        public static final String MPAA = "mpaa";
        public static final String MUSICBRAINZALBUMARTISTID = "musicbrainzalbumartistid";
        public static final String MUSICBRAINZALBUMID = "musicbrainzalbumid";
        public static final String MUSICBRAINZARTISTID = "musicbrainzartistid";
        public static final String MUSICBRAINZTRACKID = "musicbrainztrackid";
        public static final String ORIGINALTITLE = "originaltitle";
        public static final String PLAYCOUNT = "playcount";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String PREMIERED = "premiered";
        public static final String PRODUCTIONCODE = "productioncode";
        public static final String RATING = "rating";
        public static final String RELEASETYPE = "releasetype";
        public static final String RESUME = "resume";
        public static final String RUNTIME = "runtime";
        public static final String SEASON = "season";
        public static final String SET = "set";
        public static final String SETID = "setid";
        public static final String SHOWLINK = "showlink";
        public static final String SHOWTITLE = "showtitle";
        public static final String SORTTITLE = "sorttitle";
        public static final String SPECIALSORTEPISODE = "specialsortepisode";
        public static final String SPECIALSORTSEASON = "specialsortseason";
        public static final String STREAMDETAILS = "streamdetails";
        public static final String STUDIO = "studio";
        public static final String STYLE = "style";
        public static final String TAG = "tag";
        public static final String TAGLINE = "tagline";
        public static final String THEME = "theme";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TITLE = "title";
        public static final String TOP250 = "top250";
        public static final String TRACK = "track";
        public static final String TRAILER = "trailer";
        public static final String TVSHOWID = "tvshowid";
        public static final String TYPE = "type";
        public static final String UNIQUEID = "uniqueid";
        public static final String VOTES = "votes";
        public static final String WATCHEDEPISODES = "watchedepisodes";
        public static final String WRITER = "writer";
        public static final String YEAR = "year";
        public final String album;
        public final List<String> albumartist;
        public final List<Integer> albumartistid;
        public final Integer albumid;
        public final String albumlabel;
        public final String albumreleasetype;
        public final MediaModel.Artwork art;
        public final List<String> artist;
        public final List<Integer> artistid;
        public final List<VideoModel.Cast> cast;
        public final String comment;
        public final Boolean compilation;
        public final List<String> country;
        public final String dateadded;
        public final String description;
        public final List<String> director;
        public final Integer disc;
        public final String displayartist;
        public final Integer duration;
        public final Integer episode;
        public final String episodeguide;
        public final String fanart;
        public final String file;
        public final String firstaired;
        public final List<String> genre;
        public final List<Integer> genreid;
        public final Integer id;
        public final String imdbnumber;
        public final String label;
        public final String lastplayed;
        public final String lyrics;
        public final List<String> mood;
        public final String mpaa;
        public final String musicbrainzalbumartistid;
        public final String musicbrainzalbumid;
        public final String musicbrainzartistid;
        public final String musicbrainztrackid;
        public final String originaltitle;
        public final Integer playcount;
        public final String plot;
        public final String plotoutline;
        public final String premiered;
        public final String productioncode;
        public final Integer rating;
        public final String releasetype;
        public final VideoModel.Resume resume;
        public final Integer runtime;
        public final Integer season;
        public final String set;
        public final Integer setid;
        public final List<String> showlink;
        public final String showtitle;
        public final String sorttitle;
        public final Integer specialsortepisode;
        public final Integer specialsortseason;
        public final VideoModel.Streams streamdetails;
        public final List<String> studio;
        public final List<String> style;
        public final List<String> tag;
        public final String tagline;
        public final List<String> theme;
        public final String thumbnail;
        public final String title;
        public final Integer top250;
        public final Integer track;
        public final String trailer;
        public final Integer tvshowid;
        public final String type;
        public final HashMap<String, String> uniqueid;
        public final String votes;
        public final Integer watchedepisodes;
        public final List<String> writer;
        public final Integer year;

        public BaseItem(String string, List<String> list, List<Integer> list2, Integer n, String string2, String string3, MediaModel.Artwork artwork, List<String> list3, List<Integer> list4, List<VideoModel.Cast> list5, String string4, Boolean bl, List<String> list6, String string5, String string6, List<String> list7, Integer n2, String string7, Integer n3, Integer n4, String string8, String string9, String string10, String string11, List<String> list8, List<Integer> list9, Integer n5, String string12, String string13, String string14, String string15, List<String> list10, String string16, String string17, String string18, String string19, String string20, String string21, Integer n6, String string22, String string23, String string24, String string25, Integer n7, String string26, VideoModel.Resume resume, Integer n8, Integer n9, String string27, Integer n10, List<String> list11, String string28, String string29, Integer n11, Integer n12, VideoModel.Streams streams, List<String> list12, List<String> list13, List<String> list14, String string30, List<String> list15, String string31, String string32, Integer n13, Integer n14, String string33, Integer n15, String string34, HashMap<String, String> hashMap, String string35, Integer n16, List<String> list16, Integer n17) {
            this.album = string;
            this.albumartist = list;
            this.albumartistid = list2;
            this.albumid = n;
            this.albumlabel = string2;
            this.albumreleasetype = string3;
            this.art = artwork;
            this.artist = list3;
            this.artistid = list4;
            this.cast = list5;
            this.comment = string4;
            this.compilation = bl;
            this.country = list6;
            this.dateadded = string5;
            this.description = string6;
            this.director = list7;
            this.disc = n2;
            this.displayartist = string7;
            this.duration = n3;
            this.episode = n4;
            this.episodeguide = string8;
            this.fanart = string9;
            this.file = string10;
            this.firstaired = string11;
            this.genre = list8;
            this.genreid = list9;
            this.id = n5;
            this.imdbnumber = string12;
            this.label = string13;
            this.lastplayed = string14;
            this.lyrics = string15;
            this.mood = list10;
            this.mpaa = string16;
            this.musicbrainzalbumartistid = string17;
            this.musicbrainzalbumid = string18;
            this.musicbrainzartistid = string19;
            this.musicbrainztrackid = string20;
            this.originaltitle = string21;
            this.playcount = n6;
            this.plot = string22;
            this.plotoutline = string23;
            this.premiered = string24;
            this.productioncode = string25;
            this.rating = n7;
            this.releasetype = string26;
            this.resume = resume;
            this.runtime = n8;
            this.season = n9;
            this.set = string27;
            this.setid = n10;
            this.showlink = list11;
            this.showtitle = string28;
            this.sorttitle = string29;
            this.specialsortepisode = n11;
            this.specialsortseason = n12;
            this.streamdetails = streams;
            this.studio = list12;
            this.style = list13;
            this.tag = list14;
            this.tagline = string30;
            this.theme = list15;
            this.thumbnail = string31;
            this.title = string32;
            this.top250 = n13;
            this.track = n14;
            this.trailer = string33;
            this.tvshowid = n15;
            this.type = string34;
            this.uniqueid = hashMap;
            this.votes = string35;
            this.watchedepisodes = n16;
            this.writer = list16;
            this.year = n17;
        }

        public BaseItem(JsonNode jsonNode) {
            this.album = BaseItem.parseString(jsonNode, ALBUM);
            this.albumartist = BaseItem.getStringArray(jsonNode, ALBUMARTIST);
            this.albumartistid = BaseItem.getIntegerArray(jsonNode, ALBUMARTISTID);
            this.albumid = BaseItem.parseInt(jsonNode, ALBUMID);
            this.albumlabel = BaseItem.parseString(jsonNode, ALBUMLABEL);
            this.albumreleasetype = BaseItem.parseString(jsonNode, ALBUMRELEASETYPE);
            this.art = jsonNode.has(ART) ? new MediaModel.Artwork(jsonNode.get(ART)) : null;
            this.artist = BaseItem.getStringArray(jsonNode, ARTIST);
            this.artistid = BaseItem.getIntegerArray(jsonNode, ARTISTID);
            this.cast = VideoModel.Cast.getVideoModelCastList(jsonNode, CAST);
            this.comment = BaseItem.parseString(jsonNode, COMMENT);
            this.compilation = BaseItem.parseBoolean(jsonNode, COMPILATION);
            this.country = BaseItem.getStringArray(jsonNode, COUNTRY);
            this.dateadded = BaseItem.parseString(jsonNode, DATEADDED);
            this.description = BaseItem.parseString(jsonNode, DESCRIPTION);
            this.director = BaseItem.getStringArray(jsonNode, DIRECTOR);
            this.disc = BaseItem.parseInt(jsonNode, DISC);
            this.displayartist = BaseItem.parseString(jsonNode, DISPLAYARTIST);
            this.duration = BaseItem.parseInt(jsonNode, DURATION);
            this.episode = BaseItem.parseInt(jsonNode, EPISODE);
            this.episodeguide = BaseItem.parseString(jsonNode, EPISODEGUIDE);
            this.fanart = BaseItem.parseString(jsonNode, FANART);
            this.file = BaseItem.parseString(jsonNode, FILE);
            this.firstaired = BaseItem.parseString(jsonNode, FIRSTAIRED);
            this.genre = BaseItem.getStringArray(jsonNode, GENRE);
            this.genreid = BaseItem.getIntegerArray(jsonNode, GENREID);
            this.id = BaseItem.parseInt(jsonNode, ID);
            this.imdbnumber = BaseItem.parseString(jsonNode, IMDBNUMBER);
            this.label = jsonNode.get(LABEL).getTextValue();
            this.lastplayed = BaseItem.parseString(jsonNode, LASTPLAYED);
            this.lyrics = BaseItem.parseString(jsonNode, LYRICS);
            this.mood = BaseItem.getStringArray(jsonNode, MOOD);
            this.mpaa = BaseItem.parseString(jsonNode, MPAA);
            this.musicbrainzalbumartistid = BaseItem.parseString(jsonNode, MUSICBRAINZALBUMARTISTID);
            this.musicbrainzalbumid = BaseItem.parseString(jsonNode, MUSICBRAINZALBUMID);
            this.musicbrainzartistid = BaseItem.parseString(jsonNode, MUSICBRAINZARTISTID);
            this.musicbrainztrackid = BaseItem.parseString(jsonNode, MUSICBRAINZTRACKID);
            this.originaltitle = BaseItem.parseString(jsonNode, ORIGINALTITLE);
            this.playcount = BaseItem.parseInt(jsonNode, PLAYCOUNT);
            this.plot = BaseItem.parseString(jsonNode, PLOT);
            this.plotoutline = BaseItem.parseString(jsonNode, PLOTOUTLINE);
            this.premiered = BaseItem.parseString(jsonNode, PREMIERED);
            this.productioncode = BaseItem.parseString(jsonNode, PRODUCTIONCODE);
            this.rating = BaseItem.parseInt(jsonNode, RATING);
            this.releasetype = BaseItem.parseString(jsonNode, RELEASETYPE);
            this.resume = jsonNode.has(RESUME) ? new VideoModel.Resume(jsonNode.get(RESUME)) : null;
            this.runtime = BaseItem.parseInt(jsonNode, RUNTIME);
            this.season = BaseItem.parseInt(jsonNode, SEASON);
            this.set = BaseItem.parseString(jsonNode, SET);
            this.setid = BaseItem.parseInt(jsonNode, SETID);
            this.showlink = BaseItem.getStringArray(jsonNode, SHOWLINK);
            this.showtitle = BaseItem.parseString(jsonNode, SHOWTITLE);
            this.sorttitle = BaseItem.parseString(jsonNode, SORTTITLE);
            this.specialsortepisode = BaseItem.parseInt(jsonNode, SPECIALSORTEPISODE);
            this.specialsortseason = BaseItem.parseInt(jsonNode, SPECIALSORTSEASON);
            this.streamdetails = jsonNode.has(STREAMDETAILS) ? new VideoModel.Streams(jsonNode.get(STREAMDETAILS)) : null;
            this.studio = BaseItem.getStringArray(jsonNode, STUDIO);
            this.style = BaseItem.getStringArray(jsonNode, STYLE);
            this.tag = BaseItem.getStringArray(jsonNode, TAG);
            this.tagline = BaseItem.parseString(jsonNode, TAGLINE);
            this.theme = BaseItem.getStringArray(jsonNode, THEME);
            this.thumbnail = BaseItem.parseString(jsonNode, THUMBNAIL);
            this.title = BaseItem.parseString(jsonNode, TITLE);
            this.top250 = BaseItem.parseInt(jsonNode, TOP250);
            this.track = BaseItem.parseInt(jsonNode, TRACK);
            this.trailer = BaseItem.parseString(jsonNode, TRAILER);
            this.tvshowid = BaseItem.parseInt(jsonNode, TVSHOWID);
            this.type = BaseItem.parseString(jsonNode, TYPE);
            this.uniqueid = BaseItem.getStringMap(jsonNode, UNIQUEID);
            this.votes = BaseItem.parseString(jsonNode, VOTES);
            this.watchedepisodes = BaseItem.parseInt(jsonNode, WATCHEDEPISODES);
            this.writer = BaseItem.getStringArray(jsonNode, WRITER);
            this.year = BaseItem.parseInt(jsonNode, YEAR);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(ALBUM, this.album);
            ArrayNode arrayNode = OM.createArrayNode();
            for (String object152 : this.albumartist) {
                arrayNode.add(object152);
            }
            objectNode.put(ALBUMARTIST, (JsonNode)arrayNode);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Integer n : this.albumartistid) {
                arrayNode2.add(n);
            }
            objectNode.put(ALBUMARTISTID, (JsonNode)arrayNode2);
            objectNode.put(ALBUMID, this.albumid);
            objectNode.put(ALBUMLABEL, this.albumlabel);
            objectNode.put(ALBUMRELEASETYPE, this.albumreleasetype);
            objectNode.put(ART, this.art == null ? null : this.art.toJsonNode());
            ArrayNode arrayNode3 = OM.createArrayNode();
            for (String string : this.artist) {
                arrayNode3.add(string);
            }
            objectNode.put(ARTIST, (JsonNode)arrayNode3);
            ArrayNode arrayNode4 = OM.createArrayNode();
            for (Integer n : this.artistid) {
                arrayNode4.add(n);
            }
            objectNode.put(ARTISTID, (JsonNode)arrayNode4);
            ArrayNode arrayNode5 = OM.createArrayNode();
            for (VideoModel.Cast cast : this.cast) {
                arrayNode5.add(cast.toJsonNode());
            }
            objectNode.put(CAST, (JsonNode)arrayNode5);
            objectNode.put(COMMENT, this.comment);
            objectNode.put(COMPILATION, this.compilation);
            ArrayNode arrayNode6 = OM.createArrayNode();
            for (String string : this.country) {
                arrayNode6.add(string);
            }
            objectNode.put(COUNTRY, (JsonNode)arrayNode6);
            objectNode.put(DATEADDED, this.dateadded);
            objectNode.put(DESCRIPTION, this.description);
            ArrayNode arrayNode7 = OM.createArrayNode();
            for (String string : this.director) {
                arrayNode7.add(string);
            }
            objectNode.put(DIRECTOR, (JsonNode)arrayNode7);
            objectNode.put(DISC, this.disc);
            objectNode.put(DISPLAYARTIST, this.displayartist);
            objectNode.put(DURATION, this.duration);
            objectNode.put(EPISODE, this.episode);
            objectNode.put(EPISODEGUIDE, this.episodeguide);
            objectNode.put(FANART, this.fanart);
            objectNode.put(FILE, this.file);
            objectNode.put(FIRSTAIRED, this.firstaired);
            ArrayNode arrayNode8 = OM.createArrayNode();
            for (String string : this.genre) {
                arrayNode8.add(string);
            }
            objectNode.put(GENRE, (JsonNode)arrayNode8);
            ArrayNode arrayNode9 = OM.createArrayNode();
            for (Integer n : this.genreid) {
                arrayNode9.add(n);
            }
            objectNode.put(GENREID, (JsonNode)arrayNode9);
            objectNode.put(ID, this.id);
            objectNode.put(IMDBNUMBER, this.imdbnumber);
            objectNode.put(LABEL, this.label);
            objectNode.put(LASTPLAYED, this.lastplayed);
            objectNode.put(LYRICS, this.lyrics);
            ArrayNode arrayNode10 = OM.createArrayNode();
            for (String string : this.mood) {
                arrayNode10.add(string);
            }
            objectNode.put(MOOD, (JsonNode)arrayNode10);
            objectNode.put(MPAA, this.mpaa);
            objectNode.put(MUSICBRAINZALBUMARTISTID, this.musicbrainzalbumartistid);
            objectNode.put(MUSICBRAINZALBUMID, this.musicbrainzalbumid);
            objectNode.put(MUSICBRAINZARTISTID, this.musicbrainzartistid);
            objectNode.put(MUSICBRAINZTRACKID, this.musicbrainztrackid);
            objectNode.put(ORIGINALTITLE, this.originaltitle);
            objectNode.put(PLAYCOUNT, this.playcount);
            objectNode.put(PLOT, this.plot);
            objectNode.put(PLOTOUTLINE, this.plotoutline);
            objectNode.put(PREMIERED, this.premiered);
            objectNode.put(PRODUCTIONCODE, this.productioncode);
            objectNode.put(RATING, this.rating);
            objectNode.put(RELEASETYPE, this.releasetype);
            objectNode.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
            objectNode.put(RUNTIME, this.runtime);
            objectNode.put(SEASON, this.season);
            objectNode.put(SET, this.set);
            objectNode.put(SETID, this.setid);
            ArrayNode arrayNode11 = OM.createArrayNode();
            for (String string : this.showlink) {
                arrayNode11.add(string);
            }
            objectNode.put(SHOWLINK, (JsonNode)arrayNode11);
            objectNode.put(SHOWTITLE, this.showtitle);
            objectNode.put(SORTTITLE, this.sorttitle);
            objectNode.put(SPECIALSORTEPISODE, this.specialsortepisode);
            objectNode.put(SPECIALSORTSEASON, this.specialsortseason);
            objectNode.put(STREAMDETAILS, this.streamdetails == null ? null : this.streamdetails.toJsonNode());
            ArrayNode arrayNode12 = OM.createArrayNode();
            for (String string : this.studio) {
                arrayNode12.add(string);
            }
            objectNode.put(STUDIO, (JsonNode)arrayNode12);
            ArrayNode arrayNode13 = OM.createArrayNode();
            for (String string : this.style) {
                arrayNode13.add(string);
            }
            objectNode.put(STYLE, (JsonNode)arrayNode13);
            ArrayNode arrayNode14 = OM.createArrayNode();
            for (String string : this.tag) {
                arrayNode14.add(string);
            }
            objectNode.put(TAG, (JsonNode)arrayNode14);
            objectNode.put(TAGLINE, this.tagline);
            ArrayNode arrayNode15 = OM.createArrayNode();
            for (String string : this.theme) {
                arrayNode15.add(string);
            }
            objectNode.put(THEME, (JsonNode)arrayNode15);
            objectNode.put(THUMBNAIL, this.thumbnail);
            objectNode.put(TITLE, this.title);
            objectNode.put(TOP250, this.top250);
            objectNode.put(TRACK, this.track);
            objectNode.put(TRAILER, this.trailer);
            objectNode.put(TVSHOWID, this.tvshowid);
            objectNode.put(TYPE, this.type);
            ObjectNode objectNode2 = OM.createObjectNode();
            for (String string : this.uniqueid.values()) {
                objectNode2.put(string, this.uniqueid.get(string));
            }
            objectNode.put(UNIQUEID, (JsonNode)objectNode2);
            objectNode.put(VOTES, this.votes);
            objectNode.put(WATCHEDEPISODES, this.watchedepisodes);
            ArrayNode arrayNode16 = OM.createArrayNode();
            for (String string : this.writer) {
                arrayNode16.add(string);
            }
            objectNode.put(WRITER, (JsonNode)arrayNode16);
            objectNode.put(YEAR, this.year);
            return objectNode;
        }

        static List<BaseItem> getListModelBaseItemList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<BaseItem> arrayList = new ArrayList<BaseItem>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new BaseItem(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<BaseItem>(0);
        }

        public static interface Releasetype {
            public static final String ALBUM = "album";
            public static final String SINGLE = "single";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("album", "single"));
        }

        public static interface Albumreleasetype {
            public static final String ALBUM = "album";
            public static final String SINGLE = "single";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("album", "single"));
        }

        public static interface Type {
            public static final String UNKNOWN = "unknown";
            public static final String MOVIE = "movie";
            public static final String EPISODE = "episode";
            public static final String MUSICVIDEO = "musicvideo";
            public static final String SONG = "song";
            public static final String PICTURE = "picture";
            public static final String CHANNEL = "channel";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "movie", "episode", "musicvideo", "song", "picture", "channel"));
        }
    }

    public static class AllItems
    extends BaseItem {
        public static final String API_TYPE = "List.Item.All";
        public static final String CHANNEL = "channel";
        public static final String CHANNELNUMBER = "channelnumber";
        public static final String CHANNELTYPE = "channeltype";
        public static final String ENDTIME = "endtime";
        public static final String HIDDEN = "hidden";
        public static final String LOCKED = "locked";
        public static final String STARTTIME = "starttime";
        public final String channel;
        public final Integer channelnumber;
        public final String channeltype;
        public final String endtime;
        public final Boolean hidden;
        public final Boolean locked;
        public final String starttime;

        public AllItems(JsonNode jsonNode) {
            super(jsonNode);
            this.channel = AllItems.parseString(jsonNode, CHANNEL);
            this.channelnumber = AllItems.parseInt(jsonNode, CHANNELNUMBER);
            this.channeltype = AllItems.parseString(jsonNode, CHANNELTYPE);
            this.endtime = AllItems.parseString(jsonNode, ENDTIME);
            this.hidden = AllItems.parseBoolean(jsonNode, HIDDEN);
            this.locked = AllItems.parseBoolean(jsonNode, LOCKED);
            this.starttime = AllItems.parseString(jsonNode, STARTTIME);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(CHANNEL, this.channel);
            objectNode.put(CHANNELNUMBER, this.channelnumber);
            objectNode.put(CHANNELTYPE, this.channeltype);
            objectNode.put(ENDTIME, this.endtime);
            objectNode.put(HIDDEN, this.hidden);
            objectNode.put(LOCKED, this.locked);
            objectNode.put(STARTTIME, this.starttime);
            return objectNode;
        }

        static List<AllItems> getListModelAllItemsList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<AllItems> arrayList = new ArrayList<AllItems>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new AllItems(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<AllItems>(0);
        }

        public static interface Channeltype {
            public static final String TV = "tv";
            public static final String RADIO = "radio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
        }
    }

    public static class TextureFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Textures";
        public final And and;
        public final TextureFilterRule filterRuleTextures;
        public final Or or;

        public TextureFilter(And and) {
            this.and = and;
            this.filterRuleTextures = null;
            this.or = null;
        }

        public TextureFilter(TextureFilterRule textureFilterRule) {
            this.filterRuleTextures = textureFilterRule;
            this.and = null;
            this.or = null;
        }

        public TextureFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleTextures = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleTextures != null) {
                return this.filterRuleTextures.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<TextureFilter> or;

            public Or(List<TextureFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (TextureFilter textureFilter : this.or) {
                    arrayNode.add(textureFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<TextureFilter> and;

            public And(List<TextureFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (TextureFilter textureFilter : this.and) {
                    arrayNode.add(textureFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class TVShowFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.TVShows";
        public final And and;
        public final TVShowFilterRule filterRuleTVShows;
        public final Or or;

        public TVShowFilter(And and) {
            this.and = and;
            this.filterRuleTVShows = null;
            this.or = null;
        }

        public TVShowFilter(TVShowFilterRule tVShowFilterRule) {
            this.filterRuleTVShows = tVShowFilterRule;
            this.and = null;
            this.or = null;
        }

        public TVShowFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleTVShows = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleTVShows != null) {
                return this.filterRuleTVShows.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<TVShowFilter> or;

            public Or(List<TVShowFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (TVShowFilter tVShowFilter : this.or) {
                    arrayNode.add(tVShowFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<TVShowFilter> and;

            public And(List<TVShowFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (TVShowFilter tVShowFilter : this.and) {
                    arrayNode.add(tVShowFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class SongFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Songs";
        public final And and;
        public final SongFilterRule filterRuleSongs;
        public final Or or;

        public SongFilter(And and) {
            this.and = and;
            this.filterRuleSongs = null;
            this.or = null;
        }

        public SongFilter(SongFilterRule songFilterRule) {
            this.filterRuleSongs = songFilterRule;
            this.and = null;
            this.or = null;
        }

        public SongFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleSongs = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleSongs != null) {
                return this.filterRuleSongs.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<SongFilter> or;

            public Or(List<SongFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (SongFilter songFilter : this.or) {
                    arrayNode.add(songFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<SongFilter> and;

            public And(List<SongFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (SongFilter songFilter : this.and) {
                    arrayNode.add(songFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class TextureFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Textures";
        public static final String FIELD = "field";
        public final String field;

        public TextureFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String TEXTUREID = "textureid";
            public static final String URL = "url";
            public static final String CACHEDURL = "cachedurl";
            public static final String LASTHASHCHECK = "lasthashcheck";
            public static final String IMAGEHASH = "imagehash";
            public static final String WIDTH = "width";
            public static final String HEIGHT = "height";
            public static final String USECOUNT = "usecount";
            public static final String LASTUSED = "lastused";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("textureid", "url", "cachedurl", "lasthashcheck", "imagehash", "width", "height", "usecount", "lastused"));
        }
    }

    public static class TVShowFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.TVShows";
        public static final String FIELD = "field";
        public final String field;

        public TVShowFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String PLOT = "plot";
            public static final String STATUS = "status";
            public static final String VOTES = "votes";
            public static final String RATING = "rating";
            public static final String YEAR = "year";
            public static final String GENRE = "genre";
            public static final String DIRECTOR = "director";
            public static final String ACTOR = "actor";
            public static final String NUMEPISODES = "numepisodes";
            public static final String NUMWATCHED = "numwatched";
            public static final String PLAYCOUNT = "playcount";
            public static final String PATH = "path";
            public static final String STUDIO = "studio";
            public static final String MPAARATING = "mpaarating";
            public static final String DATEADDED = "dateadded";
            public static final String LASTPLAYED = "lastplayed";
            public static final String INPROGRESS = "inprogress";
            public static final String TAG = "tag";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "status", "votes", "rating", "year", "genre", "director", "actor", "numepisodes", "numwatched", "playcount", "path", "studio", "mpaarating", "dateadded", "lastplayed", "inprogress", "tag", "playlist", "virtualfolder"));
        }
    }

    public static class SongFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Songs";
        public static final String FIELD = "field";
        public final String field;

        public SongFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String GENRE = "genre";
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String ALBUMARTIST = "albumartist";
            public static final String TITLE = "title";
            public static final String YEAR = "year";
            public static final String TIME = "time";
            public static final String TRACKNUMBER = "tracknumber";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String RATING = "rating";
            public static final String COMMENT = "comment";
            public static final String MOODS = "moods";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "title", "year", "time", "tracknumber", "filename", "path", "playcount", "lastplayed", "rating", "comment", "moods", "playlist", "virtualfolder"));
        }
    }

    public static class MusicVideoFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.MusicVideos";
        public static final String FIELD = "field";
        public final String field;

        public MusicVideoFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String GENRE = "genre";
            public static final String ALBUM = "album";
            public static final String YEAR = "year";
            public static final String ARTIST = "artist";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String TIME = "time";
            public static final String DIRECTOR = "director";
            public static final String STUDIO = "studio";
            public static final String PLOT = "plot";
            public static final String TAG = "tag";
            public static final String DATEADDED = "dateadded";
            public static final String VIDEORESOLUTION = "videoresolution";
            public static final String AUDIOCHANNELS = "audiochannels";
            public static final String VIDEOCODEC = "videocodec";
            public static final String AUDIOCODEC = "audiocodec";
            public static final String AUDIOLANGUAGE = "audiolanguage";
            public static final String SUBTITLELANGUAGE = "subtitlelanguage";
            public static final String VIDEOASPECT = "videoaspect";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "genre", "album", "year", "artist", "filename", "path", "playcount", "lastplayed", "time", "director", "studio", "plot", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
        }
    }

    public static class MovieFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Movies";
        public static final String FIELD = "field";
        public final String field;

        public MovieFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String PLOT = "plot";
            public static final String PLOTOUTLINE = "plotoutline";
            public static final String TAGLINE = "tagline";
            public static final String VOTES = "votes";
            public static final String RATING = "rating";
            public static final String TIME = "time";
            public static final String WRITERS = "writers";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String INPROGRESS = "inprogress";
            public static final String GENRE = "genre";
            public static final String COUNTRY = "country";
            public static final String YEAR = "year";
            public static final String DIRECTOR = "director";
            public static final String ACTOR = "actor";
            public static final String MPAARATING = "mpaarating";
            public static final String TOP250 = "top250";
            public static final String STUDIO = "studio";
            public static final String HASTRAILER = "hastrailer";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String SET = "set";
            public static final String TAG = "tag";
            public static final String DATEADDED = "dateadded";
            public static final String VIDEORESOLUTION = "videoresolution";
            public static final String AUDIOCHANNELS = "audiochannels";
            public static final String VIDEOCODEC = "videocodec";
            public static final String AUDIOCODEC = "audiocodec";
            public static final String AUDIOLANGUAGE = "audiolanguage";
            public static final String SUBTITLELANGUAGE = "subtitlelanguage";
            public static final String VIDEOASPECT = "videoaspect";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "tagline", "votes", "rating", "time", "writers", "playcount", "lastplayed", "inprogress", "genre", "country", "year", "director", "actor", "mpaarating", "top250", "studio", "hastrailer", "filename", "path", "set", "tag", "dateadded", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
        }
    }

    public static class EpisodeFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Episodes";
        public static final String FIELD = "field";
        public final String field;

        public EpisodeFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String TITLE = "title";
            public static final String TVSHOW = "tvshow";
            public static final String PLOT = "plot";
            public static final String VOTES = "votes";
            public static final String RATING = "rating";
            public static final String TIME = "time";
            public static final String WRITERS = "writers";
            public static final String AIRDATE = "airdate";
            public static final String PLAYCOUNT = "playcount";
            public static final String LASTPLAYED = "lastplayed";
            public static final String INPROGRESS = "inprogress";
            public static final String GENRE = "genre";
            public static final String YEAR = "year";
            public static final String DIRECTOR = "director";
            public static final String ACTOR = "actor";
            public static final String EPISODE = "episode";
            public static final String SEASON = "season";
            public static final String FILENAME = "filename";
            public static final String PATH = "path";
            public static final String STUDIO = "studio";
            public static final String MPAARATING = "mpaarating";
            public static final String DATEADDED = "dateadded";
            public static final String TAG = "tag";
            public static final String VIDEORESOLUTION = "videoresolution";
            public static final String AUDIOCHANNELS = "audiochannels";
            public static final String VIDEOCODEC = "videocodec";
            public static final String AUDIOCODEC = "audiocodec";
            public static final String AUDIOLANGUAGE = "audiolanguage";
            public static final String SUBTITLELANGUAGE = "subtitlelanguage";
            public static final String VIDEOASPECT = "videoaspect";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "tvshow", "plot", "votes", "rating", "time", "writers", "airdate", "playcount", "lastplayed", "inprogress", "genre", "year", "director", "actor", "episode", "season", "filename", "path", "studio", "mpaarating", "dateadded", "tag", "videoresolution", "audiochannels", "videocodec", "audiocodec", "audiolanguage", "subtitlelanguage", "videoaspect", "playlist", "virtualfolder"));
        }
    }

    public static class ArtistFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Artists";
        public static final String FIELD = "field";
        public final String field;

        public ArtistFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String ARTIST = "artist";
            public static final String GENRE = "genre";
            public static final String MOODS = "moods";
            public static final String STYLES = "styles";
            public static final String INSTRUMENTS = "instruments";
            public static final String BIOGRAPHY = "biography";
            public static final String BORN = "born";
            public static final String BANDFORMED = "bandformed";
            public static final String DISBANDED = "disbanded";
            public static final String DIED = "died";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("artist", "genre", "moods", "styles", "instruments", "biography", "born", "bandformed", "disbanded", "died", "playlist", "virtualfolder"));
        }
    }

    public static class AlbumFilterRule
    extends FilterRule {
        public static final String API_TYPE = "List.Filter.Rule.Albums";
        public static final String FIELD = "field";
        public final String field;

        public AlbumFilterRule(String string, FilterRule.Value value, String string2) {
            super(string, value);
            this.field = string2;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FIELD, this.field);
            return objectNode;
        }

        public static interface Field {
            public static final String GENRE = "genre";
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String ALBUMARTIST = "albumartist";
            public static final String YEAR = "year";
            public static final String REVIEW = "review";
            public static final String THEMES = "themes";
            public static final String MOODS = "moods";
            public static final String STYLES = "styles";
            public static final String TYPE = "type";
            public static final String LABEL = "label";
            public static final String RATING = "rating";
            public static final String PLAYCOUNT = "playcount";
            public static final String PLAYLIST = "playlist";
            public static final String VIRTUALFOLDER = "virtualfolder";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("genre", "album", "artist", "albumartist", "year", "review", "themes", "moods", "styles", "type", "label", "rating", "playcount", "playlist", "virtualfolder"));
        }
    }

    public static class FilterRule
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Rule";
        public static final String OPERATOR = "operator";
        public static final String VALUE = "value";
        public final String operator;
        public final Value value;

        public FilterRule(String string, Value value) {
            this.operator = string;
            this.value = value;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(OPERATOR, this.operator);
            objectNode.put(VALUE, this.value == null ? null : this.value.toJsonNode());
            return objectNode;
        }

        public static interface Operator {
            public static final String CONTAINS = "contains";
            public static final String DOESNOTCONTAIN = "doesnotcontain";
            public static final String IS = "is";
            public static final String ISNOT = "isnot";
            public static final String STARTSWITH = "startswith";
            public static final String ENDSWITH = "endswith";
            public static final String GREATERTHAN = "greaterthan";
            public static final String LESSTHAN = "lessthan";
            public static final String AFTER = "after";
            public static final String BEFORE = "before";
            public static final String INTHELAST = "inthelast";
            public static final String NOTINTHELAST = "notinthelast";
            public static final String TRUE = "true";
            public static final String FALSE = "false";
            public static final String BETWEEN = "between";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("contains", "doesnotcontain", "is", "isnot", "startswith", "endswith", "greaterthan", "lessthan", "after", "before", "inthelast", "notinthelast", "true", "false", "between"));
        }

        public static class Value
        extends AbstractModel {
            public final String stringArg;
            public final List<String> stringArgList;

            public Value(String string) {
                this.stringArg = string;
                this.stringArgList = null;
            }

            public Value(List<String> list) {
                this.stringArgList = list;
                this.stringArg = null;
            }

            @Override
            public JsonNode toJsonNode() {
                if (this.stringArg != null) {
                    return new TextNode(this.stringArg);
                }
                if (this.stringArgList != null) {
                    ArrayNode arrayNode = OM.createArrayNode();
                    for (String string : this.stringArgList) {
                        arrayNode.add(string);
                    }
                    return arrayNode;
                }
                return null;
            }
        }
    }

    public static class MusicVideoFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.MusicVideos";
        public final And and;
        public final MusicVideoFilterRule filterRuleMusicVideos;
        public final Or or;

        public MusicVideoFilter(And and) {
            this.and = and;
            this.filterRuleMusicVideos = null;
            this.or = null;
        }

        public MusicVideoFilter(MusicVideoFilterRule musicVideoFilterRule) {
            this.filterRuleMusicVideos = musicVideoFilterRule;
            this.and = null;
            this.or = null;
        }

        public MusicVideoFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleMusicVideos = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleMusicVideos != null) {
                return this.filterRuleMusicVideos.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<MusicVideoFilter> or;

            public Or(List<MusicVideoFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (MusicVideoFilter musicVideoFilter : this.or) {
                    arrayNode.add(musicVideoFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<MusicVideoFilter> and;

            public And(List<MusicVideoFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (MusicVideoFilter musicVideoFilter : this.and) {
                    arrayNode.add(musicVideoFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class MovieFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Movies";
        public final And and;
        public final MovieFilterRule filterRuleMovies;
        public final Or or;

        public MovieFilter(And and) {
            this.and = and;
            this.filterRuleMovies = null;
            this.or = null;
        }

        public MovieFilter(MovieFilterRule movieFilterRule) {
            this.filterRuleMovies = movieFilterRule;
            this.and = null;
            this.or = null;
        }

        public MovieFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleMovies = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleMovies != null) {
                return this.filterRuleMovies.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<MovieFilter> or;

            public Or(List<MovieFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (MovieFilter movieFilter : this.or) {
                    arrayNode.add(movieFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<MovieFilter> and;

            public And(List<MovieFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (MovieFilter movieFilter : this.and) {
                    arrayNode.add(movieFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class EpisodeFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Episodes";
        public final And and;
        public final EpisodeFilterRule filterRuleEpisodes;
        public final Or or;

        public EpisodeFilter(And and) {
            this.and = and;
            this.filterRuleEpisodes = null;
            this.or = null;
        }

        public EpisodeFilter(EpisodeFilterRule episodeFilterRule) {
            this.filterRuleEpisodes = episodeFilterRule;
            this.and = null;
            this.or = null;
        }

        public EpisodeFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleEpisodes = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleEpisodes != null) {
                return this.filterRuleEpisodes.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<EpisodeFilter> or;

            public Or(List<EpisodeFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (EpisodeFilter episodeFilter : this.or) {
                    arrayNode.add(episodeFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<EpisodeFilter> and;

            public And(List<EpisodeFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (EpisodeFilter episodeFilter : this.and) {
                    arrayNode.add(episodeFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class ArtistFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Artists";
        public final And and;
        public final ArtistFilterRule filterRuleArtists;
        public final Or or;

        public ArtistFilter(And and) {
            this.and = and;
            this.filterRuleArtists = null;
            this.or = null;
        }

        public ArtistFilter(ArtistFilterRule artistFilterRule) {
            this.filterRuleArtists = artistFilterRule;
            this.and = null;
            this.or = null;
        }

        public ArtistFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleArtists = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleArtists != null) {
                return this.filterRuleArtists.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<ArtistFilter> or;

            public Or(List<ArtistFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (ArtistFilter artistFilter : this.or) {
                    arrayNode.add(artistFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<ArtistFilter> and;

            public And(List<ArtistFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (ArtistFilter artistFilter : this.and) {
                    arrayNode.add(artistFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }

    public static class AlbumFilter
    extends AbstractModel {
        public static final String API_TYPE = "List.Filter.Albums";
        public final And and;
        public final AlbumFilterRule filterRuleAlbums;
        public final Or or;

        public AlbumFilter(And and) {
            this.and = and;
            this.filterRuleAlbums = null;
            this.or = null;
        }

        public AlbumFilter(AlbumFilterRule albumFilterRule) {
            this.filterRuleAlbums = albumFilterRule;
            this.and = null;
            this.or = null;
        }

        public AlbumFilter(Or or) {
            this.or = or;
            this.and = null;
            this.filterRuleAlbums = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.and != null) {
                return this.and.toJsonNode();
            }
            if (this.filterRuleAlbums != null) {
                return this.filterRuleAlbums.toJsonNode();
            }
            if (this.or != null) {
                return this.or.toJsonNode();
            }
            return null;
        }

        public static class Or
        extends AbstractModel {
            public static final String OR = "or";
            public final List<AlbumFilter> or;

            public Or(List<AlbumFilter> list) {
                this.or = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (AlbumFilter albumFilter : this.or) {
                    arrayNode.add(albumFilter.toJsonNode());
                }
                objectNode.put(OR, (JsonNode)arrayNode);
                return objectNode;
            }
        }

        public static class And
        extends AbstractModel {
            public static final String AND = "and";
            public final List<AlbumFilter> and;

            public And(List<AlbumFilter> list) {
                this.and = list;
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                ArrayNode arrayNode = OM.createArrayNode();
                for (AlbumFilter albumFilter : this.and) {
                    arrayNode.add(albumFilter.toJsonNode());
                }
                objectNode.put(AND, (JsonNode)arrayNode);
                return objectNode;
            }
        }
    }
}

