/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ItemModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.MediaModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;

public final class PVRModel {

    public static interface TimerState {
        public static final String UNKNOWN = "unknown";
        public static final String NEW = "new";
        public static final String SCHEDULED = "scheduled";
        public static final String RECORDING = "recording";
        public static final String COMPLETED = "completed";
        public static final String ABORTED = "aborted";
        public static final String CANCELLED = "cancelled";
        public static final String CONFLICT_OK = "conflict_ok";
        public static final String CONFLICT_NOTOK = "conflict_notok";
        public static final String ERROR = "error";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "new", "scheduled", "recording", "completed", "aborted", "cancelled", "conflict_ok", "conflict_notok", "error"));
    }

    public static interface PropertyName {
        public static final String AVAILABLE = "available";
        public static final String RECORDING = "recording";
        public static final String SCANNING = "scanning";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("available", "recording", "scanning"));
    }

    public static interface TimerFields {
        public static final String TITLE = "title";
        public static final String SUMMARY = "summary";
        public static final String CHANNELID = "channelid";
        public static final String ISRADIO = "isradio";
        public static final String REPEATING = "repeating";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String RUNTIME = "runtime";
        public static final String LIFETIME = "lifetime";
        public static final String FIRSTDAY = "firstday";
        public static final String WEEKDAYS = "weekdays";
        public static final String PRIORITY = "priority";
        public static final String STARTMARGIN = "startmargin";
        public static final String ENDMARGIN = "endmargin";
        public static final String STATE = "state";
        public static final String FILE = "file";
        public static final String DIRECTORY = "directory";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "summary", "channelid", "isradio", "repeating", "starttime", "endtime", "runtime", "lifetime", "firstday", "weekdays", "priority", "startmargin", "endmargin", "state", "file", "directory"));
    }

    public static interface RecordingFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String GENRE = "genre";
        public static final String PLAYCOUNT = "playcount";
        public static final String RESUME = "resume";
        public static final String CHANNEL = "channel";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String RUNTIME = "runtime";
        public static final String LIFETIME = "lifetime";
        public static final String ICON = "icon";
        public static final String ART = "art";
        public static final String STREAMURL = "streamurl";
        public static final String FILE = "file";
        public static final String DIRECTORY = "directory";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "genre", "playcount", "resume", "channel", "starttime", "endtime", "runtime", "lifetime", "icon", "art", "streamurl", "file", "directory"));
    }

    public static interface ChannelFields {
        public static final String THUMBNAIL = "thumbnail";
        public static final String CHANNELTYPE = "channeltype";
        public static final String HIDDEN = "hidden";
        public static final String LOCKED = "locked";
        public static final String CHANNEL = "channel";
        public static final String LASTPLAYED = "lastplayed";
        public static final String BROADCASTNOW = "broadcastnow";
        public static final String BROADCASTNEXT = "broadcastnext";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("thumbnail", "channeltype", "hidden", "locked", "channel", "lastplayed", "broadcastnow", "broadcastnext"));
    }

    public static interface BroadcastFields {
        public static final String TITLE = "title";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String STARTTIME = "starttime";
        public static final String ENDTIME = "endtime";
        public static final String RUNTIME = "runtime";
        public static final String PROGRESS = "progress";
        public static final String PROGRESSPERCENTAGE = "progresspercentage";
        public static final String GENRE = "genre";
        public static final String EPISODENAME = "episodename";
        public static final String EPISODENUM = "episodenum";
        public static final String EPISODEPART = "episodepart";
        public static final String FIRSTAIRED = "firstaired";
        public static final String HASTIMER = "hastimer";
        public static final String ISACTIVE = "isactive";
        public static final String PARENTALRATING = "parentalrating";
        public static final String WASACTIVE = "wasactive";
        public static final String THUMBNAIL = "thumbnail";
        public static final String RATING = "rating";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("title", "plot", "plotoutline", "starttime", "endtime", "runtime", "progress", "progresspercentage", "genre", "episodename", "episodenum", "episodepart", "firstaired", "hastimer", "isactive", "parentalrating", "wasactive", "thumbnail", "rating"));
    }

    public static interface ChannelType {
        public static final String TV = "tv";
        public static final String RADIO = "radio";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "PVR.Property.Value";
        public static final String AVAILABLE = "available";
        public static final String RECORDING = "recording";
        public static final String SCANNING = "scanning";
        public final Boolean available;
        public final Boolean recording;
        public final Boolean scanning;

        public PropertyValue(Boolean bl, Boolean bl2, Boolean bl3) {
            this.available = bl;
            this.recording = bl2;
            this.scanning = bl3;
        }

        public PropertyValue(JsonNode jsonNode) {
            this.available = PropertyValue.parseBoolean(jsonNode, AVAILABLE);
            this.recording = PropertyValue.parseBoolean(jsonNode, RECORDING);
            this.scanning = PropertyValue.parseBoolean(jsonNode, SCANNING);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(AVAILABLE, this.available);
            objectNode.put(RECORDING, this.recording);
            objectNode.put(SCANNING, this.scanning);
            return objectNode;
        }

        static List<PropertyValue> getPVRModelPropertyValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new PropertyValue(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<PropertyValue>(0);
        }
    }

    public static class TimerDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Timer";
        public static final String CHANNELID = "channelid";
        public static final String DIRECTORY = "directory";
        public static final String ENDMARGIN = "endmargin";
        public static final String ENDTIME = "endtime";
        public static final String FILE = "file";
        public static final String FIRSTDAY = "firstday";
        public static final String ISRADIO = "isradio";
        public static final String LIFETIME = "lifetime";
        public static final String PRIORITY = "priority";
        public static final String REPEATING = "repeating";
        public static final String RUNTIME = "runtime";
        public static final String STARTMARGIN = "startmargin";
        public static final String STARTTIME = "starttime";
        public static final String STATE = "state";
        public static final String SUMMARY = "summary";
        public static final String TIMERID = "timerid";
        public static final String TITLE = "title";
        public static final String WEEKDAYS = "weekdays";
        public final Integer channelid;
        public final String directory;
        public final Integer endmargin;
        public final String endtime;
        public final String file;
        public final String firstday;
        public final Boolean isradio;
        public final Integer lifetime;
        public final Integer priority;
        public final Boolean repeating;
        public final Integer runtime;
        public final Integer startmargin;
        public final String starttime;
        public final String state;
        public final String summary;
        public final Integer timerid;
        public final String title;
        public final String weekdays;

        public TimerDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.channelid = TimerDetail.parseInt(jsonNode, CHANNELID);
            this.directory = TimerDetail.parseString(jsonNode, DIRECTORY);
            this.endmargin = TimerDetail.parseInt(jsonNode, ENDMARGIN);
            this.endtime = TimerDetail.parseString(jsonNode, ENDTIME);
            this.file = TimerDetail.parseString(jsonNode, FILE);
            this.firstday = TimerDetail.parseString(jsonNode, FIRSTDAY);
            this.isradio = TimerDetail.parseBoolean(jsonNode, ISRADIO);
            this.lifetime = TimerDetail.parseInt(jsonNode, LIFETIME);
            this.priority = TimerDetail.parseInt(jsonNode, PRIORITY);
            this.repeating = TimerDetail.parseBoolean(jsonNode, REPEATING);
            this.runtime = TimerDetail.parseInt(jsonNode, RUNTIME);
            this.startmargin = TimerDetail.parseInt(jsonNode, STARTMARGIN);
            this.starttime = TimerDetail.parseString(jsonNode, STARTTIME);
            this.state = TimerDetail.parseString(jsonNode, STATE);
            this.summary = TimerDetail.parseString(jsonNode, SUMMARY);
            this.timerid = TimerDetail.parseInt(jsonNode, TIMERID);
            this.title = TimerDetail.parseString(jsonNode, TITLE);
            this.weekdays = TimerDetail.parseString(jsonNode, WEEKDAYS);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(CHANNELID, this.channelid);
            objectNode.put(DIRECTORY, this.directory);
            objectNode.put(ENDMARGIN, this.endmargin);
            objectNode.put(ENDTIME, this.endtime);
            objectNode.put(FILE, this.file);
            objectNode.put(FIRSTDAY, this.firstday);
            objectNode.put(ISRADIO, this.isradio);
            objectNode.put(LIFETIME, this.lifetime);
            objectNode.put(PRIORITY, this.priority);
            objectNode.put(REPEATING, this.repeating);
            objectNode.put(RUNTIME, this.runtime);
            objectNode.put(STARTMARGIN, this.startmargin);
            objectNode.put(STARTTIME, this.starttime);
            objectNode.put(STATE, this.state);
            objectNode.put(SUMMARY, this.summary);
            objectNode.put(TIMERID, this.timerid);
            objectNode.put(TITLE, this.title);
            objectNode.put(WEEKDAYS, this.weekdays);
            return objectNode;
        }

        static List<TimerDetail> getPVRModelTimerDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<TimerDetail> arrayList = new ArrayList<TimerDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new TimerDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<TimerDetail>(0);
        }

        public static interface Weekday {
            public static final String MONDAY = "monday";
            public static final String TUESDAY = "tuesday";
            public static final String WEDNESDAY = "wednesday";
            public static final String THURSDAY = "thursday";
            public static final String FRIDAY = "friday";
            public static final String SATURDAY = "saturday";
            public static final String SUNDAY = "sunday";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"));
        }

        public static interface State {
            public static final String UNKNOWN = "unknown";
            public static final String NEW = "new";
            public static final String SCHEDULED = "scheduled";
            public static final String RECORDING = "recording";
            public static final String COMPLETED = "completed";
            public static final String ABORTED = "aborted";
            public static final String CANCELLED = "cancelled";
            public static final String CONFLICT_OK = "conflict_ok";
            public static final String CONFLICT_NOTOK = "conflict_notok";
            public static final String ERROR = "error";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "new", "scheduled", "recording", "completed", "aborted", "cancelled", "conflict_ok", "conflict_notok", "error"));
        }
    }

    public static class RecordingDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Recording";
        public static final String ART = "art";
        public static final String CHANNEL = "channel";
        public static final String DIRECTORY = "directory";
        public static final String ENDTIME = "endtime";
        public static final String FILE = "file";
        public static final String GENRE = "genre";
        public static final String ICON = "icon";
        public static final String LIFETIME = "lifetime";
        public static final String PLAYCOUNT = "playcount";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String RECORDINGID = "recordingid";
        public static final String RESUME = "resume";
        public static final String RUNTIME = "runtime";
        public static final String STARTTIME = "starttime";
        public static final String STREAMURL = "streamurl";
        public static final String TITLE = "title";
        public final MediaModel.Artwork art;
        public final String channel;
        public final String directory;
        public final String endtime;
        public final String file;
        public final String genre;
        public final String icon;
        public final Integer lifetime;
        public final Integer playcount;
        public final String plot;
        public final String plotoutline;
        public final Integer recordingid;
        public final VideoModel.Resume resume;
        public final Integer runtime;
        public final String starttime;
        public final String streamurl;
        public final String title;

        public RecordingDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.art = jsonNode.has(ART) ? new MediaModel.Artwork(jsonNode.get(ART)) : null;
            this.channel = RecordingDetail.parseString(jsonNode, CHANNEL);
            this.directory = RecordingDetail.parseString(jsonNode, DIRECTORY);
            this.endtime = RecordingDetail.parseString(jsonNode, ENDTIME);
            this.file = RecordingDetail.parseString(jsonNode, FILE);
            this.genre = RecordingDetail.parseString(jsonNode, GENRE);
            this.icon = RecordingDetail.parseString(jsonNode, ICON);
            this.lifetime = RecordingDetail.parseInt(jsonNode, LIFETIME);
            this.playcount = RecordingDetail.parseInt(jsonNode, PLAYCOUNT);
            this.plot = RecordingDetail.parseString(jsonNode, PLOT);
            this.plotoutline = RecordingDetail.parseString(jsonNode, PLOTOUTLINE);
            this.recordingid = RecordingDetail.parseInt(jsonNode, RECORDINGID);
            this.resume = jsonNode.has(RESUME) ? new VideoModel.Resume(jsonNode.get(RESUME)) : null;
            this.runtime = RecordingDetail.parseInt(jsonNode, RUNTIME);
            this.starttime = RecordingDetail.parseString(jsonNode, STARTTIME);
            this.streamurl = RecordingDetail.parseString(jsonNode, STREAMURL);
            this.title = RecordingDetail.parseString(jsonNode, TITLE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ART, this.art == null ? null : this.art.toJsonNode());
            objectNode.put(CHANNEL, this.channel);
            objectNode.put(DIRECTORY, this.directory);
            objectNode.put(ENDTIME, this.endtime);
            objectNode.put(FILE, this.file);
            objectNode.put(GENRE, this.genre);
            objectNode.put(ICON, this.icon);
            objectNode.put(LIFETIME, this.lifetime);
            objectNode.put(PLAYCOUNT, this.playcount);
            objectNode.put(PLOT, this.plot);
            objectNode.put(PLOTOUTLINE, this.plotoutline);
            objectNode.put(RECORDINGID, this.recordingid);
            objectNode.put(RESUME, this.resume == null ? null : this.resume.toJsonNode());
            objectNode.put(RUNTIME, this.runtime);
            objectNode.put(STARTTIME, this.starttime);
            objectNode.put(STREAMURL, this.streamurl);
            objectNode.put(TITLE, this.title);
            return objectNode;
        }

        static List<RecordingDetail> getPVRModelRecordingDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<RecordingDetail> arrayList = new ArrayList<RecordingDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new RecordingDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<RecordingDetail>(0);
        }
    }

    public static class ChannelGroupExtendedDetail
    extends ChannelGroupDetail {
        public static final String API_TYPE = "PVR.Details.ChannelGroup.Extended";
        public static final String CHANNELS = "channels";
        public static final String LIMITS = "limits";
        public final List<ChannelDetail> channels;
        public final ListModel.LimitsReturned limits;

        public ChannelGroupExtendedDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.channels = ChannelDetail.getPVRModelChannelDetailList(jsonNode, CHANNELS);
            this.limits = jsonNode.has(LIMITS) ? new ListModel.LimitsReturned(jsonNode.get(LIMITS)) : null;
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (ChannelDetail channelDetail : this.channels) {
                arrayNode.add(channelDetail.toJsonNode());
            }
            objectNode.put(CHANNELS, (JsonNode)arrayNode);
            objectNode.put(LIMITS, this.limits == null ? null : this.limits.toJsonNode());
            return objectNode;
        }

        static List<ChannelGroupExtendedDetail> getPVRModelChannelGroupExtendedDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ChannelGroupExtendedDetail> arrayList = new ArrayList<ChannelGroupExtendedDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ChannelGroupExtendedDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ChannelGroupExtendedDetail>(0);
        }
    }

    public static class ChannelGroupDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.ChannelGroup";
        public static final String CHANNELGROUPID = "channelgroupid";
        public static final String CHANNELTYPE = "channeltype";
        public final Integer channelgroupid;
        public final String channeltype;

        public ChannelGroupDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.channelgroupid = ChannelGroupDetail.parseInt(jsonNode, CHANNELGROUPID);
            this.channeltype = ChannelGroupDetail.parseString(jsonNode, CHANNELTYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(CHANNELGROUPID, this.channelgroupid);
            objectNode.put(CHANNELTYPE, this.channeltype);
            return objectNode;
        }

        static List<ChannelGroupDetail> getPVRModelChannelGroupDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ChannelGroupDetail> arrayList = new ArrayList<ChannelGroupDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ChannelGroupDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ChannelGroupDetail>(0);
        }

        public static interface Channeltype {
            public static final String TV = "tv";
            public static final String RADIO = "radio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
        }
    }

    public static class ChannelDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Channel";
        public static final String BROADCASTNEXT = "broadcastnext";
        public static final String BROADCASTNOW = "broadcastnow";
        public static final String CHANNEL = "channel";
        public static final String CHANNELID = "channelid";
        public static final String CHANNELTYPE = "channeltype";
        public static final String HIDDEN = "hidden";
        public static final String LASTPLAYED = "lastplayed";
        public static final String LOCKED = "locked";
        public static final String THUMBNAIL = "thumbnail";
        public final BroadcastDetail broadcastnext;
        public final BroadcastDetail broadcastnow;
        public final String channel;
        public final Integer channelid;
        public final String channeltype;
        public final Boolean hidden;
        public final String lastplayed;
        public final Boolean locked;
        public final String thumbnail;

        public ChannelDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.broadcastnext = jsonNode.has(BROADCASTNEXT) ? new BroadcastDetail(jsonNode.get(BROADCASTNEXT)) : null;
            this.broadcastnow = jsonNode.has(BROADCASTNOW) ? new BroadcastDetail(jsonNode.get(BROADCASTNOW)) : null;
            this.channel = ChannelDetail.parseString(jsonNode, CHANNEL);
            this.channelid = ChannelDetail.parseInt(jsonNode, CHANNELID);
            this.channeltype = ChannelDetail.parseString(jsonNode, CHANNELTYPE);
            this.hidden = ChannelDetail.parseBoolean(jsonNode, HIDDEN);
            this.lastplayed = ChannelDetail.parseString(jsonNode, LASTPLAYED);
            this.locked = ChannelDetail.parseBoolean(jsonNode, LOCKED);
            this.thumbnail = ChannelDetail.parseString(jsonNode, THUMBNAIL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(BROADCASTNEXT, this.broadcastnext == null ? null : this.broadcastnext.toJsonNode());
            objectNode.put(BROADCASTNOW, this.broadcastnow == null ? null : this.broadcastnow.toJsonNode());
            objectNode.put(CHANNEL, this.channel);
            objectNode.put(CHANNELID, this.channelid);
            objectNode.put(CHANNELTYPE, this.channeltype);
            objectNode.put(HIDDEN, this.hidden);
            objectNode.put(LASTPLAYED, this.lastplayed);
            objectNode.put(LOCKED, this.locked);
            objectNode.put(THUMBNAIL, this.thumbnail);
            return objectNode;
        }

        static List<ChannelDetail> getPVRModelChannelDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ChannelDetail> arrayList = new ArrayList<ChannelDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ChannelDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ChannelDetail>(0);
        }

        public static interface Channeltype {
            public static final String TV = "tv";
            public static final String RADIO = "radio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("tv", "radio"));
        }
    }

    public static class BroadcastDetail
    extends ItemModel.BaseDetail {
        public static final String API_TYPE = "PVR.Details.Broadcast";
        public static final String BROADCASTID = "broadcastid";
        public static final String ENDTIME = "endtime";
        public static final String EPISODENAME = "episodename";
        public static final String EPISODENUM = "episodenum";
        public static final String EPISODEPART = "episodepart";
        public static final String FIRSTAIRED = "firstaired";
        public static final String GENRE = "genre";
        public static final String HASTIMER = "hastimer";
        public static final String ISACTIVE = "isactive";
        public static final String PARENTALRATING = "parentalrating";
        public static final String PLOT = "plot";
        public static final String PLOTOUTLINE = "plotoutline";
        public static final String PROGRESS = "progress";
        public static final String PROGRESSPERCENTAGE = "progresspercentage";
        public static final String RATING = "rating";
        public static final String RUNTIME = "runtime";
        public static final String STARTTIME = "starttime";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TITLE = "title";
        public static final String WASACTIVE = "wasactive";
        public final Integer broadcastid;
        public final String endtime;
        public final String episodename;
        public final Integer episodenum;
        public final Integer episodepart;
        public final String firstaired;
        public final String genre;
        public final Boolean hastimer;
        public final Boolean isactive;
        public final Integer parentalrating;
        public final String plot;
        public final String plotoutline;
        public final Integer progress;
        public final Double progresspercentage;
        public final Integer rating;
        public final Integer runtime;
        public final String starttime;
        public final String thumbnail;
        public final String title;
        public final Boolean wasactive;

        public BroadcastDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.broadcastid = BroadcastDetail.parseInt(jsonNode, BROADCASTID);
            this.endtime = BroadcastDetail.parseString(jsonNode, ENDTIME);
            this.episodename = BroadcastDetail.parseString(jsonNode, EPISODENAME);
            this.episodenum = BroadcastDetail.parseInt(jsonNode, EPISODENUM);
            this.episodepart = BroadcastDetail.parseInt(jsonNode, EPISODEPART);
            this.firstaired = BroadcastDetail.parseString(jsonNode, FIRSTAIRED);
            this.genre = BroadcastDetail.parseString(jsonNode, GENRE);
            this.hastimer = BroadcastDetail.parseBoolean(jsonNode, HASTIMER);
            this.isactive = BroadcastDetail.parseBoolean(jsonNode, ISACTIVE);
            this.parentalrating = BroadcastDetail.parseInt(jsonNode, PARENTALRATING);
            this.plot = BroadcastDetail.parseString(jsonNode, PLOT);
            this.plotoutline = BroadcastDetail.parseString(jsonNode, PLOTOUTLINE);
            this.progress = BroadcastDetail.parseInt(jsonNode, PROGRESS);
            this.progresspercentage = BroadcastDetail.parseDouble(jsonNode, PROGRESSPERCENTAGE);
            this.rating = BroadcastDetail.parseInt(jsonNode, RATING);
            this.runtime = BroadcastDetail.parseInt(jsonNode, RUNTIME);
            this.starttime = BroadcastDetail.parseString(jsonNode, STARTTIME);
            this.thumbnail = BroadcastDetail.parseString(jsonNode, THUMBNAIL);
            this.title = BroadcastDetail.parseString(jsonNode, TITLE);
            this.wasactive = BroadcastDetail.parseBoolean(jsonNode, WASACTIVE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(BROADCASTID, this.broadcastid);
            objectNode.put(ENDTIME, this.endtime);
            objectNode.put(EPISODENAME, this.episodename);
            objectNode.put(EPISODENUM, this.episodenum);
            objectNode.put(EPISODEPART, this.episodepart);
            objectNode.put(FIRSTAIRED, this.firstaired);
            objectNode.put(GENRE, this.genre);
            objectNode.put(HASTIMER, this.hastimer);
            objectNode.put(ISACTIVE, this.isactive);
            objectNode.put(PARENTALRATING, this.parentalrating);
            objectNode.put(PLOT, this.plot);
            objectNode.put(PLOTOUTLINE, this.plotoutline);
            objectNode.put(PROGRESS, this.progress);
            objectNode.put(PROGRESSPERCENTAGE, this.progresspercentage);
            objectNode.put(RATING, this.rating);
            objectNode.put(RUNTIME, this.runtime);
            objectNode.put(STARTTIME, this.starttime);
            objectNode.put(THUMBNAIL, this.thumbnail);
            objectNode.put(TITLE, this.title);
            objectNode.put(WASACTIVE, this.wasactive);
            return objectNode;
        }

        static List<BroadcastDetail> getPVRModelBroadcastDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<BroadcastDetail> arrayList = new ArrayList<BroadcastDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new BroadcastDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<BroadcastDetail>(0);
        }
    }

    public static class ChannelGroupId
    extends AbstractModel {
        public static final String API_TYPE = "PVR.ChannelGroup.Id";
        public final Integer id;
        public final String stringArg;

        public ChannelGroupId(Integer n) {
            this.id = n;
            this.stringArg = null;
        }

        public ChannelGroupId(String string) {
            this.stringArg = string;
            this.id = null;
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.id != null) {
                return new IntNode(this.id.intValue());
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            return null;
        }

        public static interface StringArg {
            public static final String ALLTV = "alltv";
            public static final String ALLRADIO = "allradio";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("alltv", "allradio"));
        }
    }
}

