/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.thetvdb;

import com.uwetrottmann.thetvdb.TheTvdbAuthenticator;
import com.uwetrottmann.thetvdb.TheTvdbInterceptor;
import com.uwetrottmann.thetvdb.services.TheTvdbAuthentication;
import com.uwetrottmann.thetvdb.services.TheTvdbEpisodes;
import com.uwetrottmann.thetvdb.services.TheTvdbLanguages;
import com.uwetrottmann.thetvdb.services.TheTvdbSearch;
import com.uwetrottmann.thetvdb.services.TheTvdbSeries;
import com.uwetrottmann.thetvdb.services.TheTvdbUpdated;
import com.uwetrottmann.thetvdb.services.TheTvdbUser;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class TheTvdb {
    public static final String API_HOST = "api.thetvdb.com";
    public static final String API_URL = "https://api.thetvdb.com/";
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    @Nullable
    private OkHttpClient okHttpClient;
    @Nullable
    private Retrofit retrofit;
    private String apiKey;
    @Nullable
    private String currentJsonWebToken;

    public TheTvdb(String apiKey) {
        this.apiKey = apiKey;
    }

    public String apiKey() {
        return this.apiKey;
    }

    public void apiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Nullable
    public String jsonWebToken() {
        return this.currentJsonWebToken;
    }

    public void jsonWebToken(@Nullable String value) {
        this.currentJsonWebToken = value;
    }

    protected Retrofit.Builder retrofitBuilder() {
        return new Retrofit.Builder().baseUrl(API_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.okHttpClient());
    }

    protected synchronized OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            this.setOkHttpClientDefaults(builder);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    protected void setOkHttpClientDefaults(OkHttpClient.Builder builder) {
        builder.addNetworkInterceptor((Interceptor)new TheTvdbInterceptor(this)).authenticator((Authenticator)new TheTvdbAuthenticator(this));
    }

    protected Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.retrofit = this.retrofitBuilder().build();
        }
        return this.retrofit;
    }

    public TheTvdbAuthentication authentication() {
        return (TheTvdbAuthentication)this.getRetrofit().create(TheTvdbAuthentication.class);
    }

    public TheTvdbEpisodes episodes() {
        return (TheTvdbEpisodes)this.getRetrofit().create(TheTvdbEpisodes.class);
    }

    public TheTvdbLanguages languages() {
        return (TheTvdbLanguages)this.getRetrofit().create(TheTvdbLanguages.class);
    }

    public TheTvdbSeries series() {
        return (TheTvdbSeries)this.getRetrofit().create(TheTvdbSeries.class);
    }

    public TheTvdbSearch search() {
        return (TheTvdbSearch)this.getRetrofit().create(TheTvdbSearch.class);
    }

    public TheTvdbUpdated updated() {
        return (TheTvdbUpdated)this.getRetrofit().create(TheTvdbUpdated.class);
    }

    public TheTvdbUser user() {
        return (TheTvdbUser)this.getRetrofit().create(TheTvdbUser.class);
    }
}

