/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.token;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.encoder.Encoder;
import com.floreysoft.jmte.renderer.NullRenderer;
import com.floreysoft.jmte.renderer.RawRenderer;
import com.floreysoft.jmte.token.ExpressionToken;
import java.util.List;

public class StringToken
extends ExpressionToken {
    private final String defaultValue;
    private final String prefix;
    private final String suffix;
    private final String rendererName;
    private final String parameters;

    public StringToken() {
        this("", "", null, null, null, null, null);
    }

    public StringToken(String text, String variableName, String defaultValue, String prefix, String suffix, String rendererName, String parameters) {
        super(variableName);
        this.defaultValue = defaultValue;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rendererName = rendererName;
        this.parameters = parameters;
        this.setText(text);
    }

    public StringToken(String variableName) {
        this(variableName, variableName, null, null, null, null, null);
    }

    public StringToken(String text, List<String> segments, String variableName, String defaultValue, String prefix, String suffix, String rendererName, String parameters) {
        super(segments, variableName);
        this.defaultValue = defaultValue;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rendererName = rendererName;
        this.parameters = parameters;
        this.setText(text);
    }

    public StringToken(List<String> segments, String variableName) {
        super(segments, variableName);
        this.defaultValue = null;
        this.prefix = null;
        this.suffix = null;
        this.rendererName = null;
        this.parameters = null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object evaluate(TemplateContext context) {
        String renderedResult;
        Object value = this.resolveDefault(this.evaluatePlain(context));
        boolean rawRendering = false;
        NamedRenderer rendererForName = this.resolveNamedRenderer(context);
        if (rendererForName != null && (value != null || rendererForName instanceof NullRenderer)) {
            if (rendererForName instanceof RawRenderer) {
                rawRendering = true;
            }
            renderedResult = rendererForName.render(value, this.parameters, context.locale, context.model);
        } else if (value != null) {
            Renderer<?> rendererForClass = context.resolveRendererForClass(value.getClass());
            if (rendererForClass != null) {
                if (rendererForClass instanceof RawRenderer) {
                    rawRendering = true;
                }
                renderedResult = rendererForClass.render(value, context.locale, context.model);
            } else {
                renderedResult = value.toString();
            }
        } else {
            renderedResult = null;
        }
        if (renderedResult == null || renderedResult.equals("")) {
            return "";
        }
        String prefixedRenderedResult = (this.prefix != null ? this.prefix : "") + renderedResult + (this.suffix != null ? this.suffix : "");
        Encoder encoder = context.getEncoder();
        if (!rawRendering && encoder != null) {
            String encodedPrefixedRenderedResult = encoder.encode(prefixedRenderedResult);
            return encodedPrefixedRenderedResult;
        }
        return prefixedRenderedResult;
    }

    private NamedRenderer resolveNamedRenderer(TemplateContext context) {
        if (this.rendererName != null && !this.rendererName.equals("")) {
            return context.resolveNamedRenderer(this.rendererName);
        }
        return null;
    }

    private Object resolveDefault(Object value) {
        if ((value == null || value.equals("")) && this.defaultValue != null) {
            value = this.defaultValue;
        }
        return value;
    }

    public String getRendererName() {
        return this.rendererName;
    }

    public String getParameters() {
        return this.parameters;
    }

    @Override
    public String emit() {
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix).append(',');
        }
        sb.append(this.getExpression());
        if (this.defaultValue != null) {
            sb.append('(').append(this.defaultValue).append(')');
        }
        if (this.suffix != null) {
            sb.append(',').append(this.suffix);
        }
        if (this.rendererName != null) {
            sb.append(';').append(this.rendererName);
        }
        if (this.parameters != null) {
            sb.append('(').append(this.parameters).append(')');
        }
        return sb.toString();
    }
}

