/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import com.sun.jna.Platform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.jdesktop.beansbinding.ELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.Log4jBackstop;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.ThresholdLoggerFilter;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.cli.TinyMediaManagerCLI;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettingsDefaults;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettingsDefaults;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmTaskbar;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.wizard.TinyMediaManagerWizard;

public final class TinyMediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManager.class);

    public static void main(final String[] args) {
        if (args != null && args.length > 0) {
            LOGGER.debug("TMM started with: {}", (Object)Arrays.toString(args));
            if (!TinyMediaManagerCLI.checkArgs(args)) {
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            }
            System.setProperty("java.awt.headless", "true");
        } else {
            String head = System.getProperty("java.awt.headless");
            if (head != null && head.equals("true")) {
                LOGGER.info("TMM started 'headless', and without params -> displaying syntax ");
                TinyMediaManagerCLI.printHelp();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            }
            TinyMediaManager.setConsoleLogLevel();
        }
        try {
            RandomAccessFile f = new RandomAccessFile("access.test", "rw");
            f.close();
            Files.deleteIfExists(Paths.get("access.test", new String[0]));
        }
        catch (Exception e2) {
            String msg = "Cannot write to TMM directory, have no rights - exiting.";
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, msg);
            } else {
                System.out.println(msg);
            }
            TinyMediaManager.shutdownLogger();
            System.exit(1);
        }
        Path license = Paths.get(Globals.DATA_FOLDER, "tmm.lic");
        if (Files.exists(license, new LinkOption[0])) {
            try {
                License.getInstance().setLicenseCode(Utils.readFileToString(license));
            }
            catch (Exception e) {
                LOGGER.warn("unable to decode license file - {}", (Object)e.getMessage());
            }
        }
        LOGGER.info("=======================================================");
        LOGGER.info("=== tinyMediaManager (c) 2012 - 2022 Manuel Laggner ===");
        LOGGER.info("=======================================================");
        LOGGER.info("tmm.version      : {}", (Object)ReleaseInfo.getRealVersion());
        LOGGER.info("os.name          : {}", (Object)System.getProperty("os.name"));
        LOGGER.info("os.version       : {}", (Object)System.getProperty("os.version"));
        LOGGER.info("os.arch          : {}", (Object)System.getProperty("os.arch"));
        LOGGER.info("java.version     : {}", (Object)System.getProperty("java.version"));
        LOGGER.info("java.maxMem      : {} MiB", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        if (Globals.isRunningJavaWebStart()) {
            LOGGER.info("java.webstart    : true");
        }
        if (Globals.isRunningWebSwing()) {
            LOGGER.info("java.webswing    : true");
        }
        TinyMediaManager.debugCharacterEncoding("current encoding : ");
        Locale.setDefault(Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()));
        LOGGER.info("System language  : {}_{}", (Object)System.getProperty("user.language"), (Object)System.getProperty("user.country"));
        LOGGER.info("GUI language     : {}_{}", (Object)Locale.getDefault().getLanguage(), (Object)Locale.getDefault().getCountry());
        LOGGER.info("Scraper language : {}", (Object)MovieModuleManager.getInstance().getSettings().getScraperLanguage());
        LOGGER.info("TV Scraper lang  : {}", (Object)TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block45: {
                    boolean newVersion = !Settings.getInstance().isCurrentVersion();
                    try {
                        Thread.setDefaultUncaughtExceptionHandler(new Log4jBackstop());
                        if (!GraphicsEnvironment.isHeadless()) {
                            Thread.currentThread().setName("main");
                            TmmTaskbar.setImage(new LogoCircle().getImage());
                        } else {
                            Thread.currentThread().setName("headless");
                            LOGGER.debug("starting without GUI...");
                        }
                        Toolkit tk = Toolkit.getDefaultToolkit();
                        tk.addAWTEventListener(TmmUILayoutStore.getInstance(), 64L);
                        if (!GraphicsEnvironment.isHeadless()) {
                            TinyMediaManager.setLookAndFeel();
                        }
                        this.doStartupTasks();
                        org.jdesktop.beansbinding.util.logging.Logger.getLogger((String)ELProperty.class.getName()).setLevel(java.util.logging.Level.SEVERE);
                        TmmUILogCollector.init();
                        LOGGER.info("=====================================================");
                        SplashScreen splash = null;
                        if (!GraphicsEnvironment.isHeadless()) {
                            splash = SplashScreen.getSplashScreen();
                        }
                        Graphics2D g2 = null;
                        if (splash != null) {
                            g2 = splash.createGraphics();
                            if (g2 != null) {
                                Font font = new Font("Dialog", 0, 11);
                                g2.setFont(font);
                                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                            } else {
                                LOGGER.debug("got no graphics from splash");
                            }
                        } else {
                            LOGGER.debug("no splash found");
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "starting tinyMediaManager", 0);
                            splash.update();
                        }
                        LOGGER.info("starting tinyMediaManager");
                        UpgradeTasks.setOldVersion();
                        if (newVersion) {
                            LOGGER.info("Upgrade from " + UpgradeTasks.getOldVersion() + " to " + ReleaseInfo.getVersion());
                            if (g2 != null) {
                                this.updateProgress(g2, "upgrading to new version", 10);
                                splash.update();
                            }
                            UpgradeTasks.performUpgradeTasksBeforeDatabaseLoading();
                            Settings.getInstance().setCurrentVersion();
                            Settings.getInstance().saveSettings();
                        }
                        if (Settings.getInstance().useProxy()) {
                            LOGGER.info("setting proxy");
                            Settings.getInstance().setProxy();
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "loading internals", 20);
                            splash.update();
                        }
                        TmmOsUtils.loadNativeLibs();
                        MediaGenres.init();
                        LanguageUtils.init();
                        if (g2 != null) {
                            this.updateProgress(g2, "loading movie module", 30);
                            splash.update();
                        }
                        TmmModuleManager.getInstance().startUp();
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> TmmModuleManager.getInstance().shutDown()));
                        TmmModuleManager.getInstance().registerModule(MovieModuleManager.getInstance());
                        TmmModuleManager.getInstance().enableModule(MovieModuleManager.getInstance());
                        if (g2 != null) {
                            this.updateProgress(g2, "loading TV show module", 40);
                            splash.update();
                        }
                        TmmModuleManager.getInstance().registerModule(TvShowModuleManager.getInstance());
                        TmmModuleManager.getInstance().enableModule(TvShowModuleManager.getInstance());
                        if (g2 != null) {
                            this.updateProgress(g2, "loading plugins", 50);
                            splash.update();
                        }
                        MediaProviders.loadMediaProviders();
                        if (Settings.getInstance().isNewConfig()) {
                            MovieSettingsDefaults.setDefaultScrapers();
                            TvShowSettingsDefaults.setDefaultScrapers();
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "starting services", 60);
                            splash.update();
                        }
                        Upnp u = Upnp.getInstance();
                        if (Settings.getInstance().isUpnpShareLibrary()) {
                            u.startWebServer();
                            u.createUpnpService();
                            u.startMediaServer();
                        }
                        if (Settings.getInstance().isUpnpRemotePlay()) {
                            u.createUpnpService();
                            u.sendPlayerSearchRequest();
                            u.startWebServer();
                        }
                        try {
                            KodiRPC.getInstance().connect();
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage());
                        }
                        if (newVersion) {
                            if (g2 != null) {
                                this.updateProgress(g2, "upgrading database to new version", 70);
                                splash.update();
                            }
                            UpgradeTasks.performUpgradeTasksAfterDatabaseLoading();
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "loading ui", 80);
                            splash.update();
                        }
                        if (!GraphicsEnvironment.isHeadless()) {
                            TmmThreadPool task;
                            LocalDate validUntil;
                            MainWindow window = MainWindow.getInstance();
                            if (g2 != null) {
                                this.updateProgress(g2, "finished starting :)", 100);
                                splash.update();
                            }
                            TmmUILayoutStore.getInstance().loadSettings(window);
                            window.setVisible(true);
                            if (Settings.getInstance().isNewConfig()) {
                                TinyMediaManagerWizard wizard = new TinyMediaManagerWizard();
                                wizard.setLocationRelativeTo(null);
                                wizard.setVisible(true);
                            } else if (!Boolean.parseBoolean(System.getProperty("tmm.noupdate"))) {
                                TmmUIHelper.checkForUpdate(5, false);
                            }
                            if (newVersion && !ReleaseInfo.getVersion().equals(UpgradeTasks.getOldVersion())) {
                                SwingUtilities.invokeLater(WhatsNewDialog::showChangelog);
                            }
                            if (newVersion && UpgradeTasks.getOldVersion().startsWith("3")) {
                                TmmUIHelper.restartWarningAfterV4Upgrade();
                            }
                            if (License.getInstance().isValidLicense() && (validUntil = License.getInstance().validUntil()) != null && validUntil.minus(7L, ChronoUnit.DAYS).isBefore(LocalDate.now())) {
                                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(window, TmmResourceBundle.getString("tmm.renewlicense").replace("{}", TmmDateFormat.MEDIUM_DATE_FORMAT.format(Date.valueOf(validUntil)))));
                            }
                            if (MovieModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                                task = new MovieUpdateDatasourceTask();
                                TmmTaskManager.getInstance().addMainTask(task);
                            }
                            if (TvShowModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                                task = new TvShowUpdateDatasourceTask();
                                TmmTaskManager.getInstance().addMainTask(task);
                            }
                            break block45;
                        }
                        TinyMediaManager.setConsoleLogLevel();
                        TinyMediaManagerCLI.start(args);
                        while (TmmTaskManager.getInstance().poolRunning()) {
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException window) {}
                        }
                        LOGGER.info("bye bye");
                        try {
                            TmmTaskManager.getInstance().shutdown();
                            TmmModuleManager.getInstance().saveSettings();
                            TmmTaskManager.getInstance().shutdownNow();
                            TmmModuleManager.getInstance().shutDown();
                            TinyMediaManager.shutdownLogger();
                        }
                        catch (Exception ex) {
                            LOGGER.warn(ex.getMessage());
                        }
                        System.exit(0);
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error("IllegalStateException", (Throwable)e);
                        if (!GraphicsEnvironment.isHeadless() && e.getMessage().contains("file is locked")) {
                            JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.nostart") + "\n" + TmmResourceBundle.getString("tmm.nostart.instancerunning"), TmmResourceBundle.getString("tmm.nostart"), 0, new LogoCircle());
                        }
                        TinyMediaManager.shutdownLogger();
                        System.exit(1);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while start of tmm", (Throwable)e);
                        if (!GraphicsEnvironment.isHeadless()) {
                            MessageDialog.showExceptionWindow(e);
                        }
                        TinyMediaManager.shutdownLogger();
                        System.exit(1);
                    }
                }
            }

            private void updateProgress(Graphics2D g2, String text, int progress) {
                g2.setComposite(AlphaComposite.Clear);
                g2.fillRect(50, 350, 230, 100);
                g2.setPaintMode();
                g2.setColor(new Color(134, 134, 134));
                g2.drawString(text + "...", 51, 390);
                int l = g2.getFontMetrics().stringWidth(ReleaseInfo.getRealVersion());
                g2.drawString(ReleaseInfo.getRealVersion(), 277 - l, 443);
                g2.setColor(new Color(20, 20, 20));
                g2.fillRoundRect(51, 400, 227, 6, 6, 6);
                g2.setColor(new Color(134, 134, 134));
                g2.fillRoundRect(51, 400, 227 * progress / 100, 6, 6, 6);
                LOGGER.debug("Startup (" + progress + "%) " + text);
            }

            private void doStartupTasks() {
                UpgradeTasks.renameDownloadedFiles();
                Utils.cleanOldLogs();
                Path db = Paths.get(Settings.getInstance().getSettingsFolder(), new String[0]);
                Utils.createBackupFile(db);
                Utils.deleteOldBackupFile(db, 5);
                if (Platform.isLinux() && !TmmOsUtils.existsDesktopFileForLinux()) {
                    Path desktopFile = Paths.get(System.getProperty("user.home"), ".local", "share", "applications", "tinyMediaManager.desktop").toAbsolutePath();
                    if (Files.isWritable(desktopFile.getParent())) {
                        TmmOsUtils.createDesktopFileForLinux(desktopFile.toFile());
                    } else {
                        TmmOsUtils.createDesktopFileForLinux(new File("tinyMediaManager.desktop"));
                    }
                }
            }
        });
    }

    public static void setLookAndFeel() {
        try {
            Font font = Font.decode(Settings.getInstance().getFontFamily());
            Font savedFont = new Font(font.getFamily(), font.getStyle(), Settings.getInstance().getFontSize());
            UIManager.put("defaultFont", savedFont);
        }
        catch (Exception e) {
            LOGGER.warn("could not set default font - {}", (Object)e.getMessage());
        }
        try {
            TmmUIHelper.setTheme();
            ToolTipManager.sharedInstance().setInitialDelay(300);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize LaF - {}", (Object)e.getMessage());
        }
    }

    public static void shutdownLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    public static void setConsoleLogLevel() {
        Level level;
        String loglevelAsString;
        switch (loglevelAsString = System.getProperty("tmm.consoleloglevel", "")) {
            case "OFF": {
                level = null;
                break;
            }
            case "ERROR": {
                level = Level.ERROR;
                break;
            }
            case "WARN": {
                level = Level.WARN;
                break;
            }
            case "INFO": {
                level = Level.INFO;
                break;
            }
            case "DEBUG": {
                level = Level.DEBUG;
                break;
            }
            case "TRACE": {
                level = Level.TRACE;
                break;
            }
            default: {
                return;
            }
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender consoleAppender = lc.getLogger("ROOT").getAppender("CONSOLE");
        if (consoleAppender instanceof ConsoleAppender) {
            if (level == null) {
                consoleAppender.stop();
            } else {
                ThresholdLoggerFilter filter = new ThresholdLoggerFilter(level);
                filter.start();
                consoleAppender.clearAllFilters();
                consoleAppender.addFilter((Filter)filter);
            }
        }
    }

    private static void debugCharacterEncoding(String text) {
        String defaultCharacterEncoding = System.getProperty("file.encoding");
        byte[] bArray = new byte[]{119};
        ByteArrayInputStream is = new ByteArrayInputStream(bArray);
        InputStreamReader reader = new InputStreamReader(is);
        LOGGER.info(text + defaultCharacterEncoding + " | " + reader.getEncoding() + " | " + Charset.defaultCharset());
    }
}

