/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.mediainfo.MediaInfoUtils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class TmmOsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmOsUtils.class);
    public static final String DESKTOP_FILE = "tinyMediaManager.desktop";

    private TmmOsUtils() {
    }

    public static boolean existsDesktopFileForLinux() {
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
            return false;
        }
        String currentUsersHomeDir = System.getProperty("user.home");
        for (Path path : Arrays.asList(Paths.get(currentUsersHomeDir, ".local", "share", "applications", DESKTOP_FILE).toAbsolutePath(), Paths.get("usr", "local", "share", "applications", DESKTOP_FILE).toAbsolutePath(), Paths.get("usr", "share", "applications", DESKTOP_FILE).toAbsolutePath())) {
            if (path.toFile().exists()) continue;
            return true;
        }
        return false;
    }

    public static void createDesktopFileForLinux(File desktop) {
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
            return;
        }
        String path = new File(TinyMediaManager.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(60);
        sb.append("[Desktop Entry]\n");
        sb.append("Type=Application\n");
        sb.append("Name=tinyMediaManager\n");
        sb.append("Path=");
        sb.append(path);
        sb.append('\n');
        sb.append("Exec=/bin/sh -c \"");
        sb.append(path);
        sb.append("/tinyMediaManager\"\n");
        sb.append("Icon=");
        sb.append(path);
        sb.append("/tmm.png\n");
        sb.append("Categories=AudioVideo;Video;Database;Java;");
        sb.append("\n");
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(desktop, "UTF-8");){
            writer.write(sb.toString());
            if (!desktop.setExecutable(true)) {
                LOGGER.warn("could not make {} executable", (Object)desktop.getName());
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public static ProcessBuilder getPBforTMMrestart() {
        ProcessBuilder pb;
        Path tmmExecutable;
        if (SystemUtils.IS_OS_WINDOWS) {
            tmmExecutable = Paths.get("tinyMediaManager.exe", new String[0]);
            pb = new ProcessBuilder("cmd", "/c", "start", tmmExecutable.toAbsolutePath().getFileName().toString());
        } else if (SystemUtils.IS_OS_MAC) {
            tmmExecutable = Paths.get("../../MacOS/tinyMediaManager", new String[0]);
            pb = new ProcessBuilder("nohup", "/bin/sh", "-c", "./" + tmmExecutable.toAbsolutePath().getFileName().toString());
        } else {
            tmmExecutable = Paths.get("tinyMediaManager", new String[0]);
            pb = new ProcessBuilder("nohup", "/bin/sh", "-c", "./" + tmmExecutable.toAbsolutePath().getFileName().toString());
        }
        pb.directory(tmmExecutable.toAbsolutePath().getParent().toAbsolutePath().toFile());
        pb.redirectOutput(new File(SystemUtils.IS_OS_WINDOWS ? "NUL" : "/dev/null")).redirectErrorStream(true);
        return pb;
    }

    public static void loadNativeLibs() {
        String miv;
        if (!Platform.is64Bit()) {
            return;
        }
        Object nativepath = "native/";
        if (SystemUtils.IS_OS_WINDOWS) {
            nativepath = (String)nativepath + "windows";
        } else if (SystemUtils.IS_OS_LINUX) {
            nativepath = (String)nativepath + "linux";
        } else if (SystemUtils.IS_OS_MAC) {
            nativepath = (String)nativepath + "mac";
        }
        Path tmmNativeDir = Paths.get((String)nativepath, new String[0]).toAbsolutePath();
        try {
            Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), "tmm");
            Path nativeDir = tmpDir.resolve((String)nativepath).toAbsolutePath();
            Utils.copyDirectoryRecursive(tmmNativeDir, nativeDir);
            if (!Files.exists(nativeDir, new LinkOption[0]) || Utils.isFolderEmpty(nativeDir)) {
                throw new FileNotFoundException(nativeDir.toString());
            }
            System.setProperty("jna.library.path", nativeDir.toString());
            LOGGER.debug("Loading native libs from: {}", (Object)nativeDir);
        }
        catch (Exception e) {
            LOGGER.info("could not copy native libs to the temp folder -> try to load from install dir");
            System.setProperty("jna.library.path", tmmNativeDir.toString());
            LOGGER.debug("Loading native libs from: {}", (Object)tmmNativeDir);
        }
        if (MediaInfoUtils.useMediaInfo() && !StringUtils.isEmpty((CharSequence)(miv = MediaInfo.version()))) {
            LOGGER.info("Using libmediainfo version '{}'", (Object)miv);
        }
    }
}

