/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.addon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.addon.IAddon;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.UrlUtil;

public class AddonManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddonManager.class);
    private static final String REPOSITORY_URL = "https://gitlab.com/api/v4/projects/9945251/packages/maven/org/tinymediamanager/addon/";

    private AddonManager() {
        throw new IllegalAccessError();
    }

    static String getOsName() {
        if (SystemUtils.IS_OS_MAC) {
            return "macos";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return "windows";
        }
        return "linux";
    }

    static String getOsArch() {
        String arch = SystemUtils.OS_ARCH;
        if ("arm".equalsIgnoreCase(arch)) {
            return "armv7";
        }
        return arch;
    }

    static Path getAddonFolder() {
        return Paths.get("native", "addons");
    }

    public static String getLatestVersionForAddon(IAddon addon) {
        String metadataXml;
        try {
            OnDiskCachedUrl url = new OnDiskCachedUrl(REPOSITORY_URL + addon.getFullAddonName() + "/maven-metadata.xml", 1, TimeUnit.DAYS);
            metadataXml = UrlUtil.getStringFromUrl(url);
        }
        catch (Exception e) {
            LOGGER.error("could not load addon metadata - '{}'", (Object)e.getMessage());
            return "";
        }
        if (StringUtils.isBlank((CharSequence)metadataXml)) {
            return "";
        }
        Document document = Jsoup.parse((String)metadataXml, (String)"", (Parser)Parser.xmlParser());
        Elements elements = document.select("metadata > versioning > release");
        if (elements.isEmpty()) {
            return "";
        }
        return ((Element)elements.get(0)).text();
    }

    public static void downloadLatestVersionForAddon(IAddon addon) throws IOException, InterruptedException {
        AddonManager.downloadLatestVersionForAddon(addon, AddonManager.getAddonFolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void downloadLatestVersionForAddon(IAddon addon, Path targetFolder) throws IOException, InterruptedException {
        String version = AddonManager.getLatestVersionForAddon(addon);
        Path tempFile = null;
        Path target = targetFolder.resolve(addon.getAddonName());
        try {
            String urlAsString = REPOSITORY_URL + addon.getFullAddonName() + "/" + version + "/" + addon.getFullAddonName() + "-" + version + ".tar.br";
            Url url = new Url(urlAsString);
            String filename = FilenameUtils.getName((String)urlAsString);
            try {
                Path tempFolder = Paths.get(Utils.getTempFolder(), new String[0]);
                if (!Files.exists(tempFolder, new LinkOption[0])) {
                    Files.createDirectory(tempFolder, new FileAttribute[0]);
                }
                tempFile = tempFolder.resolve(filename + ".part");
            }
            catch (Exception e) {
                LOGGER.debug("could not write to temp folder: {}", (Object)e.getMessage());
                tempFile = target.resolveSibling(filename + ".part");
            }
            try (InputStream is = url.getInputStream();
                 FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());){
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                Utils.flushFileOutputStreamToDisk(outputStream);
            }
            if (!Files.exists(tempFile, new LinkOption[0]) || Files.size(tempFile) == 0L) {
                FileUtils.deleteQuietly((File)tempFile.toFile());
                throw new IOException("0byte file downloaded: " + filename);
            }
            Utils.deleteDirectoryRecursive(target);
            Utils.unpackBrotli(tempFile.toFile(), target.toFile());
            Utils.writeStringToFile(targetFolder.resolve(addon.getAddonName() + ".v"), version);
        }
        catch (Throwable throwable) {
            if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                Utils.deleteFileSafely(tempFile);
            }
            throw throwable;
        }
        if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
            Utils.deleteFileSafely(tempFile);
        }
    }
}

