/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieExporter;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieARDetectorTask;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.movie.tasks.MovieSubtitleSearchAndDownloadTask;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.util.ListUtils;
import picocli.CommandLine;

@CommandLine.Command(name="movie", mixinStandardHelpOptions=true, sortOptions=false, synopsisHeading="%n", footerHeading="%nExamples:%n", footer={"  tinyMediaManager movie -u -n -r", "    to find/scrape and rename new movies%n", "  tinyMediaManager movie -t -s", "    to download missing trailer/subtitles%n", "  tinyMediaManager movie -e -eT=ExcelXml -eP=/user/export/movies", "    to export the movie list with the ExcelXml template to /user/export/movies"})
class MovieCommand
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieCommand.class);
    @CommandLine.ArgGroup
    Datasource datasource;
    @CommandLine.ArgGroup
    Scrape scrape;
    @CommandLine.Option(names={"-t", "--downloadTrailer"}, description={"Download missing trailers"})
    boolean downloadTrailer;
    @CommandLine.ArgGroup(exclusive=false)
    Subtitle subtitle;
    @CommandLine.ArgGroup
    Rename rename;
    @CommandLine.ArgGroup(exclusive=false)
    Export export;
    @CommandLine.Option(names={"-w", "--rewriteNFO"}, description={"Rewrite NFO files of all movies"})
    boolean rewriteNFO;
    @CommandLine.ArgGroup
    AspectRatioDetect ard;

    MovieCommand() {
    }

    @Override
    public void run() {
        if (this.datasource != null) {
            this.updateDataSources();
        }
        ArrayList<Movie> moviesToScrape = new ArrayList<Movie>();
        if (this.scrape != null) {
            this.scrapeMovies(moviesToScrape);
        }
        if (this.ard != null) {
            this.detectAspectRatio();
        }
        if (this.downloadTrailer) {
            this.downloadTrailer();
        }
        if (this.subtitle != null && this.subtitle.download) {
            this.downloadSubtitles();
        }
        if (this.rename != null) {
            this.renameMovies(moviesToScrape);
        }
        if (this.export != null) {
            this.exportMovies();
        }
        if (this.rewriteNFO) {
            this.rewriteNfoFiles();
        }
    }

    private void updateDataSources() {
        LOGGER.info("updating movie data sources...");
        if (this.datasource.updateAll) {
            MovieUpdateDatasourceTask task = new MovieUpdateDatasourceTask();
            task.run();
        } else {
            ArrayList<String> dataSources = new ArrayList<String>(MovieModuleManager.getInstance().getSettings().getMovieDataSource());
            if (ListUtils.isNotEmpty(dataSources)) {
                int[] nArray = this.datasource.indices;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (dataSources.size() < i2 - 1) continue;
                    MovieUpdateDatasourceTask task = new MovieUpdateDatasourceTask((String)dataSources.get(i2 - 1));
                    task.run();
                }
            }
        }
        LOGGER.info("Found {} new movies", (Object)MovieModuleManager.getInstance().getMovieList().getNewMovies().size());
    }

    private void scrapeMovies(List<Movie> moviesToScrape) {
        if (this.scrape.scrapeAll) {
            LOGGER.info("scraping ALL movies...");
            moviesToScrape.addAll(MovieModuleManager.getInstance().getMovieList().getMovies());
        } else if (this.scrape.scrapeNew) {
            LOGGER.info("scraping NEW movies...");
            moviesToScrape.addAll(MovieModuleManager.getInstance().getMovieList().getNewMovies());
        } else if (this.scrape.scrapeUnscraped) {
            LOGGER.info("scraping UNSCRAPED movies...");
            moviesToScrape.addAll(MovieModuleManager.getInstance().getMovieList().getUnscrapedMovies());
        }
        if (!moviesToScrape.isEmpty()) {
            MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
            List<MovieScraperMetadataConfig> config = MovieModuleManager.getInstance().getSettings().getScraperMetadataConfig();
            options.loadDefaults();
            MovieScrapeTask.MovieScrapeParams movieScrapeParams = new MovieScrapeTask.MovieScrapeParams(moviesToScrape, options, config);
            movieScrapeParams.setOverwriteExistingItems(!MovieModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
            MovieScrapeTask task = new MovieScrapeTask(movieScrapeParams);
            task.run();
            while (TmmTaskManager.getInstance().poolRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void detectAspectRatio() {
        List<Object> moviesToDetect = new ArrayList();
        if (this.ard.ardAll) {
            moviesToDetect = MovieModuleManager.getInstance().getMovieList().getMovies();
        } else if (this.ard.ardNew) {
            moviesToDetect = MovieModuleManager.getInstance().getMovieList().getNewMovies();
        }
        if (!moviesToDetect.isEmpty()) {
            MovieARDetectorTask task = new MovieARDetectorTask(moviesToDetect);
            task.run();
        }
    }

    private void downloadTrailer() {
        LOGGER.info("downloading missing trailers...");
        List moviesWithoutTrailer = MovieModuleManager.getInstance().getMovieList().getMovies().stream().filter(movie -> movie.getMediaFiles(MediaFileType.TRAILER).isEmpty()).collect(Collectors.toList());
        for (Movie movie2 : moviesWithoutTrailer) {
            MovieTrailerDownloadTask task = new MovieTrailerDownloadTask(movie2);
            task.run();
        }
    }

    private void downloadSubtitles() {
        LOGGER.info("downloading missing subtitles...");
        ArrayList<MediaLanguages> languages = new ArrayList<MediaLanguages>();
        if (this.subtitle.languages != null) {
            for (String language : this.subtitle.languages) {
                MediaLanguages mediaLanguage = MediaLanguages.get(language);
                if (languages.contains((Object)mediaLanguage)) continue;
                languages.add(mediaLanguage);
            }
        } else {
            languages.add(MovieModuleManager.getInstance().getSettings().getSubtitleScraperLanguage());
        }
        List<Movie> moviesWithoutSubtitle = MovieModuleManager.getInstance().getMovieList().getMovies().stream().filter(movie -> !movie.getHasSubtitles()).collect(Collectors.toList());
        for (MediaLanguages language : languages) {
            MovieSubtitleSearchAndDownloadTask task = new MovieSubtitleSearchAndDownloadTask(moviesWithoutSubtitle, language);
            task.run();
        }
    }

    private void renameMovies(List<Movie> moviesToScrape) {
        ArrayList<Movie> moviesToRename = new ArrayList<Movie>();
        if (this.rename.renameNew) {
            LOGGER.info("renaming NEW/RECENTLY SCRAPED movies...");
            moviesToRename.addAll(moviesToScrape);
        } else if (this.rename.renameAll) {
            LOGGER.info("renaming ALL movies...");
            moviesToRename.addAll(MovieModuleManager.getInstance().getMovieList().getMovies());
        }
        if (!moviesToRename.isEmpty()) {
            MovieRenameTask task = new MovieRenameTask(moviesToScrape);
            task.run();
        }
    }

    private void exportMovies() {
        for (ExportTemplate exportTemplate : MovieExporter.findTemplates(MediaEntityExporter.TemplateType.MOVIE)) {
            if (!exportTemplate.getPath().endsWith(this.export.template)) continue;
            LOGGER.info("exporting movies...");
            MovieExporter ex = null;
            try {
                ex = new MovieExporter(Paths.get(exportTemplate.getPath(), new String[0]));
                List<Movie> movies = MovieModuleManager.getInstance().getMovieList().getMovies();
                movies.sort(new MovieComparator());
                ex.export(movies, this.export.path);
            }
            catch (Exception e) {
                LOGGER.error("could not export movies - {}", (Object)e.getMessage());
            }
            return;
        }
    }

    private void rewriteNfoFiles() {
        if (MovieModuleManager.getInstance().getSettings().getNfoFilenames().isEmpty()) {
            LOGGER.info("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        for (Movie movie : MovieModuleManager.getInstance().getMovieList().getMovies()) {
            movie.writeNFO();
        }
    }

    static class Export {
        @CommandLine.Option(names={"-e", "--export"}, required=true, description={"Export your movie list using a specified template"})
        boolean export;
        @CommandLine.Option(names={"-eT", "--exportTemplate"}, required=true, description={"The export template to use. Use the folder name from the templates folder"})
        String template;
        @CommandLine.Option(names={"-eP", "--exportPath"}, required=true, description={"The path to export your movie list to"})
        Path path;

        Export() {
        }
    }

    static class Rename {
        @CommandLine.Option(names={"-r", "--renameNew"}, required=true, description={"Rename & cleanup all movies from former scrape command"})
        boolean renameNew;
        @CommandLine.Option(names={"--renameAll"}, required=true, description={"Rename & cleanup all movies"})
        boolean renameAll;

        Rename() {
        }
    }

    static class Subtitle {
        @CommandLine.Option(names={"-s", "--downloadSubtitles"}, required=true, description={"Download missing subtitles"})
        boolean download;
        @CommandLine.Option(names={"-sL", "--subtitleLanguage"}, paramLabel="<language>", description={"Desired subtitle language(s) (optional)"})
        String[] languages;

        Subtitle() {
        }
    }

    static class AspectRatioDetect {
        @CommandLine.Option(names={"-d", "--ardNew"}, description={"Detect aspect ratio of new movies (found with the update options)"})
        boolean ardNew;
        @CommandLine.Option(names={"-dA", "--ardAll"}, description={"Detect aspect ratio of all movies"})
        boolean ardAll;

        AspectRatioDetect() {
        }
    }

    static class Scrape {
        @CommandLine.Option(names={"-n", "--scrapeNew"}, description={"Scrape new movies (found with the update options)"})
        boolean scrapeNew;
        @CommandLine.Option(names={"--scrapeUnscraped"}, description={"Scrape all unscraped movies"})
        boolean scrapeUnscraped;
        @CommandLine.Option(names={"--scrapeAll"}, description={"Scrape all movies"})
        boolean scrapeAll;

        Scrape() {
        }
    }

    static class Datasource {
        @CommandLine.Option(names={"-u", "--updateAll"}, required=true, description={"Scan all data sources for new content"})
        boolean updateAll;
        @CommandLine.Option(names={"--updateX"}, required=true, paramLabel="<index>", description={"Scan the given data sources for new content. The indices are in the same order as in the UI/settings"})
        int[] indices;

        Datasource() {
        }
    }
}

