/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowComparator;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowExporter;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowARDetectorTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowSubtitleSearchAndDownloadTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.util.ListUtils;
import picocli.CommandLine;

@CommandLine.Command(name="tvshow", mixinStandardHelpOptions=true, sortOptions=false, synopsisHeading="%n", footerHeading="%nExamples:%n", footer={"  tinyMediaManager tvshow -u -n -r", "    to find/scrape and rename new TV shows/episodes%n", "  tinyMediaManager tvshow -t -s", "    to download missing trailer/subtitles%n", "  tinyMediaManager tvshow -e -eT=TvShowDetailExampleXml -eP=/user/export/tv", "    to export the TV show list with the TvShowDetailExampleXml template to /user/export/tv"})
class TvShowCommand
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowCommand.class);
    @CommandLine.ArgGroup
    Datasource datasource;
    @CommandLine.ArgGroup
    Scrape scrape;
    @CommandLine.Option(names={"-t", "--downloadTrailer"}, description={"Download missing trailers"})
    boolean downloadTrailer;
    @CommandLine.ArgGroup(exclusive=false)
    Subtitle subtitle;
    @CommandLine.ArgGroup
    Rename rename;
    @CommandLine.ArgGroup(exclusive=false)
    Export export;
    @CommandLine.Option(names={"-w", "--rewriteNFO"}, description={"Rewrite NFO files of all TV shows/episodes"})
    boolean rewriteNFO;
    @CommandLine.ArgGroup
    AspectRatioDetect ard;

    TvShowCommand() {
    }

    @Override
    public void run() {
        if (this.datasource != null) {
            this.updateDataSources();
        }
        ArrayList<TvShow> showsToScrape = new ArrayList<TvShow>();
        ArrayList<TvShowEpisode> episodesToScrape = new ArrayList<TvShowEpisode>();
        if (this.scrape != null) {
            this.scrapeTvShows(showsToScrape, episodesToScrape);
        }
        if (this.ard != null) {
            this.detectAspectRatio();
        }
        if (this.downloadTrailer) {
            this.downloadTrailer();
        }
        if (this.subtitle != null && this.subtitle.download) {
            this.downloadSubtitles();
        }
        if (this.rename != null) {
            this.renameTvShows(showsToScrape, episodesToScrape);
        }
        if (this.export != null) {
            this.exportTvShows();
        }
        if (this.rewriteNFO) {
            this.rewriteNfoFiles();
        }
    }

    private void updateDataSources() {
        LOGGER.info("updating TV show data sources...");
        if (this.datasource.updateAll) {
            TvShowUpdateDatasourceTask task = new TvShowUpdateDatasourceTask();
            task.run();
        } else {
            ArrayList<String> dataSources = new ArrayList<String>(TvShowModuleManager.getInstance().getSettings().getTvShowDataSource());
            if (ListUtils.isNotEmpty(dataSources)) {
                int[] nArray = this.datasource.indices;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (dataSources.size() < i2 - 1) continue;
                    TvShowUpdateDatasourceTask task = new TvShowUpdateDatasourceTask((String)dataSources.get(i2 - 1));
                    task.run();
                }
            }
        }
        LOGGER.info("Found {} new TV shows / {} new episodes", (Object)TvShowModuleManager.getInstance().getTvShowList().getNewTvShows().size(), (Object)TvShowModuleManager.getInstance().getTvShowList().getNewEpisodes().size());
    }

    private void scrapeTvShows(List<TvShow> showsToScrape, List<TvShowEpisode> episodesToScrape) {
        HashSet<TvShow> scrapeShow = new HashSet<TvShow>();
        HashSet<TvShowEpisode> scrapeEpisode = new HashSet<TvShowEpisode>();
        if (this.scrape.scrapeAll) {
            LOGGER.info("scraping ALL tv shows/episodes...");
            scrapeShow.addAll(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
        } else if (this.scrape.scrapeNew) {
            LOGGER.info("scraping NEW tv shows/episodes...");
            scrapeShow.addAll(TvShowModuleManager.getInstance().getTvShowList().getNewTvShows());
            scrapeEpisode.addAll(TvShowModuleManager.getInstance().getTvShowList().getNewEpisodes());
        } else if (this.scrape.scrapeUnscraped) {
            LOGGER.info("scraping UNSCRAPED tv shows/episodes...");
            scrapeShow.addAll(TvShowModuleManager.getInstance().getTvShowList().getUnscrapedTvShows());
            scrapeEpisode.addAll(TvShowModuleManager.getInstance().getTvShowList().getUnscrapedEpisodes());
        }
        HashSet<TvShowEpisode> removedEpisode = new HashSet<TvShowEpisode>();
        for (TvShowEpisode ep : scrapeEpisode) {
            if (!scrapeShow.contains(ep.getTvShow())) continue;
            removedEpisode.add(ep);
        }
        scrapeEpisode.removeAll(removedEpisode);
        showsToScrape.addAll(scrapeShow);
        episodesToScrape.addAll(scrapeEpisode);
        if (!showsToScrape.isEmpty()) {
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.loadDefaults();
            List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = TvShowModuleManager.getInstance().getSettings().getTvShowScraperMetadataConfig();
            List<TvShowEpisodeScraperMetadataConfig> list = TvShowModuleManager.getInstance().getSettings().getEpisodeScraperMetadataConfig();
            TvShowScrapeTask.TvShowScrapeParams tvShowScrapeParams = new TvShowScrapeTask.TvShowScrapeParams(showsToScrape, options, tvShowScraperMetadataConfig, list);
            tvShowScrapeParams.setOverwriteExistingItems(!TvShowModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
            TvShowScrapeTask task = new TvShowScrapeTask(tvShowScrapeParams);
            task.run();
            while (TmmTaskManager.getInstance().poolRunning()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (!episodesToScrape.isEmpty()) {
            HashMap<TvShow, List> newEpisodes = new HashMap<TvShow, List>();
            for (TvShowEpisode tvShowEpisode : episodesToScrape) {
                List episodes = newEpisodes.computeIfAbsent(tvShowEpisode.getTvShow(), k -> new ArrayList());
                episodes.add(tvShowEpisode);
            }
            for (Map.Entry entry : newEpisodes.entrySet()) {
                TvShow tvShow = (TvShow)entry.getKey();
                TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions();
                options.loadDefaults();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tvShow.getLastScraperId(), tvShow.getLastScrapeLanguage()})) {
                    options.setMetadataScraper(MediaScraper.getMediaScraperById(tvShow.getLastScraperId(), ScraperType.TV_SHOW));
                    options.setLanguage(MediaLanguages.valueOf(tvShow.getLastScrapeLanguage()));
                }
                List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = TvShowModuleManager.getInstance().getSettings().getEpisodeScraperMetadataConfig();
                TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask((List)entry.getValue(), options, episodeScraperMetadataConfig, !TvShowModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
                task.run();
                while (TmmTaskManager.getInstance().poolRunning()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private void detectAspectRatio() {
        ArrayList<TvShowEpisode> episodesToDetect = new ArrayList<TvShowEpisode>();
        if (this.ard.ardAll) {
            episodesToDetect.addAll(TvShowModuleManager.getInstance().getTvShowList().getEpisodes());
        } else if (this.ard.ardNew) {
            episodesToDetect.addAll(TvShowModuleManager.getInstance().getTvShowList().getNewEpisodes());
        }
        if (!episodesToDetect.isEmpty()) {
            TvShowARDetectorTask task = new TvShowARDetectorTask(episodesToDetect);
            task.run();
        }
    }

    private void downloadTrailer() {
        LOGGER.info("downloading missing trailers...");
        List tvShowsWithoutTrailer = TvShowModuleManager.getInstance().getTvShowList().getTvShows().stream().filter(tvShow -> tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty()).collect(Collectors.toList());
        for (TvShow tvShow2 : tvShowsWithoutTrailer) {
            TvShowHelpers.downloadBestTrailer(tvShow2);
        }
        while (TmmTaskManager.getInstance().poolRunning()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void downloadSubtitles() {
        LOGGER.info("downloading missing subtitles...");
        ArrayList<MediaLanguages> languages = new ArrayList<MediaLanguages>();
        if (this.subtitle.languages != null) {
            for (String language : this.subtitle.languages) {
                MediaLanguages mediaLanguage = MediaLanguages.get(language);
                if (languages.contains((Object)mediaLanguage)) continue;
                languages.add(mediaLanguage);
            }
        } else {
            languages.add(TvShowModuleManager.getInstance().getSettings().getSubtitleScraperLanguage());
        }
        ArrayList<TvShowEpisode> episodesWithoutSubtitles = new ArrayList<TvShowEpisode>();
        TvShowModuleManager.getInstance().getTvShowList().getTvShows().forEach(tvShow -> tvShow.getEpisodes().forEach(episode -> {
            if (!episode.getHasSubtitles()) {
                episodesWithoutSubtitles.add((TvShowEpisode)episode);
            }
        }));
        for (MediaLanguages language : languages) {
            TvShowSubtitleSearchAndDownloadTask task = new TvShowSubtitleSearchAndDownloadTask(episodesWithoutSubtitles, language);
            task.run();
        }
    }

    private void renameTvShows(List<TvShow> showsToScrape, List<TvShowEpisode> episodesToScrape) {
        TvShowRenameTask task;
        ArrayList<TvShow> tvShowsToRename = new ArrayList<TvShow>();
        ArrayList<TvShowEpisode> episodesToRename = new ArrayList<TvShowEpisode>();
        if (this.rename.renameNew) {
            LOGGER.info("renaming NEW/RECENTLY SCRAPED tv shows...");
            tvShowsToRename.addAll(showsToScrape);
            episodesToRename.addAll(episodesToScrape);
        } else if (this.rename.renameAll) {
            LOGGER.info("renaming ALL tv shows...");
            tvShowsToRename.addAll(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
        }
        if (!tvShowsToRename.isEmpty()) {
            task = new TvShowRenameTask(tvShowsToRename, null, true);
            task.run();
        }
        if (!episodesToRename.isEmpty()) {
            task = new TvShowRenameTask(null, episodesToRename, true);
            task.run();
        }
    }

    private void exportTvShows() {
        for (ExportTemplate exportTemplate : TvShowExporter.findTemplates(MediaEntityExporter.TemplateType.TV_SHOW)) {
            if (!exportTemplate.getPath().endsWith(this.export.template)) continue;
            LOGGER.info("exporting tv shows...");
            TvShowExporter ex = null;
            try {
                ex = new TvShowExporter(Paths.get(exportTemplate.getPath(), new String[0]));
                List<TvShow> tvShows = TvShowModuleManager.getInstance().getTvShowList().getTvShows();
                tvShows.sort(new TvShowComparator());
                ex.export(tvShows, this.export.path);
            }
            catch (Exception e) {
                LOGGER.error("could not export tv shows - {}", (Object)e.getMessage());
            }
            return;
        }
    }

    private void rewriteNfoFiles() {
        if (TvShowModuleManager.getInstance().getSettings().getNfoFilenames().isEmpty()) {
            LOGGER.info("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        for (TvShow tvShow : TvShowModuleManager.getInstance().getTvShowList().getTvShows()) {
            tvShow.writeNFO();
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.writeNFO();
            }
        }
    }

    static class Export {
        @CommandLine.Option(names={"-e", "--export"}, required=true, description={"Export your TV show list using a specified template"})
        boolean export;
        @CommandLine.Option(names={"-eT", "--exportTemplate"}, required=true, description={"The export template to use. Use the folder name from the templates folder"})
        String template;
        @CommandLine.Option(names={"-eP", "--exportPath"}, required=true, description={"The path to export your TV show list to"})
        Path path;

        Export() {
        }
    }

    static class Rename {
        @CommandLine.Option(names={"-r", "--renameNew"}, required=true, description={"Rename & cleanup all TV shows/episodes from former scrape command"})
        boolean renameNew;
        @CommandLine.Option(names={"--renameAll"}, required=true, description={"Rename & cleanup all TV shows/episodes"})
        boolean renameAll;

        Rename() {
        }
    }

    static class Subtitle {
        @CommandLine.Option(names={"-s", "--downloadSubtitles"}, required=true, description={"Download missing subtitles"})
        boolean download;
        @CommandLine.Option(names={"-sL", "--subtitleLanguage"}, paramLabel="<language>", description={"Desired subtitle language(s) (optional)"})
        String[] languages;

        Subtitle() {
        }
    }

    static class AspectRatioDetect {
        @CommandLine.Option(names={"-d", "--ardNew"}, description={"Detect aspect ratio of new TV shows/episodes (found with the update options)"})
        boolean ardNew;
        @CommandLine.Option(names={"-dA", "--ardAll"}, description={"Detect aspect ratio of all TV shows/episodes"})
        boolean ardAll;

        AspectRatioDetect() {
        }
    }

    static class Scrape {
        @CommandLine.Option(names={"-n", "--scrapeNew"}, description={"Scrape new TV shows/episodes (found with the update options)"})
        boolean scrapeNew;
        @CommandLine.Option(names={"--scrapeUnscraped"}, description={"Scrape all unscraped TV shows/episodes"})
        boolean scrapeUnscraped;
        @CommandLine.Option(names={"--scrapeAll"}, description={"Scrape all TV shows/episodes"})
        boolean scrapeAll;

        Scrape() {
        }
    }

    static class Datasource {
        @CommandLine.Option(names={"-u", "--updateAll"}, required=true, description={"Scan all data sources for new content"})
        boolean updateAll;
        @CommandLine.Option(names={"--updateX"}, required=true, paramLabel="<index>", description={"Scan the given data sources for new content. The indices are in the same order as in the UI/settings"})
        int[] indices;

        Datasource() {
        }
    }
}

