/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFilePosition;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.mediainfo.MediaInfoFile;
import org.tinymediamanager.core.mediainfo.MediaInfoUtils;
import org.tinymediamanager.core.mediainfo.MediaInfoXMLParser;
import org.tinymediamanager.core.mediainfo.MediaInfoXmlCreator;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaFileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFileHelper.class);
    public static final List<String> TRAILER_FOLDERS = List.of("trailer", "trailers");
    public static final List<String> EXTRA_FOLDERS = List.of("extra", "extras", "behind the scenes", "behindthescenes", "deleted scenes", "deletedscenes", "deleted", "featurette", "featurettes", "interview", "interviews", "scene", "scenes", "short", "shorts", "other", "others");
    public static final List<String> SUPPORTED_ARTWORK_FILETYPES;
    public static final List<String> DEFAULT_VIDEO_FILETYPES;
    public static final List<String> DEFAULT_AUDIO_FILETYPES;
    public static final List<String> DEFAULT_SUBTITLE_FILETYPES;
    public static final List<String> BINARY_FILETYPES;
    public static final Pattern MOVIESET_ARTWORK_PATTERN;
    public static final Pattern POSTER_PATTERN;
    public static final Pattern FANART_PATTERN;
    public static final Pattern EXTRAFANART_PATTERN;
    public static final Pattern BANNER_PATTERN;
    public static final Pattern THUMB_PATTERN;
    public static final Pattern SEASON_POSTER_PATTERN;
    public static final Pattern SEASON_FANART_PATTERN;
    public static final Pattern SEASON_BANNER_PATTERN;
    public static final Pattern SEASON_THUMB_PATTERN;
    public static final Pattern LOGO_PATTERN;
    public static final Pattern CLEARLOGO_PATTERN;
    public static final Pattern CHARACTERART_PATTERN;
    public static final Pattern DISCART_PATTERN;
    public static final Pattern CLEARART_PATTERN;
    public static final Pattern KEYART_PATTERN;
    public static final String VIDEO_FORMAT_96P = "96p";
    public static final String VIDEO_FORMAT_120P = "120p";
    public static final String VIDEO_FORMAT_144P = "144p";
    public static final String VIDEO_FORMAT_240P = "240p";
    public static final String VIDEO_FORMAT_288P = "288p";
    public static final String VIDEO_FORMAT_360P = "360p";
    public static final String VIDEO_FORMAT_480P = "480p";
    public static final String VIDEO_FORMAT_540P = "540p";
    public static final String VIDEO_FORMAT_576P = "576p";
    public static final String VIDEO_FORMAT_720P = "720p";
    public static final String VIDEO_FORMAT_1080P = "1080p";
    public static final String VIDEO_FORMAT_1440P = "1440p";
    public static final String VIDEO_FORMAT_2160P = "2160p";
    public static final String VIDEO_FORMAT_4320P = "4320p";
    public static final List<String> VIDEO_FORMATS;
    public static final String VIDEO_FORMAT_LD = "LD";
    public static final String VIDEO_FORMAT_SD = "SD";
    public static final String VIDEO_FORMAT_HD = "HD";
    public static final String VIDEO_FORMAT_UHD = "UHD";
    public static final String VIDEO_3D = "3D";
    public static final String VIDEO_3D_SBS = "3D SBS";
    public static final String VIDEO_3D_TAB = "3D TAB";
    public static final String VIDEO_3D_HSBS = "3D HSBS";
    public static final String VIDEO_3D_HTAB = "3D HTAB";
    public static final String VIDEO_3D_MVC = "3D MVC";
    public static final String VIDEO_TS = "VIDEO_TS";
    public static final String BDMV = "BDMV";
    public static final String HVDVD_TS = "HVDVD_TS";

    private MediaFileHelper() {
    }

    public static List<String> getVideoFormats() {
        Field[] declaredFields;
        ArrayList<String> videoFormats = new ArrayList<String>();
        for (Field field : declaredFields = MediaFileHelper.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("VIDEO_FORMAT_") || field.isAnnotationPresent(Deprecated.class)) continue;
            try {
                videoFormats.add((String)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return videoFormats;
    }

    private static Path detectDatasource(Path file) {
        for (String ds : Utils.getAllDatasources()) {
            if (!file.toAbsolutePath().startsWith(ds)) continue;
            return Paths.get(ds, new String[0]);
        }
        return null;
    }

    public static MediaFileType parseMediaFileType(Path pathToFile) {
        return MediaFileHelper.parseMediaFileType(pathToFile, MediaFileHelper.detectDatasource(pathToFile));
    }

    public static MediaFileType parseMediaFileType(Path pathToFile, Path datasource) {
        String foldername;
        String basename;
        String ext;
        String filename;
        block18: {
            block17: {
                filename = pathToFile.getFileName().toString();
                ext = FilenameUtils.getExtension((String)filename).toLowerCase(Locale.ROOT);
                basename = FilenameUtils.getBaseName((String)filename);
                foldername = FilenameUtils.getBaseName((String)(pathToFile.getParent() == null ? "" : pathToFile.getParent().toString().toLowerCase(Locale.ROOT)));
                Path relative = datasource != null ? datasource.relativize(pathToFile) : pathToFile;
                ArrayList<String> relativePathJunks = new ArrayList<String>();
                if (relative.getNameCount() > 2) {
                    relative = relative.subpath(1, relative.getNameCount() - 1);
                    for (int i = 1; i <= relative.getNameCount(); ++i) {
                        relativePathJunks.add(relative.subpath(i - 1, i).toString().toLowerCase(Locale.ROOT));
                    }
                }
                if (filename.contains(".EXTRAS.") || basename.matches("(?i).*[_.-]+extra[s]?$") || basename.matches("(?i).*[-]+extra[s]?[-].*") || foldername.equalsIgnoreCase("extras") || foldername.equalsIgnoreCase("extra") || basename.matches("(?i).*[-](behindthescenes|deleted|featurette|interview|scene|short|other)$")) break block17;
                if (!EXTRA_FOLDERS.stream().anyMatch(relativePathJunks::contains)) break block18;
            }
            return MediaFileType.EXTRA;
        }
        if (ext.equals("nfo")) {
            return MediaFileType.NFO;
        }
        if (ext.equals("vsmeta")) {
            return MediaFileType.VSMETA;
        }
        if (basename.endsWith("-mediainfo") && "xml".equalsIgnoreCase(ext)) {
            return MediaFileType.MEDIAINFO;
        }
        if (SUPPORTED_ARTWORK_FILETYPES.contains(ext)) {
            return MediaFileHelper.parseImageType(pathToFile);
        }
        if (basename.matches("(?i).*[_.-]+theme\\d*$") || basename.matches("(?i)theme\\d*")) {
            return MediaFileType.THEME;
        }
        if (Settings.getInstance().getAudioFileType().contains("." + ext)) {
            return MediaFileType.AUDIO;
        }
        if (Settings.getInstance().getSubtitleFileType().contains("." + ext)) {
            return MediaFileType.SUBTITLE;
        }
        if (Settings.getInstance().getVideoFileType().contains("." + ext)) {
            if (basename.matches("(?i).*[\\[\\]\\(\\)_.-]+trailer[\\[\\]\\(\\)_.-]?(\\d)*$") || basename.equalsIgnoreCase("movie-trailer") || TRAILER_FOLDERS.contains(foldername)) {
                return MediaFileType.TRAILER;
            }
            if (basename.matches("(?i).*[\\[\\]\\(\\)_.-]+sample[\\[\\]\\(\\)_.-]?$") || basename.equalsIgnoreCase("sample") || foldername.equalsIgnoreCase("sample")) {
                return MediaFileType.SAMPLE;
            }
            return MediaFileType.VIDEO;
        }
        if (MediaFileHelper.isDiscFile(filename, foldername)) {
            return MediaFileType.VIDEO;
        }
        if (ext.equals("txt")) {
            return MediaFileType.TEXT;
        }
        return MediaFileType.UNKNOWN;
    }

    public static MediaFileType parseImageType(Path pathToFile) {
        String filename = pathToFile.getFileName().toString();
        String foldername = pathToFile.getParent() == null ? "" : pathToFile.getParent().toString().toLowerCase(Locale.ROOT);
        Matcher matcher = MOVIESET_ARTWORK_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.GRAPHIC;
        }
        matcher = SEASON_POSTER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_POSTER;
        }
        matcher = SEASON_FANART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_FANART;
        }
        matcher = SEASON_BANNER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_BANNER;
        }
        matcher = SEASON_THUMB_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.SEASON_THUMB;
        }
        matcher = POSTER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.POSTER;
        }
        matcher = EXTRAFANART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.EXTRAFANART;
        }
        matcher = FANART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            if (foldername.endsWith("extrafanart")) {
                return MediaFileType.EXTRAFANART;
            }
            return MediaFileType.FANART;
        }
        matcher = BANNER_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.BANNER;
        }
        matcher = THUMB_PATTERN.matcher(filename);
        if (matcher.matches()) {
            if (foldername.endsWith("extrathumbs")) {
                return MediaFileType.EXTRATHUMB;
            }
            return MediaFileType.THUMB;
        }
        matcher = CLEARART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CLEARART;
        }
        matcher = LOGO_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.LOGO;
        }
        matcher = CLEARLOGO_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CLEARLOGO;
        }
        matcher = DISCART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.DISC;
        }
        matcher = CHARACTERART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.CHARACTERART;
        }
        if (foldername.endsWith("characterart")) {
            return MediaFileType.CHARACTERART;
        }
        matcher = KEYART_PATTERN.matcher(filename);
        if (matcher.matches()) {
            return MediaFileType.KEYART;
        }
        if (foldername.equalsIgnoreCase("extrafanarts") || foldername.equalsIgnoreCase("extrafanart")) {
            return MediaFileType.EXTRAFANART;
        }
        if (foldername.equalsIgnoreCase("extrathumbs") || foldername.equalsIgnoreCase("extrathumb")) {
            return MediaFileType.EXTRATHUMB;
        }
        return MediaFileType.GRAPHIC;
    }

    public static String getVideoFormat(MediaFile mediaFile) {
        int w = mediaFile.getVideoWidth();
        int h = mediaFile.getVideoHeight();
        if (w == 0 || h == 0) {
            return "";
        }
        if (w <= MediaFileHelper.blur(128) && h <= MediaFileHelper.blur(96)) {
            return VIDEO_FORMAT_96P;
        }
        if (w <= MediaFileHelper.blur(160) && h <= MediaFileHelper.blur(120)) {
            return VIDEO_FORMAT_120P;
        }
        if (w <= MediaFileHelper.blur(176) && h <= MediaFileHelper.blur(144)) {
            return VIDEO_FORMAT_144P;
        }
        if (w <= MediaFileHelper.blur(256) && h <= MediaFileHelper.blur(144)) {
            return VIDEO_FORMAT_144P;
        }
        if (w <= MediaFileHelper.blur(320) && h <= MediaFileHelper.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= MediaFileHelper.blur(352) && h <= MediaFileHelper.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= MediaFileHelper.blur(426) && h <= MediaFileHelper.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= MediaFileHelper.blur(480) && h <= MediaFileHelper.blur(272)) {
            return VIDEO_FORMAT_288P;
        }
        if (w <= MediaFileHelper.blur(480) && h <= MediaFileHelper.blur(360)) {
            return VIDEO_FORMAT_360P;
        }
        if (w <= MediaFileHelper.blur(640) && h <= MediaFileHelper.blur(360)) {
            return VIDEO_FORMAT_360P;
        }
        if (w <= MediaFileHelper.blur(640) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(720) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(800) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(853) && h <= MediaFileHelper.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= MediaFileHelper.blur(776) && h <= MediaFileHelper.blur(592)) {
            return VIDEO_FORMAT_576P;
        }
        if (w <= MediaFileHelper.blur(960) && h <= MediaFileHelper.blur(544)) {
            return VIDEO_FORMAT_540P;
        }
        if (w <= MediaFileHelper.blur(1280) && h <= MediaFileHelper.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= MediaFileHelper.blur(960) && h <= MediaFileHelper.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= MediaFileHelper.blur(1080) && h <= MediaFileHelper.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= MediaFileHelper.blur(1920) && h <= MediaFileHelper.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= MediaFileHelper.blur(1440) && h <= MediaFileHelper.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= MediaFileHelper.blur(1620) && h <= MediaFileHelper.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= MediaFileHelper.blur(1920) && h <= MediaFileHelper.blur(1440)) {
            return VIDEO_FORMAT_1440P;
        }
        if (w <= MediaFileHelper.blur(2160) && h <= MediaFileHelper.blur(1440)) {
            return VIDEO_FORMAT_1440P;
        }
        if (w <= MediaFileHelper.blur(2560) && h <= MediaFileHelper.blur(1440)) {
            return VIDEO_FORMAT_1440P;
        }
        if (w <= MediaFileHelper.blur(3840) && h <= MediaFileHelper.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(3840) && h <= MediaFileHelper.blur(1600)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(4096) && h <= MediaFileHelper.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(4096) && h <= MediaFileHelper.blur(1716)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= MediaFileHelper.blur(3996) && h <= MediaFileHelper.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        return VIDEO_FORMAT_4320P;
    }

    public static String getVideoDefinitionCategory(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return "";
        }
        if (mediaFile.getVideoWidth() == 0 || mediaFile.getVideoHeight() == 0) {
            return "";
        }
        if (mediaFile.getVideoWidth() <= 640 && mediaFile.getVideoHeight() <= 360) {
            return VIDEO_FORMAT_LD;
        }
        if (mediaFile.getVideoWidth() < 1280 && mediaFile.getVideoHeight() < 720) {
            return VIDEO_FORMAT_SD;
        }
        if (mediaFile.getVideoWidth() <= 1920 && mediaFile.getVideoHeight() <= 1080) {
            return VIDEO_FORMAT_HD;
        }
        return VIDEO_FORMAT_UHD;
    }

    public static boolean isVideoDefinitionLD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_LD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    public static boolean isVideoDefinitionSD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_SD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    public static boolean isVideoDefinitionHD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_HD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    public static boolean isVideoDefinitionUHD(MediaFile mediaFile) {
        if (!mediaFile.isVideo()) {
            return false;
        }
        return VIDEO_FORMAT_UHD.equals(MediaFileHelper.getVideoDefinitionCategory(mediaFile));
    }

    private static int blur(int value) {
        return value + value / 100;
    }

    public static boolean gatherFileInformation(MediaFile mediaFile) {
        boolean dirty = false;
        try {
            long size;
            BasicFileAttributes view = Files.readAttributes(mediaFile.getFileAsPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (view.creationTime().toMillis() > 100000L) {
                Date creDat = new Date(view.creationTime().toMillis());
                mediaFile.setDateCreated(creDat);
            }
            if (view.lastModifiedTime().toMillis() > 100000L) {
                Date modDat = new Date(view.lastModifiedTime().toMillis());
                mediaFile.setDateLastModified(modDat);
                mediaFile.setFiledate(view.lastModifiedTime().toMillis());
            }
            if ((size = view.size()) > 0L && mediaFile.getFilesize() > 0L && size != mediaFile.getFilesize()) {
                dirty = true;
            }
            mediaFile.setFilesize(size);
        }
        catch (Exception e) {
            LOGGER.debug("could not get file information (size/date): {}", (Object)e.getMessage());
        }
        if (mediaFile.getFile().toFile().isDirectory()) {
            long size = FileUtils.sizeOfDirectory((File)mediaFile.getFile().toFile());
            if (size > 0L && mediaFile.getFilesize() > 0L && size != mediaFile.getFilesize()) {
                dirty = true;
            }
            mediaFile.setFilesize(size);
        }
        return dirty;
    }

    public static void gatherMediaInformation(MediaFile mediaFile, boolean force) {
        String extension = mediaFile.getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            extension = extension.toLowerCase(Locale.ROOT);
        }
        boolean fileSizeChanged = MediaFileHelper.gatherFileInformation(mediaFile);
        if (!mediaFile.isValidMediainfoFormat()) {
            if (StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
                mediaFile.setContainerFormat(extension);
            }
            return;
        }
        if (!(fileSizeChanged || force || mediaFile.getContainerFormat().isEmpty())) {
            return;
        }
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            MediaFileHelper.gatherSubtitleInformation(mediaFile);
        }
        if (mediaFile.getFilesize() == 0L && StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
            LOGGER.debug("0 Byte file detected: {}", (Object)mediaFile.getFilename());
            mediaFile.setContainerFormat(extension);
            return;
        }
        switch (mediaFile.getType()) {
            case SUBTITLE: 
            case NFO: 
            case TEXT: 
            case MEDIAINFO: 
            case VSMETA: 
            case UNKNOWN: 
            case DOUBLE_EXT: {
                mediaFile.setContainerFormat(mediaFile.getExtension());
                return;
            }
        }
        LOGGER.debug("start MediaInfo for {}", (Object)mediaFile.getFileAsPath());
        List<Object> mediaInfoFiles = new ArrayList();
        if (!fileSizeChanged) {
            try {
                Path xmlFile = Paths.get(mediaFile.getPath(), FilenameUtils.getBaseName((String)mediaFile.getFilename()) + "-mediainfo.xml");
                mediaInfoFiles.addAll(MediaFileHelper.detectRelevantFiles(MediaFileHelper.parseMediaInfoXml(xmlFile)));
                if (!mediaInfoFiles.isEmpty()) {
                    LOGGER.trace("mediainfo.xml found - '{}'", (Object)xmlFile.getFileName());
                    MediaFileHelper.parseMediainfoSnapshot(mediaFile, mediaInfoFiles);
                }
            }
            catch (Exception e) {
                mediaInfoFiles.clear();
                LOGGER.debug("could not read mediainfo data - maybe a broken XML? {}", (Object)e.getMessage());
            }
        }
        if (mediaInfoFiles.isEmpty() && !(mediaInfoFiles = mediaFile.isISO() ? MediaFileHelper.getMediaInfoSnapshotFromISO(mediaFile) : MediaFileHelper.getMediaInfoFromSingleFile(mediaFile)).isEmpty()) {
            MediaFileHelper.parseMediainfoSnapshot(mediaFile, mediaInfoFiles);
        }
    }

    private static void parseMediainfoSnapshot(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        if (mediaInfoFiles.isEmpty()) {
            LOGGER.debug("no mediainfo data provided");
            return;
        }
        if (mediaFile.isISO() || mediaFile.isDiscFile()) {
            if (MediaFileHelper.isDVDStructure(mediaInfoFiles)) {
                MediaFileHelper.gatherMediaInformationFromDvdFile(mediaFile, mediaInfoFiles);
            } else if (MediaFileHelper.isBlurayStructure(mediaInfoFiles)) {
                MediaFileHelper.gatherMediaInformationFromBluRayFile(mediaFile, mediaInfoFiles);
            } else if (MediaFileHelper.isHDDVDStructure(mediaInfoFiles)) {
                MediaFileHelper.gatherMediaInformationFromHdDvdFile(mediaFile, mediaInfoFiles);
            } else {
                MediaFileHelper.gatherMediaInformationFromFile(mediaFile, mediaInfoFiles);
            }
        } else {
            MediaFileHelper.gatherMediaInformationFromFile(mediaFile, mediaInfoFiles);
        }
    }

    public static boolean isDiscFile(String filename, String path) {
        return MediaFileHelper.isDVDFile(filename, path) || MediaFileHelper.isBlurayFile(filename, path) || MediaFileHelper.isHDDVDFile(filename, path);
    }

    public static boolean isDVDFile(String filename, String path) {
        String pathname = FilenameUtils.normalizeNoEndSeparator((String)path);
        if (pathname == null) {
            pathname = "";
        }
        pathname = pathname.toLowerCase(Locale.ROOT);
        if ("video_ts".equalsIgnoreCase(filename) || pathname.endsWith("video_ts")) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        return filename.toLowerCase(Locale.ROOT).matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)");
    }

    private static boolean isDVDStructure(List<MediaInfoFile> files) {
        for (MediaInfoFile mediaInfoFile : files) {
            String filename = FilenameUtils.getName((String)mediaInfoFile.getFilename());
            if (!MediaFileHelper.isDVDFile(filename, mediaInfoFile.getPath())) continue;
            return true;
        }
        return false;
    }

    public static boolean isHDDVDFile(String filename, String path) {
        String pathname = FilenameUtils.normalizeNoEndSeparator((String)path);
        if (pathname == null) {
            pathname = "";
        }
        pathname = pathname.toLowerCase(Locale.ROOT);
        return "hvdvd_ts".equalsIgnoreCase(filename) || pathname.endsWith("hvdvd_ts");
    }

    private static boolean isHDDVDStructure(List<MediaInfoFile> files) {
        for (MediaInfoFile mediaInfoFile : files) {
            String filename = FilenameUtils.getName((String)mediaInfoFile.getFilename());
            if (!MediaFileHelper.isHDDVDFile(filename, mediaInfoFile.getPath())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlurayFile(String filename, String path) {
        String pathname = FilenameUtils.normalizeNoEndSeparator((String)path);
        if (pathname == null) {
            pathname = "";
        }
        pathname = pathname.toLowerCase(Locale.ROOT);
        if ("bdmv".equalsIgnoreCase(filename) || pathname.endsWith("bdmv")) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        return filename.toLowerCase(Locale.ROOT).matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts|\\d{5}\\.clpi|\\d{5}\\.mpls)");
    }

    public static boolean isMainDiscIdentifierFile(String filename) {
        return filename.equalsIgnoreCase("video_ts.ifo") || filename.equalsIgnoreCase("index.bdmv") || filename.equalsIgnoreCase("hv000i01.ifo");
    }

    private static boolean isBlurayStructure(List<MediaInfoFile> files) {
        for (MediaInfoFile mediaInfoFile : files) {
            String filename = FilenameUtils.getName((String)mediaInfoFile.getFilename());
            if (!MediaFileHelper.isBlurayFile(filename, mediaInfoFile.getPath())) continue;
            return true;
        }
        return false;
    }

    private static synchronized List<MediaInfoFile> getMediaInfoFromSingleFile(MediaFile mediaFile) {
        if (!MediaInfoUtils.useMediaInfo()) {
            return Collections.emptyList();
        }
        List<MediaInfoFile> mediaInfoFiles = new ArrayList<MediaInfoFile>();
        if (Files.isDirectory(mediaFile.getFileAsPath(), new LinkOption[0])) {
            for (Path path : Utils.listFilesRecursive(mediaFile.getFileAsPath())) {
                try {
                    mediaInfoFiles.add(new MediaInfoFile(path, Files.size(path)));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse filesize of {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            mediaInfoFiles = MediaFileHelper.detectRelevantFiles(mediaInfoFiles);
        } else {
            mediaInfoFiles.add(new MediaInfoFile(mediaFile.getFile()));
        }
        for (MediaInfoFile file : mediaInfoFiles) {
            try (MediaInfo mediaInfo = new MediaInfo();){
                if (!mediaInfo.open(Paths.get(file.getPath(), file.getFilename()))) {
                    LOGGER.error("Mediainfo could not open file: {}", (Object)file);
                    continue;
                }
                file.setSnapshot(mediaInfo.snapshot());
            }
            catch (Error | Exception e) {
                LOGGER.error("Mediainfo could not open file: {} - {}", (Object)mediaFile.getFileAsPath(), (Object)e.getMessage());
            }
        }
        if (Settings.getInstance().isWriteMediaInfoXml() && mediaFile.getType().equals((Object)MediaFileType.VIDEO)) {
            try {
                MediaInfoXmlCreator mediaInfoXmlCreator = new MediaInfoXmlCreator(mediaFile, mediaInfoFiles);
                mediaInfoXmlCreator.write();
            }
            catch (Exception e) {
                LOGGER.debug("could not write mediainfo xml - {}", (Object)e.getMessage());
            }
        }
        return mediaInfoFiles;
    }

    private static List<MediaInfoFile> parseMediaInfoXml(Path xmlFile) {
        List<MediaInfoFile> miFiles = null;
        if (Files.exists(xmlFile, new LinkOption[0])) {
            try {
                LOGGER.trace("try to parse mediainfo xml - {}", (Object)xmlFile);
                miFiles = new MediaInfoXMLParser(xmlFile).parseXML();
            }
            catch (Exception e) {
                LOGGER.debug("unable to parse mediainfo xml - {} - {}", (Object)xmlFile, (Object)e.getMessage());
            }
        }
        if (miFiles == null) {
            return Collections.emptyList();
        }
        return miFiles;
    }

    private static synchronized List<MediaInfoFile> getMediaInfoSnapshotFromISO(MediaFile mediaFile) {
        if (!MediaInfoUtils.useMediaInfo()) {
            return Collections.emptyList();
        }
        List<MediaInfoFile> miFiles = MediaFileHelper.parseIso9660(mediaFile);
        if (miFiles.isEmpty()) {
            miFiles = MediaFileHelper.parseIsoUdf(mediaFile);
        }
        if (Settings.getInstance().isWriteMediaInfoXml()) {
            try {
                MediaInfoXmlCreator mediaInfoXmlCreator = new MediaInfoXmlCreator(mediaFile, miFiles);
                mediaInfoXmlCreator.write();
            }
            catch (Exception e) {
                LOGGER.debug("could not write mediainfo xml - {}", (Object)e.getMessage());
            }
        }
        return miFiles;
    }

    static List<MediaInfoFile> parseIso9660(MediaFile mediaFile) {
        ArrayList<MediaInfoFile> miFiles = new ArrayList<MediaInfoFile>();
        int bufferSize = 65536;
        try (Iso9660FileSystem image = new Iso9660FileSystem(mediaFile.getFileAsPath().toFile(), true);){
            LOGGER.trace("ISO: Open");
            ArrayList<MediaInfoFile> allFiles = new ArrayList<MediaInfoFile>();
            ArrayList<Iso9660FileEntry> fileEntries = new ArrayList<Iso9660FileEntry>();
            for (Iso9660FileEntry entry : image) {
                if (entry.isDirectory()) continue;
                fileEntries.add(entry);
                allFiles.add(new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize()));
            }
            List<MediaInfoFile> relevantFiles = MediaFileHelper.detectRelevantFiles(allFiles);
            for (Iso9660FileEntry entry : fileEntries) {
                MediaInfoFile mif = new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize());
                if (!relevantFiles.contains(mif)) continue;
                LOGGER.trace("ISO: got entry {}, size : {}", (Object)entry.getName(), (Object)entry.getSize());
                MediaFile mf = new MediaFile(Paths.get(mediaFile.getFileAsPath().toString(), entry.getPath()));
                if (!mf.isDiscFile()) continue;
                try (MediaInfo fileMI = new MediaInfo();){
                    int fromBufferSize;
                    byte[] fromBuffer = new byte[bufferSize];
                    long fileSize = entry.getSize();
                    fileMI.openBufferInit(fileSize, 0L);
                    long pos = 0L;
                    do {
                        long toread;
                        if ((fromBufferSize = image.readBytes(entry, pos, fromBuffer, 0, (int)(toread = pos + (long)bufferSize > fileSize ? fileSize - pos : (long)bufferSize))) <= 0) continue;
                        pos += (long)fromBufferSize;
                        int result = fileMI.openBufferContinue(fromBuffer, fromBufferSize);
                        if ((result & 8) == 8) break;
                        if (fileMI.openBufferContinueGoToGet() == -1L) continue;
                        pos = fileMI.openBufferContinueGoToGet();
                        LOGGER.trace("ISO: Seek to {}", (Object)pos);
                        fileMI.openBufferInit(fileSize, pos);
                    } while (fromBufferSize > 0);
                    LOGGER.trace("ISO: finalize entry");
                    fileMI.openBufferFinalize();
                    mif.setSnapshot(fileMI.snapshot());
                    miFiles.add(mif);
                }
                catch (Error | Exception e) {
                    LOGGER.debug("Mediainfo could not open file STREAM for file {}", (Object)entry.getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mediainfo could not open as ISO9660 - {}", (Object)e.getMessage());
        }
        return miFiles;
    }

    static List<MediaInfoFile> parseIsoUdf(MediaFile mediaFile) {
        ArrayList<MediaInfoFile> miFiles = new ArrayList<MediaInfoFile>();
        try (UDFFileSystem image = new UDFFileSystem(mediaFile.getFileAsPath().toFile(), true);){
            int bufferSize = 262144;
            ArrayList<MediaInfoFile> allFiles = new ArrayList<MediaInfoFile>();
            ArrayList<UDFFileEntry> fileEntries = new ArrayList<UDFFileEntry>();
            for (UDFFileEntry entry : image) {
                if (entry.isDirectory()) continue;
                fileEntries.add(entry);
                allFiles.add(new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize()));
            }
            List<MediaInfoFile> relevantFiles = MediaFileHelper.detectRelevantFiles(allFiles);
            for (UDFFileEntry entry : fileEntries) {
                MediaInfoFile mif = new MediaInfoFile(Paths.get(entry.getPath(), new String[0]), entry.getSize());
                if (!relevantFiles.contains(mif)) continue;
                LOGGER.trace("ISO: got entry {}, size : {}", (Object)entry.getPath(), (Object)entry.getSize());
                try (MediaInfo fileMI = new MediaInfo();){
                    int fromBufferSize;
                    byte[] fromBuffer = new byte[bufferSize];
                    long fileSize = entry.getSize();
                    fileMI.openBufferInit(fileSize, 0L);
                    long pos = 0L;
                    do {
                        long toread;
                        if ((fromBufferSize = image.readFileContent(entry, pos, fromBuffer, 0, (int)(toread = pos + (long)bufferSize > fileSize ? fileSize - pos : (long)bufferSize))) <= 0) continue;
                        pos += (long)fromBufferSize;
                        int result = fileMI.openBufferContinue(fromBuffer, fromBufferSize);
                        if ((result & 8) == 8) break;
                        if (fileMI.openBufferContinueGoToGet() == -1L) continue;
                        pos = fileMI.openBufferContinueGoToGet();
                        LOGGER.trace("ISO: Seek to {}", (Object)pos);
                        fileMI.openBufferInit(fileSize, pos);
                    } while (fromBufferSize > 0);
                    LOGGER.trace("ISO: finalize entry");
                    fileMI.openBufferFinalize();
                    mif.setSnapshot(fileMI.snapshot());
                    miFiles.add(mif);
                }
                catch (Error | Exception e) {
                    LOGGER.debug("Mediainfo could not open file UDF for file {} - {}", (Object)entry.getPath(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Mediainfo could not open as UDF - {}", (Object)e.getMessage());
        }
        return miFiles;
    }

    static List<MediaInfoFile> detectRelevantFiles(List<MediaInfoFile> mediaInfoFiles) {
        if (mediaInfoFiles.isEmpty()) {
            return Collections.emptyList();
        }
        if (MediaFileHelper.isDVDStructure(mediaInfoFiles)) {
            return MediaFileHelper.detectRelevantDvdFiles(mediaInfoFiles);
        }
        if (MediaFileHelper.isBlurayStructure(mediaInfoFiles)) {
            return MediaFileHelper.detectRelevantBlurayFiles(mediaInfoFiles);
        }
        if (MediaFileHelper.isHDDVDStructure(mediaInfoFiles)) {
            return MediaFileHelper.detectRelevantHdDvdFiles(mediaInfoFiles);
        }
        return mediaInfoFiles;
    }

    private static List<MediaInfoFile> detectRelevantDvdFiles(List<MediaInfoFile> mediaInfoFiles) {
        String prefix = MediaFileHelper.detectRelevantDvdPrefix(mediaInfoFiles);
        ArrayList<MediaInfoFile> relevantFiles = new ArrayList<MediaInfoFile>();
        MediaInfoFile ifo = null;
        MediaInfoFile vob = null;
        for (MediaInfoFile file : mediaInfoFiles) {
            if (!file.getFilename().startsWith(prefix)) continue;
            if (file.getFileExtension().equalsIgnoreCase("ifo")) {
                ifo = file;
                continue;
            }
            if (!file.getFileExtension().equalsIgnoreCase("vob") || vob != null && vob.getFilesize() >= file.getFilesize()) continue;
            vob = file;
        }
        if (ifo != null) {
            relevantFiles.add(ifo);
        }
        if (vob != null) {
            relevantFiles.add(vob);
        }
        return relevantFiles;
    }

    private static String detectRelevantDvdPrefix(List<MediaInfoFile> mediaInfoFiles) {
        HashMap fileSizes = new HashMap();
        mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("vob")).forEach(mediaInfoFile -> {
            String prefix = mediaInfoFile.getFilename().replaceAll("(?i)_\\d?\\.vob", "");
            Long size = fileSizes.getOrDefault(prefix, 0L) + mediaInfoFile.getFilesize();
            fileSizes.put(prefix, size);
        });
        return (String)fileSizes.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey();
    }

    private static List<MediaInfoFile> detectRelevantBlurayFiles(List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile clpi;
        MediaInfoFile mainVideo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("m2ts")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
        if (mainVideo == null) {
            mainVideo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("mpls")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
        }
        if (mainVideo == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaInfoFile> relevantFiles = new ArrayList<MediaInfoFile>();
        relevantFiles.add(mainVideo);
        String basename = FilenameUtils.getBaseName((String)mainVideo.getFilename());
        MediaInfoFile ssif = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("ssif") && mediaInfoFile.getFilename().startsWith(basename)).findFirst().orElse(null);
        if (ssif != null) {
            relevantFiles.add(ssif);
        }
        if ((clpi = (MediaInfoFile)mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("clpi") && mediaInfoFile.getFilename().startsWith(basename)).findFirst().orElse(null)) != null) {
            relevantFiles.add(clpi);
        }
        return relevantFiles;
    }

    private static List<MediaInfoFile> detectRelevantHdDvdFiles(List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile evo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equalsIgnoreCase("evo")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
        if (evo == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaInfoFile> relevantFiles = new ArrayList<MediaInfoFile>();
        relevantFiles.add(evo);
        return relevantFiles;
    }

    public static String getMediaInfo(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        if (miSnapshot == null) {
            return "";
        }
        List<Map<String, String>> stream = miSnapshot.get((Object)streamKind);
        if (stream == null) {
            return "";
        }
        Map<String, String> info = stream.get(streamNumber);
        if (info == null) {
            return "";
        }
        Map<String, String> normalizedMap = MediaFileHelper.normalizeKeys(info);
        List<String> normalizedKeys = MediaFileHelper.normalizeKeys(keys);
        for (String key : normalizedKeys) {
            String value = normalizedMap.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return value;
        }
        return "";
    }

    public static String getMediaInfoContains(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind streamKind, int streamNumber, String search, String ... keys) {
        if (miSnapshot == null) {
            return "";
        }
        List<Map<String, String>> stream = miSnapshot.get((Object)streamKind);
        if (stream == null) {
            return "";
        }
        Map<String, String> info = stream.get(streamNumber);
        if (info == null) {
            return "";
        }
        Map<String, String> normalizedMap = MediaFileHelper.normalizeKeys(info);
        List<String> normalizedKeys = MediaFileHelper.normalizeKeys(keys);
        for (String key : normalizedKeys) {
            String value = normalizedMap.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value) || !value.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            return search;
        }
        return "";
    }

    private static Map<String, String> normalizeKeys(Map<String, String> originalMap) {
        HashMap<String, String> normalizedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            normalizedMap.put(MediaFileHelper.normalizeKey(entry.getKey()), entry.getValue());
        }
        return normalizedMap;
    }

    private static List<String> normalizeKeys(String ... keys) {
        ArrayList<String> normalizedKeys = new ArrayList<String>();
        for (String key : keys) {
            normalizedKeys.add(MediaFileHelper.normalizeKey(key));
        }
        return normalizedKeys;
    }

    public static String normalizeKey(String key) {
        String normalizedKey = key.replace("(", "");
        normalizedKey = normalizedKey.replace(")", "");
        normalizedKey = normalizedKey.replace('/', '_');
        normalizedKey = normalizedKey.replace('*', '_');
        normalizedKey = normalizedKey.replace(':', '_');
        normalizedKey = normalizedKey.replace('.', '_');
        normalizedKey = normalizedKey.toLowerCase(Locale.ROOT);
        return normalizedKey;
    }

    public static String getMediaInfoDirect(MediaFile mediaFile, MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        List<MediaInfoFile> mediaInfoFiles = MediaFileHelper.getMediaInfoFromSingleFile(mediaFile);
        if (!mediaInfoFiles.isEmpty()) {
            return MediaFileHelper.getMediaInfo(mediaInfoFiles.get(0).getSnapshot(), streamKind, streamNumber, keys);
        }
        return "";
    }

    private static void gatherSubtitleInformation(MediaFile mediaFile) {
        String filename = mediaFile.getFilename();
        String path = mediaFile.getPath();
        MediaFileSubtitle sub = new MediaFileSubtitle();
        String shortname = mediaFile.getBasename().toLowerCase(Locale.ROOT);
        List<String> splitted = ParserUtils.splitByPunctuation(shortname);
        if (splitted.contains("forced")) {
            sub.setForced(true);
            sub.set(MediaStreamInfo.Flags.FLAG_FORCED);
            shortname = shortname.replaceAll("\\p{Punct}*forced", "");
        }
        if (splitted.contains("sdh")) {
            sub.set(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
            shortname = shortname.replaceAll("\\p{Punct}*sdh", "");
        } else if (splitted.contains("cc")) {
            sub.set(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
            shortname = shortname.replaceAll("\\p{Punct}*cc", "");
        }
        sub.setLanguage(LanguageUtils.parseLanguageFromString(shortname));
        if (sub.getLanguage().isEmpty() && filename.endsWith(".sub")) {
            Path idx = Paths.get(path, filename.replaceFirst("sub$", "idx"));
            try (FileReader fr = new FileReader(idx.toFile());
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    String lang = "";
                    if (line.startsWith("id:")) {
                        lang = StrgUtils.substr(line, "id: (.*?),");
                    }
                    if (line.startsWith("# alt:")) {
                        lang = StrgUtils.substr(line, "^# alt: (.*?)$");
                    }
                    if (lang.isEmpty()) continue;
                    sub.setLanguage(LanguageUtils.getIso3LanguageFromLocalizedString(lang));
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.debug("could not read idx file: {}", (Object)e.getMessage());
            }
        }
        sub.setCodec(mediaFile.getExtension());
        mediaFile.setSubtitles(Collections.singletonList(sub));
    }

    private static void gatherSubtitleInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        mediaFile.clearSubtitleInformation();
        int streams = MediaFileHelper.getSubtitleStreamCount(miSnapshot);
        ArrayList<MediaFileSubtitle> subtitles = new ArrayList<MediaFileSubtitle>();
        for (int i = 0; i < streams; ++i) {
            String def;
            MediaFileSubtitle stream = new MediaFileSubtitle();
            stream.id = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, i, "StreamKindPos");
            String codec = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, i, "CodecID/Hint", "Format");
            stream.setCodec(codec.replaceAll("\\p{Punct}", ""));
            String lang = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, i, "Language/String", "Language");
            stream.setLanguage(LanguageUtils.parseLanguageFromString(lang));
            String forced = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, i, "Forced");
            boolean b = forced.equalsIgnoreCase("true") || forced.equalsIgnoreCase("yes");
            stream.setForced(b);
            String title = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, i, "Title");
            if (StringUtils.isNotBlank((CharSequence)title)) {
                stream.setTitle(title);
            }
            if ((def = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, i, "Default")).equalsIgnoreCase("yes")) {
                stream.setDefaultStream(true);
            }
            subtitles.add(stream);
        }
        mediaFile.setSubtitles(subtitles);
    }

    private static void gatherAudioInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        mediaFile.clearAudioInformation();
        ArrayList<MediaFileAudioStream> audioStreams = new ArrayList<MediaFileAudioStream>();
        for (int i = 0; i < MediaFileHelper.getAudioStreamCount(miSnapshot); ++i) {
            String def;
            String commName;
            String audioProfile;
            String addFeature;
            String formatString;
            String[] acSearch = new String[]{"Format", "Format_Profile", "Format_Commercial", "Format_Commercial_IfAny", "CodecID", "Codec"};
            String audioCodec = MediaFileHelper.getMediaInfoContains(miSnapshot, MediaInfo.StreamKind.Audio, i, "TrueHD", acSearch);
            if (StringUtils.isBlank((CharSequence)audioCodec)) {
                audioCodec = MediaFileHelper.getMediaInfoContains(miSnapshot, MediaInfo.StreamKind.Audio, i, "DTS", acSearch);
            }
            if (StringUtils.isBlank((CharSequence)audioCodec)) {
                audioCodec = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format");
                audioCodec = audioCodec.replaceAll("\\p{Punct}", "");
            }
            if ("ac3".equalsIgnoreCase(audioCodec) && "e-ac-3".equalsIgnoreCase(formatString = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_String"))) {
                audioCodec = "EAC3";
            }
            if (!(addFeature = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_AdditionalFeatures")).isEmpty()) {
                if ("dts".equalsIgnoreCase(audioCodec)) {
                    if (addFeature.startsWith("XLL")) {
                        audioCodec = addFeature.endsWith("X") ? "DTS-X" : "DTSHD-MA";
                    }
                    if (addFeature.equals("ES")) {
                        audioCodec = "DTS-ES";
                    }
                    if (addFeature.equals("XBR")) {
                        audioCodec = "DTSHD-HRA";
                    }
                }
                if ("TrueHD".equalsIgnoreCase(audioCodec) && addFeature.equalsIgnoreCase("16-ch")) {
                    audioCodec = "TrueHD/Atmos";
                }
            }
            if (!(audioProfile = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_Profile")).isEmpty()) {
                if ("dts".equalsIgnoreCase(audioCodec)) {
                    if (audioProfile.contains("ES")) {
                        audioCodec = "DTS-ES";
                    }
                    if (audioProfile.contains("HRA")) {
                        audioCodec = "DTSHD-HRA";
                    }
                    if (audioProfile.contains("MA")) {
                        audioCodec = "DTSHD-MA";
                    }
                    if (audioProfile.contains("X")) {
                        audioCodec = "DTS-X";
                    }
                }
                if ("TrueHD".equalsIgnoreCase(audioCodec) && audioProfile.contains("Atmos")) {
                    audioCodec = "TrueHD/Atmos";
                }
                if ("MPEG Audio".equalsIgnoreCase(audioCodec)) {
                    String codecId = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "CodecID");
                    if ("55".equals(codecId) || "A_MPEG/L3".equalsIgnoreCase(codecId) || "Layer 3".equalsIgnoreCase(audioProfile)) {
                        audioCodec = "MP3";
                    } else if ("A_MPEG/L2".equalsIgnoreCase(codecId) || "Layer 2".equalsIgnoreCase(audioProfile)) {
                        audioCodec = "MP2";
                    }
                }
            }
            if (("ac3".equalsIgnoreCase(audioCodec) || "eac3".equalsIgnoreCase(audioCodec) || "dts".equalsIgnoreCase(audioCodec) || "TrueHD".equalsIgnoreCase(audioCodec)) && !(commName = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Format_Commercial", "Format_Commercial_IfAny").toLowerCase(Locale.ROOT)).isEmpty()) {
                if (commName.contains("master audio")) {
                    audioCodec = "DTSHD-MA";
                }
                if (commName.contains("high resolution audio")) {
                    audioCodec = "DTSHD-HRA";
                }
                if (commName.contains("extended") || commName.contains("es matrix") || commName.contains("es discrete")) {
                    audioCodec = "DTS-ES";
                }
                if (commName.contains("truehd") && commName.contains("atmos")) {
                    audioCodec = "TrueHD/Atmos";
                }
                if (commName.contains("dolby digital plus") && commName.contains("atmos")) {
                    audioCodec = "EAC3/Atmos";
                }
                if (commName.contains("ex audio")) {
                    audioCodec = "AC3EX";
                }
            }
            MediaFileAudioStream stream = new MediaFileAudioStream();
            stream.id = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "StreamKindPos");
            stream.setCodec(audioCodec);
            int ch = MediaFileHelper.parseChannelsAsInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Channel(s)"));
            int ch2 = MediaFileHelper.parseChannelsAsInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Channel(s)_Original"));
            if (ch2 > ch) {
                ch = ch2;
            }
            stream.setAudioChannels(ch);
            String br = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "BitRate", "BitRate_Maximum", "BitRate_Minimum", "BitRate_Nominal");
            if (StringUtils.isNotBlank((CharSequence)br)) {
                try {
                    String[] brMode = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "BitRate_Mode").split("/");
                    if (brMode.length > 1) {
                        String[] brChunks = br.split("/");
                        int brMult = 0;
                        for (String brChunk : brChunks) {
                            brMult += MetadataUtil.parseInt(brChunk.trim(), 0);
                        }
                        stream.setBitrate(brMult / 1000);
                    } else {
                        br = br.replace("kb/s", "");
                        stream.setBitrate(Integer.parseInt(br.trim()) / 1000);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse bitrate: {}", (Object)e.getMessage());
                }
            }
            String bd = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "BitDepth");
            stream.setBitDepth(MetadataUtil.parseInt(bd, 0));
            String language = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Language/String", "Language");
            if (language.isEmpty()) {
                if (!mediaFile.isDiscFile()) {
                    String shortname = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                    stream.setLanguage(LanguageUtils.parseLanguageFromString(shortname));
                }
            } else {
                stream.setLanguage(LanguageUtils.parseLanguageFromString(language));
            }
            if ((def = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Default")).equalsIgnoreCase("yes")) {
                stream.setDefaultStream(true);
            }
            String title = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Audio, i, "Title");
            stream.setAudioTitle(title);
            audioStreams.add(stream);
        }
        mediaFile.setAudioStreams(audioStreams);
    }

    private static int getStreamCount(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot, MediaInfo.StreamKind kind) {
        List<Map<String, String>> map = miSnapshot.get((Object)kind);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    private static int getAudioStreamCount(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int streamCount = 0;
        try {
            streamCount = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "AudioCount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (streamCount == 0) {
            streamCount = MediaFileHelper.getStreamCount(miSnapshot, MediaInfo.StreamKind.Audio);
        }
        return streamCount;
    }

    private static int getSubtitleStreamCount(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int streamsTextCount = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "TextCount"), 0);
        int streamsStreamCount = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Text, 0, "StreamCount"), 0);
        return streamsTextCount > 0 ? streamsTextCount : streamsStreamCount;
    }

    public static int parseChannelsAsInt(String channels) {
        int highest = 0;
        if (!channels.isEmpty()) {
            try {
                String[] parts;
                for (String p : parts = channels.split("/")) {
                    String[] c;
                    if (p.toLowerCase(Locale.ROOT).contains("object")) continue;
                    p = p.replaceAll("[a-zA-Z]", "");
                    int ch = 0;
                    for (String s : c = p.split("[^0-9]")) {
                        if (!s.matches("[0-9]+")) continue;
                        ch += Integer.parseInt(s);
                    }
                    if (ch <= highest) continue;
                    highest = ch;
                }
            }
            catch (NumberFormatException e) {
                highest = 0;
            }
        }
        return highest;
    }

    private static void gatherExtraData(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        String episode;
        String season;
        String date;
        String genre;
        String plot;
        String originalTitle;
        String title;
        String imdbId = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "id");
        if (MetadataUtil.isValidImdbId(imdbId)) {
            mediaFile.addExtraData("imdbId", imdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)(title = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Title", "Movie")))) {
            mediaFile.addExtraData("title", title);
        }
        if (StringUtils.isNotBlank((CharSequence)(originalTitle = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Original")))) {
            mediaFile.addExtraData("originalTitle", originalTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(plot = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "extra/LongDescription", "Summary", "Description")))) {
            mediaFile.addExtraData("plot", plot);
        }
        if (StringUtils.isNotBlank((CharSequence)(genre = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Genre")))) {
            mediaFile.addExtraData("genre", genre);
        }
        if (StringUtils.isNotBlank((CharSequence)(date = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Recorded_Date", "Date"))) && date.matches("^\\d{4}.*")) {
            mediaFile.addExtraData("year", date.substring(0, 4));
        }
        if (StringUtils.isNotBlank((CharSequence)(season = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Season")))) {
            mediaFile.addExtraData("season", season);
        }
        if (StringUtils.isNotBlank((CharSequence)(episode = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Recorded_Date", "Date")))) {
            mediaFile.addExtraData("episode", episode);
        }
    }

    private static void gatherVideoInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        mediaFile.clearVideoInformation();
        int height = 0;
        int width = 0;
        try {
            height = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "Height"));
            width = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "Width"));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse width/height: {}", (Object)e.getMessage());
        }
        String mvc = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "MultiView_Count");
        if ("2".equals(mvc) && width > 0 && height > 0) {
            float calculatedAspect = (float)width / (float)height;
            if (calculatedAspect > 3.0f) {
                width /= 2;
            } else if ((double)calculatedAspect < 1.5) {
                height /= 2;
            }
        }
        mediaFile.setVideoWidth(width);
        mediaFile.setVideoHeight(height);
        String br = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "BitRate");
        if (StringUtils.isNotBlank((CharSequence)br)) {
            try {
                mediaFile.setVideoBitRate(Integer.parseInt(br) / 1000);
            }
            catch (NumberFormatException e) {
                mediaFile.setVideoBitRate(0);
            }
        }
        String scanType = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "ScanType");
        String codecId = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "CodecID");
        Object videoCodec = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "CodecID/Hint", "Format");
        if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"Microsoft")) {
            videoCodec = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "Format");
        }
        if (codecId.equalsIgnoreCase("XVID")) {
            videoCodec = "XVID";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"MPEG")) {
            try {
                int version = Integer.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "Format_Version").replaceAll("\\D*", ""));
                videoCodec = "MPEG-" + version;
            }
            catch (Exception e) {
                LOGGER.trace("could not parse MPEG version: {}", (Object)e.getMessage());
            }
        }
        mediaFile.setVideoCodec(MediaFileHelper.getFirstEntryViaScanner((String)videoCodec));
        String bd = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "BitDepth");
        mediaFile.setBitDepth(MetadataUtil.parseInt(bd, 0));
        try {
            String fr = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "FrameRate");
            mediaFile.setFrameRate(Double.parseDouble(fr));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse frame rate: {}", (Object)e.getMessage());
        }
        if (height == 0 || scanType.isEmpty()) {
            mediaFile.setExactVideoFormat("");
        } else {
            mediaFile.setExactVideoFormat("" + height + Character.toLowerCase(scanType.charAt(0)));
        }
        String containerFormat = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Menu_Format_List", "Format");
        if (StringUtils.isBlank((CharSequence)containerFormat)) {
            containerFormat = MediaFileHelper.getFirstEntryViaScanner(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Format/Extensions"));
        }
        if (StringUtils.isNotBlank((CharSequence)containerFormat)) {
            if ("BDAV".equalsIgnoreCase(containerFormat)) {
                containerFormat = "Blu-Ray Video";
            } else if ("DVD-Video".equalsIgnoreCase(containerFormat)) {
                containerFormat = "DVD Video";
            }
            mediaFile.setContainerFormat(containerFormat);
        } else {
            mediaFile.setContainerFormat(mediaFile.getExtension());
        }
        String parString = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "PixelAspectRatio", "Pixel_aspect_ratio");
        if (parString.isEmpty()) {
            parString = "1.0";
        }
        try {
            float par = Float.parseFloat(parString);
            mediaFile.setAspectRatio(Float.valueOf((float)mediaFile.getVideoWidth() * par / (float)mediaFile.getVideoHeight()));
        }
        catch (Exception e) {
            LOGGER.warn("Could not parse AspectRatio '{}'", (Object)parString);
        }
        mediaFile.setVideo3DFormat(MediaFileHelper.parse3DFormat(mediaFile, miSnapshot));
        String hdrFormat = MediaFileHelper.detectHdrFormat(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "HDR_Format/String", "HDR_Format"));
        if (StringUtils.isBlank((CharSequence)hdrFormat)) {
            hdrFormat = MediaFileHelper.detectHdrFormat(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "HDR_Format_Compatibility"));
        }
        if (StringUtils.isBlank((CharSequence)hdrFormat)) {
            hdrFormat = MediaFileHelper.detectHdrFormat(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "transfer_characteristics"));
        }
        mediaFile.setHdrFormat(hdrFormat);
    }

    private static String detectHdrFormat(String source) {
        if ((source = source.toLowerCase(Locale.ROOT)).contains("dolby vision")) {
            return "Dolby Vision";
        }
        if (source.contains("hlg")) {
            return "HLG";
        }
        if (source.contains("2094")) {
            return "HDR10+";
        }
        if (source.contains("hdr10")) {
            return "HDR10";
        }
        return "";
    }

    public static void gatherImageInformation(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int height = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Image, 0, "Height"), 0);
        int width = MetadataUtil.parseInt(MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Image, 0, "Width"), 0);
        String videoCodec = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Image, 0, "CodecID/Hint", "Format");
        mediaFile.clearVideoInformation();
        mediaFile.checkForAnimation();
        mediaFile.setVideoHeight(height);
        mediaFile.setVideoWidth(width);
        mediaFile.setVideoCodec(MediaFileHelper.getFirstEntryViaScanner(videoCodec));
        String extensions = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        mediaFile.setContainerFormat(MediaFileHelper.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
        String bd = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Image, 0, "BitDepth");
        mediaFile.setBitDepth(MetadataUtil.parseInt(bd, 0));
        if (StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
            mediaFile.setContainerFormat(mediaFile.getExtension());
        }
    }

    public static String getFirstEntryViaScanner(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        Scanner scanner = new Scanner(string);
        try {
            String string2 = scanner.next();
            scanner.close();
            return string2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("could not parse string {} with a Scanner: {}", (Object)string, (Object)e.getMessage());
                return "";
            }
        }
    }

    private static void gatherMediaInformationFromFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot = mediaInfoFiles.get(0).getSnapshot();
        if (miSnapshot == null) {
            LOGGER.error("error getting MediaInfo for {}", (Object)mediaFile.getFilename());
            mediaFile.setContainerFormat(mediaFile.getExtension());
            return;
        }
        LOGGER.trace("got mediainfo for '{}'", (Object)mediaFile.getFileAsPath());
        switch (mediaFile.getType()) {
            case VIDEO: {
                MediaFileHelper.gatherExtraData(mediaFile, miSnapshot);
            }
            case EXTRA: 
            case SAMPLE: 
            case TRAILER: {
                MediaFileHelper.gatherVideoInformation(mediaFile, miSnapshot);
                MediaFileHelper.gatherAudioInformation(mediaFile, miSnapshot);
                MediaFileHelper.gatherSubtitleInformation(mediaFile, miSnapshot);
                break;
            }
            case AUDIO: {
                MediaFileHelper.gatherAudioInformation(mediaFile, miSnapshot);
                break;
            }
            case POSTER: 
            case BANNER: 
            case FANART: 
            case THUMB: 
            case EXTRAFANART: 
            case GRAPHIC: 
            case SEASON_POSTER: 
            case SEASON_FANART: 
            case SEASON_BANNER: 
            case SEASON_THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case CHARACTERART: 
            case DISC: 
            case EXTRATHUMB: 
            case KEYART: {
                MediaFileHelper.gatherImageInformation(mediaFile, miSnapshot);
                break;
            }
            case NFO: {
                break;
            }
            default: {
                LOGGER.debug("no mediainformation handling for MediaFile type {} yet.", (Object)mediaFile.getType());
            }
        }
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            mediaFile.setContainerFormat(mediaFile.getExtension());
        } else {
            String extensions = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
            mediaFile.setContainerFormat(MediaFileHelper.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
            if (StringUtils.isBlank((CharSequence)mediaFile.getContainerFormat())) {
                mediaFile.setContainerFormat(mediaFile.getExtension());
            }
        }
        switch (mediaFile.getType()) {
            case VIDEO: 
            case EXTRA: 
            case SAMPLE: 
            case TRAILER: 
            case AUDIO: {
                String miTitle;
                String br = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "OverallBitRate");
                if (StringUtils.isBlank((CharSequence)br)) {
                    br = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "OverallBitRate_Maximum");
                }
                if (StringUtils.isNotBlank((CharSequence)br)) {
                    try {
                        mediaFile.setOverallBitRate(Integer.parseInt(br) / 1000);
                    }
                    catch (NumberFormatException e) {
                        mediaFile.setOverallBitRate(0);
                    }
                }
                if (!(miTitle = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Title")).isEmpty()) {
                    mediaFile.setTitle(miTitle);
                }
                mediaFile.setDuration(MediaFileHelper.parseDuration(miSnapshot));
                break;
            }
        }
    }

    private static int parseDuration(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        String dur = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.General, 0, "Duration");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dur})) {
            try {
                double ddur = Double.parseDouble(dur);
                if (ddur > 25000.0) {
                    return (int)(ddur / 1000.0);
                }
                return (int)ddur;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String parse3DFormat(MediaFile mediaFile, Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        int height = mediaFile.getVideoHeight();
        int width = mediaFile.getVideoWidth();
        String mvc = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "MultiView_Count");
        String video3DFormat = "";
        if (!StringUtils.isEmpty((CharSequence)mvc) && mvc.equals("2")) {
            video3DFormat = VIDEO_3D;
            String mvl = MediaFileHelper.getMediaInfo(miSnapshot, MediaInfo.StreamKind.Video, 0, "MultiView_Layout").toLowerCase(Locale.ROOT);
            LOGGER.trace("3D detected :) - {}", (Object)mvl);
            if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("top") && mvl.contains("bottom")) {
                video3DFormat = VIDEO_3D_HTAB;
                if (height > width) {
                    video3DFormat = VIDEO_3D_TAB;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("side")) {
                video3DFormat = VIDEO_3D_HSBS;
                if (mediaFile.getAspectRatio().floatValue() > 3.0f) {
                    video3DFormat = VIDEO_3D_SBS;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("laced")) {
                video3DFormat = VIDEO_3D_MVC;
            }
        } else if (width == 3840 && height <= 1080) {
            video3DFormat = VIDEO_3D_SBS;
        } else if (width == 1920 && height == 2160) {
            video3DFormat = VIDEO_3D_TAB;
        }
        return video3DFormat;
    }

    private static void gatherMediaInformationFromDvdFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile ifo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("ifo")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (ifo == null) {
            LOGGER.debug("Could not find a valid IFO file");
            return;
        }
        LOGGER.trace("Considering IFO file: {}", (Object)ifo.getFilename());
        String prefix = StrgUtils.substr(ifo.getFilename(), "(?i)^(VTS_\\d+).*");
        MediaInfoFile vob = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFilename().startsWith(prefix) && mediaInfoFile.getFileExtension().equals("vob")).max(Comparator.comparingLong(MediaInfoFile::getFilesize)).orElse(null);
        if (vob == null) {
            LOGGER.debug("Could not find a valid VOB file");
            return;
        }
        LOGGER.trace("Considering VOB file: {}", (Object)vob.getFilename());
        MediaFileHelper.gatherVideoInformation(mediaFile, vob.getSnapshot());
        MediaFileHelper.gatherSubtitleInformation(mediaFile, ifo.getSnapshot());
        MediaFileHelper.gatherAudioInformation(mediaFile, vob.getSnapshot());
        for (int i = 0; i < MediaFileHelper.getAudioStreamCount(ifo.getSnapshot()); ++i) {
            String id = MediaFileHelper.getMediaInfo(ifo.getSnapshot(), MediaInfo.StreamKind.Audio, i, "StreamKindPos");
            MediaFileAudioStream audioStream = null;
            for (MediaFileAudioStream stream : mediaFile.getAudioStreams()) {
                if (!id.equals(stream.id)) continue;
                audioStream = stream;
                break;
            }
            if (audioStream == null) continue;
            String language = MediaFileHelper.getMediaInfo(ifo.getSnapshot(), MediaInfo.StreamKind.Audio, i, "Language/String", "Language");
            if (language.isEmpty()) {
                if (mediaFile.isDiscFile()) continue;
                String shortname = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                audioStream.setLanguage(LanguageUtils.parseLanguageFromString(shortname));
                continue;
            }
            audioStream.setLanguage(LanguageUtils.parseLanguageFromString(language));
        }
        mediaFile.setDuration(ifo.getDuration());
        String br = MediaFileHelper.getMediaInfo(vob.getSnapshot(), MediaInfo.StreamKind.General, 0, "OverallBitRate");
        if (!br.isEmpty()) {
            try {
                mediaFile.setOverallBitRate(Integer.parseInt(br) / 1000);
            }
            catch (NumberFormatException e) {
                mediaFile.setOverallBitRate(0);
            }
        }
    }

    private static void gatherMediaInformationFromBluRayFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile ssif;
        MediaInfoFile m2ts = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("m2ts") || mediaInfoFile.getFileExtension().equals("mpls")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (m2ts == null) {
            LOGGER.debug("Could not find a valid M2TS file");
            return;
        }
        LOGGER.trace("Considering M2TS file: {}", (Object)m2ts.getFilename());
        MediaFileHelper.gatherMediaInformationFromFile(mediaFile, Collections.singletonList(m2ts));
        MediaInfoFile clpi = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("clpi")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (clpi != null) {
            Object language;
            String id;
            int i;
            if (mediaFile.getDuration() == 0) {
                mediaFile.setDuration(MediaFileHelper.parseDuration(clpi.getSnapshot()));
            }
            for (i = 0; i < MediaFileHelper.getAudioStreamCount(clpi.getSnapshot()); ++i) {
                id = MediaFileHelper.getMediaInfo(clpi.getSnapshot(), MediaInfo.StreamKind.Audio, i, "StreamKindPos");
                MediaFileAudioStream audioStream = null;
                for (MediaFileAudioStream mediaFileAudioStream : mediaFile.getAudioStreams()) {
                    if (!id.equals(mediaFileAudioStream.id)) continue;
                    audioStream = mediaFileAudioStream;
                    break;
                }
                if (audioStream == null) continue;
                language = MediaFileHelper.getMediaInfo(clpi.getSnapshot(), MediaInfo.StreamKind.Audio, i, "Language/String", "Language");
                if (((String)language).isEmpty()) {
                    if (mediaFile.isDiscFile()) continue;
                    String string = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                    audioStream.setLanguage(LanguageUtils.parseLanguageFromString(string));
                    continue;
                }
                audioStream.setLanguage(LanguageUtils.parseLanguageFromString((String)language));
            }
            for (i = 0; i < MediaFileHelper.getSubtitleStreamCount(clpi.getSnapshot()); ++i) {
                id = MediaFileHelper.getMediaInfo(clpi.getSnapshot(), MediaInfo.StreamKind.Text, i, "StreamKindPos");
                MediaFileSubtitle subtitle = null;
                for (MediaFileSubtitle mediaFileSubtitle : mediaFile.getSubtitles()) {
                    if (!id.equals(mediaFileSubtitle.id)) continue;
                    subtitle = mediaFileSubtitle;
                    break;
                }
                if (subtitle == null) continue;
                language = MediaFileHelper.getMediaInfo(clpi.getSnapshot(), MediaInfo.StreamKind.Text, i, "Language/String", "Language");
                if (((String)language).isEmpty()) {
                    if (mediaFile.isDiscFile()) continue;
                    String string = mediaFile.getBasename().toLowerCase(Locale.ROOT);
                    subtitle.setLanguage(LanguageUtils.parseLanguageFromString(string));
                    continue;
                }
                subtitle.setLanguage(LanguageUtils.parseLanguageFromString((String)language));
            }
        }
        if ((ssif = (MediaInfoFile)mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("ssif")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null)) != null) {
            if (mediaFile.getDuration() == 0) {
                mediaFile.setDuration(MediaFileHelper.parseDuration(ssif.getSnapshot()));
            }
            mediaFile.setVideo3DFormat(MediaFileHelper.parse3DFormat(mediaFile, ssif.getSnapshot()));
        }
    }

    private static void gatherMediaInformationFromHdDvdFile(MediaFile mediaFile, List<MediaInfoFile> mediaInfoFiles) {
        MediaInfoFile evo = mediaInfoFiles.stream().filter(mediaInfoFile -> mediaInfoFile.getFileExtension().equals("evo")).max(Comparator.comparingInt(MediaInfoFile::getDuration)).orElse(null);
        if (evo == null) {
            LOGGER.debug("Could not find a valid EVO file");
            return;
        }
        LOGGER.trace("Considering EVO file: {}", (Object)evo.getFilename());
        MediaFileHelper.gatherMediaInformationFromFile(mediaFile, Collections.singletonList(evo));
    }

    public static Path getMainVideoFile(MediaFile mediaFile) {
        if (Files.isDirectory(mediaFile.getFileAsPath(), new LinkOption[0])) {
            List<MediaInfoFile> mediaInfoFiles = new ArrayList<MediaInfoFile>();
            for (Path path : Utils.listFiles(mediaFile.getFileAsPath())) {
                try {
                    mediaInfoFiles.add(new MediaInfoFile(path, Files.size(path)));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse filesize of {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            if (mediaFile.isDVDFile()) {
                String relevantPrefix = MediaFileHelper.detectRelevantDvdPrefix(mediaInfoFiles);
                mediaInfoFiles = mediaInfoFiles.stream().filter(file -> {
                    if (!"vob".equalsIgnoreCase(file.getFileExtension())) {
                        return false;
                    }
                    return file.getFilename().startsWith(relevantPrefix);
                }).sorted().collect(Collectors.toList());
            } else if (mediaFile.isBlurayFile()) {
                mediaInfoFiles = MediaFileHelper.detectRelevantBlurayFiles(mediaInfoFiles);
            } else if (mediaFile.isHDDVDFile()) {
                mediaInfoFiles = MediaFileHelper.detectRelevantHdDvdFiles(mediaInfoFiles);
            }
            if (!mediaInfoFiles.isEmpty()) {
                Path path;
                MediaInfoFile mediaInfoFile = mediaInfoFiles.stream().filter(file -> file.getFilesize() > 200000000L).findFirst().orElse(null);
                if (mediaInfoFile == null) {
                    mediaInfoFile = mediaInfoFiles.get(0);
                }
                if (Files.exists(path = Paths.get(mediaInfoFile.getPath(), mediaInfoFile.getFilename()), new LinkOption[0])) {
                    return path;
                }
            }
        }
        return mediaFile.getFileAsPath();
    }

    public static List<Path> getVideoFiles(MediaFile mediaFile) {
        if (Files.isDirectory(mediaFile.getFileAsPath(), new LinkOption[0])) {
            List<MediaInfoFile> mediaInfoFiles = new ArrayList<MediaInfoFile>();
            for (Path path : Utils.listFiles(mediaFile.getFileAsPath())) {
                try {
                    mediaInfoFiles.add(new MediaInfoFile(path, Files.size(path)));
                }
                catch (Exception e) {
                    LOGGER.debug("could not parse filesize of {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            if (mediaFile.isDVDFile()) {
                String relevantPrefix = MediaFileHelper.detectRelevantDvdPrefix(mediaInfoFiles);
                mediaInfoFiles = mediaInfoFiles.stream().filter(file -> {
                    if (!"vob".equalsIgnoreCase(file.getFileExtension())) {
                        return false;
                    }
                    if (file.getFilename().toLowerCase(Locale.ROOT).endsWith("_0.vob")) {
                        return false;
                    }
                    return file.getFilename().startsWith(relevantPrefix);
                }).sorted().collect(Collectors.toList());
            } else if (mediaFile.isBlurayFile()) {
                mediaInfoFiles = MediaFileHelper.detectRelevantBlurayFiles(mediaInfoFiles);
            } else if (mediaFile.isHDDVDFile()) {
                mediaInfoFiles = MediaFileHelper.detectRelevantHdDvdFiles(mediaInfoFiles);
            }
            ArrayList<Path> files = new ArrayList<Path>();
            mediaInfoFiles.forEach(mediaInfoFile -> files.add(Paths.get(mediaInfoFile.getPath(), mediaInfoFile.getFilename())));
            return files;
        }
        return Collections.singletonList(mediaFile.getFileAsPath());
    }

    public static MediaFilePosition getPositionInMediaFile(MediaFile mediaFile, int pos) {
        List mediaInfoFiles = MediaFileHelper.getVideoFiles(mediaFile).stream().map(path -> new MediaInfoFile((Path)path)).collect(Collectors.toList());
        MediaFilePosition result = null;
        if (mediaInfoFiles.size() == 1) {
            return new MediaFilePosition(mediaFile.getFileAsPath(), pos);
        }
        if (mediaInfoFiles.size() > 1) {
            int totalDuration = 0;
            Path filePath = null;
            int duration = -1;
            for (MediaInfoFile file : mediaInfoFiles) {
                try (MediaInfo mediaInfo = new MediaInfo();){
                    filePath = Paths.get(file.getPath(), file.getFilename());
                    if (!mediaInfo.open(filePath)) {
                        LOGGER.error("Mediainfo could not open file: {}", (Object)file);
                    } else {
                        file.setSnapshot(mediaInfo.snapshot());
                    }
                    duration = file.getDuration();
                    LOGGER.info("{}: total duration: {} - file duration: {} - video duration: {}", new Object[]{file.getFilename(), totalDuration, duration, mediaFile.getDuration()});
                    if (pos <= totalDuration + duration) {
                        result = new MediaFilePosition(filePath, pos - totalDuration);
                        break;
                    }
                    totalDuration += duration;
                }
                catch (Error | Exception e) {
                    LOGGER.error("Mediainfo could not open file: {} - {}", (Object)mediaFile.getFileAsPath(), (Object)e.getMessage());
                }
            }
            if (result == null) {
                result = new MediaFilePosition(filePath, duration);
            }
        }
        return result;
    }

    public static void gatherLanguageInformation(MediaFile mediaFile, String commonPart) {
        if (mediaFile.getType() != MediaFileType.SUBTITLE && mediaFile.getType() != MediaFileType.AUDIO) {
            return;
        }
        String shortname = mediaFile.getBasename();
        shortname = shortname.replace(commonPart, "");
        List<String> chunks = ParserUtils.splitByPunctuation(shortname);
        String language = "";
        int languageIndex = 0;
        String title = "";
        ArrayList<MediaStreamInfo.Flags> flags = new ArrayList<MediaStreamInfo.Flags>();
        for (int i = chunks.size() - 1; i >= 0; --i) {
            language = LanguageUtils.parseLanguageFromString(chunks.get(i));
            if (!StringUtils.isNotBlank((CharSequence)language)) continue;
            languageIndex = i;
            break;
        }
        if (languageIndex < chunks.size() - 1) {
            title = String.join((CharSequence)" ", chunks.subList(languageIndex + 1, chunks.size()));
            if (title.contains("forced")) {
                flags.add(MediaStreamInfo.Flags.FLAG_FORCED);
                title = title.replaceAll("\\p{Punct}*forced", "");
            }
            if (title.contains("sdh")) {
                flags.add(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
                title = title.replaceAll("\\p{Punct}*sdh", "");
            } else if (title.contains("cc")) {
                flags.add(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED);
                title = title.replaceAll("\\p{Punct}*cc", "");
            }
            title = title.strip();
        }
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            MediaFileSubtitle sub = mediaFile.getSubtitles().get(0);
            if (StringUtils.isBlank((CharSequence)sub.getLanguage())) {
                sub.setLanguage(language);
            }
            sub.setTitle(title);
            sub.set(flags);
        } else if (mediaFile.getType() == MediaFileType.AUDIO) {
            MediaFileAudioStream audio = mediaFile.getAudioStreams().get(0);
            if (StringUtils.isBlank((CharSequence)audio.getLanguage())) {
                audio.setLanguage(language);
            }
            if (StringUtils.isBlank((CharSequence)audio.getTitle())) {
                audio.setAudioTitle(title);
            }
            audio.set(flags);
        }
    }

    static {
        VIDEO_FORMATS = List.of(VIDEO_FORMAT_480P, VIDEO_FORMAT_540P, VIDEO_FORMAT_576P, VIDEO_FORMAT_720P, VIDEO_FORMAT_1080P, VIDEO_FORMAT_2160P, VIDEO_FORMAT_4320P);
        SUPPORTED_ARTWORK_FILETYPES = List.of("jpg", "jpeg,", "png", "tbn", "gif", "bmp", "webp");
        DEFAULT_VIDEO_FILETYPES = List.of(".3gp", ".asf", ".asx", ".avc", ".avi", ".bdmv", ".bin", ".bivx", ".braw", ".dat", ".divx", ".dv", ".dvr-ms", ".disc", ".evo", ".fli", ".flv", ".h264", ".ifo", ".img", ".iso", ".mts", ".mt2s", ".m2ts", ".m2v", ".m4v", ".mkv", ".mk3d", ".mov", ".mp4", ".mpeg", ".mpg", ".nrg", ".nsv", ".nuv", ".ogm", ".pva", ".qt", ".rm", ".rmvb", ".strm", ".svq3", ".ts", ".ty", ".viv", ".vob", ".vp3", ".wmv", ".webm", ".xvid");
        DEFAULT_AUDIO_FILETYPES = List.of(".a52", ".aa3", ".aac", ".ac3", ".adt", ".adts", ".aif", ".aiff", ".alac", ".ape", ".at3", ".atrac", ".au", ".dts", ".flac", ".m4a", ".m4b", ".m4p", ".mid", ".midi", ".mka", ".mp3", ".mpa", ".mlp", ".oga", ".ogg", ".pcm", ".ra", ".ram", ".tta", ".thd", ".wav", ".wave", ".wma");
        DEFAULT_SUBTITLE_FILETYPES = List.of(".aqt", ".cvd", ".dks", ".jss", ".sub", ".sup", ".ttxt", ".mpl", ".pjs", ".psb", ".rt", ".srt", ".smi", ".ssf", ".ssa", ".svcd", ".usf", ".ass", ".pgs", ".vobsub");
        BINARY_FILETYPES = List.of("bin", "dat", "img", "nrg", "disc");
        String extensions = String.join((CharSequence)"|", SUPPORTED_ARTWORK_FILETYPES);
        MOVIESET_ARTWORK_PATTERN = Pattern.compile("(?i)movieset-(poster|fanart|banner|disc|discart|logo|clearlogo|clearart|thumb)\\.(" + extensions + ")$");
        POSTER_PATTERN = Pattern.compile("(?i)(.*-poster|poster|folder|movie|.*-cover|cover)\\.(" + extensions + ")$");
        FANART_PATTERN = Pattern.compile("(?i)(.*-fanart|.*\\.fanart|fanart)\\.(" + extensions + ")$");
        EXTRAFANART_PATTERN = Pattern.compile("(?i)(.*-fanart|.*\\.fanart|fanart)[0-9]+\\.(" + extensions + ")$");
        BANNER_PATTERN = Pattern.compile("(?i)(.*-banner|banner)\\.(" + extensions + ")$");
        THUMB_PATTERN = Pattern.compile("(?i)(.*-thumb|thumb|.*-landscape|landscape)[0-9]{0,2}\\.(" + extensions + ")$");
        SEASON_POSTER_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)(-poster)?\\.(" + extensions + ")$");
        SEASON_FANART_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)(-fanart)?\\.(" + extensions + ")$");
        SEASON_BANNER_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)-banner\\.(" + extensions + ")$");
        SEASON_THUMB_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)-(thumb|landscape)\\.(" + extensions + ")$");
        LOGO_PATTERN = Pattern.compile("(?i)(.*-logo|logo)\\.(" + extensions + ")$");
        CLEARLOGO_PATTERN = Pattern.compile("(?i)(.*-clearlogo|clearlogo)\\.(" + extensions + ")$");
        CHARACTERART_PATTERN = Pattern.compile("(?i)(.*-characterart|characterart)[0-9]{0,2}\\.(" + extensions + ")$");
        DISCART_PATTERN = Pattern.compile("(?i)(.*-discart|discart|.*-disc|disc)\\.(" + extensions + ")$");
        CLEARART_PATTERN = Pattern.compile("(?i)(.*-clearart|clearart)\\.(" + extensions + ")$");
        KEYART_PATTERN = Pattern.compile("(?i)(.*-keyart|keyart)\\.(" + extensions + ")$");
    }
}

