/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum TrailerQuality {
    SD("SD", Arrays.asList("SD", "480p", "360p", "240p", "144p")),
    HD_720("720p", Arrays.asList("HD", "720p", "720")),
    HD_1080("1080p", Arrays.asList("HD", "1080p", "1080"));

    private final String displayText;
    private final List<String> possibleQualities;

    private TrailerQuality(String text, List<String> qualities) {
        this.displayText = text;
        this.possibleQualities = qualities;
    }

    public boolean containsQuality(String quality) {
        if (StringUtils.isBlank((CharSequence)quality)) {
            return false;
        }
        for (String qual : this.possibleQualities) {
            if (!quality.equalsIgnoreCase(qual)) continue;
            return true;
        }
        return false;
    }

    public List<String> getPossibleQualities() {
        return Collections.unmodifiableList(this.possibleQualities);
    }

    public static TrailerQuality getTrailerQuality(String quality) {
        for (TrailerQuality q : TrailerQuality.values()) {
            if (!q.containsQuality(quality)) continue;
            return q;
        }
        return SD;
    }

    public String toString() {
        return this.displayText;
    }
}

