/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.DynaEnum;

public class MediaGenres
extends DynaEnum<MediaGenres> {
    private static final Comparator<MediaGenres> COMPARATOR = new MediaGenresComparator();
    public static final MediaGenres ACTION = new MediaGenres("ACTION", 0, "Action");
    public static final MediaGenres ADVENTURE = new MediaGenres("ADVENTURE", 1, "Adventure");
    public static final MediaGenres ANIMATION = new MediaGenres("ANIMATION", 2, "Animation");
    public static final MediaGenres ANIME = new MediaGenres("ANIME", -1, "Anime");
    public static final MediaGenres ANIMAL = new MediaGenres("ANIMAL", 3, "Animal");
    public static final MediaGenres BIOGRAPHY = new MediaGenres("BIOGRAPHY", 4, "Biography");
    public static final MediaGenres COMEDY = new MediaGenres("COMEDY", 5, "Comedy");
    public static final MediaGenres CRIME = new MediaGenres("CRIME", 6, "Crime");
    public static final MediaGenres DISASTER = new MediaGenres("DISASTER", 7, "Disaster");
    public static final MediaGenres DOCUMENTARY = new MediaGenres("DOCUMENTARY", 8, "Documentary", new String[]{"Home and Garden", "Food"});
    public static final MediaGenres DRAMA = new MediaGenres("DRAMA", 9, "Drama");
    public static final MediaGenres EASTERN = new MediaGenres("EASTERN", 10, "Eastern");
    public static final MediaGenres EROTIC = new MediaGenres("EROTIC", 11, "Erotic");
    public static final MediaGenres FAMILY = new MediaGenres("FAMILY", 12, "Family", new String[]{"Children"});
    public static final MediaGenres FAN_FILM = new MediaGenres("FAN_FILM", 13, "Fan Film");
    public static final MediaGenres FANTASY = new MediaGenres("FANTASY", 14, "Fantasy");
    public static final MediaGenres FILM_NOIR = new MediaGenres("FILM_NOIR", 15, "Film Noir");
    public static final MediaGenres FOREIGN = new MediaGenres("FOREIGN", 16, "Foreign");
    public static final MediaGenres GAME_SHOW = new MediaGenres("GAME_SHOW", 17, "Game Show", new String[]{"Game Show", "Gameshow"});
    public static final MediaGenres HISTORY = new MediaGenres("HISTORY", 18, "History");
    public static final MediaGenres HOLIDAY = new MediaGenres("HOLIDAY", 19, "Holiday", new String[]{"Travel"});
    public static final MediaGenres HORROR = new MediaGenres("HORROR", 20, "Horror");
    public static final MediaGenres INDIE = new MediaGenres("INDIE", 21, "Indie", new String[]{"Special Interest"});
    public static final MediaGenres MINI_SERIES = new MediaGenres("MINI_SERIES", 22, "Mini-Series");
    public static final MediaGenres MUSIC = new MediaGenres("MUSIC", 23, "Music");
    public static final MediaGenres MUSICAL = new MediaGenres("MUSICAL", 24, "Musical");
    public static final MediaGenres MYSTERY = new MediaGenres("MYSTERY", 25, "Mystery");
    public static final MediaGenres NEO_NOIR = new MediaGenres("NEO_NOIR", 26, "Neo Noir");
    public static final MediaGenres NEWS = new MediaGenres("NEWS", 27, "News");
    public static final MediaGenres REALITY_TV = new MediaGenres("REALITY_TV", 28, "Reality TV", new String[]{"Reality"});
    public static final MediaGenres ROAD_MOVIE = new MediaGenres("ROAD_MOVIE", 29, "Road Movie");
    public static final MediaGenres ROMANCE = new MediaGenres("ROMANCE", 30, "Romance");
    public static final MediaGenres SCIENCE_FICTION = new MediaGenres("SCIENCE_FICTION", 31, "Science Fiction", new String[]{"Sci-Fi", "Science-Fiction"});
    public static final MediaGenres SERIES = new MediaGenres("SERIES", 32, "Series");
    public static final MediaGenres SHORT = new MediaGenres("SHORT", 33, "Short");
    public static final MediaGenres SILENT_MOVIE = new MediaGenres("SILENT_MOVIE", 34, "Silent Movie");
    public static final MediaGenres SOAP = new MediaGenres("SOAP", 35, "Soap");
    public static final MediaGenres SPORT = new MediaGenres("SPORT", 36, "Sport");
    public static final MediaGenres SPORTING_EVENT = new MediaGenres("SPORTING_EVENT", 37, "Sporting Event");
    public static final MediaGenres SPORTS_FILM = new MediaGenres("SPORTS_FILM", 38, "Sports Film");
    public static final MediaGenres SUSPENSE = new MediaGenres("SUSPENSE", 39, "Suspense");
    public static final MediaGenres TALK_SHOW = new MediaGenres("TALK_SHOW", 40, "Talk Show");
    public static final MediaGenres TV_MOVIE = new MediaGenres("TV_MOVIE", 41, "TV Movie");
    public static final MediaGenres THRILLER = new MediaGenres("THRILLER", 42, "Thriller");
    public static final MediaGenres WAR = new MediaGenres("WAR", 43, "War");
    public static final MediaGenres WESTERN = new MediaGenres("WESTERN", 44, "Western");
    private final String name;
    private final String[] alternateNames;

    private MediaGenres(String enumName, int ordinal, String name) {
        super(enumName, ordinal);
        this.name = name;
        this.alternateNames = MediaGenres.loadAlternateNames(enumName);
        this.addElement();
    }

    private MediaGenres(String enumName, int ordinal, String name, String[] alternates) {
        super(enumName, ordinal);
        this.name = name;
        this.alternateNames = (String[])ArrayUtils.addAll((Object[])MediaGenres.loadAlternateNames(enumName), (Object[])alternates);
        this.addElement();
    }

    public static void init() {
    }

    @Override
    public String toString() {
        return this.getLocalizedName();
    }

    public String dump() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String getName() {
        return this.name;
    }

    @JsonValue
    public String getEnumName() {
        return this.name();
    }

    public static String[] loadAlternateNames(String propName) {
        ArrayList<CallSite> alt = new ArrayList<CallSite>();
        for (Locale loc : MediaGenres.getLanguages()) {
            if (loc == null || loc.getLanguage().equals("en")) continue;
            ResourceBundle b = ResourceBundle.getBundle("messages", loc);
            try {
                alt.add((CallSite)((Object)(loc.getLanguage() + "-" + b.getString("Genres." + propName))));
            }
            catch (Exception exception) {}
        }
        return alt.toArray(new String[0]);
    }

    private static List<Locale> getLanguages() {
        try {
            Class<?> clazz = Class.forName("org.tinymediamanager.core.Utils");
            Method method = clazz.getDeclaredMethod("getLanguages", new Class[0]);
            if (method.getReturnType() == List.class) {
                return (List)method.invoke(null, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.singletonList(new Locale("en", "US"));
    }

    public static MediaGenres[] values() {
        MediaGenres[] mg = MediaGenres.values(MediaGenres.class);
        Arrays.sort(mg, COMPARATOR);
        return mg;
    }

    public static synchronized MediaGenres getGenre(String name) {
        String cleanedName = name.replaceAll("[._-]", " ");
        for (MediaGenres genre : MediaGenres.values(MediaGenres.class)) {
            if (genre.name().equals(name)) {
                return genre;
            }
            if (genre.name.equalsIgnoreCase(name)) {
                return genre;
            }
            if (genre.name.equalsIgnoreCase(cleanedName)) {
                return genre;
            }
            for (String notation : genre.alternateNames) {
                if (notation.equalsIgnoreCase(name)) {
                    return genre;
                }
                if (notation.length() <= 3 || !notation.substring(0, 3).matches(".{2}-")) continue;
                if (notation.substring(3).equalsIgnoreCase(name)) {
                    return genre;
                }
                if (name.length() <= 3 || !notation.substring(3).equalsIgnoreCase(name.substring(3))) continue;
                return genre;
            }
        }
        return new MediaGenres(name, MediaGenres.values(MediaGenres.class).length, name);
    }

    @JsonCreator
    public static synchronized MediaGenres getGenreByEnumName(String name) {
        for (MediaGenres genre : MediaGenres.values(MediaGenres.class)) {
            if (!genre.name().equals(name)) continue;
            return genre;
        }
        return MediaGenres.getGenre(name);
    }

    public String getLocalizedName() {
        return this.getLocalizedName(Locale.getDefault());
    }

    public String getLocalizedName(Locale locale) {
        String lang = locale.getLanguage() + "-";
        for (String notation : this.alternateNames) {
            if (!notation.startsWith(lang)) continue;
            return notation.substring(3);
        }
        return this.name;
    }

    public static void addListener(DynaEnum.DynaEnumEventListener<?> listener) {
        MediaGenres.addListener(MediaGenres.class, listener);
    }

    public static void removeListener(DynaEnum.DynaEnumEventListener<?> listener) {
        MediaGenres.removeListener(MediaGenres.class, listener);
    }

    public static class MediaGenresComparator
    implements Comparator<MediaGenres> {
        @Override
        public int compare(MediaGenres o1, MediaGenres o2) {
            if (o1.toString() == null && o2.toString() == null) {
                return 0;
            }
            if (o1.toString() == null) {
                return 1;
            }
            if (o2.toString() == null) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

