/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieLogoNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.tasks.MovieExtraImageFetcherTask;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.thirdparty.FFmpeg;
import org.tinymediamanager.thirdparty.VSMeta;

public class MovieArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieArtworkHelper.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile(".*?(\\d+)$");

    private MovieArtworkHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadArtwork(Movie movie, MediaFileType type) {
        if (type == MediaFileType.EXTRAFANART || type == MediaFileType.EXTRATHUMB) {
            MovieArtworkHelper.downloadExtraArtwork(movie, type);
            return;
        }
        String url = movie.getArtworkUrl(type);
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            List<IFileNaming> fileNamings = MovieArtworkHelper.getFileNamingsForMediaFileType(movie, type);
            if (fileNamings.isEmpty()) {
                return;
            }
            ArrayList<String> filenames = new ArrayList<String>();
            for (IFileNaming fileNaming : fileNamings) {
                String filename = MovieArtworkHelper.getArtworkFilename(movie, fileNaming, Utils.getArtworkExtensionFromUrl(url));
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                filenames.add(filename);
            }
            if (!filenames.isEmpty()) {
                MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(movie, url, MediaFileType.getMediaArtworkType(type), filenames);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
        finally {
            if (url.startsWith("file:")) {
                movie.removeArtworkUrl(type);
            }
        }
    }

    public static void downloadMissingArtwork(Movie movie) {
        MovieArtworkHelper.downloadMissingArtwork(movie, false);
    }

    public static void downloadMissingArtwork(Movie movie, boolean force) {
        MediaFileType[] mfts;
        for (MediaFileType mft : mfts = MediaFileType.getGraphicMediaFileTypes()) {
            List<MediaFile> mfs = movie.getMediaFiles(mft);
            if (!mfs.isEmpty()) continue;
            boolean download = false;
            switch (mft) {
                case FANART: {
                    if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case POSTER: {
                    if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case BANNER: {
                    if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARART: {
                    if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case DISC: {
                    if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case LOGO: {
                    if (MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARLOGO: {
                    if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case THUMB: {
                    if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case KEYART: {
                    if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case EXTRAFANART: {
                    if (!MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && !force) break;
                    download = true;
                    break;
                }
                case EXTRATHUMB: {
                    if (!MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && !force) break;
                    download = true;
                    break;
                }
            }
            if (!download) continue;
            MovieArtworkHelper.downloadArtwork(movie, mft);
        }
    }

    public static void downloadMissingArtwork(Movie movie, List<MediaArtwork> artwork, List<MovieScraperMetadataConfig> metadataConfig) {
        if (metadataConfig.contains(MovieScraperMetadataConfig.POSTER) && movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieArtworkHelper.setBestPoster(movie, artwork);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.FANART) && movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieArtworkHelper.setBestFanart(movie, artwork);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.LOGO) && movie.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.LOGO, !MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty());
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.CLEARLOGO) && movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty());
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.CLEARART) && movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty());
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.BANNER) && movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty());
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.THUMB) && movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty());
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.DISCART) && movie.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, !MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty());
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.KEYART) && movie.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.KEYART, !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty());
        }
        ArrayList<String> extrathumbs = new ArrayList<String>();
        if (metadataConfig.contains(MovieScraperMetadataConfig.EXTRATHUMB) && movie.getMediaFiles(MediaFileType.EXTRATHUMB).isEmpty() && MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder()) continue;
                extrathumbs.add(art.getDefaultUrl());
                if (extrathumbs.size() < MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount()) continue;
                break;
            }
            movie.setExtraThumbs(extrathumbs);
            if (!extrathumbs.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
            }
        }
        ArrayList<String> extrafanarts = new ArrayList<String>();
        if (metadataConfig.contains(MovieScraperMetadataConfig.EXTRAFANART) && MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder()) continue;
                extrafanarts.add(art.getDefaultUrl());
                if (extrafanarts.size() < MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount()) continue;
                break;
            }
            movie.setExtraFanarts(extrafanarts);
            if (!extrafanarts.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
            }
        }
        movie.saveToDb();
    }

    public static boolean hasMissingArtwork(Movie movie, List<MovieScraperMetadataConfig> config) {
        if (config.contains(MovieScraperMetadataConfig.POSTER) && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.FANART) && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.BANNER) && !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.DISCART) && !MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.LOGO) && !MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARLOGO) && !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARART) && !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.THUMB) && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.KEYART) && !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.EXTRAFANART) && MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && !MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.EXTRAFANART).isEmpty()) {
            return true;
        }
        return config.contains(MovieScraperMetadataConfig.EXTRATHUMB) && MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && movie.getMediaFiles(MediaFileType.EXTRATHUMB).isEmpty();
    }

    public static String getArtworkFilename(Movie movie, IFileNaming fileNaming, String extension) {
        List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && !mfs.isEmpty()) {
            return fileNaming.getFilename(movie.getVideoBasenameWithoutStacking(), extension);
        }
        return fileNaming.getFilename("", extension);
    }

    public static List<MovieFanartNaming> getFanartNamesForMovie(Movie movie) {
        List<MovieFanartNaming> fanartnames = new ArrayList<MovieFanartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
            return fanartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().contains(MovieFanartNaming.FILENAME_FANART)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART);
            }
            if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().contains(MovieFanartNaming.FILENAME_FANART2)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART2);
            }
            if (fanartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART);
            }
        } else if (movie.isDisc()) {
            fanartnames.add(MovieFanartNaming.FANART);
        } else {
            fanartnames = MovieModuleManager.getInstance().getSettings().getFanartFilenames();
        }
        return fanartnames;
    }

    public static List<MoviePosterNaming> getPosterNamesForMovie(Movie movie) {
        ArrayList<MoviePosterNaming> posternames = new ArrayList<MoviePosterNaming>();
        if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
            return posternames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.FILENAME_POSTER)) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER);
            }
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.FILENAME)) {
                posternames.add(MoviePosterNaming.FILENAME);
            }
            if (posternames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.FOLDER)) {
                posternames.add(MoviePosterNaming.FOLDER);
            }
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.POSTER) || posternames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                posternames.add(MoviePosterNaming.POSTER);
            }
        } else {
            posternames.addAll(MovieModuleManager.getInstance().getSettings().getPosterFilenames());
        }
        return posternames;
    }

    public static List<MovieBannerNaming> getBannerNamesForMovie(Movie movie) {
        ArrayList<MovieBannerNaming> bannernames = new ArrayList<MovieBannerNaming>();
        if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
            return bannernames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().contains(MovieBannerNaming.FILENAME_BANNER)) {
                bannernames.add(MovieBannerNaming.FILENAME_BANNER);
            }
            if (bannernames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
                bannernames.add(MovieBannerNaming.FILENAME_BANNER);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().contains(MovieBannerNaming.BANNER)) {
                bannernames.add(MovieBannerNaming.BANNER);
            }
            if (bannernames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
                bannernames.add(MovieBannerNaming.BANNER);
            }
        } else {
            bannernames.addAll(MovieModuleManager.getInstance().getSettings().getBannerFilenames());
        }
        return bannernames;
    }

    public static List<MovieClearartNaming> getClearartNamesForMovie(Movie movie) {
        ArrayList<MovieClearartNaming> clearartnames = new ArrayList<MovieClearartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
            return clearartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().contains(MovieClearartNaming.FILENAME_CLEARART)) {
                clearartnames.add(MovieClearartNaming.FILENAME_CLEARART);
            }
            if (clearartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
                clearartnames.add(MovieClearartNaming.FILENAME_CLEARART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().contains(MovieClearartNaming.CLEARART)) {
                clearartnames.add(MovieClearartNaming.CLEARART);
            }
            if (clearartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
                clearartnames.add(MovieClearartNaming.CLEARART);
            }
        } else {
            clearartnames.addAll(MovieModuleManager.getInstance().getSettings().getClearartFilenames());
        }
        return clearartnames;
    }

    public static List<MovieDiscartNaming> getDiscartNamesForMovie(Movie movie) {
        ArrayList<MovieDiscartNaming> discartnames = new ArrayList<MovieDiscartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty()) {
            return discartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISC) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISC)) {
                discartnames.add(MovieDiscartNaming.FILENAME_DISC);
            }
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISCART) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISCART)) {
                discartnames.add(MovieDiscartNaming.FILENAME_DISCART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISC) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISC)) {
                discartnames.add(MovieDiscartNaming.DISC);
            }
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISCART) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISCART)) {
                discartnames.add(MovieDiscartNaming.DISCART);
            }
        } else {
            discartnames.addAll(MovieModuleManager.getInstance().getSettings().getDiscartFilenames());
        }
        return discartnames;
    }

    public static List<MovieKeyartNaming> getKeyartNamesForMovie(Movie movie) {
        ArrayList<MovieKeyartNaming> keyartnames = new ArrayList<MovieKeyartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
            return keyartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().contains(MovieKeyartNaming.FILENAME_KEYART)) {
                keyartnames.add(MovieKeyartNaming.FILENAME_KEYART);
            }
            if (keyartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
                keyartnames.add(MovieKeyartNaming.FILENAME_KEYART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().contains(MovieKeyartNaming.KEYART)) {
                keyartnames.add(MovieKeyartNaming.KEYART);
            }
            if (keyartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
                keyartnames.add(MovieKeyartNaming.KEYART);
            }
        } else {
            keyartnames.addAll(MovieModuleManager.getInstance().getSettings().getKeyartFilenames());
        }
        return keyartnames;
    }

    public static List<MovieLogoNaming> getLogoNamesForMovie(Movie movie) {
        ArrayList<MovieLogoNaming> logonames = new ArrayList<MovieLogoNaming>();
        if (MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty()) {
            return logonames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getLogoFilenames().contains(MovieLogoNaming.FILENAME_LOGO)) {
                logonames.add(MovieLogoNaming.FILENAME_LOGO);
            }
            if (logonames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty()) {
                logonames.add(MovieLogoNaming.FILENAME_LOGO);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getLogoFilenames().contains(MovieLogoNaming.LOGO)) {
                logonames.add(MovieLogoNaming.LOGO);
            }
            if (logonames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty()) {
                logonames.add(MovieLogoNaming.LOGO);
            }
        } else {
            logonames.addAll(MovieModuleManager.getInstance().getSettings().getLogoFilenames());
        }
        return logonames;
    }

    public static List<MovieClearlogoNaming> getClearlogoNamesForMovie(Movie movie) {
        ArrayList<MovieClearlogoNaming> clearlogonames = new ArrayList<MovieClearlogoNaming>();
        if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
            return clearlogonames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().contains(MovieClearlogoNaming.FILENAME_CLEARLOGO)) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_CLEARLOGO);
            }
            if (clearlogonames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_CLEARLOGO);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().contains(MovieClearlogoNaming.CLEARLOGO)) {
                clearlogonames.add(MovieClearlogoNaming.CLEARLOGO);
            }
            if (clearlogonames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
                clearlogonames.add(MovieClearlogoNaming.CLEARLOGO);
            }
        } else {
            clearlogonames.addAll(MovieModuleManager.getInstance().getSettings().getClearlogoFilenames());
        }
        return clearlogonames;
    }

    public static List<MovieThumbNaming> getThumbNamesForMovie(Movie movie) {
        ArrayList<MovieThumbNaming> thumbnames = new ArrayList<MovieThumbNaming>();
        if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
            return thumbnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.FILENAME_THUMB)) {
                thumbnames.add(MovieThumbNaming.FILENAME_THUMB);
            }
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.FILENAME_LANDSCAPE)) {
                thumbnames.add(MovieThumbNaming.FILENAME_LANDSCAPE);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.THUMB)) {
                thumbnames.add(MovieThumbNaming.FILENAME_THUMB);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
                thumbnames.add(MovieThumbNaming.FILENAME_LANDSCAPE);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.THUMB)) {
                thumbnames.add(MovieThumbNaming.THUMB);
            }
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.LANDSCAPE)) {
                thumbnames.add(MovieThumbNaming.LANDSCAPE);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.FILENAME_THUMB)) {
                thumbnames.add(MovieThumbNaming.THUMB);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
                thumbnames.add(MovieThumbNaming.LANDSCAPE);
            }
        } else {
            thumbnames.addAll(MovieModuleManager.getInstance().getSettings().getThumbFilenames());
        }
        return thumbnames;
    }

    public static List<MovieExtraFanartNaming> getExtraFanartNamesForMovie(Movie movie) {
        List<MovieExtraFanartNaming> fanartnames = new ArrayList<MovieExtraFanartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
            return fanartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().contains(MovieExtraFanartNaming.FILENAME_EXTRAFANART)) {
                fanartnames.add(MovieExtraFanartNaming.FILENAME_EXTRAFANART);
            }
            if (MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().contains(MovieExtraFanartNaming.FILENAME_EXTRAFANART2)) {
                fanartnames.add(MovieExtraFanartNaming.FILENAME_EXTRAFANART2);
            }
            if (fanartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
                fanartnames.add(MovieExtraFanartNaming.FILENAME_EXTRAFANART);
            }
        } else if (movie.isDisc()) {
            fanartnames.add(MovieExtraFanartNaming.EXTRAFANART);
        } else {
            fanartnames = MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames();
        }
        return fanartnames;
    }

    private static void downloadExtraArtwork(Movie movie, MediaFileType type) {
        MovieExtraImageFetcherTask task = new MovieExtraImageFetcherTask(movie, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void setArtwork(Movie movie, List<MediaArtwork> artwork, List<MovieScraperMetadataConfig> config, boolean overwrite) {
        List<MediaArtwork> sortedFanarts;
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        if (config.contains(MovieScraperMetadataConfig.POSTER) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.POSTER)))) {
            MovieArtworkHelper.setBestPoster(movie, artwork);
        }
        if (config.contains(MovieScraperMetadataConfig.FANART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.FANART)))) {
            MovieArtworkHelper.setBestFanart(movie, artwork);
        }
        if (config.contains(MovieScraperMetadataConfig.LOGO) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.LOGO)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.LOGO, !MovieModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARLOGO) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.CLEARLOGO)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.CLEARART)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.BANNER) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.BANNER)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.THUMB) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.THUMB)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.DISCART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.DISC)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, !MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.KEYART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.KEYART)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.KEYART, !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty());
        }
        if (config.contains(MovieScraperMetadataConfig.EXTRATHUMB) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.EXTRATHUMB)))) {
            ArrayList<String> extrathumbs = new ArrayList<String>();
            if (MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount() > 0) {
                sortedFanarts = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder(), MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage());
                for (MediaArtwork art : sortedFanarts) {
                    extrathumbs.add(art.getDefaultUrl());
                    if (extrathumbs.size() < MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount()) continue;
                    break;
                }
                movie.setExtraThumbs(extrathumbs);
                if (!extrathumbs.isEmpty() && !movie.isMultiMovieDir()) {
                    MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
                }
            }
        }
        if (config.contains(MovieScraperMetadataConfig.EXTRAFANART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.EXTRAFANART)))) {
            ArrayList<String> extrafanarts = new ArrayList<String>();
            if (MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount() > 0) {
                sortedFanarts = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder(), MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage());
                for (MediaArtwork art : sortedFanarts) {
                    extrafanarts.add(art.getDefaultUrl());
                    if (extrafanarts.size() < MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount()) continue;
                    break;
                }
                movie.setExtraFanarts(extrafanarts);
                if (!extrafanarts.isEmpty() && !movie.isMultiMovieDir()) {
                    MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
                }
            }
        }
        movie.saveToDb();
        movie.writeNFO();
    }

    private static void setBestPoster(Movie movie, List<MediaArtwork> artwork) {
        String preferredLanguage;
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
        List<MediaArtwork> sortedPosters = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder, preferredLanguage = MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage());
        if (!sortedPosters.isEmpty()) {
            MediaArtwork foundPoster = sortedPosters.get(0);
            movie.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
            if (movie.getTmdbId() == 0 && foundPoster.getTmdbId() > 0) {
                movie.setTmdbId(foundPoster.getTmdbId());
            }
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(Movie movie, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage();
        MediaArtwork fanartWoText = null;
        for (MediaArtwork art : artwork) {
            if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals("") || art.getSizeOrder() != preferredSizeOrder) continue;
            fanartWoText = art;
            break;
        }
        List<MediaArtwork> sortedFanarts = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder, preferredLanguage);
        if (fanartWoText != null) {
            sortedFanarts.add(0, fanartWoText);
        }
        if (!sortedFanarts.isEmpty()) {
            MediaArtwork foundfanart = sortedFanarts.get(0);
            movie.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
            if (movie.getTmdbId() == 0 && foundfanart.getTmdbId() > 0) {
                movie.setTmdbId(foundfanart.getTmdbId());
            }
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.FANART);
        }
    }

    private static List<MediaArtwork> sortArtwork(List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, int sizeOrder, String language) {
        ArrayList<MediaArtwork> sortedArtwork = new ArrayList<MediaArtwork>();
        for (MediaArtwork art : artwork) {
            if (sortedArtwork.contains(art) || art.getType() != type || !art.getLanguage().equals(language) || art.getSizeOrder() != sizeOrder) continue;
            sortedArtwork.add(art);
        }
        if (MovieModuleManager.getInstance().getSettings().isImageLanguagePriority()) {
            int newOrder = sizeOrder;
            for (int counter = 1; counter <= 2; ++counter) {
                newOrder /= 2;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != type || !art.getLanguage().equals(language) || art.getSizeOrder() != newOrder) continue;
                    sortedArtwork.add(art);
                }
            }
        }
        for (MediaArtwork art : artwork) {
            if (sortedArtwork.contains(art) || art.getType() != type || art.getSizeOrder() != sizeOrder) continue;
            sortedArtwork.add(art);
        }
        int newOrder = sizeOrder;
        for (int counter = 1; counter <= 2; ++counter) {
            newOrder /= 2;
            for (MediaArtwork art : artwork) {
                if (sortedArtwork.contains(art) || art.getType() != type || art.getSizeOrder() != newOrder) continue;
                sortedArtwork.add(art);
            }
        }
        if (sortedArtwork.isEmpty() && !artwork.isEmpty()) {
            for (MediaArtwork art : artwork) {
                if (sortedArtwork.contains(art) || art.getType() != type) continue;
                sortedArtwork.add(art);
            }
        }
        return sortedArtwork;
    }

    private static void setBestArtwork(Movie movie, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, boolean download) {
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.getInstance().getSettings().getImageScraperLanguage().getLanguage();
        List<MediaArtwork> sortedArtworks = MovieArtworkHelper.sortArtwork(artwork, type, preferredSizeOrder, preferredLanguage);
        for (MediaArtwork art : sortedArtworks) {
            if (art.getType() != type || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            movie.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            if (!download) break;
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.getMediaFileType(type));
            break;
        }
    }

    public static void cleanupArtwork(Movie movie, List<MovieScraperMetadataConfig> metadataConfig) {
        if (!ScraperMetadataConfig.containsAnyArtwork(metadataConfig)) {
            return;
        }
        for (MovieScraperMetadataConfig config : metadataConfig) {
            List<MediaFile> mediaFiles;
            MediaFileType type = MovieArtworkHelper.getMediaFileTypeForConfig(config);
            if (type == null || (mediaFiles = movie.getMediaFiles(type)).isEmpty()) continue;
            List<IFileNaming> fileNamings = MovieArtworkHelper.getFileNamingsForMediaFileType(movie, type);
            MediaFile baseArtwork = mediaFiles.get(0);
            for (IFileNaming fileNaming : fileNamings) {
                boolean ok;
                MediaFile otherArtwork;
                String filename = MovieArtworkHelper.getArtworkFilename(movie, fileNaming, baseArtwork.getExtension());
                if (!StringUtils.isNotBlank((CharSequence)filename) || mediaFiles.contains(otherArtwork = new MediaFile(movie.getPathNIO().resolve(filename))) || !(ok = MovieRenamer.copyFile(baseArtwork.getFileAsPath(), otherArtwork.getFileAsPath()))) continue;
                movie.addToMediaFiles(otherArtwork);
            }
        }
    }

    private static MediaFileType getMediaFileTypeForConfig(MovieScraperMetadataConfig config) {
        MediaFileType type;
        block3: {
            if (!config.isArtwork()) {
                return null;
            }
            type = null;
            try {
                type = MediaFileType.valueOf(config.name());
            }
            catch (Exception ignored) {
                if (config != MovieScraperMetadataConfig.DISCART) break block3;
                type = MediaFileType.DISC;
            }
        }
        return type;
    }

    private static List<IFileNaming> getFileNamingsForMediaFileType(Movie movie, MediaFileType type) {
        ArrayList<IFileNaming> fileNamings = new ArrayList<IFileNaming>(0);
        switch (type) {
            case FANART: {
                fileNamings.addAll(MovieArtworkHelper.getFanartNamesForMovie(movie));
                break;
            }
            case POSTER: {
                fileNamings.addAll(MovieArtworkHelper.getPosterNamesForMovie(movie));
                break;
            }
            case LOGO: {
                fileNamings.addAll(MovieArtworkHelper.getLogoNamesForMovie(movie));
                break;
            }
            case CLEARLOGO: {
                fileNamings.addAll(MovieArtworkHelper.getClearlogoNamesForMovie(movie));
                break;
            }
            case BANNER: {
                fileNamings.addAll(MovieArtworkHelper.getBannerNamesForMovie(movie));
                break;
            }
            case CLEARART: {
                fileNamings.addAll(MovieArtworkHelper.getClearartNamesForMovie(movie));
                break;
            }
            case THUMB: {
                fileNamings.addAll(MovieArtworkHelper.getThumbNamesForMovie(movie));
                break;
            }
            case DISC: {
                fileNamings.addAll(MovieArtworkHelper.getDiscartNamesForMovie(movie));
                break;
            }
            case KEYART: {
                fileNamings.addAll(MovieArtworkHelper.getKeyartNamesForMovie(movie));
                break;
            }
        }
        return fileNamings;
    }

    public static boolean extractArtworkFromVsmeta(Movie movie, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        byte[] bytes;
        List<Enum> fileNamings;
        VSMeta vsmeta = new VSMeta(vsMetaFile.getFileAsPath());
        vsmeta.parseFile();
        switch (artworkType) {
            case POSTER: {
                fileNamings = MovieModuleManager.getInstance().getSettings().getPosterFilenames();
                bytes = vsmeta.getPosterBytes();
                break;
            }
            case BACKGROUND: {
                fileNamings = MovieModuleManager.getInstance().getSettings().getFanartFilenames();
                bytes = vsmeta.getBackdropBytes();
                break;
            }
            default: {
                return false;
            }
        }
        if (fileNamings.isEmpty() || bytes.length == 0) {
            return false;
        }
        String basename = FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)vsMetaFile.getFilename()));
        for (IFileNaming iFileNaming : fileNamings) {
            try {
                String filename = iFileNaming.getFilename(basename, "jpg");
                MediaFile mf = new MediaFile(vsMetaFile.getFileAsPath().getParent().resolve(filename), MediaFileType.getMediaFileType(artworkType));
                Files.write(mf.getFileAsPath(), bytes, new OpenOption[0]);
                movie.addToMediaFiles(mf);
            }
            catch (Exception e) {
                LOGGER.warn("could not extract VSMETA artwork: {}", (Object)e.getMessage());
            }
        }
        return true;
    }

    public static int getIndexOfArtwork(String filename) {
        String basename = FilenameUtils.getBaseName((String)filename);
        Matcher matcher = INDEX_PATTERN.matcher(basename);
        if (matcher.find() && matcher.groupCount() == 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                LOGGER.debug("could not parse index of '{}'- {}", (Object)filename, (Object)e.getMessage());
            }
        }
        return -1;
    }

    public static void createThumbWithFfmpeg(Movie movie) throws Exception {
        if (movie.isDisc()) {
            throw new UnsupportedOperationException("This cannot be done for disc images");
        }
        MediaFile mf = movie.getMainVideoFile();
        String fileType = "." + FilenameUtils.getExtension((String)mf.getFilename().toLowerCase(Locale.ROOT));
        if (!Settings.getInstance().getAllSupportedFileTypes().contains(fileType)) {
            throw new UnsupportedOperationException("invalid video file for FFmpeg");
        }
        int seconds = Settings.getInstance().getFfmpegPercentage() * mf.getDuration() / 100;
        Path tempFile = Paths.get(Utils.getTempFolder(), "ffmpeg-still." + System.currentTimeMillis() + ".jpg");
        FFmpeg.createStill(mf.getFileAsPath(), tempFile, seconds);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (Files.exists(tempFile, new LinkOption[0])) {
            movie.removeAllMediaFiles(MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.THUMB));
            boolean first = true;
            for (MovieThumbNaming thumbNaming : MovieArtworkHelper.getThumbNamesForMovie(movie)) {
                Path thumb = movie.getPathNIO().resolve(MovieArtworkHelper.getArtworkFilename(movie, thumbNaming, "jpg"));
                if (Files.exists(thumb, new LinkOption[0])) {
                    Utils.deleteFileSafely(thumb);
                }
                Utils.copyFileSafe(tempFile, thumb);
                if (first) {
                    movie.setArtwork(thumb, MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.THUMB));
                    movie.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.THUMB);
                    first = false;
                }
                MediaFile artwork = new MediaFile(thumb, MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.THUMB));
                artwork.gatherMediaInformation();
                movie.addToMediaFiles(artwork);
            }
            movie.saveToDb();
        }
    }
}

