/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import com.fasterxml.jackson.databind.ObjectReader;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ObservableCopyOnWriteArrayList;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

public final class MovieList
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieList.class);
    private static MovieList instance;
    private final List<Movie> movieList;
    private final List<MovieSet> movieSetList;
    private final CopyOnWriteArrayList<Integer> yearsInMovies;
    private final CopyOnWriteArrayList<String> tagsInMovies;
    private final CopyOnWriteArrayList<MediaGenres> genresInMovies;
    private final CopyOnWriteArrayList<String> videoCodecsInMovies;
    private final CopyOnWriteArrayList<String> videoContainersInMovies;
    private final CopyOnWriteArrayList<String> audioCodecsInMovies;
    private final CopyOnWriteArrayList<MediaCertification> certificationsInMovies;
    private final CopyOnWriteArrayList<Double> frameRatesInMovies;
    private final CopyOnWriteArrayList<Integer> audioStreamsInMovies;
    private final CopyOnWriteArrayList<Integer> subtitlesInMovies;
    private final CopyOnWriteArrayList<String> audioLanguagesInMovies;
    private final CopyOnWriteArrayList<String> subtitleLanguagesInMovies;
    private final CopyOnWriteArrayList<String> decadeInMovies;
    private final CopyOnWriteArrayList<String> hdrFormatInMovies;
    private final CopyOnWriteArrayList<String> audioTitlesInMovies;
    private final PropertyChangeListener movieListener;
    private final PropertyChangeListener movieSetListener;
    private final Comparator<MovieSet> movieSetComparator = new MovieSetComparator();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    private MovieList() {
        this.movieList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Movie.class));
        this.movieSetList = new ObservableCopyOnWriteArrayList<MovieSet>();
        this.yearsInMovies = new CopyOnWriteArrayList();
        this.tagsInMovies = new CopyOnWriteArrayList();
        this.genresInMovies = new CopyOnWriteArrayList();
        this.videoCodecsInMovies = new CopyOnWriteArrayList();
        this.videoContainersInMovies = new CopyOnWriteArrayList();
        this.audioCodecsInMovies = new CopyOnWriteArrayList();
        this.certificationsInMovies = new CopyOnWriteArrayList();
        this.frameRatesInMovies = new CopyOnWriteArrayList();
        this.audioStreamsInMovies = new CopyOnWriteArrayList();
        this.subtitlesInMovies = new CopyOnWriteArrayList();
        this.audioLanguagesInMovies = new CopyOnWriteArrayList();
        this.subtitleLanguagesInMovies = new CopyOnWriteArrayList();
        this.decadeInMovies = new CopyOnWriteArrayList();
        this.hdrFormatInMovies = new CopyOnWriteArrayList();
        this.audioTitlesInMovies = new CopyOnWriteArrayList();
        this.movieListener = evt -> {
            if (evt.getSource() instanceof Movie) {
                Movie movie = (Movie)evt.getSource();
                switch (evt.getPropertyName()) {
                    case "year": {
                        this.updateYear(Collections.singletonList(movie));
                        break;
                    }
                    case "certification": {
                        this.updateCertifications(Collections.singletonList(movie));
                        break;
                    }
                    case "genre": {
                        this.updateGenres(Collections.singletonList(movie));
                        break;
                    }
                    case "tags": {
                        this.updateTags(Collections.singletonList(movie));
                        break;
                    }
                    case "mediaFiles": 
                    case "mediaInformation": {
                        this.updateMediaInformationLists(Collections.singletonList(movie));
                        break;
                    }
                }
            }
        };
        this.movieSetListener = evt -> {
            switch (evt.getPropertyName()) {
                case "addedMovie": 
                case "removedMovie": {
                    this.firePropertyChange("movieInMovieSetCount", null, this.getMovieInMovieSetCount());
                    break;
                }
            }
        };
    }

    static synchronized MovieList getInstance() {
        if (instance == null) {
            instance = new MovieList();
        }
        return instance;
    }

    public void addMovie(Movie movie) {
        if (!this.movieList.contains(movie)) {
            int oldValue = this.movieList.size();
            this.movieList.add(movie);
            this.updateLists(Collections.singletonList(movie));
            movie.addPropertyChangeListener(this.movieListener);
            this.firePropertyChange("movies", null, this.movieList);
            this.firePropertyChange("movieCount", oldValue, this.movieList.size());
        }
    }

    void removeDatasource(String datasource) {
        if (StringUtils.isEmpty((CharSequence)datasource)) {
            return;
        }
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        Path path = Paths.get(datasource, new String[0]);
        for (int i = this.movieList.size() - 1; i >= 0; --i) {
            Movie movie = this.movieList.get(i);
            if (!path.equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            moviesToRemove.add(movie);
        }
        this.removeMovies(moviesToRemove);
    }

    void exchangeDatasource(String oldDatasource, String newDatasource) {
        Path oldPath = Paths.get(oldDatasource, new String[0]);
        List moviesToChange = this.movieList.stream().filter(movie -> oldPath.equals(Paths.get(movie.getDataSource(), new String[0]))).collect(Collectors.toList());
        ArrayList<MediaFile> imagesToCache = new ArrayList<MediaFile>();
        for (Movie movie2 : moviesToChange) {
            Path newMoviePath;
            Path oldMoviePath = movie2.getPathNIO();
            try {
                newMoviePath = Paths.get(newDatasource, Paths.get(movie2.getDataSource(), new String[0]).relativize(oldMoviePath).toString());
            }
            catch (Exception e) {
                newMoviePath = Paths.get(newDatasource, FilenameUtils.separatorsToSystem((String)movie2.getPath().replace(movie2.getDataSource(), "")));
            }
            movie2.setDataSource(newDatasource);
            movie2.setPath(newMoviePath.toAbsolutePath().toString());
            movie2.updateMediaFilePath(oldMoviePath, newMoviePath);
            movie2.saveToDb();
            imagesToCache.addAll(movie2.getImagesToCache());
        }
        if (!imagesToCache.isEmpty()) {
            ImageCacheTask task = new ImageCacheTask(imagesToCache);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
    }

    public List<Movie> getUnscrapedMovies() {
        return this.movieList.parallelStream().filter(movie -> !movie.isScraped()).collect(Collectors.toList());
    }

    public List<Movie> getNewMovies() {
        return this.movieList.parallelStream().filter(MediaEntity::isNewlyAdded).collect(Collectors.toList());
    }

    public Collection<MediaGenres> getUsedGenres() {
        return Collections.unmodifiableList(this.genresInMovies);
    }

    public void removeMovies(List<Movie> movies) {
        if (movies == null || movies.isEmpty()) {
            return;
        }
        int oldValue = this.movieList.size();
        for (int i = movies.size() - 1; i >= 0; --i) {
            Movie movie = movies.get(i);
            this.readWriteLock.writeLock().lock();
            this.movieList.remove(movie);
            this.readWriteLock.writeLock().unlock();
            if (movie.getMovieSet() != null) {
                MovieSet movieSet = movie.getMovieSet();
                movieSet.removeMovie(movie, false);
                movie.setMovieSet(null);
            }
            try {
                MovieModuleManager.getInstance().removeMovieFromDb(movie);
            }
            catch (Exception e) {
                LOGGER.error("Error removing movie from DB: {}", (Object)e.getMessage());
            }
            for (MediaFile mf : movie.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        this.firePropertyChange("movies", null, this.movieList);
        this.firePropertyChange("movieCount", oldValue, this.movieList.size());
    }

    public void deleteMovies(List<Movie> movies) {
        if (movies == null || movies.isEmpty()) {
            return;
        }
        int oldValue = this.movieList.size();
        for (int i = movies.size() - 1; i >= 0; --i) {
            Movie movie = movies.get(i);
            movie.deleteFilesSafely();
            this.readWriteLock.writeLock().lock();
            this.movieList.remove(movie);
            this.readWriteLock.writeLock().unlock();
            if (movie.getMovieSet() != null) {
                MovieSet movieSet = movie.getMovieSet();
                movieSet.removeMovie(movie, false);
                movie.setMovieSet(null);
            }
            try {
                MovieModuleManager.getInstance().removeMovieFromDb(movie);
            }
            catch (Exception e) {
                LOGGER.error("Error removing movie from DB: {}", (Object)e.getMessage());
            }
            for (MediaFile mf : movie.getMediaFiles()) {
                if (!mf.isGraphic()) continue;
                ImageCache.invalidateCachedImage(mf);
            }
        }
        this.firePropertyChange("movies", null, this.movieList);
        this.firePropertyChange("movieCount", oldValue, this.movieList.size());
    }

    public List<Movie> getMovies() {
        return this.movieList;
    }

    void loadMoviesFromDatabase(MVMap<UUID, String> movieMap) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        ObjectReader movieObjectReader = MovieModuleManager.getInstance().getMovieObjectReader();
        ArrayList toRemove = new ArrayList();
        long start = System.nanoTime();
        new ArrayList(movieMap.keyList()).parallelStream().forEach(uuid -> {
            String json = "";
            try {
                json = (String)movieMap.get(uuid);
                Movie movie = (Movie)movieObjectReader.readValue(json);
                movie.setDbId((UUID)uuid);
                if (movie.getMediaFiles(MediaFileType.VIDEO).isEmpty() || movie.getPathNIO() == null || StringUtils.isBlank((CharSequence)movie.getDataSource())) {
                    LOGGER.info("movie \"{}\" without video file/path/datasource - dropping", (Object)movie.getTitle());
                    lock.writeLock().lock();
                    toRemove.add(uuid);
                    lock.writeLock().unlock();
                    return;
                }
                lock.writeLock().lock();
                this.movieList.add(movie);
                lock.writeLock().unlock();
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding movie json string: {}", (Object)e.getMessage());
                LOGGER.info("dropping corrupt movie: {}", (Object)json);
                lock.writeLock().lock();
                toRemove.add(uuid);
                lock.writeLock().unlock();
            }
        });
        long end = System.nanoTime();
        for (UUID uuid2 : toRemove) {
            movieMap.remove((Object)uuid2);
        }
        LOGGER.info("found {} movies in database", (Object)this.movieList.size());
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
    }

    void loadMovieSetsFromDatabase(MVMap<UUID, String> movieSetMap) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        ObjectReader movieSetObjectReader = MovieModuleManager.getInstance().getMovieSetObjectReader();
        ArrayList toRemove = new ArrayList();
        long start = System.nanoTime();
        new ArrayList(movieSetMap.keyList()).parallelStream().forEach(uuid -> {
            try {
                MovieSet movieSet = (MovieSet)movieSetObjectReader.readValue((String)movieSetMap.get(uuid));
                movieSet.setDbId((UUID)uuid);
                lock.writeLock().lock();
                this.movieSetList.add(movieSet);
                lock.writeLock().unlock();
            }
            catch (Exception e) {
                LOGGER.warn("problem decoding movie set json string: {}", (Object)e.getMessage());
                LOGGER.info("dropping corrupt movie set");
                lock.writeLock().lock();
                toRemove.add(uuid);
                lock.writeLock().unlock();
            }
        });
        long end = System.nanoTime();
        for (UUID uuid2 : toRemove) {
            movieSetMap.remove((Object)uuid2);
        }
        LOGGER.info("found {} movieSets in database", (Object)this.movieSetList.size());
        LOGGER.debug("took {} ms", (Object)((end - start) / 1000000L));
    }

    void initDataAfterLoading() {
        this.checkAndCleanupMediaFiles();
        for (Movie movie : this.movieList) {
            movie.initializeAfterLoading();
            movie.addPropertyChangeListener(this.movieListener);
        }
        this.updateLists(this.movieList);
        for (MovieSet movieSet : this.movieSetList) {
            movieSet.initializeAfterLoading();
        }
    }

    public void persistMovie(Movie movie) {
        try {
            MovieModuleManager.getInstance().persistMovie(movie);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist movie: {} - {}", (Object)movie.getTitle(), (Object)e.getMessage());
        }
    }

    public void removeMovieFromDb(Movie movie) {
        try {
            MovieModuleManager.getInstance().removeMovieFromDb(movie);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove movie: {}", (Object)movie.getTitle());
        }
        for (MediaFile mf : movie.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mf);
        }
    }

    public void persistMovieSet(MovieSet movieSet) {
        try {
            MovieModuleManager.getInstance().persistMovieSet(movieSet);
        }
        catch (Exception e) {
            LOGGER.error("failed to persist movie set: {}", (Object)movieSet.getTitle());
        }
    }

    public void removeMovieSetFromDb(MovieSet movieSet) {
        try {
            MovieModuleManager.getInstance().removeMovieSetFromDb(movieSet);
        }
        catch (Exception e) {
            LOGGER.error("failed to remove movie set: {}", (Object)movieSet.getTitle());
        }
        for (MediaFile mf : movieSet.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            ImageCache.invalidateCachedImage(mf);
        }
    }

    public MovieSet lookupMovieSet(UUID uuid) {
        for (MovieSet movieSet : this.movieSetList) {
            if (!movieSet.getDbId().equals(uuid)) continue;
            return movieSet;
        }
        return null;
    }

    public Movie lookupMovie(UUID uuid) {
        for (Movie movie : this.movieList) {
            if (!movie.getDbId().equals(uuid)) continue;
            return movie;
        }
        return null;
    }

    public synchronized Movie getMovieByPath(Path path) {
        for (Movie movie : this.movieList) {
            if (movie.getPathNIO().compareTo(path.toAbsolutePath()) != 0) continue;
            LOGGER.debug("Ok, found already existing movie '{}' in DB (path: {})", (Object)movie.getTitle(), (Object)path);
            return movie;
        }
        return null;
    }

    public synchronized List<Movie> getMoviesByPath(Path path) {
        return this.movieList.parallelStream().filter(movie -> movie.getPathNIO().compareTo(path) == 0).collect(Collectors.toList());
    }

    public List<MediaSearchResult> searchMovie(String searchTerm, int year, Map<String, Object> ids, MediaScraper metadataScraper) throws ScrapeException {
        return this.searchMovie(searchTerm, year, ids, metadataScraper, MovieModuleManager.getInstance().getSettings().getScraperLanguage());
    }

    public List<MediaSearchResult> searchMovie(String searchTerm, int year, Map<String, Object> ids, MediaScraper mediaScraper, MediaLanguages language) throws ScrapeException {
        if (mediaScraper == null || !mediaScraper.isEnabled()) {
            return Collections.emptyList();
        }
        TreeSet<MediaSearchResult> sr = new TreeSet<MediaSearchResult>();
        IMovieMetadataProvider provider = (IMovieMetadataProvider)mediaScraper.getMediaProvider();
        Pattern tmdbPattern = Pattern.compile("https://www.themoviedb.org/movie/(.*?)-.*");
        MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
        options.setLanguage(language);
        options.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
        options.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
        options.setMetadataScraper(mediaScraper);
        if (ids != null) {
            options.setIds(ids);
        }
        if (!searchTerm.isEmpty()) {
            String query = searchTerm.toLowerCase(Locale.ROOT);
            if (MetadataUtil.isValidImdbId(query)) {
                options.setImdbId(query);
            } else if (query.startsWith("imdb:")) {
                String imdbId = query.replace("imdb:", "");
                if (MetadataUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("https://www.imdb.com/title/")) {
                String imdbId = query.split("/")[4];
                if (MetadataUtil.isValidImdbId(imdbId)) {
                    options.setImdbId(imdbId);
                }
            } else if (query.startsWith("tmdb:")) {
                try {
                    int tmdbId = Integer.parseInt(query.replace("tmdb:", ""));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {}
            } else if (tmdbPattern.matcher(query).matches()) {
                try {
                    int tmdbId = Integer.parseInt(tmdbPattern.matcher(query).replaceAll("$1"));
                    if (tmdbId > 0) {
                        options.setTmdbId(tmdbId);
                    }
                }
                catch (Exception tmdbId) {
                    // empty catch block
                }
            }
            options.setSearchQuery(searchTerm);
        }
        if (year > 0) {
            options.setSearchYear(year);
        }
        LOGGER.info("=====================================================");
        LOGGER.info("Searching with scraper: {}", (Object)provider.getProviderInfo().getId());
        LOGGER.info("options: {}", (Object)options);
        LOGGER.info("=====================================================");
        sr.addAll(provider.search(options));
        if (sr.isEmpty() && MovieModuleManager.getInstance().getSettings().isScraperFallback()) {
            for (MediaScraper ms : this.getAvailableMediaScrapers()) {
                if (provider.getProviderInfo().equals(ms.getMediaProvider().getProviderInfo()) || ms.getMediaProvider().getProviderInfo().getName().startsWith("Kodi") || !ms.getMediaProvider().isActive()) continue;
                LOGGER.info("no result yet - trying alternate scraper: {}", (Object)ms.getName());
                try {
                    LOGGER.info("=====================================================");
                    LOGGER.info("Searching with alternate scraper: '{}', '{}'", (Object)ms.getMediaProvider().getId(), (Object)provider.getProviderInfo().getVersion());
                    LOGGER.info("options: {}", (Object)options);
                    LOGGER.info("=====================================================");
                    sr.addAll(((IMovieMetadataProvider)ms.getMediaProvider()).search(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("searchMovieFallback - '{}'", (Object)e.getMessage());
                }
                if (sr.isEmpty()) continue;
                break;
            }
        }
        return new ArrayList<MediaSearchResult>(sr);
    }

    public List<MediaScraper> getAvailableMediaScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public MediaScraper getDefaultMediaScraper() {
        MediaScraper scraper = MediaScraper.getMediaScraperById(MovieModuleManager.getInstance().getSettings().getMovieScraper(), ScraperType.MOVIE);
        if (scraper == null || !scraper.isEnabled()) {
            scraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
        }
        return scraper;
    }

    public MediaScraper getMediaScraperById(String providerId) {
        return MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE);
    }

    public List<MediaScraper> getAvailableArtworkScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_ARTWORK);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getArtworkScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper artworkScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (artworkScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_ARTWORK)) == null) continue;
            artworkScrapers.add(artworkScraper);
        }
        return artworkScrapers;
    }

    public List<MediaScraper> getDefaultArtworkScrapers() {
        List<MediaScraper> defaultScrapers = this.getArtworkScrapers(MovieModuleManager.getInstance().getSettings().getArtworkScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getAvailableTrailerScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_TRAILER);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultTrailerScrapers() {
        List<MediaScraper> defaultScrapers = this.getTrailerScrapers(MovieModuleManager.getInstance().getSettings().getTrailerScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getTrailerScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> trailerScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper trailerScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (trailerScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_TRAILER)) == null) continue;
            trailerScrapers.add(trailerScraper);
        }
        return trailerScrapers;
    }

    public List<MediaScraper> getAvailableSubtitleScrapers() {
        List<MediaScraper> availableScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SUBTITLE);
        availableScrapers.sort(new MovieMediaScraperComparator());
        return availableScrapers;
    }

    public List<MediaScraper> getDefaultSubtitleScrapers() {
        List<MediaScraper> defaultScrapers = this.getSubtitleScrapers(MovieModuleManager.getInstance().getSettings().getSubtitleScrapers());
        return defaultScrapers.stream().filter(MediaScraper::isActive).collect(Collectors.toList());
    }

    public List<MediaScraper> getSubtitleScrapers(List<String> providerIds) {
        ArrayList<MediaScraper> subtitleScrapers = new ArrayList<MediaScraper>();
        for (String providerId : providerIds) {
            MediaScraper subtitleScraper;
            if (StringUtils.isBlank((CharSequence)providerId) || (subtitleScraper = MediaScraper.getMediaScraperById(providerId, ScraperType.MOVIE_SUBTITLE)) == null) continue;
            subtitleScrapers.add(subtitleScraper);
        }
        return subtitleScrapers;
    }

    public int getMovieCount() {
        return this.movieList.size();
    }

    public int getMovieSetCount() {
        return this.movieSetList.size();
    }

    public int getMovieInMovieSetCount() {
        int count = 0;
        for (MovieSet movieSet : this.movieSetList) {
            count += movieSet.getMovies().size();
        }
        return count;
    }

    private void updateLists(Collection<Movie> movies) {
        this.updateYear(movies);
        this.updateDecades(movies);
        this.updateTags(movies);
        this.updateGenres(movies);
        this.updateCertifications(movies);
        this.updateMediaInformationLists(movies);
    }

    private void updateYear(Collection<Movie> movies) {
        HashSet years = new HashSet();
        movies.forEach(movie -> years.add(movie.getYear()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.yearsInMovies, years)) {
            this.firePropertyChange("year", null, this.yearsInMovies);
        }
    }

    private void updateDecades(Collection<Movie> movies) {
        HashSet decades = new HashSet();
        movies.forEach(movie -> decades.add(movie.getDecadeShort()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.decadeInMovies, decades)) {
            this.firePropertyChange("decade", null, this.decadeInMovies);
        }
    }

    private void updateGenres(Collection<Movie> movies) {
        HashSet genres = new HashSet();
        movies.forEach(movie -> genres.addAll(movie.getGenres()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.genresInMovies, genres)) {
            this.firePropertyChange("genre", null, this.genresInMovies);
        }
    }

    private void updateTags(Collection<Movie> movies) {
        HashSet tags = new HashSet();
        movies.forEach(movie -> tags.addAll(movie.getTags()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.tagsInMovies, tags)) {
            this.firePropertyChange("tags", null, this.tagsInMovies);
        }
    }

    private void updateMediaInformationLists(Collection<Movie> movies) {
        HashSet<String> videoCodecs = new HashSet<String>();
        HashSet<Double> frameRates = new HashSet<Double>();
        HashMap<String, String> videoContainers = new HashMap<String, String>();
        HashSet<String> audioCodecs = new HashSet<String>();
        HashSet<Integer> audioStreamCount = new HashSet<Integer>();
        HashSet<Integer> subtitleCount = new HashSet<Integer>();
        HashSet<String> audioLanguages = new HashSet<String>();
        HashSet<String> subtitleLanguages = new HashSet<String>();
        HashSet<String> hdrFormat = new HashSet<String>();
        HashSet<String> audioTitles = new HashSet<String>();
        for (Movie movie : movies) {
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
                if (mf.getSubtitleLanguagesList().isEmpty()) continue;
                subtitleLanguages.addAll(mf.getSubtitleLanguagesList());
            }
        }
        for (Movie movie : movies) {
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (StringUtils.isNotBlank((CharSequence)mf.getVideoCodec())) {
                    videoCodecs.add(mf.getVideoCodec());
                }
                if (mf.getFrameRate() > 0.0) {
                    frameRates.add(mf.getFrameRate());
                }
                if (StringUtils.isNotBlank((CharSequence)mf.getContainerFormat())) {
                    videoContainers.putIfAbsent(mf.getContainerFormat().toLowerCase(Locale.ROOT), mf.getContainerFormat());
                }
                for (MediaFileAudioStream audio : mf.getAudioStreams()) {
                    if (!StringUtils.isNotBlank((CharSequence)audio.getCodec())) continue;
                    audioCodecs.add(audio.getCodec());
                }
                if (!mf.getAudioStreams().isEmpty()) {
                    audioStreamCount.add(mf.getAudioStreams().size());
                }
                if (!mf.getSubtitles().isEmpty()) {
                    subtitleCount.add(mf.getSubtitles().size());
                }
                if (!mf.getAudioLanguagesList().isEmpty()) {
                    audioLanguages.addAll(mf.getAudioLanguagesList());
                }
                if (!mf.getHdrFormat().isEmpty()) {
                    hdrFormat.add(mf.getHdrFormat());
                }
                if (mf.getAudioTitleList().isEmpty()) continue;
                audioTitles.addAll(mf.getAudioTitleList());
            }
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoCodecsInMovies, videoCodecs)) {
            this.firePropertyChange("videoCodec", null, this.videoCodecsInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.frameRatesInMovies, frameRates)) {
            this.firePropertyChange("frameRate", null, this.frameRatesInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.videoContainersInMovies, videoContainers.values())) {
            this.firePropertyChange("videoContainer", null, this.videoContainersInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioCodecsInMovies, audioCodecs)) {
            this.firePropertyChange("audioCodec", null, this.audioCodecsInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioStreamsInMovies, audioStreamCount)) {
            this.firePropertyChange("audioStreams", null, this.audioStreamsInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitlesInMovies, subtitleCount)) {
            this.firePropertyChange("countSubtitles", null, this.subtitlesInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioLanguagesInMovies, audioLanguages)) {
            this.firePropertyChange("audioLanugages", null, this.audioLanguagesInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.subtitleLanguagesInMovies, subtitleLanguages)) {
            this.firePropertyChange("subtitleLanguages", null, this.subtitleLanguagesInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.hdrFormatInMovies, hdrFormat)) {
            this.firePropertyChange("hdrFormat", null, this.hdrFormatInMovies);
        }
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.audioTitlesInMovies, audioTitles)) {
            this.firePropertyChange("audioTitle", null, this.audioTitlesInMovies);
        }
    }

    private void updateCertifications(Collection<Movie> movies) {
        HashSet certifications = new HashSet();
        movies.forEach(movie -> certifications.add(movie.getCertification()));
        if (ListUtils.addToCopyOnWriteArrayListIfAbsent(this.certificationsInMovies, certifications)) {
            this.firePropertyChange("certification", null, this.certificationsInMovies);
        }
    }

    public Collection<Integer> getYearsInMovies() {
        return Collections.unmodifiableList(this.yearsInMovies);
    }

    public Collection<String> getDecadeInMovies() {
        return Collections.unmodifiableList(this.decadeInMovies);
    }

    public Collection<String> getTagsInMovies() {
        return Collections.unmodifiableList(this.tagsInMovies);
    }

    public Collection<String> getVideoCodecsInMovies() {
        return Collections.unmodifiableList(this.videoCodecsInMovies);
    }

    public Collection<String> getVideoContainersInMovies() {
        return Collections.unmodifiableList(this.videoContainersInMovies);
    }

    public Collection<String> getAudioCodecsInMovies() {
        return Collections.unmodifiableList(this.audioCodecsInMovies);
    }

    public Collection<MediaCertification> getCertificationsInMovies() {
        return Collections.unmodifiableList(this.certificationsInMovies);
    }

    public Collection<Double> getFrameRatesInMovies() {
        return Collections.unmodifiableList(this.frameRatesInMovies);
    }

    public Collection<Integer> getAudioStreamsInMovies() {
        return Collections.unmodifiableList(this.audioStreamsInMovies);
    }

    public Collection<Integer> getSubtitlesInMovies() {
        return Collections.unmodifiableList(this.subtitlesInMovies);
    }

    public Collection<String> getAudioLanguagesInMovies() {
        return Collections.unmodifiableList(this.audioLanguagesInMovies);
    }

    public Collection<String> getSubtitleLanguagesInMovies() {
        return Collections.unmodifiableList(this.subtitleLanguagesInMovies);
    }

    public Collection<String> getHDRFormatInMovies() {
        return Collections.unmodifiableList(this.hdrFormatInMovies);
    }

    public Collection<String> getAudioTitlesInMovies() {
        return Collections.unmodifiableList(this.audioTitlesInMovies);
    }

    public void searchDuplicates() {
        HashMap<CallSite, Movie> duplicates = new HashMap<CallSite, Movie>();
        for (Movie movie : this.movieList) {
            movie.clearDuplicate();
            Map<String, Object> ids = movie.getIds();
            for (Map.Entry<String, Object> entry : ids.entrySet()) {
                if (entry.getKey().equals("tmdbSet")) continue;
                String id = entry.getKey() + String.valueOf(entry.getValue());
                if (duplicates.containsKey(id)) {
                    movie.setDuplicate();
                    Movie movie2 = (Movie)duplicates.get(id);
                    movie2.setDuplicate();
                    continue;
                }
                duplicates.put((CallSite)((Object)id), movie);
            }
        }
    }

    public List<MovieSet> getMovieSetList() {
        return Collections.unmodifiableList(this.movieSetList);
    }

    public List<MovieSet> getSortedMovieSetList() {
        ArrayList<MovieSet> sortedMovieSets = new ArrayList<MovieSet>(this.getMovieSetList());
        sortedMovieSets.sort(this.movieSetComparator);
        return sortedMovieSets;
    }

    public void addMovieSet(MovieSet movieSet) {
        int oldValue = this.movieSetList.size();
        this.readWriteLock.writeLock().lock();
        this.movieSetList.add(movieSet);
        this.readWriteLock.writeLock().unlock();
        movieSet.addPropertyChangeListener(this.movieSetListener);
        this.firePropertyChange("addedMovieSet", null, movieSet);
        this.firePropertyChange("movieSetCount", oldValue, this.movieSetList.size());
        this.firePropertyChange("movieInMovieSetCount", oldValue, this.getMovieInMovieSetCount());
    }

    public void removeMovieSet(MovieSet movieSet) {
        int oldValue = this.movieSetList.size();
        movieSet.removePropertyChangeListener(this.movieSetListener);
        try {
            for (MediaFile mf : movieSet.getMediaFiles(MediaFileType.NFO)) {
                Utils.deleteFileSafely(mf.getFileAsPath());
            }
            MovieSetArtworkHelper.removeMovieSetArtwork(movieSet);
            if (StringUtils.isNotBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder())) {
                String movieSetName = movieSet.getTitleForStorage();
                Utils.deleteEmptyDirectoryRecursive(Paths.get(MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder(), movieSetName));
            }
            movieSet.removeAllMovies();
            this.readWriteLock.writeLock().lock();
            this.movieSetList.remove(movieSet);
            this.readWriteLock.writeLock().unlock();
            MovieModuleManager.getInstance().removeMovieSetFromDb(movieSet);
        }
        catch (Exception e) {
            LOGGER.error("Error removing movie set from DB: {}", (Object)e.getMessage());
        }
        this.firePropertyChange("removedMovieSet", null, movieSet);
        this.firePropertyChange("movieSetCount", oldValue, this.movieSetList.size());
        this.firePropertyChange("movieInMovieSetCount", oldValue, this.getMovieInMovieSetCount());
    }

    public MovieSet findMovieSet(String title, int tmdbId) {
        if (tmdbId > 0) {
            for (MovieSet movieSet : this.movieSetList) {
                if (movieSet.getTmdbId() != tmdbId) continue;
                return movieSet;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            for (MovieSet movieSet : this.movieSetList) {
                if (!movieSet.getTitle().equals(title)) continue;
                return movieSet;
            }
        }
        return null;
    }

    public synchronized MovieSet getMovieSet(String title, int tmdbId) {
        MovieSet movieSet = this.findMovieSet(title, tmdbId);
        if (movieSet == null && StringUtils.isNotBlank((CharSequence)title)) {
            movieSet = new MovieSet(title);
            if (tmdbId > 0) {
                movieSet.setTmdbId(tmdbId);
            }
            movieSet.saveToDb();
            this.addMovieSet(movieSet);
        }
        return movieSet;
    }

    private void checkAndCleanupMediaFiles() {
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (Movie movie : this.movieList) {
            List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
            if (!mfs.isEmpty()) continue;
            moviesToRemove.add(movie);
        }
        if (!moviesToRemove.isEmpty()) {
            this.removeMovies(moviesToRemove);
            LOGGER.warn("movies without VIDEOs detected");
            Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Message message = new Message(Message.MessageLevel.SEVERE, "tmm.movies", "message.database.corrupteddata");
                MessageManager.instance.pushMessage(message);
            });
            thread.start();
        }
    }

    public void invalidateTitleSortable() {
        this.movieList.parallelStream().forEach(Movie::clearTitleSortable);
    }

    public void addOfflineMovie(String title, String datasource, MediaSource mediaSource) {
        if (!MovieModuleManager.getInstance().getSettings().getMovieDataSource().contains(datasource)) {
            return;
        }
        int i = 1;
        Path stubFolder = Paths.get(datasource, title);
        while (Files.exists(stubFolder, new LinkOption[0])) {
            stubFolder = Paths.get(datasource, title + "(" + i++ + ")");
        }
        Path stubFile = stubFolder.resolve(title + ".disc");
        try {
            Files.createDirectory(stubFolder, new FileAttribute[0]);
            Files.createFile(stubFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("could not create stub file - {}", (Object)e.getMessage());
            return;
        }
        MediaFile mf = new MediaFile(stubFile);
        mf.gatherMediaInformation();
        Movie movie = new Movie();
        movie.setTitle(title);
        movie.setPath(stubFolder.toAbsolutePath().toString());
        movie.setDataSource(datasource);
        movie.setMediaSource(mediaSource);
        movie.setDateAdded(new Date());
        movie.addToMediaFiles(mf);
        movie.setOffline(true);
        movie.setNewlyAdded(true);
        try {
            this.addMovie(movie);
            movie.saveToDb();
        }
        catch (Exception e) {
            try {
                Utils.deleteDirectoryRecursive(stubFolder);
            }
            catch (Exception e1) {
                LOGGER.debug("could not delete stub folder - {}", (Object)e1.getMessage());
            }
            throw e;
        }
    }

    public List<String> getTvShowTitles() {
        ArrayList<String> tvShowTitles = new ArrayList<String>();
        TvShowModuleManager.getInstance().getTvShowList().getTvShows().forEach(tvShow -> tvShowTitles.add(tvShow.getTitle()));
        tvShowTitles.sort(Comparator.naturalOrder());
        return tvShowTitles;
    }

    public List<MovieScraperMetadataConfig> detectMissingMetadata(Movie movie) {
        return this.detectMissingFields(movie, MovieModuleManager.getInstance().getSettings().getMovieCheckMetadata());
    }

    public List<MovieScraperMetadataConfig> detectMissingArtwork(Movie movie) {
        return this.detectMissingFields(movie, MovieModuleManager.getInstance().getSettings().getMovieCheckArtwork());
    }

    public List<MovieScraperMetadataConfig> detectMissingFields(Movie movie, List<MovieScraperMetadataConfig> toCheck) {
        ArrayList<MovieScraperMetadataConfig> missingMetadata = new ArrayList<MovieScraperMetadataConfig>();
        for (MovieScraperMetadataConfig metadataConfig : toCheck) {
            Object value = movie.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    public List<MovieSetScraperMetadataConfig> detectMissingMetadata(MovieSet movieSet) {
        return this.detectMissingFields(movieSet, MovieModuleManager.getInstance().getSettings().getMovieSetCheckMetadata());
    }

    public List<MovieSetScraperMetadataConfig> detectMissingArtwork(MovieSet movieSet) {
        return this.detectMissingFields(movieSet, MovieModuleManager.getInstance().getSettings().getMovieSetCheckArtwork());
    }

    public List<MovieSetScraperMetadataConfig> detectMissingFields(MovieSet movieSet, List<MovieSetScraperMetadataConfig> toCheck) {
        ArrayList<MovieSetScraperMetadataConfig> missingMetadata = new ArrayList<MovieSetScraperMetadataConfig>();
        for (MovieSetScraperMetadataConfig metadataConfig : toCheck) {
            Object value = movieSet.getValueForMetadata(metadataConfig);
            if (value == null) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Number && ((Number)value).intValue() <= 0) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                missingMetadata.add(metadataConfig);
                continue;
            }
            if (value != MediaCertification.UNKNOWN) continue;
            missingMetadata.add(metadataConfig);
        }
        return missingMetadata;
    }

    private static class MovieMediaScraperComparator
    implements Comparator<MediaScraper> {
        private MovieMediaScraperComparator() {
        }

        @Override
        public int compare(MediaScraper o1, MediaScraper o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }

    private static class MovieSetComparator
    implements Comparator<MovieSet> {
        private MovieSetComparator() {
        }

        @Override
        public int compare(MovieSet o1, MovieSet o2) {
            if (o1 == null || o2 == null || o1.getTitleSortable() == null || o2.getTitleSortable() == null) {
                return 0;
            }
            return o1.getTitleSortable().compareToIgnoreCase(o2.getTitleSortable());
        }
    }
}

