/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MoviePostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoviePostProcessExecutor.class);

    public MoviePostProcessExecutor(PostProcess postProcess) {
        super(postProcess);
    }

    @Override
    public void execute() {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        for (Movie movie : selectedMovies) {
            LOGGER.info("PostProcessing: START {}", (Object)this.postProcess);
            String[] command = this.substituteMovieTokens(movie);
            try {
                this.executeCommand(command, movie);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Problem executing post process", (Throwable)e);
            }
        }
    }

    private String[] substituteMovieTokens(Movie movie) {
        Engine engine = Engine.createEngine();
        engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new MovieRenamer.MovieNamedFirstCharacterRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
        engine.registerNamedRenderer((NamedRenderer)new MovieRenamer.MovieNamedIndexOfMovieSetRenderer());
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        HashMap<String, Movie> root = new HashMap<String, Movie>();
        root.put("movie", movie);
        if (this.postProcess.getPath() == null) {
            String transformed = engine.transform(JmteUtils.morphTemplate(this.postProcess.getCommand(), MovieRenamer.getTokenMap()), root);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(JmteUtils.morphTemplate(splitted[i], MovieRenamer.getTokenMap()), root);
        }
        return splitted;
    }
}

