/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.commons.io.FilenameUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieRenamerPreviewContainer;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieRenamerPreview {
    private MovieRenamerPreview() {
        throw new IllegalAccessError();
    }

    public static MovieRenamerPreviewContainer renameMovie(Movie movie) {
        MovieRenamerPreviewContainer container = new MovieRenamerPreviewContainer(movie);
        LinkedHashMap<String, MediaFile> oldFiles = new LinkedHashMap<String, MediaFile>();
        LinkedHashSet<MediaFile> newFiles = new LinkedHashSet<MediaFile>();
        if (movie.isDisc()) {
            for (MediaFile mf : movie.getMediaFiles()) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                newFiles.add(mf);
            }
        } else {
            String newVideoBasename = "";
            if (MovieModuleManager.getInstance().getSettings().getRenamerFilename().trim().isEmpty()) {
                newVideoBasename = movie.getVideoBasenameWithoutStacking();
            } else {
                Iterator<MediaFile> ftr = MovieRenamer.generateFilename(movie, movie.getMainVideoFile(), newVideoBasename).get(0);
                newVideoBasename = FilenameUtils.getBaseName((String)((MediaFile)((Object)ftr)).getFilenameWithoutStacking());
            }
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                MediaFile ftr = MovieRenamer.generateFilename(movie, mf, newVideoBasename).get(0);
                newFiles.add(ftr);
            }
            for (MediaFile mf : movie.getMediaFilesExceptType(MediaFileType.VIDEO)) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                newFiles.addAll(MovieRenamer.generateFilename(movie, mf, newVideoBasename));
            }
        }
        Path oldMovieFolder = movie.getPathNIO();
        String pattern = MovieModuleManager.getInstance().getSettings().getRenamerPathname();
        container.newPath = pattern.isEmpty() ? Paths.get(movie.getDataSource(), new String[0]).relativize(movie.getPathNIO()) : Paths.get(MovieRenamer.createDestinationForFoldername(pattern, movie), new String[0]);
        Path newMovieFolder = Paths.get(movie.getDataSource(), new String[0]).resolve(container.newPath);
        if (!oldMovieFolder.equals(newMovieFolder)) {
            container.needsRename = true;
            for (MediaFile omf : oldFiles.values()) {
                omf.replacePathForRenamedFolder(oldMovieFolder, newMovieFolder);
            }
        }
        for (MediaFile mf : newFiles) {
            if (oldFiles.containsKey(mf.getFileAsPath().toString())) continue;
            container.needsRename = true;
            break;
        }
        for (MediaFile mf : oldFiles.values()) {
            if (newFiles.contains(mf)) continue;
            container.needsRename = true;
            break;
        }
        container.newMediaFiles.addAll(newFiles);
        return container;
    }
}

