/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;

public enum MovieScraperMetadataConfig implements ScraperMetadataConfig
{
    ID(ScraperMetadataConfig.Type.METADATA, "metatag.id"),
    TITLE(ScraperMetadataConfig.Type.METADATA),
    ORIGINAL_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.originaltitle"),
    TAGLINE(ScraperMetadataConfig.Type.METADATA),
    PLOT(ScraperMetadataConfig.Type.METADATA),
    YEAR(ScraperMetadataConfig.Type.METADATA),
    RELEASE_DATE(ScraperMetadataConfig.Type.METADATA, "metatag.releasedate"),
    RATING(ScraperMetadataConfig.Type.METADATA),
    TOP250(ScraperMetadataConfig.Type.METADATA),
    RUNTIME(ScraperMetadataConfig.Type.METADATA),
    CERTIFICATION(ScraperMetadataConfig.Type.METADATA),
    GENRES(ScraperMetadataConfig.Type.METADATA, "metatag.genre"),
    SPOKEN_LANGUAGES(ScraperMetadataConfig.Type.METADATA, "metatag.language"),
    COUNTRY(ScraperMetadataConfig.Type.METADATA),
    PRODUCTION_COMPANY(ScraperMetadataConfig.Type.METADATA, "metatag.studio"),
    TAGS(ScraperMetadataConfig.Type.METADATA),
    COLLECTION(ScraperMetadataConfig.Type.METADATA, "metatag.movieset", "Settings.movieset.scraper.hint"),
    TRAILER(ScraperMetadataConfig.Type.METADATA),
    ACTORS(ScraperMetadataConfig.Type.CAST),
    PRODUCERS(ScraperMetadataConfig.Type.CAST),
    DIRECTORS(ScraperMetadataConfig.Type.CAST),
    WRITERS(ScraperMetadataConfig.Type.CAST),
    POSTER(ScraperMetadataConfig.Type.ARTWORK),
    FANART(ScraperMetadataConfig.Type.ARTWORK),
    BANNER(ScraperMetadataConfig.Type.ARTWORK),
    CLEARART(ScraperMetadataConfig.Type.ARTWORK),
    THUMB(ScraperMetadataConfig.Type.ARTWORK),
    LOGO(ScraperMetadataConfig.Type.ARTWORK),
    CLEARLOGO(ScraperMetadataConfig.Type.ARTWORK),
    DISCART(ScraperMetadataConfig.Type.ARTWORK, "mediafiletype.disc"),
    KEYART(ScraperMetadataConfig.Type.ARTWORK),
    EXTRAFANART(ScraperMetadataConfig.Type.ARTWORK),
    EXTRATHUMB(ScraperMetadataConfig.Type.ARTWORK);

    private final ScraperMetadataConfig.Type type;
    private final String description;
    private final String tooltip;

    private MovieScraperMetadataConfig(ScraperMetadataConfig.Type type) {
        this(type, null, null);
    }

    private MovieScraperMetadataConfig(ScraperMetadataConfig.Type type, String description) {
        this(type, description, null);
    }

    private MovieScraperMetadataConfig(ScraperMetadataConfig.Type type, String description, String tooltip) {
        this.type = type;
        this.description = description;
        this.tooltip = tooltip;
    }

    @Override
    public ScraperMetadataConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            try {
                if (this.type == ScraperMetadataConfig.Type.ARTWORK) {
                    return TmmResourceBundle.getString("mediafiletype." + this.name().toLowerCase(Locale.ROOT));
                }
                return TmmResourceBundle.getString("metatag." + this.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception exception) {}
        } else {
            try {
                return TmmResourceBundle.getString(this.description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (StringUtils.isBlank((CharSequence)this.tooltip)) {
            return null;
        }
        try {
            return TmmResourceBundle.getString(this.tooltip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<MovieScraperMetadataConfig> valuesForType(ScraperMetadataConfig.Type type) {
        ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
        for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
            if (config.type != type) continue;
            values.add(config);
        }
        return values;
    }

    public static List<MovieScraperMetadataConfig> getValues() {
        ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (value.type == ScraperMetadataConfig.Type.DEPRECATED) continue;
            values.add(value);
        }
        return values;
    }

    public static List<MovieScraperMetadataConfig> getValuesWithout(MovieScraperMetadataConfig ... valuesToExclude) {
        ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
        List<MovieScraperMetadataConfig> exclude = Arrays.asList(valuesToExclude);
        for (MovieScraperMetadataConfig value : MovieScraperMetadataConfig.values()) {
            if (value.type == ScraperMetadataConfig.Type.DEPRECATED || exclude.contains(value)) continue;
            values.add(value);
        }
        return values;
    }
}

