/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;

public class MovieSetNfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetNfoParser.class);
    private Element root;
    private final List<String> supportedElements = new ArrayList<String>();
    public String title = "";
    public String plot = "";
    public String userNote = "";
    public Map<String, Object> ids = new HashMap<String, Object>();
    public List<String> tags = new ArrayList<String>();
    public List<MediaGenres> genres = new ArrayList<MediaGenres>();
    public List<String> studios = new ArrayList<String>();
    public List<String> unsupportedElements = new ArrayList<String>();

    private MovieSetNfoParser(Document document) {
        document.outputSettings().prettyPrint(false);
        Elements elements = document.select("collection");
        if (!elements.isEmpty()) {
            this.parseEmbyNfo((Element)elements.get(0));
            return;
        }
    }

    private void parseEmbyNfo(Element root) {
        this.root = root;
        this.parseTag(MovieSetNfoParser::parseTitle);
        this.parseTag(MovieSetNfoParser::parsePlot);
        this.parseTag(MovieSetNfoParser::parseIds);
        this.parseTag(MovieSetNfoParser::parseTags);
        this.parseTag(MovieSetNfoParser::parseUserNote);
        this.parseTag(MovieSetNfoParser::parseGenres);
        this.parseTag(MovieSetNfoParser::parseStudios);
        this.parseTag(MovieSetNfoParser::findUnsupportedElements);
    }

    private void parseTag(Function<MovieSetNfoParser, Void> function) {
        try {
            function.apply(this);
        }
        catch (Exception e) {
            LOGGER.warn("problem parsing tag (line {}): {}", (Object)e.getStackTrace()[0].getLineNumber(), (Object)e.getMessage());
        }
    }

    public static MovieSetNfoParser parseNfo(Path path) throws Exception {
        return new MovieSetNfoParser(Jsoup.parse((InputStream)new FileInputStream(path.toFile()), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
    }

    public static MovieSetNfoParser parseNfo(String content) throws Exception {
        return new MovieSetNfoParser(Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser()));
    }

    public boolean isValidNfo() {
        return StringUtils.isNotBlank((CharSequence)this.title);
    }

    private Element getSingleElement(Element parent, String tag) {
        Elements elements = parent.select(parent.tagName() + " > " + tag);
        if (elements.size() != 1) {
            return null;
        }
        return (Element)elements.get(0);
    }

    private Void parseTitle() {
        this.supportedElements.add("title");
        Element element = this.getSingleElement(this.root, "title");
        if (element != null) {
            this.title = element.ownText();
        }
        return null;
    }

    private Void parsePlot() {
        this.supportedElements.add("plot");
        Element element = this.getSingleElement(this.root, "plot");
        if (element != null) {
            this.plot = element.wholeText();
        }
        return null;
    }

    private Void parseIds() {
        this.supportedElements.add("tmdbid");
        this.supportedElements.add("ids");
        this.supportedElements.add("uniqueid");
        Element element = this.getSingleElement(this.root, "tmdbid");
        if (element != null) {
            try {
                this.ids.put("tmdb", MetadataUtil.parseInt(element.ownText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Elements elements = this.root.select(this.root.tagName() + " > uniqueid");
        for (Element id : elements) {
            try {
                String key = id.attr("type");
                if ("tmdb".equals(key)) {
                    key = "tmdbSet";
                }
                String value = id.ownText();
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value})) continue;
                try {
                    this.ids.put(key, MetadataUtil.parseInt(value));
                }
                catch (Exception e) {
                    this.ids.put(key, value);
                }
            }
            catch (Exception key) {}
        }
        element = this.getSingleElement(this.root, "ids");
        if (element != null) {
            Elements children = element.children();
            for (Element entry : children) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.tagName(), entry.ownText()})) continue;
                try {
                    this.ids.put(entry.tagName(), MetadataUtil.parseInt(entry.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(entry.tagName(), entry.ownText());
                }
            }
        }
        return null;
    }

    private Void parseTags() {
        this.supportedElements.add("tag");
        Elements elements = this.root.select(this.root.tagName() + " > tag");
        for (Element element : elements) {
            if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
            this.tags.add(element.ownText());
        }
        return null;
    }

    private Void parseUserNote() {
        this.supportedElements.add("user_note");
        Element element = this.getSingleElement(this.root, "user_note");
        if (element != null) {
            this.userNote = element.ownText();
        }
        return null;
    }

    private Void parseGenres() {
        this.supportedElements.add("genres");
        this.supportedElements.add("genre");
        Elements elements = null;
        Element element = this.getSingleElement(this.root, "genres");
        elements = element != null ? element.select(element.tagName() + " > genre") : this.root.select(this.root.tagName() + " > genre");
        if (elements != null && !elements.isEmpty()) {
            for (Element genre : elements) {
                if (!StringUtils.isNotBlank((CharSequence)genre.ownText())) continue;
                for (String sp : ParserUtils.split(genre.ownText())) {
                    this.genres.add(MediaGenres.getGenre(sp.trim()));
                }
            }
        }
        return null;
    }

    private Void parseStudios() {
        this.supportedElements.add("studio");
        Elements elements = this.root.select(this.root.tagName() + " > studio");
        if (elements.size() == 1) {
            try {
                this.studios.addAll(ParserUtils.split(((Element)elements.get(0)).ownText()));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.studios.add(element.ownText());
            }
        }
        return null;
    }

    private Void findUnsupportedElements() {
        for (Element element : this.root.children()) {
            if (this.supportedElements.contains(element.tagName().toLowerCase(Locale.ROOT))) continue;
            String elementText = element.toString().replaceAll(">\\r?\\n\\s*<", "><");
            this.unsupportedElements.add(elementText);
        }
        return null;
    }

    public MovieSet toMovieSet() {
        MovieSet movieSet = new MovieSet();
        movieSet.setTitle(this.title);
        movieSet.setPlot(this.plot);
        for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("tmdb")) {
                movieSet.setId("tmdbSet", entry.getValue());
                continue;
            }
            movieSet.setId(entry.getKey(), entry.getValue());
        }
        movieSet.addToTags(this.tags);
        movieSet.setNote(this.userNote);
        return movieSet;
    }
}

