/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.connector.MovieToKodiConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToEmbyConnector
extends MovieToKodiConnector {
    public MovieToEmbyConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addOwnTags() {
        super.addOwnTags();
        this.addLockdata();
    }

    protected void addLockdata() {
        Element lockdata = this.document.createElement("lockdata");
        lockdata.setTextContent("true");
        this.root.appendChild(lockdata);
    }

    @Override
    protected void addDirectors() {
        for (Person director : this.movie.getDirectors()) {
            int tmdbid;
            Element element = this.document.createElement("director");
            String imdbId = director.getIdAsString("imdb");
            if (StringUtils.isNotBlank((CharSequence)imdbId)) {
                element.setAttribute("imdbid", imdbId);
            }
            if ((tmdbid = director.getIdAsInt("tmdb")) > 0) {
                element.setAttribute("tmdbid", String.valueOf(tmdbid));
            }
            element.setTextContent(director.getName());
            this.root.appendChild(element);
        }
    }
}

