/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToXbmcConnector
extends MovieGenericXmlConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieToXbmcConnector.class);

    public MovieToXbmcConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addOwnTags() {
        this.addEpbookmark();
        this.addTop250();
        this.addLastplayed();
        this.addStatusAndCode();
        this.addFileinfo();
    }

    @Override
    protected void addTrailer() {
        Element trailer = this.document.createElement("trailer");
        for (MediaTrailer mediaTrailer : new ArrayList<MediaTrailer>(this.movie.getTrailer())) {
            if (!mediaTrailer.getInNfo().booleanValue() || mediaTrailer.getUrl().startsWith("file")) continue;
            trailer.setTextContent(this.prepareTrailerForXbmc(mediaTrailer));
            break;
        }
        this.root.appendChild(trailer);
    }

    private String prepareTrailerForXbmc(MediaTrailer trailer) {
        Pattern pattern = Pattern.compile("https{0,1}://.*youtube..*/watch\\?v=(.*)$");
        Matcher matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/?action=play_video&videoid=" + matcher.group(1);
        }
        pattern = Pattern.compile("https{0,1}://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");
        matcher = pattern.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("failed to escape " + trailer.getUrl());
            }
        }
        return trailer.getUrl();
    }

    private void addEpbookmark() {
        Element epbookmark = this.document.createElement("epbookmark");
        Element year = this.getSingleElementByTag("year");
        if (year != null) {
            if (this.parser != null) {
                epbookmark.setTextContent(this.parser.epbookmark);
            }
            this.root.insertBefore(epbookmark, year);
        }
    }

    private void addTop250() {
        Element top250 = this.document.createElement("top250");
        top250.setTextContent(Integer.toString(this.movie.getTop250()));
        Element set = this.getSingleElementByTag("set");
        if (set != null) {
            this.root.insertBefore(top250, set);
        }
    }

    private void addLastplayed() {
        Element lastplayed = this.document.createElement("lastplayed");
        Element genre = this.getSingleElementByTag("genre");
        if (genre != null) {
            if (this.parser != null && this.parser.lastplayed != null) {
                lastplayed.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(this.parser.lastplayed));
            }
            this.root.insertBefore(lastplayed, genre);
        }
    }

    private void addStatusAndCode() {
        Element status = this.document.createElement("status");
        Element code = this.document.createElement("code");
        Element premiered = this.getSingleElementByTag("premiered");
        if (premiered != null) {
            if (this.parser != null) {
                status.setTextContent(this.parser.status);
                code.setTextContent(this.parser.code);
            }
            this.root.insertBefore(status, premiered);
            this.root.insertBefore(code, premiered);
        }
    }

    private void addFileinfo() {
        Element fileinfo = this.document.createElement("fileinfo");
        Element streamdetails = this.document.createElement("streamdetails");
        MediaFile vid = this.movie.getMainVideoFile();
        if (vid != null) {
            Element video = this.document.createElement("video");
            Element codec = this.document.createElement("codec");
            if ("h265".equalsIgnoreCase(vid.getVideoCodec())) {
                codec.setTextContent("HEVC");
            } else {
                codec.setTextContent(vid.getVideoCodec());
            }
            video.appendChild(codec);
            Element aspect = this.document.createElement("aspect");
            aspect.setTextContent(Float.toString(vid.getAspectRatio().floatValue()));
            video.appendChild(aspect);
            Element width = this.document.createElement("width");
            width.setTextContent(Integer.toString(vid.getVideoWidth()));
            video.appendChild(width);
            Element height = this.document.createElement("height");
            height.setTextContent(Integer.toString(vid.getVideoHeight()));
            video.appendChild(height);
            if (!this.movie.isDisc() && !this.movie.getMainVideoFile().getExtension().equalsIgnoreCase("iso")) {
                Element durationinseconds = this.document.createElement("durationinseconds");
                durationinseconds.setTextContent(Integer.toString(this.movie.getRuntimeFromMediaFiles()));
                video.appendChild(durationinseconds);
            }
            Element stereomode = this.document.createElement("stereomode");
            if (vid.getVideo3DFormat().equals("3D SBS") || vid.getVideo3DFormat().equals("3D HSBS")) {
                stereomode.setTextContent("left_right");
            } else if (vid.getVideo3DFormat().equals("3D TAB") || vid.getVideo3DFormat().equals("3D HTAB")) {
                stereomode.setTextContent("top_bottom");
            }
            video.appendChild(stereomode);
            streamdetails.appendChild(video);
            for (MediaFileAudioStream audioStream : vid.getAudioStreams()) {
                Element audio = this.document.createElement("audio");
                Element codec2 = this.document.createElement("codec");
                codec2.setTextContent(audioStream.getCodec());
                audio.appendChild(codec2);
                Element language = this.document.createElement("language");
                language.setTextContent(audioStream.getLanguage());
                audio.appendChild(language);
                Element channels = this.document.createElement("channels");
                channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
                audio.appendChild(channels);
                streamdetails.appendChild(audio);
            }
            if (MovieModuleManager.getInstance().getSettings().isIncludeExternalAudioStreams()) {
                for (MediaFile audioFile : this.movie.getMediaFiles(MediaFileType.AUDIO)) {
                    for (MediaFileAudioStream audioStream : vid.getAudioStreams()) {
                        Element audio = this.document.createElement("audio");
                        Element codec3 = this.document.createElement("codec");
                        codec3.setTextContent(audioStream.getCodec());
                        audio.appendChild(codec3);
                        Element language = this.document.createElement("language");
                        language.setTextContent(audioStream.getLanguage());
                        audio.appendChild(language);
                        Element channels = this.document.createElement("channels");
                        channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
                        audio.appendChild(channels);
                        streamdetails.appendChild(audio);
                    }
                }
            }
            for (MediaFileSubtitle sub : vid.getSubtitles()) {
                Element subtitle = this.document.createElement("subtitle");
                Element language = this.document.createElement("language");
                language.setTextContent(sub.getLanguage());
                subtitle.appendChild(language);
                streamdetails.appendChild(subtitle);
            }
        }
        for (MediaFile mediaFile : this.movie.getMediaFiles(MediaFileType.SUBTITLE)) {
            for (MediaFileSubtitle sub : mediaFile.getSubtitles()) {
                Element subtitle = this.document.createElement("subtitle");
                Element language = this.document.createElement("language");
                language.setTextContent(sub.getLanguage());
                subtitle.appendChild(language);
                streamdetails.appendChild(subtitle);
            }
        }
        fileinfo.appendChild(streamdetails);
        this.root.appendChild(fileinfo);
    }
}

