/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.TrailerSources;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.connector.MovieToEmbyConnector;
import org.tinymediamanager.core.movie.connector.MovieToKodiConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpLegacyConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpMovingPicturesConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpMyVideoConnector;
import org.tinymediamanager.core.movie.connector.MovieToXbmcConnector;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.movie.tasks.MovieARDetectorTask;
import org.tinymediamanager.core.movie.tasks.MovieActorImageFetcherTask;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.movie.tasks.MovieSetScrapeTask;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskChain;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class Movie
extends MediaEntity
implements IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Movie.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    private static final Comparator<MediaTrailer> TRAILER_QUALITY_COMPARATOR = new MediaTrailer.QualityComparator();
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private String tagline = "";
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private int playcount = 0;
    @JsonProperty
    private boolean isDisc = false;
    @JsonProperty
    private String spokenLanguages = "";
    @JsonProperty
    private String country = "";
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date releaseDate = null;
    @JsonProperty
    private boolean multiMovieDir = false;
    @JsonProperty
    private int top250 = 0;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private boolean videoIn3D = false;
    @JsonProperty
    private MediaCertification certification = MediaCertification.UNKNOWN;
    @JsonProperty
    private UUID movieSetId;
    @JsonProperty
    private MovieEdition edition = MovieEdition.NONE;
    @JsonProperty
    private boolean stacked = false;
    @JsonProperty
    private boolean offline = false;
    @JsonProperty
    private final List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private final List<String> extraThumbs = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private final List<String> extraFanarts = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private final List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> producers = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> directors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> writers = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<MediaTrailer> trailer = new CopyOnWriteArrayList<MediaTrailer>();
    @JsonProperty
    private final List<String> showlinks = new CopyOnWriteArrayList<String>();
    private MovieSet movieSet;
    private String titleSortable = "";
    private String originalTitleSortable = "";
    private Date lastWatched = null;
    private String localizedSpokenLanguages = "";

    public void merge(Movie other) {
        this.merge(other, false);
    }

    public void forceMerge(Movie other) {
        this.merge(other, true);
    }

    void merge(Movie other, boolean force) {
        if (other == null) {
            return;
        }
        super.merge(other, force);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setTagline(StringUtils.isEmpty((CharSequence)this.tagline) || force ? other.tagline : this.tagline);
        this.setSpokenLanguages(StringUtils.isEmpty((CharSequence)this.spokenLanguages) || force ? other.spokenLanguages : this.spokenLanguages);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        this.setWatched(!this.watched || force ? other.watched : this.watched);
        this.setPlaycount(this.playcount == 0 || force ? other.playcount : this.playcount);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setTop250(this.top250 == 0 || force ? other.top250 : this.top250);
        this.setReleaseDate(this.releaseDate == null || force ? other.releaseDate : this.releaseDate);
        this.setMovieSet(this.movieSet == null || force ? other.movieSet : this.movieSet);
        this.setMediaSource(this.mediaSource == MediaSource.UNKNOWN || force ? other.mediaSource : this.mediaSource);
        this.setCertification(this.certification == MediaCertification.UNKNOWN || force ? other.certification : this.certification);
        this.setEdition(this.edition == MovieEdition.NONE || force ? other.edition : this.edition);
        if (force) {
            this.genres.clear();
            this.actors.clear();
            this.producers.clear();
            this.directors.clear();
            this.writers.clear();
            this.trailer.clear();
            this.extraFanarts.clear();
            this.extraThumbs.clear();
        }
        this.setGenres(other.genres);
        this.setActors(other.actors);
        this.setProducers(other.producers);
        this.setDirectors(other.directors);
        this.setWriters(other.writers);
        this.setShowlinks(other.showlinks);
        this.setExtraFanarts(other.extraFanarts);
        this.setExtraThumbs(other.extraThumbs);
        ArrayList<MediaTrailer> mergedTrailers = new ArrayList<MediaTrailer>(this.trailer);
        ListUtils.mergeLists(mergedTrailers, other.trailer);
        this.setTrailers(mergedTrailers);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void addToMediaFiles(MediaFile mediaFile) {
        super.addToMediaFiles(mediaFile);
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    @Override
    public boolean isScraped() {
        return this.scraped || !this.plot.isEmpty() && this.year != 0;
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public String getTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public String getOriginalTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.originalTitleSortable)) {
            this.originalTitleSortable = Utils.getSortableName(this.getOriginalTitle());
        }
        return this.originalTitleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
        this.originalTitleSortable = "";
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> mf = this.getMediaFiles(MediaFileType.NFO);
        return mf != null && !mf.isEmpty();
    }

    @Deprecated
    public Boolean getHasMetadata() {
        return !this.plot.isEmpty() && this.year != 0;
    }

    @Deprecated
    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : Arrays.asList(MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.MediaArtworkType.BACKGROUND)) {
            if (!StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasTrailer() {
        return !this.getMediaFiles(MediaFileType.TRAILER).isEmpty();
    }

    public Boolean getHasNote() {
        return StringUtils.isNotBlank((CharSequence)this.note);
    }

    public String getTitleForUi() {
        Object titleForUi = this.title;
        if (this.year > 0) {
            titleForUi = (String)titleForUi + " (" + this.year + ")";
        }
        return titleForUi;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        if (this.movieSetId != null) {
            this.movieSet = MovieModuleManager.getInstance().getMovieList().lookupMovieSet(this.movieSetId);
        }
    }

    public List<MediaTrailer> getTrailer() {
        return this.trailer;
    }

    public void addToTrailer(Collection<MediaTrailer> newTrailers) {
        LinkedHashSet<MediaTrailer> newItems = new LinkedHashSet<MediaTrailer>();
        for (MediaTrailer trailer : ListUtils.nullSafe(newTrailers)) {
            if (trailer == null || this.trailer.contains(trailer)) continue;
            newItems.add(trailer);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.trailer.addAll(newItems);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public List<String> getShowlinks() {
        return this.showlinks;
    }

    public void setShowlinks(List<String> newShowlinks) {
        ListUtils.mergeLists(this.showlinks, newShowlinks);
        Utils.removeEmptyStringsFromList(this.showlinks);
        this.firePropertyChange("showlinks", null, this.showlinks);
        this.firePropertyChange("showlinksAsString", null, this.showlinks);
    }

    public void addShowlinks(Collection<String> newShowlinks) {
        LinkedHashSet<String> newItems = new LinkedHashSet<String>(1);
        for (String showlink : ListUtils.nullSafe(newShowlinks)) {
            if (StringUtils.isBlank((CharSequence)showlink) || this.showlinks.contains(showlink)) continue;
            newItems.add(showlink);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.showlinks.addAll(newItems);
        this.firePropertyChange("newShowlinks", null, newShowlinks);
        this.firePropertyChange("showlinksAsString", null, newShowlinks);
    }

    public void removeShowlink(String showlink) {
        if (this.showlinks.remove(showlink)) {
            this.firePropertyChange("showlinks", null, this.showlinks);
            this.firePropertyChange("showlinksAsString", null, this.showlinks);
        }
    }

    public String getShowlinksAsString() {
        return String.join((CharSequence)", ", this.showlinks);
    }

    public boolean getHasSubtitles() {
        if (!this.getMediaFiles(MediaFileType.SUBTITLE).isEmpty()) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public int getTraktTvId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktTvId(int newValue) {
        this.setId("trakt", newValue);
    }

    public int getRuntime() {
        int runtimeFromMi = this.getRuntimeFromMediaFilesInMinutes();
        if (MovieModuleManager.getInstance().getSettings().isRuntimeFromMediaInfo() && runtimeFromMi > 0) {
            return runtimeFromMi;
        }
        return this.runtime == 0 ? runtimeFromMi : this.runtime;
    }

    public String getTagline() {
        return this.tagline;
    }

    public boolean hasFile(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return false;
        }
        for (MediaFile file : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (filename.compareTo(file.getFilename()) != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getExtraThumbs() {
        return this.extraThumbs;
    }

    @JsonSetter
    public void setExtraThumbs(List<String> extraThumbs) {
        ListUtils.mergeLists(this.extraThumbs, extraThumbs);
    }

    public List<String> getExtraFanarts() {
        return this.extraFanarts;
    }

    @JsonSetter
    public void setExtraFanarts(List<String> extraFanarts) {
        ListUtils.mergeLists(this.extraFanarts, extraFanarts);
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public void setMetadata(MediaMetadata metadata, List<MovieScraperMetadataConfig> config, boolean overwriteExistingItems) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (metadata.getIds().isEmpty()) {
            LOGGER.warn("wanted to save empty metadata for {}", (Object)this.getTitle());
            return;
        }
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        if (!matchFound && overwriteExistingItems) {
            this.ids.clear();
        }
        if (overwriteExistingItems) {
            this.setIds(metadata.getIds());
        } else {
            for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
                if (this.ids.containsKey(entry.getKey())) continue;
                this.setId(entry.getKey(), entry.getValue());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getTitle()) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getTitle()))) {
            if (MovieModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.ORIGINAL_TITLE) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getOriginalTitle()))) {
            if (MovieModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setOriginalTitle(WordUtils.capitalize((String)metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(MovieScraperMetadataConfig.TAGLINE) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getTagline()))) {
            this.setTagline(metadata.getTagline());
        }
        if (config.contains(MovieScraperMetadataConfig.PLOT) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getPlot()))) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(MovieScraperMetadataConfig.YEAR) && (overwriteExistingItems || this.getYear() <= 0)) {
            this.setYear(metadata.getYear());
        }
        if (config.contains(MovieScraperMetadataConfig.RELEASE_DATE) && (overwriteExistingItems || this.getReleaseDate() == null)) {
            this.setReleaseDate(metadata.getReleaseDate());
        }
        if (config.contains(MovieScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            if (matchFound || !overwriteExistingItems) {
                newRatings.putAll(this.getRatings());
            }
            for (MediaRating mediaRating : metadata.getRatings()) {
                if (overwriteExistingItems) {
                    newRatings.put(mediaRating.getId(), mediaRating);
                    continue;
                }
                newRatings.putIfAbsent(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(MovieScraperMetadataConfig.TOP250) && (overwriteExistingItems || this.getTop250() <= 0)) {
            this.setTop250(metadata.getTop250());
        }
        if (config.contains(MovieScraperMetadataConfig.RUNTIME) && (overwriteExistingItems || this.getRuntime() <= 0)) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.contains(MovieScraperMetadataConfig.SPOKEN_LANGUAGES) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getSpokenLanguages()))) {
            this.setSpokenLanguages(StringUtils.join(metadata.getSpokenLanguages(), (String)", "));
        }
        if (config.contains(MovieScraperMetadataConfig.COUNTRY) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getCountry()))) {
            this.setCountry(StringUtils.join(metadata.getCountries(), (String)", "));
        }
        if (config.contains(MovieScraperMetadataConfig.CERTIFICATION) && (overwriteExistingItems || this.getCertification() == null || this.getCertification() == MediaCertification.UNKNOWN) && !metadata.getCertifications().isEmpty()) {
            this.setCertification(metadata.getCertifications().get(0));
        }
        if (config.contains(MovieScraperMetadataConfig.PRODUCTION_COMPANY) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getProductionCompany()))) {
            this.setProductionCompany(StringUtils.join(metadata.getProductionCompanies(), (String)", "));
        }
        if (config.contains(MovieScraperMetadataConfig.ACTORS) && (overwriteExistingItems || this.getActors().isEmpty())) {
            this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
        }
        if (config.contains(MovieScraperMetadataConfig.DIRECTORS) && (overwriteExistingItems || this.getDirectors().isEmpty())) {
            this.setDirectors(metadata.getCastMembers(Person.Type.DIRECTOR));
        }
        if (config.contains(MovieScraperMetadataConfig.WRITERS) && (overwriteExistingItems || this.getWriters().isEmpty())) {
            this.setWriters(metadata.getCastMembers(Person.Type.WRITER));
        }
        if (config.contains(MovieScraperMetadataConfig.PRODUCERS) && (overwriteExistingItems || this.getProducers().isEmpty())) {
            this.setProducers(metadata.getCastMembers(Person.Type.PRODUCER));
        }
        if (config.contains(MovieScraperMetadataConfig.GENRES) && (overwriteExistingItems || this.getGenres().isEmpty())) {
            this.setGenres(metadata.getGenres());
        }
        if (config.contains(MovieScraperMetadataConfig.TAGS)) {
            if (!matchFound || overwriteExistingItems) {
                this.removeAllTags();
            }
            this.addToTags(metadata.getTags());
        }
        this.setScraped(true);
        if (config.contains(MovieScraperMetadataConfig.COLLECTION) && (overwriteExistingItems || this.getIdAsInt("tmdbSet") == 0)) {
            int col = 0;
            try {
                col = (Integer)metadata.getId("tmdbSet");
            }
            catch (Exception entry) {
                // empty catch block
            }
            if (col != 0) {
                boolean created = false;
                MovieSet movieSet = MovieModuleManager.getInstance().getMovieList().findMovieSet(metadata.getCollectionName(), col);
                if (movieSet == null && StringUtils.isNotBlank((CharSequence)metadata.getCollectionName())) {
                    movieSet = new MovieSet(metadata.getCollectionName());
                    movieSet.setTmdbId(col);
                    movieSet.saveToDb();
                    MovieModuleManager.getInstance().getMovieList().addMovieSet(movieSet);
                    created = true;
                }
                if (movieSet != null) {
                    List<MediaScraper> movieSetMediaScrapers;
                    this.setMovieSet(null);
                    this.setMovieSet(movieSet);
                    movieSet.insertMovie(this);
                    movieSet.saveToDb();
                    if (created && !(movieSetMediaScrapers = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET)).isEmpty()) {
                        MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
                        options.setTmdbId(col);
                        options.setLanguage(MovieModuleManager.getInstance().getSettings().getScraperLanguage());
                        options.setMetadataScraper(movieSetMediaScrapers.get(0));
                        options.setArtworkScraper(MovieModuleManager.getInstance().getMovieList().getDefaultArtworkScrapers());
                        MovieSetScrapeTask task = new MovieSetScrapeTask(Collections.singletonList(movieSet), options, Arrays.asList(MovieSetScraperMetadataConfig.values()));
                        TmmTaskManager.getInstance().addUnnamedTask(task);
                    }
                }
            }
        }
        this.writeNFO();
        this.saveToDb();
        this.postProcess(config);
    }

    @JsonSetter
    public void setTrailers(List<MediaTrailer> trailers) {
        MediaTrailer preferredTrailer = null;
        this.removeAllTrailers();
        ArrayList<MediaTrailer> newItems = new ArrayList<MediaTrailer>();
        if (MovieModuleManager.getInstance().getSettings().isUseTrailerPreference()) {
            TrailerQuality desiredQuality = MovieModuleManager.getInstance().getSettings().getTrailerQuality();
            TrailerSources desiredSource = MovieModuleManager.getInstance().getSettings().getTrailerSource();
            for (MediaTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MediaTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
                sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
                for (MediaTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < TrailerQuality.getTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MediaTrailer> sortedTrailers = new ArrayList<MediaTrailer>(trailers);
            sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MediaTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            newItems.add(preferredTrailer);
        }
        for (MediaTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.isEmpty() && !trailer.getUrl().startsWith("file")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            newItems.add(trailer);
        }
        this.addToTrailer(newItems);
        this.mixinLocalTrailers();
    }

    public void setArtwork(MediaMetadata md, List<MovieScraperMetadataConfig> config, boolean overwrite) {
        this.setArtwork(md.getMediaArt(MediaArtwork.MediaArtworkType.ALL), config, overwrite);
    }

    public void setArtwork(List<MediaArtwork> artwork, List<MovieScraperMetadataConfig> config, boolean overwrite) {
        MovieArtworkHelper.setArtwork(this, artwork, config, overwrite);
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    @Override
    public void setOriginalTitle(String newValue) {
        String oldValue = this.originalTitle;
        super.setOriginalTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.originalTitleSortable;
        this.originalTitleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.originalTitleSortable);
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    @Override
    public void setYear(int newValue) {
        int oldValue = this.year;
        super.setYear(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
    }

    public String getNfoFilename(MovieNfoNaming nfo) {
        String filename = "";
        MediaFile mainFile = this.getMainFile();
        if (mainFile != null) {
            filename = mainFile.getFilename();
        }
        if (this.isStacked()) {
            filename = Utils.cleanStackingMarkers(filename);
        }
        filename = this.getNfoFilename(nfo, filename);
        return filename;
    }

    public String getNfoFilename(MovieNfoNaming nfo, String newMovieFilename) {
        Object filename;
        switch (nfo) {
            case FILENAME_NFO: {
                filename = this.isDisc() ? FilenameUtils.removeExtension((String)this.findDiscMainFile()) : FilenameUtils.removeExtension((String)newMovieFilename);
                if (((String)filename).isEmpty()) break;
                filename = (String)filename + ".nfo";
                break;
            }
            case MOVIE_NFO: {
                filename = "movie.nfo";
                break;
            }
            default: {
                filename = "";
            }
        }
        LOGGER.trace("getNfoFilename: '{}' / '{}' -> '{}'", new Object[]{newMovieFilename, nfo, filename});
        return filename;
    }

    public String getTrailerFilename(MovieTrailerNaming trailer) {
        String filename = "";
        if (this.isDisc) {
            filename = this.findDiscMainFile();
        } else {
            MediaFile mainFile = this.getMainFile();
            if (mainFile != null) {
                filename = mainFile.getFilename();
            }
        }
        if (this.isStacked()) {
            filename = Utils.cleanStackingMarkers(filename);
        }
        filename = this.getTrailerFilename(trailer, filename);
        LOGGER.trace("getTrailerFilename: {} -> '{}'", (Object)trailer, (Object)filename);
        return filename;
    }

    public String getTrailerFilename(MovieTrailerNaming trailer, String newMovieFilename) {
        String filename = trailer.getFilename(FilenameUtils.getBaseName((String)newMovieFilename), FilenameUtils.getExtension((String)newMovieFilename));
        filename = FilenameUtils.removeExtension((String)filename);
        LOGGER.trace("getTrailerFilename: '{}' / {} -> '{}'", new Object[]{newMovieFilename, trailer, filename});
        return filename;
    }

    public void downloadArtwork(MediaFileType type) {
        MovieArtworkHelper.downloadArtwork(this, type);
    }

    public void writeActorImages() {
        if (!MovieModuleManager.getInstance().getSettings().isWriteActorImages() || this.isMultiMovieDir()) {
            return;
        }
        MovieActorImageFetcherTask task = new MovieActorImageFetcherTask(this);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void writeNFO() {
        if (MovieModuleManager.getInstance().getSettings().getNfoFilenames().isEmpty()) {
            LOGGER.info("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        MovieGenericXmlConnector connector = null;
        switch (MovieModuleManager.getInstance().getSettings().getMovieConnector()) {
            case MP: {
                connector = new MovieToMpLegacyConnector(this);
                break;
            }
            case MP_MP: {
                connector = new MovieToMpMovingPicturesConnector(this);
                break;
            }
            case MP_MV: {
                connector = new MovieToMpMyVideoConnector(this);
                break;
            }
            case XBMC: {
                connector = new MovieToXbmcConnector(this);
                break;
            }
            case EMBY: {
                connector = new MovieToEmbyConnector(this);
                break;
            }
            default: {
                connector = new MovieToKodiConnector(this);
            }
        }
        if (connector != null) {
            ArrayList<MovieNfoNaming> nfonames = new ArrayList<MovieNfoNaming>();
            if (this.isMultiMovieDir() || this.isDisc) {
                nfonames.add(MovieNfoNaming.FILENAME_NFO);
            } else {
                nfonames = MovieModuleManager.getInstance().getSettings().getNfoFilenames();
            }
            connector.write(nfonames);
            this.firePropertyChange("hasNfoFile", false, true);
        }
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void addToGenres(Collection<MediaGenres> newGenres) {
        LinkedHashSet<MediaGenres> newItems = new LinkedHashSet<MediaGenres>();
        for (MediaGenres genre : ListUtils.nullSafe(newGenres)) {
            if (genre == null || this.genres.contains(genre)) continue;
            newItems.add(genre);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.genres.addAll(newItems);
        this.firePropertyChange("genre", null, newGenres);
        this.firePropertyChange("genresAsString", null, newGenres);
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public void removeAllGenres() {
        this.genres.clear();
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    @Override
    public MediaCertification getCertification() {
        return this.certification;
    }

    public void setCertification(MediaCertification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, (Object)newValue);
    }

    @Override
    public MediaRating getRating() {
        String ratingSource;
        MediaRating mediaRating = null;
        Iterator<String> iterator = MovieModuleManager.getInstance().getSettings().getRatingSources().iterator();
        while (iterator.hasNext() && (mediaRating = (MediaRating)this.ratings.get(ratingSource = iterator.next())) == null) {
        }
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public boolean getHasRating() {
        return !this.ratings.isEmpty() || this.scraped;
    }

    @Override
    public MediaRating getUserRating() {
        MediaRating mediaRating = (MediaRating)this.ratings.get("user");
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public int getPlaycount() {
        return this.playcount;
    }

    public void setPlaycount(int newValue) {
        int oldValue = this.playcount;
        this.playcount = newValue;
        this.firePropertyChange("playcount", oldValue, newValue);
    }

    public boolean isMultiMovieDir() {
        return this.multiMovieDir;
    }

    public void setMultiMovieDir(boolean multiDir) {
        this.multiMovieDir = multiDir;
    }

    public boolean hasMultiMovieNaming() {
        if (this.isDisc()) {
            return false;
        }
        MediaFile vid = this.getMainFile();
        String name = FilenameUtils.getBaseName((String)vid.getFilenameWithoutStacking());
        if (name.isEmpty()) {
            return false;
        }
        for (MediaFile mf : this.getMediaFiles()) {
            if (mf.getFilename().startsWith(name) && !mf.isDiscFile()) continue;
            return false;
        }
        return true;
    }

    public MovieSet getMovieSet() {
        return this.movieSet;
    }

    public void setMovieSet(MovieSet newValue) {
        MovieSet oldValue = this.movieSet;
        this.movieSet = newValue;
        this.movieSetId = newValue == null ? null : newValue.getDbId();
        this.firePropertyChange("movieset", oldValue, newValue);
        this.firePropertyChange("movieSetTitle", oldValue, newValue);
    }

    public void movieSetTitleChanged() {
        this.firePropertyChange("movieSetTitle", null, "");
    }

    public String getMovieSetTitle() {
        if (this.movieSet != null) {
            return this.movieSet.getTitle();
        }
        return "";
    }

    public void removeFromMovieSet() {
        if (this.movieSet != null) {
            this.movieSet.removeMovie(this, true);
        }
        this.setMovieSet(null);
    }

    public boolean isDisc() {
        return this.isDisc;
    }

    public void setDisc(boolean isDisc) {
        this.isDisc = isDisc;
    }

    public String findDiscMainFile() {
        MediaFile mainVideoFile = this.getMainVideoFile();
        Object filename = "";
        if (mainVideoFile.isBlurayFile()) {
            filename = "index.bdmv";
        }
        if (mainVideoFile.isDVDFile()) {
            filename = "VIDEO_TS.ifo";
        }
        if (mainVideoFile.isHDDVDFile()) {
            filename = "HVDVD_TS.ifo";
        }
        if (StringUtils.isNotBlank((CharSequence)filename) && mainVideoFile.getFile().toFile().isDirectory()) {
            filename = mainVideoFile.getFilename() + File.separator + (String)filename;
        }
        return filename;
    }

    public int getMediaInfoVideoBitrate() {
        return this.getMainVideoFile().getVideoBitRate();
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return this.getMainVideoFile().getBitDepth();
    }

    public String getMediaInfoAudioCodecAndChannels() {
        MediaFile mf = this.getMainVideoFile();
        if (!mf.getAudioCodec().isEmpty()) {
            return mf.getAudioCodec() + "_" + mf.getAudioChannels();
        }
        return "";
    }

    public void setSpokenLanguages(String newValue) {
        String oldValue = this.spokenLanguages;
        this.spokenLanguages = newValue;
        this.firePropertyChange("spokenLanguages", oldValue, newValue);
    }

    public String getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public String getLocalizedSpokenLanguages() {
        if (StringUtils.isBlank((CharSequence)this.localizedSpokenLanguages)) {
            ArrayList<String> translatedLanguages = new ArrayList<String>();
            for (String langu : ParserUtils.split(this.getSpokenLanguages())) {
                String translated = LanguageUtils.getLocalizedLanguageNameFromLocalizedString(Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()), langu.trim());
                translatedLanguages.add(translated);
            }
            this.localizedSpokenLanguages = String.join((CharSequence)", ", translatedLanguages);
        }
        return this.localizedSpokenLanguages;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = newValue;
        this.firePropertyChange("country", oldValue, newValue);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", oldValue, newValue);
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        if (MovieModuleManager.getInstance().getSettings().isWriteActorImages() && !this.isMultiMovieDir()) {
            filesToCache.addAll(this.listActorFiles());
        }
        return filesToCache;
    }

    protected List<MediaFile> listActorFiles() {
        if (this.getPathNIO() == null || !Files.exists(this.getPathNIO().resolve(".actors"), new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videoFiles.isEmpty()) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        mediaFilesWithAudioStreams.addAll(this.getMediaFiles(MediaFileType.AUDIO));
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    private int getRuntimeFromDvdFiles() {
        int rtifo = 0;
        MediaFile ifo = null;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo") || mf.getDuration() <= rtifo) continue;
            rtifo = mf.getDuration();
            ifo = mf;
        }
        if (ifo != null) {
            LOGGER.trace("Found longest IFO:{} duration:{}", (Object)ifo.getFilename(), (Object)this.runtime);
            String prefix = StrgUtils.substr(ifo.getFilename(), "(?i)^(VTS_\\d+).*");
            if (prefix.isEmpty()) {
                prefix = StrgUtils.substr(ifo.getFilename(), "(?i)^(HV\\d+)I.*");
            }
            if (!prefix.isEmpty()) {
                int rtvob = 0;
                for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!mf.getFilename().startsWith(prefix) || ifo.getFilename().equals(mf.getFilename())) continue;
                    LOGGER.trace("VOB:{} duration:{} accumulated:{}", new Object[]{mf.getFilename(), mf.getDuration(), rtvob += mf.getDuration()});
                }
                if (rtvob > rtifo) {
                    rtifo = rtvob;
                }
            } else {
                LOGGER.trace("TODO: bluray");
            }
        }
        return rtifo;
    }

    public int getRuntimeFromMediaFiles() {
        int runtime = 0;
        if (this.isDisc) {
            runtime = this.getRuntimeFromDvdFiles();
        }
        if (runtime < 10) {
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (mf.isMainDiscIdentifierFile() || mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo")) continue;
                runtime += mf.getDuration();
            }
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFiles() / 60;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @JsonIgnore
    public void setReleaseDate(Date newValue) {
        Date oldValue = this.releaseDate;
        this.releaseDate = newValue;
        this.firePropertyChange("releaseDate", oldValue, newValue);
        this.firePropertyChange("releaseDateAsString", oldValue, newValue);
    }

    public String getReleaseDateFormatted() {
        if (this.releaseDate == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.releaseDate);
    }

    public String getReleaseDateAsString() {
        if (this.releaseDate == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.releaseDate);
    }

    public void setReleaseDate(String dateAsString) {
        try {
            this.setReleaseDate(StrgUtils.parseDate(dateAsString));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    @Override
    public void saveToDb() {
        MovieModuleManager.getInstance().getMovieList().persistMovie(this);
    }

    @Override
    public void deleteFromDb() {
        MovieModuleManager.getInstance().getMovieList().removeMovieFromDb(this);
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
        if (MovieModuleManager.getInstance().getSettings().getMovieConnector() == MovieConnectors.MP) {
            this.writeNFO();
        }
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public int getTop250() {
        return this.top250;
    }

    public void setVideoIn3D(boolean newValue) {
        boolean oldValue = this.videoIn3D;
        this.videoIn3D = newValue;
        this.firePropertyChange("videoIn3D", oldValue, newValue);
    }

    @Override
    public boolean isVideoIn3D() {
        return this.videoIn3D || StringUtils.isNotBlank((CharSequence)this.getMainVideoFile().getVideo3DFormat());
    }

    public void setTop250(int newValue) {
        int oldValue = this.top250;
        this.top250 = newValue;
        this.firePropertyChange("top250", oldValue, newValue);
    }

    public void addToActors(Collection<Person> newActors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newActors)) {
            if (person == null || this.actors.contains(person)) continue;
            if (person.getType() != Person.Type.ACTOR) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.actors.addAll(newItems);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public void removeActors() {
        this.actors.clear();
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        this.mergePersons(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public void addToProducers(Collection<Person> newProducers) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newProducers)) {
            if (person == null || this.producers.contains(person)) continue;
            if (person.getType() != Person.Type.PRODUCER) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.producers.addAll(newItems);
        this.firePropertyChange("producers", null, this.producers);
    }

    public void removeProducers() {
        this.producers.clear();
        this.firePropertyChange("producers", null, this.producers);
    }

    @JsonSetter
    public void setProducers(List<Person> newProducers) {
        this.mergePersons(this.producers, newProducers);
        this.firePropertyChange("producers", null, this.producers);
    }

    public List<Person> getProducers() {
        return this.producers;
    }

    public void addToDirectors(Collection<Person> newDirectors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newDirectors)) {
            if (person == null || this.directors.contains(person)) continue;
            if (person.getType() != Person.Type.DIRECTOR) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.directors.addAll(newItems);
        this.firePropertyChange("directors", null, this.directors);
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public void removeDirectors() {
        this.directors.clear();
        this.firePropertyChange("directors", null, this.directors);
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    @JsonSetter
    public void setDirectors(List<Person> newDirectors) {
        this.mergePersons(this.directors, newDirectors);
        this.firePropertyChange("directors", null, this.directors);
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public List<Person> getDirectors() {
        return this.directors;
    }

    public String getDirectorsAsString() {
        ArrayList<String> directorNames = new ArrayList<String>();
        for (Person director : this.directors) {
            directorNames.add(director.getName());
        }
        return StringUtils.join(directorNames, (String)", ");
    }

    public void addToWriters(Collection<Person> newWriters) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newWriters)) {
            if (person == null || this.writers.contains(person)) continue;
            if (person.getType() != Person.Type.WRITER) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.writers.addAll(newItems);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public void removeWriters() {
        this.writers.clear();
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    @JsonSetter
    public void setWriters(List<Person> newWriters) {
        this.mergePersons(this.writers, newWriters);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public List<Person> getWriters() {
        return this.writers;
    }

    public String getWritersAsString() {
        ArrayList<String> writerNames = new ArrayList<String>();
        for (Person writer : this.writers) {
            writerNames.add(writer.getName());
        }
        return StringUtils.join(writerNames, (String)", ");
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public void reEvaluateDiscfolder() {
        boolean disc = false;
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isDiscFile()) continue;
            disc = true;
        }
        this.setDisc(disc);
    }

    public void reEvaluateStacking() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs.size() > 1 && !this.isDisc()) {
            this.setStacked(true);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.detectStackingInformation();
            }
        } else {
            this.setStacked(false);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.removeStackingInformation();
            }
        }
    }

    public boolean deleteFilesSafely() {
        if (this.isMultiMovieDir()) {
            boolean ok = true;
            for (MediaFile mf : this.getMediaFiles()) {
                if (mf.deleteSafely(this.getDataSource())) continue;
                ok = false;
            }
            try {
                Utils.deleteEmptyDirectoryRecursive(this.getPathNIO());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ok;
        }
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainVideoFile() {
        MediaFile vid = new MediaFile();
        if (this.stacked) {
            vid = this.getMediaFiles(MediaFileType.VIDEO).stream().min(Comparator.comparingInt(MediaFile::getStacking)).orElse(new MediaFile());
        } else if (this.isDisc()) {
            vid = this.getMainDVDVideoFile();
        }
        if (vid == null || vid.getFilename().isEmpty()) {
            vid = this.getBiggestMediaFile(MediaFileType.VIDEO);
        }
        if (vid != null) {
            return vid;
        }
        LOGGER.warn("Movie without video file? {}", (Object)this.getPathNIO());
        return new MediaFile();
    }

    public MediaFile getMainDVDVideoFile() {
        MediaFile vid = null;
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mediaFile.getExtension().equalsIgnoreCase("ifo") || vid != null && mediaFile.getDuration() <= vid.getDuration()) continue;
            vid = mediaFile;
        }
        if (vid != null) {
            String prefix = StrgUtils.substr(vid.getFilename(), "(?i)^(VTS_\\d+).*");
            if (prefix.isEmpty()) {
                prefix = StrgUtils.substr(vid.getFilename(), "(?i)^(HV\\d+)I.*");
            }
            for (MediaFile mif : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (!mif.getFilename().startsWith(prefix) || mif.getFilename().endsWith("IFO")) continue;
                vid = mif;
            }
        }
        if (vid == null) {
            for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (!mediaFile.getExtension().equalsIgnoreCase("m2ts") || vid != null && mediaFile.getDuration() <= vid.getDuration()) continue;
                vid = mediaFile;
            }
        }
        return vid;
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return this.getMainVideoFile().getVideoResolution();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return this.getMainVideoFile().getVideoFormat();
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return this.getMainVideoFile().getVideoCodec();
    }

    @Override
    public double getMediaInfoFrameRate() {
        return this.getMainVideoFile().getFrameRate();
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return this.getMainVideoFile().getAspectRatio().floatValue();
    }

    public String getMediaInfoAspectRatioAsString() {
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        return df.format(this.getMainVideoFile().getAspectRatio()).replaceAll("\\.", "");
    }

    @Override
    public Float getMediaInfoAspectRatio2() {
        return this.getMainVideoFile().getAspectRatio2();
    }

    public String getMediaInfoAspectRatio2AsString() {
        Float aspectRatio2 = this.getMediaInfoAspectRatio2();
        String ar2AsString = "";
        if (aspectRatio2 != null) {
            DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            ar2AsString = df.format(this.getMainVideoFile().getAspectRatio2()).replaceAll("\\.", "");
        }
        return ar2AsString;
    }

    public boolean isMultiFormat() {
        return this.getMainVideoFile().getAspectRatio2() != null;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return this.getMainVideoFile().getAudioCodec();
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        ArrayList<String> lang = new ArrayList<String>();
        lang.addAll(this.getMainVideoFile().getAudioCodecList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioCodecList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return this.getMainVideoFile().getAudioChannels();
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        ArrayList<String> lang = new ArrayList<String>();
        lang.addAll(this.getMainVideoFile().getAudioChannelsList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioChannelsList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return this.getMainVideoFile().getAudioLanguage();
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getAudioLanguagesList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioLanguagesList());
        }
        return lang;
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getSubtitleLanguagesList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.SUBTITLE)) {
            lang.addAll(mf.getSubtitleLanguagesList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return this.getMainVideoFile().getContainerFormat();
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return this.getMediaSource();
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            filesize += mf.getFilesize();
        }
        return filesize;
    }

    public String getVideo3DFormat() {
        MediaFile mediaFile = this.getMainVideoFile();
        if (StringUtils.isNotBlank((CharSequence)mediaFile.getVideo3DFormat())) {
            return mediaFile.getVideo3DFormat();
        }
        if (this.isVideoIn3D()) {
            return "3D";
        }
        return "";
    }

    @Override
    public String getVideoHDRFormat() {
        return this.getMainVideoFile().getHdrFormat();
    }

    public Boolean isVideoInHDR() {
        return StringUtils.isNotEmpty((CharSequence)this.getMainVideoFile().getHdrFormat());
    }

    public String getVideoHDR() {
        return this.isVideoInHDR() != false ? "HDR" : "";
    }

    public MovieEdition getEdition() {
        return this.edition;
    }

    public String getEditionAsString() {
        return this.edition.toString();
    }

    public void setOffline(boolean newValue) {
        boolean oldValue = this.offline;
        this.offline = newValue;
        this.firePropertyChange("offline", oldValue, newValue);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setEdition(MovieEdition newValue) {
        MovieEdition oldValue = this.edition;
        this.edition = newValue;
        this.firePropertyChange("edition", oldValue, newValue);
        this.firePropertyChange("editionAsString", oldValue, newValue);
    }

    @Override
    public void removeFromMediaFiles(MediaFile mediaFile) {
        super.removeFromMediaFiles(mediaFile);
        boolean dirty = false;
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            for (int i = this.trailer.size() - 1; i >= 0; --i) {
                MediaTrailer mediaTrailer = this.trailer.get(i);
                if (!mediaTrailer.getUrl().equals(mediaFile.getFileAsPath().toUri().toString())) continue;
                this.trailer.remove(mediaTrailer);
                dirty = true;
            }
        }
        if (dirty) {
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        switch (mediaFile.getType()) {
            case TRAILER: {
                this.firePropertyChange("trailer", false, true);
                break;
            }
            case SUBTITLE: {
                this.firePropertyChange("hasSubtitle", false, true);
                break;
            }
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        switch (mediaFile.getType()) {
            case TRAILER: {
                this.firePropertyChange("trailer", true, false);
                break;
            }
            case SUBTITLE: {
                this.firePropertyChange("hasSubtitle", true, false);
                break;
            }
        }
    }

    private void mixinLocalTrailers() {
        for (int i = this.trailer.size() - 1; i >= 0; --i) {
            MediaTrailer mediaTrailer = this.trailer.get(i);
            if (!"downloaded".equalsIgnoreCase(mediaTrailer.getProvider())) continue;
            this.trailer.remove(i);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.TRAILER)) {
            LOGGER.debug("adding local trailer {}", (Object)mf.getFilename());
            MediaTrailer mt = new MediaTrailer();
            mt.setName(mf.getFilename());
            mt.setProvider("downloaded");
            mt.setQuality(mf.getVideoFormat());
            mt.setInNfo(false);
            mt.setUrl(mf.getFile().toUri().toString());
            this.trailer.add(0, mt);
            this.firePropertyChange("trailer", null, this.trailer);
        }
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
        super.callbackForGatheredMediainformation(mediaFile);
        if (mediaFile.getType() == MediaFileType.VIDEO && MovieModuleManager.getInstance().getSettings().isUseMediainfoMetadata() && !this.isScraped() && !mediaFile.getExtraData().isEmpty()) {
            String genre;
            String plot;
            String year;
            String originalTitle;
            boolean dirty = false;
            String title = mediaFile.getExtraData().get("title");
            if (StringUtils.isNotBlank((CharSequence)title)) {
                this.setTitle(title);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(originalTitle = mediaFile.getExtraData().get("originalTitle")))) {
                this.setOriginalTitle(originalTitle);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(year = mediaFile.getExtraData().get("year")))) {
                try {
                    int y = Integer.parseInt(year);
                    if (y > 1900 && y < 2100) {
                        this.setYear(y);
                    }
                }
                catch (Exception y) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(plot = mediaFile.getExtraData().get("plot")))) {
                this.setPlot(plot);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(genre = mediaFile.getExtraData().get("genre")))) {
                ArrayList<MediaGenres> genres = new ArrayList<MediaGenres>();
                for (String part : ParserUtils.split(genre)) {
                    genres.add(MediaGenres.getGenre(part));
                }
                this.addToGenres(genres);
            }
            if (dirty) {
                this.saveToDb();
            }
        }
        if (mediaFile.getType() == MediaFileType.TRAILER) {
            this.mixinLocalTrailers();
        }
    }

    public Object getValueForMetadata(MovieScraperMetadataConfig metadataConfig) {
        switch (metadataConfig) {
            case ID: {
                return this.getIds();
            }
            case TITLE: {
                return this.getTitle();
            }
            case ORIGINAL_TITLE: {
                return this.getOriginalTitle();
            }
            case TAGLINE: {
                return this.getTagline();
            }
            case PLOT: {
                return this.getPlot();
            }
            case YEAR: {
                return this.getYear();
            }
            case RELEASE_DATE: {
                return this.getReleaseDate();
            }
            case RATING: {
                return this.getRatings();
            }
            case TOP250: {
                return this.getTop250();
            }
            case RUNTIME: {
                return this.getRuntime();
            }
            case CERTIFICATION: {
                return this.getCertification();
            }
            case GENRES: {
                return this.getGenres();
            }
            case SPOKEN_LANGUAGES: {
                return this.getSpokenLanguages();
            }
            case COUNTRY: {
                return this.getCountry();
            }
            case PRODUCTION_COMPANY: {
                return this.getProductionCompany();
            }
            case TAGS: {
                return this.getTags();
            }
            case COLLECTION: {
                return this.getMovieSet();
            }
            case TRAILER: {
                return this.getMediaFiles(MediaFileType.TRAILER);
            }
            case ACTORS: {
                return this.getActors();
            }
            case PRODUCERS: {
                return this.getProducers();
            }
            case DIRECTORS: {
                return this.getDirectors();
            }
            case WRITERS: {
                return this.getWriters();
            }
            case POSTER: {
                return this.getMediaFiles(MediaFileType.POSTER);
            }
            case FANART: {
                return this.getMediaFiles(MediaFileType.FANART);
            }
            case BANNER: {
                return this.getMediaFiles(MediaFileType.BANNER);
            }
            case CLEARART: {
                return this.getMediaFiles(MediaFileType.CLEARART);
            }
            case THUMB: {
                return this.getMediaFiles(MediaFileType.THUMB);
            }
            case LOGO: {
                return this.getMediaFiles(MediaFileType.LOGO);
            }
            case CLEARLOGO: {
                return this.getMediaFiles(MediaFileType.CLEARLOGO);
            }
            case DISCART: {
                return this.getMediaFiles(MediaFileType.DISC);
            }
            case KEYART: {
                return this.getMediaFiles(MediaFileType.KEYART);
            }
            case EXTRAFANART: {
                return this.getMediaFiles(MediaFileType.EXTRAFANART);
            }
            case EXTRATHUMB: {
                return this.getMediaFiles(MediaFileType.EXTRATHUMB);
            }
        }
        return null;
    }

    protected void postProcess(List<MovieScraperMetadataConfig> config) {
        TmmTaskChain taskChain = new TmmTaskChain();
        if (MovieModuleManager.getInstance().getSettings().isArdAfterScrape()) {
            taskChain.add(new MovieARDetectorTask(Collections.singletonList(this)));
        }
        if (MovieModuleManager.getInstance().getSettings().isRenameAfterScrape()) {
            taskChain.add(new MovieRenameTask(Collections.singletonList(this)));
            List<MediaFile> imageFiles = this.getImagesToCache();
            if (!imageFiles.isEmpty()) {
                taskChain.add(new ImageCacheTask(imageFiles));
            }
        }
        if (ScraperMetadataConfig.containsAnyCast(config) && MovieModuleManager.getInstance().getSettings().isWriteActorImages() && !this.isMultiMovieDir()) {
            taskChain.add(new TmmTask(TmmResourceBundle.getString("movie.downloadactorimages"), 1, TmmTaskHandle.TaskType.BACKGROUND_TASK){

                @Override
                protected void doInBackground() {
                    Movie.this.writeActorImages();
                }
            });
        }
        taskChain.run();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Movie movie = (Movie)o;
        return this.path.equals(movie.path) && this.getMainFile().getFile().equals(movie.getMainFile().getFile());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).append((Object)this.getMainFile().getFile()).build();
    }
}

