/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.filenaming;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.IFileNaming;

public enum MoviePosterNaming implements IFileNaming
{
    FILENAME{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "." + extension : "";
        }
    }
    ,
    FILENAME_POSTER{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-poster." + extension : "";
        }
    }
    ,
    MOVIE{

        @Override
        public String getFilename(String basename, String extension) {
            return "movie." + extension;
        }
    }
    ,
    POSTER{

        @Override
        public String getFilename(String basename, String extension) {
            return "poster." + extension;
        }
    }
    ,
    FOLDER{

        @Override
        public String getFilename(String basename, String extension) {
            return "folder." + extension;
        }
    }
    ,
    COVER{

        @Override
        public String getFilename(String basename, String extension) {
            return "cover." + extension;
        }
    };

}

