/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.filenaming;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;

public enum MovieSetThumbNaming implements IMovieSetFileNaming
{
    MOVIE_THUMB{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-thumb." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    MOVIE_LANDSCAPE{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-landscape." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    KODI_THUMB{

        @Override
        public String getFilename(String basename, String extension) {
            return "thumb." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    KODI_LANDSCAPE{

        @Override
        public String getFilename(String basename, String extension) {
            return "landscape." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_THUMB{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-thumb." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_LANDSCAPE{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-landscape." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    };

}

