/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class MovieRenameTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenameTask.class);
    private final List<Movie> moviesToRename;

    public MovieRenameTask(List<Movie> moviesToRename) {
        super(TmmResourceBundle.getString("movie.rename"));
        this.moviesToRename = new ArrayList<Movie>(moviesToRename);
    }

    @Override
    protected void doInBackground() {
        try {
            this.initThreadPool(1, "rename");
            this.start();
            ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
            for (Movie movie : this.moviesToRename) {
                if (this.cancel) break;
                this.submitTask(new RenameMovieTask(movie));
                imageFiles.addAll(movie.getMediaFiles().stream().filter(MediaFile::isGraphic).collect(Collectors.toList()));
            }
            this.waitForCompletionOrCancel();
            if (this.cancel) {
                return;
            }
            if (Settings.getInstance().isImageCache() && !imageFiles.isEmpty()) {
                ImageCacheTask task = new ImageCacheTask(imageFiles);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            LOGGER.info("Done renaming movies)");
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "Settings.renamer", "message.renamer.threadcrashed"));
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private static class RenameMovieTask
    implements Callable<Object> {
        private final Movie movie;

        private RenameMovieTask(Movie movie) {
            this.movie = movie;
        }

        @Override
        public String call() {
            MovieRenamer.renameMovie(this.movie);
            return this.movie.getTitle();
        }
    }
}

