/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieScrapeTask.class);
    private final MovieScrapeParams movieScrapeParams;
    private final List<Movie> smartScrapeList;

    public MovieScrapeTask(MovieScrapeParams movieScrapeParams) {
        super(TmmResourceBundle.getString("movie.scraping"));
        this.movieScrapeParams = movieScrapeParams;
        this.smartScrapeList = new ArrayList<Movie>(0);
    }

    @Override
    protected void doInBackground() {
        MediaScraper mediaMetadataScraper = this.movieScrapeParams.searchAndScrapeOptions.getMetadataScraper();
        if (!mediaMetadataScraper.isEnabled()) {
            return;
        }
        this.initThreadPool(3, "scrape");
        this.start();
        for (Movie movie : this.movieScrapeParams.moviesToScrape) {
            this.submitTask(new Worker(movie));
        }
        this.waitForCompletionOrCancel();
        if (!this.smartScrapeList.isEmpty() && !GraphicsEnvironment.isHeadless()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    int selectedCount = this.smartScrapeList.size();
                    int index = 0;
                    do {
                        Movie movie = this.smartScrapeList.get(index);
                        MovieChooserDialog dialogMovieChooser = new MovieChooserDialog(movie, index, selectedCount);
                        dialogMovieChooser.setVisible(true);
                        if (!dialogMovieChooser.isContinueQueue()) break;
                        if (dialogMovieChooser.isNavigateBack()) {
                            --index;
                            continue;
                        }
                        ++index;
                    } while (index < selectedCount);
                });
            }
            catch (Exception e) {
                LOGGER.error("SmartScrape crashed: {}", (Object)e.getMessage());
            }
        }
        if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
            MovieSyncTraktTvTask task = new MovieSyncTraktTvTask(this.movieScrapeParams.moviesToScrape);
            task.setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
            task.setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
            task.setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.info("Done scraping movies)");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public static class MovieScrapeParams {
        private final List<Movie> moviesToScrape;
        private final List<MovieScraperMetadataConfig> scraperMetadataConfig;
        private final MovieSearchAndScrapeOptions searchAndScrapeOptions;
        private boolean doSearch;
        private boolean overwriteExistingItems;

        public MovieScrapeParams(List<Movie> moviesToScrape, MovieSearchAndScrapeOptions searchAndScrapeOptions, List<MovieScraperMetadataConfig> scraperMetadataConfig) {
            this.moviesToScrape = new ArrayList<Movie>(moviesToScrape);
            this.searchAndScrapeOptions = searchAndScrapeOptions;
            this.scraperMetadataConfig = new ArrayList<MovieScraperMetadataConfig>(scraperMetadataConfig);
            this.doSearch = true;
            this.overwriteExistingItems = true;
        }

        public MovieScrapeParams setDoSearch(boolean doSearch) {
            this.doSearch = doSearch;
            return this;
        }

        public MovieScrapeParams setOverwriteExistingItems(boolean overwriteExistingItems) {
            this.overwriteExistingItems = overwriteExistingItems;
            return this;
        }
    }

    private class Worker
    implements Runnable {
        private MovieList movieList;
        private final Movie movie;

        public Worker(Movie movie) {
            this.movie = movie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    this.movieList = MovieModuleManager.getInstance().getMovieList();
                    MediaScraper mediaMetadataScraper = MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getMetadataScraper();
                    List<MediaScraper> artworkScrapers = MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getArtworkScrapers();
                    List<MediaScraper> trailerScrapers = MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getTrailerScrapers();
                    MediaSearchResult result1 = null;
                    if (MovieScrapeTask.this.movieScrapeParams.doSearch && (result1 = this.searchForMovie(mediaMetadataScraper)) == null) {
                        List<Movie> list = MovieScrapeTask.this.smartScrapeList;
                        synchronized (list) {
                            MovieScrapeTask.this.smartScrapeList.add(this.movie);
                            return;
                        }
                    }
                    if ((!MovieScrapeTask.this.movieScrapeParams.doSearch || result1 == null) && MovieScrapeTask.this.movieScrapeParams.doSearch) break block14;
                    MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions);
                    options.setSearchResult(result1);
                    if (MovieScrapeTask.this.movieScrapeParams.doSearch) {
                        options.setIds(result1.getIds());
                        mediaMetadataScraper = this.movieList.getMediaScraperById(result1.getProviderId());
                    } else {
                        options.setIds(this.movie.getIds());
                    }
                    MediaMetadata md = null;
                    if (mediaMetadataScraper == null || mediaMetadataScraper.getMediaProvider() == null) break block14;
                    LOGGER.info("=====================================================");
                    LOGGER.info("Scraper metadata with scraper: " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getId() + ", " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getVersion());
                    LOGGER.info(options.toString());
                    LOGGER.info("=====================================================");
                    try {
                        md = ((IMovieMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                    }
                    catch (MissingIdException e) {
                        LOGGER.warn("missing id for scrape");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "scraper.error.missingid"));
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("searchMovieFallback", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.scrape.metadatamoviefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    if (md != null && (ScraperMetadataConfig.containsAnyMetadata(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig) || ScraperMetadataConfig.containsAnyCast(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig))) {
                        this.movie.setMetadata(md, MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig, MovieScrapeTask.this.movieScrapeParams.overwriteExistingItems);
                        this.movie.setLastScraperId(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getMetadataScraper().getId());
                        this.movie.setLastScrapeLanguage(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions.getLanguage().name());
                    }
                    if (ScraperMetadataConfig.containsAnyArtwork(MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig)) {
                        this.movie.setArtwork(this.getArtwork(this.movie, md, artworkScrapers), MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig, MovieScrapeTask.this.movieScrapeParams.overwriteExistingItems);
                    }
                    if (MovieScrapeTask.this.movieScrapeParams.scraperMetadataConfig.contains(MovieScraperMetadataConfig.TRAILER)) {
                        this.movie.setTrailers(this.getTrailers(this.movie, md, trailerScrapers));
                        this.movie.saveToDb();
                        this.movie.writeNFO();
                        MovieHelpers.startAutomaticTrailerDownload(this.movie);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        private MediaSearchResult searchForMovie(MediaScraper mediaMetadataProvider) throws ScrapeException {
            List<MediaSearchResult> results = this.movieList.searchMovie(this.movie.getTitle(), this.movie.getYear(), this.movie.getIds(), mediaMetadataProvider);
            MediaSearchResult result = null;
            if (ListUtils.isNotEmpty(results)) {
                result = results.get(0);
                if (results.size() > 1) {
                    MediaSearchResult result2 = results.get(1);
                    if (result.getScore() == result2.getScore()) {
                        LOGGER.info("two identical results, can't decide which to take - ignore result");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.toosimilar"));
                        return null;
                    }
                }
                double scraperTreshold = MovieModuleManager.getInstance().getSettings().getScraperThreshold();
                LOGGER.info("using treshold from settings of {}", (Object)scraperTreshold);
                if ((double)result.getScore() < scraperTreshold) {
                    LOGGER.info("score is lower than {} ({}) - ignore result", (Object)scraperTreshold, (Object)Float.valueOf(result.getScore()));
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "movie.scrape.toolowscore", new String[]{String.format("%.2f", scraperTreshold)}));
                    return null;
                }
            } else {
                LOGGER.info("no result found for {}", (Object)this.movie.getTitle());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "movie.scrape.nomatchfound"));
            }
            return result;
        }

        private List<MediaArtwork> getArtwork(Movie movie, MediaMetadata metadata, List<MediaScraper> artworkScrapers) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE);
            options.setDataFromOtherOptions(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            if (metadata != null) {
                options.setIds(metadata.getIds());
            }
            options.setId("mediaFile", movie.getMainFile());
            options.setLanguage(MovieModuleManager.getInstance().getSettings().getImageScraperLanguage());
            options.setFanartSize(MovieModuleManager.getInstance().getSettings().getImageFanartSize());
            options.setPosterSize(MovieModuleManager.getInstance().getSettings().getImagePosterSize());
            for (MediaScraper scraper : artworkScrapers) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (MissingIdException missingIdException) {
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            return artwork;
        }

        private List<MediaTrailer> getTrailers(Movie movie, MediaMetadata metadata, List<MediaScraper> trailerScrapers) {
            ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.MOVIE);
            options.setDataFromOtherOptions(MovieScrapeTask.this.movieScrapeParams.searchAndScrapeOptions);
            options.setMetadata(metadata);
            if (metadata != null) {
                options.setIds(metadata.getIds());
            }
            for (MediaScraper trailerScraper : trailerScrapers) {
                try {
                    IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                    trailers.addAll(trailerProvider.getTrailers(options));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("no usable ID found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            return trailers;
        }
    }
}

