/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.connector.MovieSetNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.thirdparty.trakttv.MovieSyncTraktTvTask;

public class MovieUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpdateDatasourceTask.class);
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private static long preDirAll = 0L;
    private static long postDirAll = 0L;
    private static long visFileAll = 0L;
    private static final List<String> SKIP_FOLDERS = Arrays.asList(".", "..", "CERTIFICATE", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR", "ADV_OBJ", "PLEX VERSIONS");
    private static final String SKIP_REGEX = "(?i)^[.@](?!45|buelos)[\\w@]+.*";
    private static final Pattern VIDEO_3D_PATTERN = Pattern.compile("(?i)[ ._\\(\\[-]3D[ ._\\)\\]-]?");
    private final List<String> dataSources;
    private final List<Pattern> skipFolders;
    private final List<Movie> moviesToUpdate = new ArrayList<Movie>();
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final Set<Path> filesFound = ConcurrentHashMap.newKeySet();
    private final List<Runnable> miTasks = Collections.synchronizedList(new ArrayList());
    private final List<Path> existingMovies = new ArrayList<Path>();
    private final List<MediaFile> imageFiles = new ArrayList<MediaFile>();

    public MovieUpdateDatasourceTask() {
        super(TmmResourceBundle.getString("update.datasource"));
        this.dataSources = new ArrayList<String>(MovieModuleManager.getInstance().getSettings().getMovieDataSource());
        this.skipFolders = new ArrayList<Pattern>();
        this.init();
    }

    public MovieUpdateDatasourceTask(String datasource) {
        super(TmmResourceBundle.getString("update.datasource") + " (" + datasource + ")");
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
        this.skipFolders = new ArrayList<Pattern>();
        this.init();
    }

    public MovieUpdateDatasourceTask(List<Movie> movies) {
        super(TmmResourceBundle.getString("update.datasource"));
        this.dataSources = new ArrayList<String>(0);
        this.moviesToUpdate.addAll(movies);
        this.skipFolders = new ArrayList<Pattern>();
        this.init();
    }

    private void init() {
        for (String skipFolder : MovieModuleManager.getInstance().getSettings().getSkipFolder()) {
            try {
                Pattern pattern = Pattern.compile(skipFolder);
                this.skipFolders.add(pattern);
            }
            catch (Exception e) {
                try {
                    LOGGER.debug("no valid skip pattern - '{}'", (Object)skipFolder);
                    Pattern pattern = Pattern.compile(Pattern.quote(skipFolder));
                    this.skipFolders.add(pattern);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.moviesToUpdate.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        preDir = 0L;
        postDir = 0L;
        visFile = 0L;
        preDirAll = 0L;
        postDirAll = 0L;
        visFileAll = 0L;
        for (Movie movie : this.movieList.getMovies()) {
            this.existingMovies.add(movie.getPathNIO());
        }
        try {
            TmmTask task;
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.updateMovieSets();
            if (this.moviesToUpdate.isEmpty()) {
                this.updateDatasource();
            } else {
                this.updateMovies();
            }
            if (!this.imageFiles.isEmpty()) {
                task = new ImageCacheTask(this.imageFiles);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            if (MovieModuleManager.getInstance().getSettings().getSyncTrakt()) {
                task = new MovieSyncTraktTvTask(MovieModuleManager.getInstance().getMovieList().getMovies());
                ((MovieSyncTraktTvTask)task).setSyncCollection(MovieModuleManager.getInstance().getSettings().getSyncTraktCollection());
                ((MovieSyncTraktTvTask)task).setSyncWatched(MovieModuleManager.getInstance().getSettings().getSyncTraktWatched());
                ((MovieSyncTraktTvTask)task).setSyncRating(MovieModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took {}", (Object)stopWatch);
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void updateDatasource() {
        for (String ds : this.dataSources) {
            if (this.isInSkipFolder(Paths.get(ds, new String[0]))) {
                LOGGER.debug("datasource '{}' is also a skipfolder - skipping", (Object)ds);
                continue;
            }
            LOGGER.info("Start UDS on datasource: {}", (Object)ds);
            this.miTasks.clear();
            this.initThreadPool(3, "update");
            this.setTaskName(TmmResourceBundle.getString("update.datasource") + " '" + ds + "'");
            this.publishState();
            Path dsAsPath = Paths.get(ds, new String[0]);
            if (!Files.exists(dsAsPath, new LinkOption[0])) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                continue;
            }
            this.publishState();
            ArrayList<Path> newMovieDirs = new ArrayList<Path>();
            ArrayList<Path> existingMovieDirs = new ArrayList<Path>();
            List<Path> rootList = this.listFilesAndDirs(dsAsPath);
            if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                continue;
            }
            ArrayList<Path> rootFiles = new ArrayList<Path>();
            for (Path path : rootList) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (this.existingMovies.contains(path)) {
                        existingMovieDirs.add(path);
                        continue;
                    }
                    newMovieDirs.add(path);
                    continue;
                }
                rootFiles.add(path);
            }
            rootList.clear();
            this.publishState();
            for (Path path : newMovieDirs) {
                this.searchAndParse(dsAsPath.toAbsolutePath(), path, Integer.MAX_VALUE);
            }
            for (Path path : existingMovieDirs) {
                this.searchAndParse(dsAsPath.toAbsolutePath(), path, Integer.MAX_VALUE);
            }
            if (!rootFiles.isEmpty()) {
                this.submitTask(new ParseMultiMovieDirTask(dsAsPath.toAbsolutePath(), dsAsPath.toAbsolutePath(), rootFiles));
            }
            this.waitForCompletionOrCancel();
            LOGGER.info("FilesFound: {}", (Object)this.filesFound.size());
            LOGGER.info("moviesFound: {}", (Object)this.movieList.getMovieCount());
            LOGGER.debug("PreDir: {}", (Object)preDir);
            LOGGER.debug("PostDir: {}", (Object)postDir);
            LOGGER.debug("VisFile: {}", (Object)visFile);
            LOGGER.debug("PreDirAll: {}", (Object)preDirAll);
            LOGGER.debug("PostDirAll: {}", (Object)postDirAll);
            LOGGER.debug("VisFileAll: {}", (Object)visFileAll);
            newMovieDirs.clear();
            existingMovieDirs.clear();
            rootFiles.clear();
            if (this.cancel) break;
            this.cleanup(ds);
            if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                KodiRPC.getInstance().updateMovieMappings();
            }
            this.gatherMediainfo(ds);
            if (this.cancel) break;
            if (!Settings.getInstance().isImageCache() || !MovieModuleManager.getInstance().getSettings().isBuildImageCacheOnImport()) continue;
            for (Movie movie : this.movieList.getMovies()) {
                if (!dsAsPath.equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
                this.imageFiles.addAll(movie.getImagesToCache());
            }
        }
    }

    private void updateMovieSets() {
        if (StringUtils.isBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder())) {
            return;
        }
        LOGGER.info("Start UDS for movie sets");
        Set<Path> movieSetFiles = this.getAllFilesRecursive(Paths.get(MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder(), new String[0]));
        for (Path path : movieSetFiles) {
            if (!FilenameUtils.isExtension((String)path.getFileName().toString(), (String)"nfo")) continue;
            try {
                MovieSetNfoParser nfoParser = MovieSetNfoParser.parseNfo(path);
                MovieSet movieSet = nfoParser.toMovieSet();
                MovieSet movieSetInDb = this.matchMovieSetInDb(path, movieSet);
                if (movieSetInDb != null) {
                    movieSetInDb.addToMediaFiles(new MediaFile(path));
                    continue;
                }
                movieSet.addToMediaFiles(new MediaFile(path));
                MovieModuleManager.getInstance().getMovieList().addMovieSet(movieSet);
            }
            catch (Exception e) {
                LOGGER.debug("Could not parse movie set NFO '{}' - '{}'", (Object)path.getFileName(), (Object)e.getMessage());
            }
        }
    }

    private MovieSet matchMovieSetInDb(Path nfoFile, MovieSet movieSetFromNfo) {
        List<MovieSet> existingMovieSets = MovieModuleManager.getInstance().getMovieList().getMovieSetList();
        MediaFile foundNfo = new MediaFile(nfoFile);
        for (MovieSet movieSetInDb : existingMovieSets) {
            List<MediaFile> nfos = movieSetInDb.getMediaFiles(MediaFileType.NFO);
            if (!nfos.contains(foundNfo)) continue;
            return movieSetInDb;
        }
        int tmdbId = movieSetFromNfo.getTmdbId();
        if (tmdbId > 0) {
            for (MovieSet movieSetInDb : existingMovieSets) {
                int id = movieSetInDb.getTmdbId();
                if (id != tmdbId) continue;
                return movieSetInDb;
            }
        }
        for (MovieSet movieSetInDb : existingMovieSets) {
            if (!movieSetFromNfo.getTitle().equals(movieSetInDb.getTitle())) continue;
            return movieSetInDb;
        }
        return null;
    }

    private void updateMovies() {
        LOGGER.info("Start UDS for selected movies");
        this.initThreadPool(3, "update");
        this.setTaskName(TmmResourceBundle.getString("update.datasource"));
        this.publishState();
        HashSet movieDatasources = new HashSet();
        this.moviesToUpdate.forEach(movie -> movieDatasources.add(movie.getDataSource()));
        ArrayList<Movie> moviesToCleanup = new ArrayList<Movie>();
        for (String ds : movieDatasources) {
            Path dsAsPath = Paths.get(ds, new String[0]);
            if (!Files.exists(dsAsPath, new LinkOption[0])) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                continue;
            }
            List<Path> rootList = this.listFilesAndDirs(dsAsPath);
            if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                continue;
            }
            LinkedHashSet<Path> movieDirs = new LinkedHashSet<Path>();
            for (Movie movie2 : this.moviesToUpdate) {
                if (!movie2.getDataSource().equals(ds)) continue;
                movieDirs.add(movie2.getPathNIO());
                moviesToCleanup.add(movie2);
            }
            for (Path path : movieDirs) {
                this.submitTask(new FindMovieTask(path, Paths.get(ds, new String[0])));
            }
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("FilesFound: {}", (Object)this.filesFound.size());
        LOGGER.info("moviesFound: {}", (Object)this.movieList.getMovieCount());
        LOGGER.debug("PreDir: {}", (Object)preDir);
        LOGGER.debug("PostDir: {}", (Object)postDir);
        LOGGER.debug("VisFile: {}", (Object)visFile);
        LOGGER.debug("PreDirAll: {}", (Object)preDirAll);
        LOGGER.debug("PostDirAll: {}", (Object)postDirAll);
        LOGGER.debug("VisFileAll: {}", (Object)visFileAll);
        this.cleanup(moviesToCleanup);
        this.gatherMediainfo(moviesToCleanup);
    }

    private void parseMovieDirectory(Path movieDir, Path dataSource) {
        List<Path> movieDirList = this.listFilesAndDirs(movieDir);
        ArrayList<Path> files = new ArrayList<Path>();
        HashSet<String> normalizedVideoFiles = new HashSet<String>();
        boolean isDiscFolder = false;
        boolean isMultiMovieDir = false;
        boolean videoFileFound = false;
        Path movieRoot = movieDir;
        for (Path path : movieDirList) {
            if (!Utils.isRegularFile(path)) continue;
            files.add(path.toAbsolutePath());
            MediaFile mf = new MediaFile();
            mf.setPath(path.getParent().toString());
            mf.setFilename(path.getFileName().toString());
            mf.setType(MediaFileHelper.parseMediaFileType(path, movieDir));
            if (mf.getType() != MediaFileType.VIDEO) continue;
            videoFileFound = true;
            if (mf.isDiscFile()) {
                isDiscFolder = true;
                break;
            }
            String basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
            normalizedVideoFiles.add(basename);
        }
        if (!videoFileFound) {
            return;
        }
        if (isDiscFolder) {
            Path relative = dataSource.relativize(movieDir);
            String folder = relative.toString().toUpperCase(Locale.ROOT);
            while (folder.contains("VIDEO_TS") || folder.contains("BDMV") || folder.contains("HVDVD_TS")) {
                movieDir = movieDir.getParent();
                relative = dataSource.relativize(movieDir);
                folder = relative.toString().toUpperCase(Locale.ROOT);
            }
            movieRoot = movieDir;
        } else {
            if (normalizedVideoFiles.isEmpty()) {
                return;
            }
            if (normalizedVideoFiles.size() > 1 || movieDir.equals(dataSource)) {
                isMultiMovieDir = true;
            }
        }
        if (this.cancel) {
            return;
        }
        if (isMultiMovieDir) {
            this.createMultiMovieFromDir(dataSource, movieRoot, files);
        } else {
            this.createSingleMovieFromDir(dataSource, movieRoot, isDiscFolder);
        }
    }

    public static Movie parseNFOs(List<MediaFile> mfs) {
        Movie movie = null;
        for (MediaFile mf : mfs) {
            if (!mf.getType().equals((Object)MediaFileType.NFO)) continue;
            LOGGER.info("| parsing NFO {}", (Object)mf.getFileAsPath());
            Movie nfo = null;
            try {
                MovieNfoParser movieNfoParser = MovieNfoParser.parseNfo(mf.getFileAsPath());
                nfo = movieNfoParser.toMovie();
            }
            catch (Exception e) {
                LOGGER.warn("problem parsing NFO: {}", (Object)e.getMessage());
            }
            if (movie == null) {
                movie = nfo == null ? new Movie() : nfo;
            } else {
                movie.merge(nfo);
            }
            if (!movie.getImdbId().isEmpty() && movie.getTmdbId() != 0) continue;
            try {
                String content = Utils.readFileToString(mf.getFileAsPath());
                String imdb = ParserUtils.detectImdbId(content);
                if (movie.getImdbId().isEmpty() && !imdb.isEmpty()) {
                    LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                    movie.setImdbId(imdb);
                }
                String tmdb = StrgUtils.substr(content, "themoviedb\\.org\\/movie\\/(\\d+)");
                if (movie.getTmdbId() != 0 || tmdb.isEmpty()) continue;
                LOGGER.debug("| Found TMDB id: {}", (Object)tmdb);
                movie.setTmdbId(MetadataUtil.parseInt(tmdb, 0));
            }
            catch (IOException e) {
                LOGGER.warn("| couldn't read NFO {}", (Object)mf);
            }
        }
        for (MediaFile mf : mfs) {
            if (!mf.getType().equals((Object)MediaFileType.VSMETA)) continue;
            if (movie == null) {
                movie = new Movie();
            }
            VSMeta vsmeta = new VSMeta(mf.getFileAsPath());
            vsmeta.parseFile();
            movie.merge(vsmeta.getMovie());
        }
        if (movie == null) {
            for (MediaFile mf : mfs) {
                if (!"xml".equalsIgnoreCase(mf.getExtension())) continue;
                try {
                    MovieNfoParser movieNfoParser = MovieNfoParser.parseNfo(mf.getFileAsPath());
                    if (!StringUtils.isNotBlank((CharSequence)movieNfoParser.title)) continue;
                    movie = movieNfoParser.toMovie();
                }
                catch (Exception exception) {}
            }
        }
        return movie;
    }

    private void createSingleMovieFromDir(Path dataSource, Path movieDir, boolean isDiscFolder) {
        boolean bl;
        List<MediaFile> vid;
        LOGGER.info("Parsing single movie directory: {}, (are we a disc folder? {})", (Object)movieDir, (Object)isDiscFolder);
        Path relative = dataSource.relativize(movieDir);
        if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(movieDir.getFileName().toString())) {
            movieDir = movieDir.getParent();
        }
        Movie movie = this.movieList.getMovieByPath(movieDir);
        Set<Path> allFiles = this.getAllFilesRecursive(movieDir);
        this.filesFound.add(movieDir.toAbsolutePath());
        this.filesFound.addAll(allFiles);
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        allFiles.clear();
        if (movie == null) {
            LOGGER.debug("| movie not found; looking for NFOs");
            movie = MovieUpdateDatasourceTask.parseNFOs(mfs);
            if (movie == null) {
                movie = new Movie();
            }
            movie.setNewlyAdded(true);
        }
        String bdinfoTitle = "";
        String videoName = "";
        for (MediaFile mediaFile : mfs) {
            if (mediaFile.getType().equals((Object)MediaFileType.TEXT)) {
                try {
                    String txtFile = Utils.readFileToString(mediaFile.getFileAsPath());
                    String bdinfo = StrgUtils.substr(txtFile, ".*Disc Title:\\s+(.*?)[\\n\\r]");
                    if (!bdinfo.isEmpty()) {
                        LOGGER.debug("| Found Disc Title in BDInfo.txt: {}", (Object)bdinfo);
                        bdinfoTitle = WordUtils.capitalizeFully((String)bdinfo);
                    }
                    String imdb = ParserUtils.detectImdbId(txtFile);
                    if (!movie.getImdbId().isEmpty() || imdb.isEmpty()) continue;
                    LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                    movie.setImdbId(imdb);
                }
                catch (Exception e) {
                    LOGGER.debug("| couldn't read TXT {}", (Object)mediaFile.getFilename());
                }
                continue;
            }
            if (!mediaFile.getType().equals((Object)MediaFileType.VIDEO)) continue;
            videoName = mediaFile.getBasename();
        }
        if (movie.getTitle().isEmpty()) {
            String[] video = ParserUtils.detectCleanTitleAndYear(movieDir.getFileName().toString(), MovieModuleManager.getInstance().getSettings().getBadWord());
            movie.setTitle(video[0]);
            if (!video[1].isEmpty()) {
                try {
                    movie.setYear(Integer.parseInt(video[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)movie.getTitle()) && StringUtils.isNotBlank((CharSequence)bdinfoTitle)) {
            movie.setTitle(bdinfoTitle);
        } else if (StringUtils.isBlank((CharSequence)movie.getTitle())) {
            movie.setTitle(videoName);
        }
        movie.setPath(movieDir.toAbsolutePath().toString());
        movie.setDataSource(dataSource.toString());
        for (MediaFile mediaFile : this.getMediaFiles(mfs, MediaFileType.UNKNOWN)) {
            for (MediaFile vid2 : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                if (!mediaFile.getFilename().startsWith(vid2.getFilename())) continue;
                mediaFile.setType(MediaFileType.DOUBLE_EXT);
            }
        }
        this.addMediafilesToMovie(movie, mfs);
        if (movie.getArtworkFilename(MediaFileType.POSTER).isEmpty()) {
            for (MediaFile mediaFile : mfs) {
                Object vfilename;
                if (!mediaFile.getType().equals((Object)MediaFileType.GRAPHIC)) continue;
                LOGGER.debug("| parsing unknown graphic: {}", (Object)mediaFile.getFilename());
                vid = movie.getMediaFiles(MediaFileType.VIDEO);
                if (vid == null || vid.isEmpty() || !FilenameUtils.getBaseName((String)(vfilename = ((MediaFile)vid.get(0)).getFilename())).equals(FilenameUtils.getBaseName((String)mediaFile.getFilename())) && !FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers((String)vfilename)).trim().equals(FilenameUtils.getBaseName((String)mediaFile.getFilename())) && !movie.getTitle().equals(FilenameUtils.getBaseName((String)mediaFile.getFilename()))) continue;
                mediaFile.setType(MediaFileType.POSTER);
                movie.addToMediaFiles(mediaFile);
            }
        }
        boolean videoRemoved = false;
        for (MediaFile mediaFile : movie.getMediaFiles()) {
            if (Files.exists(mediaFile.getFile(), LinkOption.NOFOLLOW_LINKS)) continue;
            if (mediaFile.getType() == MediaFileType.VIDEO) {
                videoRemoved = true;
            }
            movie.removeFromMediaFiles(mediaFile);
        }
        if (videoRemoved && !movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
            movie.setNewlyAdded(true);
        }
        if (movie.isNewlyAdded()) {
            Matcher matcher = VIDEO_3D_PATTERN.matcher(movieDir.getFileName().toString());
            if (matcher.find()) {
                movie.setVideoIn3D(true);
            }
            if ((vid = this.getMediaFile(mfs, MediaFileType.VIDEO)) != null) {
                Matcher matcher2 = VIDEO_3D_PATTERN.matcher(((MediaFile)((Object)vid)).getFilename());
                if (matcher2.find()) {
                    movie.setVideoIn3D(true);
                }
                if (StringUtils.isBlank((CharSequence)movie.getOriginalFilename())) {
                    movie.setOriginalFilename(((MediaFile)((Object)vid)).getFilename());
                }
            }
            if (movie.getEdition() == MovieEdition.NONE) {
                movie.setEdition(MovieEdition.getMovieEditionFromString(movieDir.getFileName().toString()));
            }
        }
        boolean bl2 = false;
        boolean videoAvailable = false;
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
            videoAvailable = true;
            if (!"disc".equalsIgnoreCase(mf.getExtension())) continue;
            bl = true;
        }
        if (videoAvailable) {
            LOGGER.debug("| store movie into DB as: {}", (Object)movie.getTitle());
            this.movieList.addMovie(movie);
            movie.setOffline(bl);
            movie.reEvaluateDiscfolder();
            movie.reEvaluateStacking();
            movie.saveToDb();
        } else {
            LOGGER.error("could not add '{}' because no VIDEO file found", (Object)movieDir);
        }
        if (MovieModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
            List<MediaFile> vsmetas = movie.getMediaFiles(MediaFileType.VSMETA);
            if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty() && !vsmetas.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                LOGGER.debug("extracting POSTERs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                MovieArtworkHelper.extractArtworkFromVsmeta(movie, vsmetas.get(0), MediaArtwork.MediaArtworkType.POSTER);
            }
            if (movie.getMediaFiles(MediaFileType.FANART).isEmpty() && !vsmetas.isEmpty() && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                LOGGER.debug("extracting FANARTs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                MovieArtworkHelper.extractArtworkFromVsmeta(movie, vsmetas.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
            }
        }
        if (movie.getMovieSet() != null) {
            LOGGER.debug("| movie is part of a movieset");
            movie.getMovieSet().insertMovie(movie);
            movie.getMovieSet().saveToDb();
        }
    }

    private void createMultiMovieFromDir(Path dataSource, Path movieDir, List<Path> allFiles) {
        LOGGER.info("Parsing multi  movie directory: {}", (Object)movieDir);
        List<Movie> movies = this.movieList.getMoviesByPath(movieDir);
        this.filesFound.add(movieDir);
        this.filesFound.addAll(allFiles);
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
        for (Path file : allFiles) {
            mfs.add(new MediaFile(file));
        }
        mfs.sort((file1, file2) -> file2.getFileAsPath().getFileName().toString().length() - file1.getFileAsPath().getFileName().toString().length());
        for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
            Movie movie = null;
            String basename = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename()));
            ArrayList<MediaFile> sameName = new ArrayList<MediaFile>();
            LOGGER.trace("UDS: basename: {}", (Object)basename);
            for (MediaFile mediaFile : mfs) {
                String smBasename = FilenameUtils.getBaseName((String)mediaFile.getFilename());
                String smNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                if (!smBasename.equals(basename) && !smBasename.matches(smNameRegexp)) continue;
                if (mediaFile.getType() == MediaFileType.GRAPHIC) {
                    mediaFile.setType(MediaFileType.POSTER);
                }
                sameName.add(mediaFile);
                LOGGER.trace("UDS: found matching MF: {}", (Object)mediaFile);
            }
            for (Movie movie2 : movies) {
                if (!movie2.getMediaFiles(MediaFileType.VIDEO).contains(mf)) continue;
                LOGGER.debug("| found movie '{}' from MediaFile {}", (Object)movie2.getTitle(), (Object)mf);
                movie = movie2;
                break;
            }
            if (movie == null) {
                movie = MovieUpdateDatasourceTask.parseNFOs(sameName);
                if (movie == null) {
                    LOGGER.debug("| Create new movie from file: {}", (Object)mf);
                    movie = new Movie();
                    String[] ty = ParserUtils.detectCleanTitleAndYear(basename, MovieModuleManager.getInstance().getSettings().getBadWord());
                    movie.setTitle(ty[0]);
                    if (!ty[1].isEmpty()) {
                        try {
                            movie.setYear(Integer.parseInt((String)ty[1]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    movie.setEdition(MovieEdition.getMovieEditionFromString(basename));
                    Matcher matcher = VIDEO_3D_PATTERN.matcher(basename);
                    if (matcher.find()) {
                        movie.setVideoIn3D(true);
                    }
                }
                movie.setDataSource(dataSource.toString());
                movie.setNewlyAdded(true);
                movie.setPath(mf.getPath());
                if (StringUtils.isBlank((CharSequence)movie.getOriginalFilename())) {
                    movie.setOriginalFilename(mf.getFilename());
                }
                movies.add(movie);
            }
            if (!MetadataUtil.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            if (movie.getTmdbId() == 0) {
                movie.setTmdbId(ParserUtils.detectTmdbId(mf.getFileAsPath().toString()));
            }
            if (movie.getMediaSource() == MediaSource.UNKNOWN) {
                movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
            }
            LOGGER.debug("| parsing video file {}", (Object)mf.getFilename());
            movie.setMultiMovieDir(true);
            for (MediaFile mediaFile : this.getMediaFiles(sameName, MediaFileType.UNKNOWN)) {
                for (MediaFile vid : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                    if (!mediaFile.getFilename().startsWith(vid.getFilename())) continue;
                    mediaFile.setType(MediaFileType.DOUBLE_EXT);
                }
            }
            this.addMediafilesToMovie(movie, sameName);
            mfs.removeAll(sameName);
            for (MediaFile mediaFile : movie.getMediaFiles()) {
                if (Files.exists(mediaFile.getFile(), new LinkOption[0])) continue;
                movie.removeFromMediaFiles(mediaFile);
            }
            boolean isOffline = false;
            for (MediaFile mediaFiles : movie.getMediaFiles(MediaFileType.VIDEO)) {
                if (!"disc".equalsIgnoreCase(mediaFiles.getExtension())) continue;
                isOffline = true;
            }
            movie.setOffline(isOffline);
            if (movie.getMovieSet() != null) {
                LOGGER.debug("| movie is part of a movieset");
                movie.getMovieSet().insertMovie(movie);
                movie.getMovieSet().saveToDb();
            }
            if (MovieModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
                List<MediaFile> list = movie.getMediaFiles(MediaFileType.VSMETA);
                if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty() && !list.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                    LOGGER.debug("extracting POSTERs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                    MovieArtworkHelper.extractArtworkFromVsmeta(movie, list.get(0), MediaArtwork.MediaArtworkType.POSTER);
                }
                if (movie.getMediaFiles(MediaFileType.FANART).isEmpty() && !list.isEmpty() && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                    LOGGER.debug("extracting FANARTs from VSMETA for {}", (Object)movie.getMainFile().getFileAsPath());
                    MovieArtworkHelper.extractArtworkFromVsmeta(movie, list.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
                }
            }
            this.movieList.addMovie(movie);
            movie.saveToDb();
        }
        for (Movie m : this.movieList.getMoviesByPath(movieDir)) {
            m.reEvaluateDiscfolder();
            m.reEvaluateStacking();
            m.saveToDb();
        }
    }

    private void addMediafilesToMovie(Movie movie, List<MediaFile> mediaFiles) {
        ArrayList<MediaFile> current = new ArrayList<MediaFile>(movie.getMediaFiles());
        mediaFiles.sort(new MovieMediaFileComparator());
        MediaFile mainVideoFile = null;
        if (!movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
            mainVideoFile = movie.getMainVideoFile();
        }
        block9: for (MediaFile mf : mediaFiles) {
            if (current.contains(mf)) continue;
            if ((mf.getPath().toUpperCase(Locale.ROOT).contains("BDMV") || mf.getPath().toUpperCase(Locale.ROOT).contains("VIDEO_TS") || mf.getPath().toUpperCase(Locale.ROOT).contains("HVDVD_TS") || mf.isDiscFile()) && movie.getMediaSource() == MediaSource.UNKNOWN) {
                movie.setMediaSource(MediaSource.parseMediaSource(mf.getPath()));
            }
            if (!MetadataUtil.isValidImdbId(movie.getImdbId())) {
                movie.setImdbId(ParserUtils.detectImdbId(mf.getFileAsPath().toString()));
            }
            if (movie.getTmdbId() == 0) {
                movie.setTmdbId(ParserUtils.detectTmdbId(mf.getFileAsPath().toString()));
            }
            LOGGER.debug("| parsing {} {}", (Object)mf.getType().name(), (Object)mf.getFileAsPath());
            switch (mf.getType()) {
                case VIDEO: {
                    if (mainVideoFile == null) {
                        mainVideoFile = mf;
                    }
                    movie.addToMediaFiles(mf);
                    if (movie.getMediaSource() != MediaSource.UNKNOWN) break;
                    movie.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                    break;
                }
                case SUBTITLE: {
                    if (mf.isPacked()) break;
                    movie.addToMediaFiles(mf);
                    break;
                }
                case FANART: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrafanart")) {
                        LOGGER.warn("problem: detected media file type FANART in extrafanart folder: {}", (Object)mf.getPath());
                        continue block9;
                    }
                    if (this.hasInvalidBasename(mainVideoFile, mf, "fanart")) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case THUMB: {
                    if (mf.getPath().toLowerCase(Locale.ROOT).contains("extrathumbs")) {
                        LOGGER.warn("| problem: detected media file type THUMB in extrathumbs folder: {}", (Object)mf.getPath());
                        continue block9;
                    }
                    if (this.hasInvalidBasename(mainVideoFile, mf, "thumb")) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case POSTER: 
                case BANNER: 
                case CLEARLOGO: 
                case LOGO: 
                case CLEARART: 
                case KEYART: {
                    if (this.hasInvalidBasename(mainVideoFile, mf, mf.getType().name().toLowerCase(Locale.ROOT))) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case DISC: {
                    if (this.hasInvalidBasename(mainVideoFile, mf, "disc") || this.hasInvalidBasename(mainVideoFile, mf, "discart")) {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                    movie.addToMediaFiles(mf);
                    break;
                }
                case TRAILER: 
                case EXTRA: 
                case SAMPLE: 
                case NFO: 
                case TEXT: 
                case EXTRAFANART: 
                case EXTRATHUMB: 
                case AUDIO: 
                case MEDIAINFO: 
                case VSMETA: 
                case THEME: 
                case CHARACTERART: 
                case DOUBLE_EXT: {
                    movie.addToMediaFiles(mf);
                    break;
                }
                default: {
                    LOGGER.debug("| NOT adding unknown media file type: {}", (Object)mf.getFileAsPath());
                    continue block9;
                }
            }
            if (mf.getType() == MediaFileType.GRAPHIC || mf.getType() == MediaFileType.UNKNOWN || mf.getType() == MediaFileType.NFO || movie.getMediaFiles().contains(mf)) continue;
            LOGGER.warn("| Movie not added mf: {}", (Object)mf.getFileAsPath());
        }
        block10: for (MediaFileType type : Arrays.asList(MediaFileType.FANART, MediaFileType.POSTER, MediaFileType.BANNER, MediaFileType.CLEARLOGO, MediaFileType.LOGO, MediaFileType.CLEARART, MediaFileType.KEYART, MediaFileType.DISC)) {
            if (!movie.getMediaFiles(type).isEmpty()) continue;
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.GRAPHIC)) {
                MediaFileType parsedType = MediaFileHelper.parseImageType(mf.getFile());
                if (parsedType != type) continue;
                mf.setType(type);
                continue block10;
            }
        }
    }

    private boolean hasInvalidBasename(MediaFile mainVideoFile, MediaFile toCheck, String suffix) {
        String mainVideoFileBasename;
        if (mainVideoFile == null) {
            return false;
        }
        String toCheckBasename = FilenameUtils.getBaseName((String)toCheck.getFilename());
        if (!toCheckBasename.endsWith("-" + suffix)) {
            return false;
        }
        return !(toCheckBasename = toCheckBasename.replaceAll("-" + suffix + "$", "")).equals(mainVideoFileBasename = FilenameUtils.getBaseName((String)mainVideoFile.getFilename()));
    }

    private void cleanup(String datasource) {
        this.setTaskName(TmmResourceBundle.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = this.movieList.getMovies().size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = this.movieList.getMovies().get(i);
            boolean dirty = false;
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            Path movieDir = movie.getPathNIO();
            if (!this.filesFound.contains(movieDir)) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '{}' not found, removing from DB...", (Object)movieDir);
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.warn("dir {} not in hashset, but on hdd!", (Object)movieDir);
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    LOGGER.debug("removing orphaned file from DB: {}", (Object)mf.getFileAsPath());
                    movie.removeFromMediaFiles(mf);
                    dirty = true;
                }
                if (dirty && !movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    movie.saveToDb();
                }
            }
            if (!movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) continue;
            LOGGER.debug("Movie ({}) without VIDEO files detected, removing from DB...", (Object)movie.getTitle());
            moviesToRemove.add(movie);
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void cleanup(List<Movie> movies) {
        this.setTaskName(TmmResourceBundle.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        ArrayList<Movie> moviesToRemove = new ArrayList<Movie>();
        for (int i = movies.size() - 1; i >= 0 && !this.cancel; --i) {
            Movie movie = movies.get(i);
            boolean dirty = false;
            Path movieDir = movie.getPathNIO();
            if (!this.filesFound.contains(movieDir)) {
                if (!Files.exists(movieDir, new LinkOption[0])) {
                    LOGGER.debug("movie directory '{}' not found, removing from DB...", (Object)movieDir);
                    moviesToRemove.add(movie);
                } else {
                    LOGGER.warn("dir {} not in hashset, but on hdd!", (Object)movieDir);
                }
            }
            if (!movie.isNewlyAdded()) {
                ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(movie.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    LOGGER.debug("removing orphaned file from DB: {}", (Object)mf.getFileAsPath());
                    movie.removeFromMediaFiles(mf);
                    if (mf.isGraphic()) {
                        ImageCache.invalidateCachedImage(mf);
                    }
                    dirty = true;
                }
                if (dirty && !movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) {
                    movie.saveToDb();
                }
            }
            if (!movie.getMediaFiles(MediaFileType.VIDEO).isEmpty()) continue;
            LOGGER.debug("Movie ({}) without VIDEO files detected, removing from DB...", (Object)movie.getTitle());
            moviesToRemove.add(movie);
        }
        this.movieList.removeMovies(moviesToRemove);
    }

    private void gatherMediainfo(String datasource) {
        this.setTaskName(TmmResourceBundle.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (Runnable task : this.miTasks) {
            this.submitTask(task);
        }
        for (Movie movie : this.movieList.getMovies()) {
            if (this.cancel) break;
            if (!Paths.get(datasource, new String[0]).equals(Paths.get(movie.getDataSource(), new String[0]))) continue;
            boolean dirty = false;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, movie, false));
                    continue;
                }
                if (MediaFileHelper.gatherFileInformation(mf)) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, movie, true));
                }
                dirty = true;
            }
            if (!dirty) continue;
            movie.saveToDb();
        }
        this.waitForCompletionOrCancel();
    }

    private void gatherMediainfo(List<Movie> movies) {
        this.setTaskName(TmmResourceBundle.getString("update.mediainfo"));
        this.publishState();
        this.initThreadPool(1, "mediainfo");
        LOGGER.info("getting Mediainfo...");
        for (Movie movie : movies) {
            if (this.cancel) break;
            boolean dirty = false;
            for (MediaFile mf : new ArrayList<MediaFile>(movie.getMediaFiles())) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, movie, false));
                    continue;
                }
                if (MediaFileHelper.gatherFileInformation(mf)) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, movie, true));
                }
                dirty = true;
            }
            if (!dirty) continue;
            movie.saveToDb();
        }
        this.waitForCompletionOrCancel();
    }

    private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
        MediaFile mf = null;
        for (MediaFile mediaFile : mfs) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf = new MediaFile(mediaFile);
        }
        return mf;
    }

    private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
        List<MediaFileType> mediaFileTypes = Arrays.asList(types);
        return mfs.stream().filter(mf -> mediaFileTypes.contains((Object)mf.getType())).collect(Collectors.toList());
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                if (this.isInSkipFolder(path)) {
                    LOGGER.debug("Skipping: {}", (Object)path);
                    continue;
                }
                fileNames.add(path.toAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("error on listFilesAndDirs", (Throwable)e);
            LOGGER.debug("falling back to the alternate coding");
            fileNames = this.listFilesAndDirs2(directory);
        }
        return fileNames;
    }

    private List<Path> listFilesAndDirs2(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (Stream<Path> directoryStream = Files.walk(directory, 1, FileVisitOption.FOLLOW_LINKS);){
            List allElements = directoryStream.collect(Collectors.toList());
            for (Path path : allElements) {
                if (directory.toAbsolutePath().equals(path.toAbsolutePath())) continue;
                if (this.isInSkipFolder(path)) {
                    LOGGER.debug("Skipping: {}", (Object)path);
                    continue;
                }
                fileNames.add(path.toAbsolutePath());
            }
        }
        catch (Exception e) {
            LOGGER.error("error on listFilesAndDirs2", (Throwable)e);
        }
        return fileNames;
    }

    private Set<Path> getAllFilesRecursive(Path folder) {
        folder = folder.toAbsolutePath();
        AllFilesRecursive visitor = new AllFilesRecursive();
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return visitor.fFound;
    }

    public void searchAndParse(Path datasource, Path folder, int deep) {
        folder = folder.toAbsolutePath();
        SearchAndParseVisitor visitor = new SearchAndParseVisitor(datasource);
        try {
            Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isInSkipFolder(Path dir) {
        if (dir == null || dir.getFileName() == null) {
            return false;
        }
        String dirName = dir.getFileName().toString();
        String dirNameUppercase = dirName.toUpperCase(Locale.ROOT);
        String fullPath = dir.toAbsolutePath().toString();
        if (SKIP_FOLDERS.contains(dirNameUppercase) || dirName.matches(SKIP_REGEX)) {
            return true;
        }
        for (Pattern pattern : this.skipFolders) {
            Matcher matcher = pattern.matcher(dirName);
            if (matcher.matches()) {
                return true;
            }
            if (!pattern.toString().replace("\\Q", "").replace("\\E", "").equals(fullPath)) continue;
            return true;
        }
        return false;
    }

    private boolean containsSkipFile(Path dir) {
        return Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]);
    }

    private static synchronized void incVisFile() {
        ++visFile;
    }

    private static synchronized void incPreDir() {
        ++preDir;
    }

    private static synchronized void incPostDir() {
        ++postDir;
    }

    private class SearchAndParseVisitor
    extends AbstractFileVisitor {
        private final Path datasource;
        private final List<String> unstackedRoot = new ArrayList<String>();
        private final Set<Path> videofolders = new HashSet<Path>();

        SearchAndParseVisitor(Path datasource) {
            this.datasource = datasource;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            MovieUpdateDatasourceTask.incVisFile();
            if (Utils.isRegularFile(attr) && !file.getFileName().toString().matches(MovieUpdateDatasourceTask.SKIP_REGEX) && Settings.getInstance().getVideoFileType().contains("." + FilenameUtils.getExtension((String)file.toString()).toLowerCase(Locale.ROOT))) {
                MediaFile mf = new MediaFile(file);
                if (mf.getType() == MediaFileType.VIDEO) {
                    this.videofolders.add(file.getParent());
                } else {
                    LOGGER.debug("no VIDEO (is {}) - do not parse {}", (Object)mf.getType(), (Object)file);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            MovieUpdateDatasourceTask.incPreDir();
            String parent = "";
            if (!dir.equals(this.datasource) && !dir.getParent().equals(this.datasource)) {
                parent = dir.getParent().getFileName().toString().toUpperCase(Locale.ROOT);
            }
            if (dir.getFileName() != null && (MovieUpdateDatasourceTask.this.isInSkipFolder(dir) || MovieUpdateDatasourceTask.this.containsSkipFile(dir) || parent.matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$"))) {
                LOGGER.debug("Skipping dir: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            MovieUpdateDatasourceTask.incPostDir();
            if (MovieUpdateDatasourceTask.this.cancel) {
                return FileVisitResult.TERMINATE;
            }
            if (this.videofolders.contains(dir)) {
                boolean update = true;
                Path relative = this.datasource.relativize(dir);
                if (!Utils.getFolderStackingMarker(relative.toString()).isEmpty() && Utils.getFolderStackingMarker(relative.toString()).equals(dir.getFileName().toString())) {
                    if (this.unstackedRoot.contains(dir.getParent().toString())) {
                        update = false;
                    } else {
                        this.unstackedRoot.add(dir.getParent().toString());
                    }
                }
                if (update) {
                    for (Path sub : this.videofolders) {
                        if (sub.equals(dir) || !sub.startsWith(dir)) continue;
                        List<Path> rootFiles = this.listFilesOnly(dir);
                        MovieUpdateDatasourceTask.this.submitTask(new ParseMultiMovieDirTask(this.datasource.toAbsolutePath(), dir, rootFiles));
                        MovieUpdateDatasourceTask.this.publishState();
                        return FileVisitResult.CONTINUE;
                    }
                    MovieUpdateDatasourceTask.this.submitTask(new FindMovieTask(dir, this.datasource));
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private List<Path> listFilesOnly(Path directory) {
            ArrayList<Path> fileNames = new ArrayList<Path>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
                for (Path path : directoryStream) {
                    if (!Utils.isRegularFile(path) && !path.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) continue;
                    if (MovieUpdateDatasourceTask.this.isInSkipFolder(path)) {
                        LOGGER.debug("Skipping: {}", (Object)path);
                        continue;
                    }
                    fileNames.add(path.toAbsolutePath());
                }
            }
            catch (IOException e) {
                LOGGER.error("error on listFilesOnly: {}", (Object)e.getMessage());
            }
            return fileNames;
        }
    }

    private class AllFilesRecursive
    extends AbstractFileVisitor {
        private final Set<Path> fFound = new HashSet<Path>();

        private AllFilesRecursive() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            MovieUpdateDatasourceTask.incVisFile();
            if (file.getFileName() == null) {
                return FileVisitResult.CONTINUE;
            }
            String filename = file.getFileName().toString();
            String path = "";
            if (file.getParent() != null && file.getParent().getFileName() != null) {
                path = file.getParent().getFileName().toString();
            }
            if (Utils.isRegularFile(attr) && path.matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                if (FilenameUtils.getExtension((String)filename).equalsIgnoreCase("nfo")) {
                    this.fFound.add(file.toAbsolutePath());
                }
                return FileVisitResult.CONTINUE;
            }
            if (MediaFileHelper.isMainDiscIdentifierFile(filename)) {
                this.fFound.add(file.toAbsolutePath());
                return FileVisitResult.CONTINUE;
            }
            if (Utils.isRegularFile(attr) && !filename.matches(MovieUpdateDatasourceTask.SKIP_REGEX)) {
                this.fFound.add(file.toAbsolutePath());
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            MovieUpdateDatasourceTask.incPreDir();
            if (dir.getFileName() != null && (MovieUpdateDatasourceTask.this.isInSkipFolder(dir) || MovieUpdateDatasourceTask.this.containsSkipFile(dir))) {
                LOGGER.debug("Skipping dir: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (dir.getFileName() != null && dir.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                this.fFound.add(dir.toAbsolutePath());
                return FileVisitResult.CONTINUE;
            }
            if (dir.getParent() != null && dir.getParent().getFileName() != null && dir.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            MovieUpdateDatasourceTask.incPostDir();
            return FileVisitResult.CONTINUE;
        }
    }

    private class ParseMultiMovieDirTask
    implements Callable<Object> {
        private final Path movieDir;
        private final Path datasource;
        private final List<Path> allFiles;

        public ParseMultiMovieDirTask(Path dataSource, Path movieDir, List<Path> allFiles) {
            this.datasource = dataSource;
            this.movieDir = movieDir;
            this.allFiles = allFiles;
        }

        @Override
        public String call() {
            MovieUpdateDatasourceTask.this.createMultiMovieFromDir(this.datasource, this.movieDir, this.allFiles);
            return this.movieDir.toString();
        }
    }

    private class FindMovieTask
    implements Callable<Object> {
        private final Path subdir;
        private final Path datasource;
        private final long uniqueId;

        public FindMovieTask(Path subdir, Path datasource) {
            this.subdir = subdir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() {
            Object name = Thread.currentThread().getName();
            if (!((String)name).contains("-G")) {
                name = (String)name + "-G0";
            }
            name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName((String)name);
            MovieUpdateDatasourceTask.this.parseMovieDirectory(this.subdir, this.datasource);
            return this.subdir.toString();
        }
    }
}

