/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.time.LocalTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ArdSettings;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFilePosition;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.thirdparty.FFmpeg;
import org.tinymediamanager.thirdparty.MediaInfo;

public abstract class ARDetectorTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ARDetectorTask.class);
    private final Pattern patternSampleDarkLevel = Pattern.compile("lavfi.signalstats.YLOW=([0-9]*)");
    private final Pattern patternSample = Pattern.compile("x1:([0-9]*)\\sx2:([0-9]*)\\sy1:([0-9]*)\\sy2:([0-9]*)\\sw:([0-9]*)\\sh:([0-9]*)\\sx:");
    private final Settings settings = Settings.getInstance();
    protected ArdSettings.Mode mode = ArdSettings.Mode.DEFAULT;
    protected int sampleDuration = 2;
    protected int sampleMinNumber = 6;
    protected int sampleMaxGap = 900;
    protected float ignoreBeginningPct = 2.0f;
    protected float ignoreEndPct = 8.0f;
    protected boolean roundUp = false;
    protected float roundUpThresholdPct = 4.0f;
    private float arSecondaryDelta = 0.15f;
    private float plausiWidthPct = 50.0f;
    private float plausiHeightPct = 60.0f;
    private float plausiWidthDeltaPct = 1.5f;
    private float plausiHeightDeltaPct = 2.0f;
    protected int multiFormatMode = 0;
    private float multiFormatThresholdPct = 6.0f;
    private float darkLevelPct = 7.0f;
    private float darkLevelMaxPct = 13.0f;
    protected final List<Float> arCustomList = new LinkedList<Float>();

    public ARDetectorTask(TmmTaskHandle.TaskType type) {
        super(TmmResourceBundle.getString("update.aspectRatio"), 100, type);
        this.init();
    }

    protected void init() {
        this.mode = this.settings.getArdMode();
        ArdSettings.SampleSetting modeSettings = this.settings.getArdSampleSetting(this.mode);
        if (modeSettings == null) {
            modeSettings = this.settings.getArdSampleSetting(ArdSettings.Mode.DEFAULT);
        }
        this.sampleDuration = modeSettings.getDuration();
        this.sampleMinNumber = modeSettings.getMinNumber();
        this.sampleMaxGap = modeSettings.getMaxGap();
        this.ignoreBeginningPct = this.settings.getArdIgnoreBeginningPct();
        this.ignoreEndPct = this.settings.getArdIgnoreEndPct();
        this.arCustomList.addAll(this.settings.getCustomAspectRatios().stream().map(ar -> Float.valueOf(ar)).sorted().collect(Collectors.toList()));
        this.roundUp = this.settings.isArdRoundUp();
        this.roundUpThresholdPct = this.settings.getArdRoundUpThresholdPct();
        this.multiFormatMode = this.settings.getArdMFMode();
        if (!ArdSettings.Mode.ACCURATE.equals((Object)this.mode)) {
            this.multiFormatMode = 0;
        }
        this.multiFormatThresholdPct = this.settings.getArdMFThresholdPct();
        this.arSecondaryDelta = this.settings.getArdSecondaryDelta();
        this.plausiWidthPct = this.settings.getArdPlausiWidthPct();
        this.plausiHeightPct = this.settings.getArdPlausiHeightPct();
        this.plausiWidthDeltaPct = this.settings.getArdPlausiWidthDeltaPct();
        this.plausiHeightDeltaPct = this.settings.getArdPlausiHeightDeltaPct();
        this.darkLevelPct = this.settings.getArdDarkLevelPct();
        this.darkLevelMaxPct = this.settings.getArdDarkLevelMaxPct();
    }

    protected void analyze(MediaFile mediaFile) {
        this.analyze(mediaFile, 0);
    }

    protected void analyze(MediaFile mediaFile, int idx) {
        this.setTaskName(TmmResourceBundle.getString("update.aspectRatio") + ": " + mediaFile.getFilename());
        if (mediaFile.isISO() || mediaFile.getDuration() == 0) {
            LOGGER.warn("Mediafile '{}' can not be analyzed.", (Object)mediaFile.getFilename());
        }
        try {
            VideoInfo videoInfo = this.getPrefilledVideoInfo(mediaFile);
            int start = (int)((float)videoInfo.duration * this.ignoreBeginningPct / 100.0f);
            int end = (int)((float)videoInfo.duration * (1.0f - this.ignoreEndPct / 100.0f));
            float increment = (float)(end - start) / ((float)this.sampleMinNumber + 1.0f);
            float seconds = (float)start + increment;
            MediaFilePosition position = MediaFileHelper.getPositionInMediaFile(mediaFile, 0);
            if (position == null) {
                LOGGER.warn("Found no valid position for AR detection for '{}'", (Object)mediaFile.getFilename());
                return;
            }
            String result = FFmpeg.scanDarkLevel(0.0f, position.getPath());
            this.parseDarkLevel(result, videoInfo);
            if ((double)((float)videoInfo.darkLevel * 100.0f) / Math.pow(2.0, videoInfo.bitDepth) > (double)this.darkLevelMaxPct) {
                videoInfo.darkLevel = this.getDarkLevel(videoInfo);
            }
            LOGGER.debug("Filename: {}", (Object)mediaFile.getFileAsPath());
            LOGGER.trace("Metadata: Encoded size: {}x{}px, Encoded AR: {}, SAR: {}, BitDepth: {}, DarkLevel: {}, Duration: {}", new Object[]{videoInfo.width, videoInfo.height, mediaFile.getAspectRatio(), Float.valueOf(videoInfo.arSample), videoInfo.bitDepth, videoInfo.darkLevel, mediaFile.getDurationHHMMSS()});
            if (increment > (float)this.sampleMaxGap) {
                increment = this.sampleMaxGap;
                seconds = start;
            }
            while (seconds < (float)(end - 2)) {
                try {
                    int iSec = Math.round(seconds);
                    int iInc = Math.round(increment);
                    if (iSec >= videoInfo.duration) {
                        iSec = videoInfo.duration - this.sampleDuration;
                    }
                    position = MediaFileHelper.getPositionInMediaFile(mediaFile, iSec);
                    LOGGER.trace("Scanning {} at {}s", (Object)position.getPath(), (Object)position.getPosition());
                    result = FFmpeg.scanSample(position.getPosition(), this.sampleDuration, videoInfo.darkLevel, position.getPath());
                    this.parseSample(result, iSec, iInc, videoInfo);
                }
                catch (Exception ex) {
                    LOGGER.trace("Error scanning sample - '{}'", (Object)ex.getMessage());
                }
                seconds += increment - videoInfo.sampleSkipAdjustement;
                if (seconds < (float)start) {
                    seconds = Math.round((float)start + 0.5f * videoInfo.sampleSkipAdjustement);
                }
                if (this.cancel) {
                    return;
                }
                int progress = ((int)seconds - start) * 100 / (end - start);
                this.publishState(idx * 100 + progress);
            }
            if (videoInfo.sampleCount == 0) {
                LOGGER.debug("No results from scanning");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"task.ard", "message.ard.failed", new String[]{":", mediaFile.getFilename()}));
                return;
            }
            this.calculateARPrimaryAndSecondaryRaw(videoInfo);
            if (this.multiFormatMode > 0) {
                this.detectMultiFormat(videoInfo);
            } else {
                this.getNewHeight(videoInfo);
                videoInfo.height = videoInfo.heightPrimary;
                videoInfo.width = Math.round((float)videoInfo.height * videoInfo.arPrimaryRaw / videoInfo.arSample);
                LOGGER.trace("Multi format:      disabled");
            }
            videoInfo.arPrimary = this.roundAR(videoInfo.arPrimaryRaw);
            mediaFile.setAspectRatio(Float.valueOf(videoInfo.arPrimary));
            LOGGER.trace("AR_Primary:        {}", (Object)String.format("%.2f", Float.valueOf(videoInfo.arPrimary)));
            if (videoInfo.arSecondary > 0.0f && ArdSettings.Mode.ACCURATE.equals((Object)this.mode)) {
                videoInfo.arSecondary = this.roundAR(videoInfo.arSecondary);
                mediaFile.setAspectRatio2(Float.valueOf(videoInfo.arSecondary));
                LOGGER.trace("AR_Secondary:      {}", (Object)String.format("%.2f", Float.valueOf(videoInfo.arSecondary)));
            }
            mediaFile.setVideoHeight(videoInfo.height);
            mediaFile.setVideoWidth(videoInfo.width);
            LOGGER.info("Detected: {}x{} AR: {}{}", new Object[]{videoInfo.width, videoInfo.height, String.format("%.2f", Float.valueOf(videoInfo.arPrimary)), videoInfo.arSecondary > 0.0f ? " (AR2: " + String.format("%.2f", Float.valueOf(videoInfo.arSecondary)) + ")" : ""});
        }
        catch (Exception ex) {
            LOGGER.error("Error detecting aspect ratio", (Throwable)ex);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"task.ard", "message.ard.failed", new String[]{":", mediaFile.getFilename()}));
        }
    }

    protected VideoInfo getPrefilledVideoInfo(MediaFile mediaFile) {
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.width = mediaFile.getVideoWidth();
        String width = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "Sampled_Width");
        if (NumberUtils.isParsable((String)width)) {
            videoInfo.width = Integer.parseInt(width);
        } else {
            width = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "Width");
            if (NumberUtils.isParsable((String)width)) {
                videoInfo.width = Integer.parseInt(width);
            }
        }
        videoInfo.height = mediaFile.getVideoHeight();
        String height = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "Sampled_Height");
        if (NumberUtils.isParsable((String)height)) {
            videoInfo.height = Integer.parseInt(height);
        } else {
            height = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "Height");
            if (NumberUtils.isParsable((String)height)) {
                videoInfo.height = Integer.parseInt(height);
            }
        }
        videoInfo.bitDepth = mediaFile.getBitDepth();
        String bitDepth = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "BitDepth");
        if (NumberUtils.isParsable((String)bitDepth)) {
            videoInfo.bitDepth = Integer.parseInt(bitDepth);
        }
        videoInfo.duration = mediaFile.getDuration();
        String duration = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "Duration");
        if (NumberUtils.isParsable((String)duration)) {
            videoInfo.duration = Math.round(Float.parseFloat(duration) / 1000.0f);
        }
        videoInfo.arSample = this.getSampleAR(mediaFile);
        if (videoInfo.arSample <= 0.5f) {
            videoInfo.arSample = 1.0f;
        }
        return videoInfo;
    }

    protected int getDarkLevel(VideoInfo videoInfo) {
        return (int)Math.round(Math.pow(2.0, videoInfo.bitDepth) * (double)(this.darkLevelPct / 100.0f));
    }

    protected void parseDarkLevel(String result, VideoInfo videoInfo) {
        String ylow;
        Matcher matcher;
        videoInfo.darkLevel = 9999;
        if (StringUtils.isNotEmpty((CharSequence)result) && (matcher = this.patternSampleDarkLevel.matcher(result)).find() && NumberUtils.isParsable((String)(ylow = matcher.group(1)))) {
            videoInfo.darkLevel = Integer.parseInt(ylow) + (int)Math.pow(2.0, videoInfo.bitDepth - 7);
        }
    }

    protected void parseSample(String result, int seconds, int increment, VideoInfo videoInfo) {
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            String sample;
            String[] sampleData;
            Matcher matcher = this.patternSample.matcher(result);
            if (matcher.find() && (sampleData = (sample = matcher.results().map(match -> match.group(5) + " " + match.group(6) + " " + match.group(1) + " " + match.group(2) + " " + match.group(3) + " " + match.group(4)).sorted(Comparator.reverseOrder()).findFirst().orElse("")).split(" ")).length == 6) {
                int width = Integer.parseInt(sampleData[0]);
                int height = Integer.parseInt(sampleData[1]);
                int blackLeft = Integer.parseInt(sampleData[2]);
                int blackRight = videoInfo.width - Integer.parseInt(sampleData[3]) - 1;
                int blackTop = Integer.parseInt(sampleData[4]);
                int blackBottom = videoInfo.height - Integer.parseInt(sampleData[5]) - 1;
                videoInfo.arMeasured = height > 0 ? (float)width / (float)height : 9.99f;
                videoInfo.arCalculated = (float)((double)Math.round((double)(videoInfo.arMeasured * videoInfo.arSample) * 1000000.0) / 1000000.0);
                String barstxt = String.format("{%4d|%4d} {%3d|%3d}", blackLeft, blackRight, blackTop, blackBottom);
                this.checkPlausibility(width, height, blackLeft, blackRight, blackTop, blackBottom, barstxt, seconds, increment, videoInfo);
            }
        } else {
            throw new RuntimeException("Sample result is empty");
        }
    }

    protected void checkPlausibility(int width, int height, int blackLeft, int blackRight, int blackTop, int blackBottom, String barstxt, int seconds, int increment, VideoInfo videoInfo) {
        if ((double)Math.abs(blackLeft - blackRight) > (double)((float)videoInfo.width * this.plausiWidthDeltaPct) / 100.0) {
            LOGGER.debug("Analyzing {}s near {} => bars: {} => Sample skipped: More than {}% difference between left and right black bar", new Object[]{this.sampleDuration, String.format("%-8s", LocalTime.MIN.plusSeconds(seconds).toString()), barstxt, Float.valueOf(this.plausiWidthDeltaPct)});
            videoInfo.sampleSkipAdjustement = videoInfo.sampleSkipAdjustement == 0.0f ? (float)increment * 1.4f : 0.0f;
        } else if ((double)Math.abs(blackTop - blackBottom) > (double)((float)videoInfo.height * this.plausiHeightDeltaPct) / 100.0) {
            LOGGER.debug("Analyzing {}s near {} => bars: {} => Sample skipped: More than {}% difference between top and bottom black bar", new Object[]{this.sampleDuration, String.format("%-8s", LocalTime.MIN.plusSeconds(seconds).toString()), barstxt, Float.valueOf(this.plausiHeightDeltaPct)});
            videoInfo.sampleSkipAdjustement = videoInfo.sampleSkipAdjustement == 0.0f ? (float)increment * 1.4f : 0.0f;
        } else if ((double)((float)videoInfo.width * this.plausiWidthPct) / 100.0 >= (double)width) {
            LOGGER.debug("Analyzing {}s near {} => bars: {} => Sample skipped: Cropped width ({}px) is less than {}% of video width ({}px)", new Object[]{this.sampleDuration, String.format("%-8s", LocalTime.MIN.plusSeconds(seconds).toString()), barstxt, width, Float.valueOf(this.plausiWidthPct), videoInfo.width});
            videoInfo.sampleSkipAdjustement = videoInfo.sampleSkipAdjustement == 0.0f ? (float)increment * 1.4f : 0.0f;
        } else if ((double)((float)videoInfo.height * this.plausiHeightPct) / 100.0 >= (double)height) {
            LOGGER.debug("Analyzing {}s near {} => bars: {} => Sample skipped: Cropped height ({}px) is less than {}% of video height ({}px)", new Object[]{this.sampleDuration, String.format("%-8s", LocalTime.MIN.plusSeconds(seconds).toString()), barstxt, height, Float.valueOf(this.plausiHeightPct), videoInfo.height});
            videoInfo.sampleSkipAdjustement = videoInfo.sampleSkipAdjustement == 0.0f ? (float)increment * 1.4f : 0.0f;
        } else {
            videoInfo.sampleSkipAdjustement = 0.0f;
            if (!videoInfo.arMap.containsKey(Float.valueOf(videoInfo.arCalculated))) {
                videoInfo.arMap.put(Float.valueOf(videoInfo.arCalculated), 1);
            } else {
                videoInfo.arMap.put(Float.valueOf(videoInfo.arCalculated), videoInfo.arMap.get(Float.valueOf(videoInfo.arCalculated)) + 1);
            }
            if (!videoInfo.heightMap.containsKey(height)) {
                videoInfo.heightMap.put(height, 1);
            } else {
                videoInfo.heightMap.put(height, videoInfo.heightMap.get(height) + 1);
            }
            if (!videoInfo.widthMap.containsKey(width)) {
                videoInfo.widthMap.put(width, 1);
            } else {
                videoInfo.widthMap.put(width, videoInfo.widthMap.get(width) + 1);
            }
            ++videoInfo.sampleCount;
            LOGGER.debug("Analyzing {}s near {} => bars: {} crop: {}x{} ({}) * SAR => AR_Calculated = {}", new Object[]{this.sampleDuration, String.format("%-8s", LocalTime.MIN.plusSeconds(seconds).toString()), barstxt, width, height, String.format("%.5f", Float.valueOf(videoInfo.arMeasured)), String.format("%.5f", Float.valueOf(videoInfo.arCalculated))});
        }
    }

    protected void calculateARPrimaryAndSecondaryRaw(VideoInfo videoInfo) {
        int arSecondarySum;
        int arPrimarySum;
        videoInfo.arPrimaryRaw = videoInfo.arMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).findFirst().map(Map.Entry::getKey).orElse(Float.valueOf(0.0f)).floatValue();
        videoInfo.arSecondary = videoInfo.arMap.entrySet().stream().filter(entry -> ((Float)entry.getKey()).floatValue() <= videoInfo.arPrimaryRaw - this.arSecondaryDelta || ((Float)entry.getKey()).floatValue() >= videoInfo.arPrimaryRaw + this.arSecondaryDelta).sorted(Map.Entry.comparingByValue().reversed()).findFirst().map(Map.Entry::getKey).orElse(Float.valueOf(0.0f)).floatValue();
        if (videoInfo.arMap.size() == 0) {
            videoInfo.arSecondary = 0.0f;
        }
        if ((arPrimarySum = videoInfo.arMap.entrySet().stream().filter(entry -> ((Float)entry.getKey()).floatValue() >= videoInfo.arPrimaryRaw - this.arSecondaryDelta / 2.0f && ((Float)entry.getKey()).floatValue() <= videoInfo.arPrimaryRaw + this.arSecondaryDelta / 2.0f).map(Map.Entry::getValue).reduce(0, Integer::sum).intValue()) == (arSecondarySum = videoInfo.arMap.entrySet().stream().filter(entry -> ((Float)entry.getKey()).floatValue() >= videoInfo.arSecondary - this.arSecondaryDelta / 2.0f && ((Float)entry.getKey()).floatValue() <= videoInfo.arSecondary + this.arSecondaryDelta / 2.0f).map(Map.Entry::getValue).reduce(0, Integer::sum).intValue())) {
            float tmp = videoInfo.arPrimaryRaw;
            videoInfo.arPrimaryRaw = videoInfo.arSecondary;
            videoInfo.arSecondary = tmp;
        }
        float arPrimaryPct = (float)arPrimarySum * 100.0f / (float)videoInfo.sampleCount;
        videoInfo.arSecondaryPct = (float)arSecondarySum * 100.0f / (float)videoInfo.sampleCount;
        float arOtherPct = (float)(videoInfo.sampleCount - arPrimarySum - arSecondarySum) * 100.0f / (float)videoInfo.sampleCount;
        LOGGER.debug("AR_PrimaryRaw:     {}, {}% of samples are within \u00b1{}    Aspect ratio (AR) detected in most of the analyzed samples", new Object[]{String.format("%7.5f", Float.valueOf(videoInfo.arPrimaryRaw)), String.format("%6.2f", Float.valueOf(arPrimaryPct)), Float.valueOf(this.arSecondaryDelta)});
        LOGGER.debug("AR_SecondaryRaw:   {}, {}% of samples are within \u00b1{}    Second most frequent AR (multi format video likely at higher values)", new Object[]{String.format("%7.5f", Float.valueOf(videoInfo.arSecondary)), String.format("%6.2f", Float.valueOf(videoInfo.arSecondaryPct)), Float.valueOf(this.arSecondaryDelta)});
        LOGGER.debug("Other ARs:                  {}% of samples                     Other ARs found, high value means bad detection", (Object)String.format("%6.2f", Float.valueOf(arOtherPct)));
    }

    protected void detectMultiFormat(VideoInfo videoInfo) {
        if (videoInfo.arSecondaryPct >= this.multiFormatThresholdPct) {
            LOGGER.debug("Multi format:      yes                                             AR_Secondary ({}% of samples) >= MFV Detection Threshold ({}% of samples)", (Object)String.format("%.2f", Float.valueOf(videoInfo.arSecondaryPct)), (Object)String.format("%.2f", Float.valueOf(this.multiFormatThresholdPct)));
            if (this.multiFormatMode == 1) {
                float tmp = Math.min(videoInfo.arPrimaryRaw, videoInfo.arSecondary);
                videoInfo.arSecondary = Math.max(videoInfo.arPrimaryRaw, videoInfo.arSecondary);
                videoInfo.arPrimaryRaw = tmp;
                this.getNewHeight(videoInfo);
                videoInfo.height = Math.max(videoInfo.heightPrimary, videoInfo.heightSecondary);
                videoInfo.width = Math.round((float)videoInfo.height * videoInfo.arPrimaryRaw / videoInfo.arSample);
                LOGGER.debug("MFV detected, arPrimaryRaw is higher AR: {} height: {}", (Object)String.format("%.5f", Float.valueOf(videoInfo.arPrimaryRaw)), (Object)videoInfo.height);
                LOGGER.debug("MFV detected, arSecondary is wider AR: {}", (Object)String.format("%.5f", Float.valueOf(videoInfo.arSecondary)));
            } else if (this.multiFormatMode == 2) {
                float tmp = Math.max(videoInfo.arPrimaryRaw, videoInfo.arSecondary);
                videoInfo.arSecondary = Math.min(videoInfo.arPrimaryRaw, videoInfo.arSecondary);
                videoInfo.arPrimaryRaw = tmp;
                this.getNewHeight(videoInfo);
                videoInfo.height = Math.min(videoInfo.heightPrimary, videoInfo.heightSecondary);
                videoInfo.width = Math.round((float)videoInfo.height * videoInfo.arPrimaryRaw / videoInfo.arSample);
                LOGGER.debug("MFV detected, arPrimaryRaw is wider AR: {} height: {}", (Object)String.format("%.5f", Float.valueOf(videoInfo.arPrimaryRaw)), (Object)videoInfo.height);
                LOGGER.debug("MFV detected, arSecondary is higher AR: {}", (Object)String.format("%.5f", Float.valueOf(videoInfo.arSecondary)));
            }
        } else {
            this.getNewHeight(videoInfo);
            videoInfo.height = videoInfo.heightPrimary;
            videoInfo.width = Math.round((float)videoInfo.height * videoInfo.arPrimaryRaw / videoInfo.arSample);
            videoInfo.arSecondary = 0.0f;
            LOGGER.debug("Multi format:      no                                              AR_Secondary ({}% of samples) < MFV Detection Threshold ({}% of samples)", (Object)String.format("%.2f", Float.valueOf(videoInfo.arSecondaryPct)), (Object)String.format("%.2f", Float.valueOf(this.multiFormatThresholdPct)));
        }
    }

    protected float roundAR(float ar) {
        float rounded = 999.0f;
        boolean roundNearest = false;
        if (this.arCustomList.isEmpty()) {
            LOGGER.info("Aspect ratio list is empty. Round to two decimal points ");
            return (float)Math.round(ar * 100.0f) / 100.0f;
        }
        if (this.roundUp) {
            float arDelta = 999.0f;
            for (Float arProvided : this.arCustomList) {
                if (Math.abs(arProvided.floatValue() - ar) <= this.roundUpThresholdPct / 100.0f) {
                    rounded = this.roundAR_nearest(ar);
                    roundNearest = true;
                    break;
                }
                if (!(arDelta > arProvided.floatValue() - ar) || !(arProvided.floatValue() - ar >= 0.0f)) continue;
                arDelta = arProvided.floatValue() - ar;
                rounded = arProvided.floatValue();
            }
            if (rounded == 999.0f) {
                rounded = this.arCustomList.get(this.arCustomList.size() - 1).floatValue();
            }
        } else {
            rounded = this.roundAR_nearest(ar);
            roundNearest = true;
        }
        if (!roundNearest) {
            LOGGER.debug("Rounded to next wider Aspect Ratio from list");
        }
        return rounded;
    }

    protected float roundAR_nearest(float ar) {
        float rounded = 999.0f;
        if (this.arCustomList.size() == 1) {
            return this.arCustomList.get(0).floatValue();
        }
        for (int idx = 0; idx < this.arCustomList.size() - 1; ++idx) {
            float maxAr = (float)Math.sqrt(this.arCustomList.get(idx).doubleValue() * this.arCustomList.get(idx + 1).doubleValue());
            if (!(ar < maxAr)) continue;
            rounded = this.arCustomList.get(idx).floatValue();
            break;
        }
        if (rounded == 999.0f) {
            rounded = this.arCustomList.get(this.arCustomList.size() - 1).floatValue();
        }
        LOGGER.debug("Rounded to nearest Aspect Ratio from list");
        return rounded;
    }

    protected void getNewHeight(VideoInfo videoInfo) {
        int widthPrimary = videoInfo.widthMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).findFirst().map(Map.Entry::getKey).orElse(videoInfo.width);
        videoInfo.heightPrimary = videoInfo.heightMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).findFirst().map(Map.Entry::getKey).orElse(videoInfo.height);
        videoInfo.heightSecondary = videoInfo.heightMap.entrySet().stream().filter(entry -> (float)((Integer)entry.getKey()).intValue() >= (float)widthPrimary / (videoInfo.arPrimaryRaw + this.arSecondaryDelta) && (float)((Integer)entry.getKey()).intValue() <= (float)widthPrimary / (videoInfo.arPrimaryRaw - this.arSecondaryDelta)).sorted(Map.Entry.comparingByValue().reversed()).findFirst().map(Map.Entry::getKey).orElse(videoInfo.heightPrimary);
    }

    protected float getSampleAR(MediaFile mediaFile) {
        String pixelAspectRatio = MediaFileHelper.getMediaInfoDirect(mediaFile, MediaInfo.StreamKind.Video, 0, "PixelAspectRatio");
        if (StringUtils.isNotEmpty((CharSequence)pixelAspectRatio)) {
            return Float.parseFloat(pixelAspectRatio);
        }
        return 0.0f;
    }

    protected boolean canRun() {
        if (!FFmpeg.isAvailable()) {
            LOGGER.warn("ffmpeg is not available");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "task.ard", "message.ard.ffmpegmissing"));
            return false;
        }
        return true;
    }

    protected static class VideoInfo {
        int width;
        int height;
        int duration;
        int bitDepth;
        int darkLevel;
        int sampleCount = 0;
        float arSample = 0.0f;
        float arMeasured = 0.0f;
        float arCalculated = 0.0f;
        float arPrimary = 0.0f;
        float arPrimaryRaw = 0.0f;
        float arSecondary = 0.0f;
        float arSecondaryPct = 0.0f;
        float sampleSkipAdjustement = 0.0f;
        int heightPrimary;
        int heightSecondary;
        Map<Float, Integer> arMap = new HashMap<Float, Integer>();
        Map<Integer, Integer> widthMap = new HashMap<Integer, Integer>();
        Map<Integer, Integer> heightMap = new HashMap<Integer, Integer>();

        protected VideoInfo() {
        }
    }
}

