/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class ExportTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportTask.class);
    private MediaEntityExporter exporter;
    private List<? extends MediaEntity> entities;
    private Path exportPath;

    public ExportTask(String taskName, MediaEntityExporter exporter, List<? extends MediaEntity> entities, Path exportPath) {
        super(taskName);
        this.exporter = exporter;
        this.entities = entities;
        this.exportPath = exportPath;
    }

    @Override
    protected void doInBackground() {
        this.start();
        try {
            this.exporter.export(this.entities, this.exportPath);
        }
        catch (Exception e) {
            LOGGER.error("could not export template: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void cancel() {
        this.exporter.cancel();
        super.cancel();
    }

    @Override
    public void callback(Object obj) {
    }
}

