/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class MediaEntityActorImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityActorImageFetcherTask.class);
    protected MediaEntity mediaEntity;
    protected Set<Person> persons;
    protected boolean cleanup = true;

    protected abstract Logger getLogger();

    @Override
    public void run() {
        try {
            Path actorsDir = this.mediaEntity.getPathNIO().resolve(".actors");
            if (this.cleanup && Files.exists(actorsDir, new LinkOption[0]) && !Files.isSymbolicLink(actorsDir)) {
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(actorsDir);){
                    for (Path path : directoryStream) {
                        if (Thread.interrupted()) {
                            return;
                        }
                        if (!Utils.isRegularFile(path) || !path.getFileName().toString().matches("(?i).*\\.(tbn|png|jpg|webp)") || path.getFileName().toString().startsWith(".")) continue;
                        boolean found = false;
                        String actorImage = FilenameUtils.getBaseName((String)path.getFileName().toString()).replace("_", " ");
                        for (Person actor : this.persons) {
                            if (!actor.getName().equals(actorImage)) continue;
                            found = true;
                            if (FilenameUtils.getExtension((String)path.getFileName().toString()).equalsIgnoreCase(UrlUtil.getExtension(actor.getThumbUrl()))) break;
                            found = false;
                            break;
                        }
                        if (found) continue;
                        Utils.deleteFileWithBackup(path, this.mediaEntity.getDataSource());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (Person person : this.persons) {
                try {
                    this.downloadPersonImage(person);
                }
                catch (InterruptedIOException | InterruptedException e) {
                    LOGGER.info("artwork download aborted");
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.warn("Problem downloading actor artwork: {}", (Object)e.getMessage());
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
        }
    }

    private void downloadPersonImage(Person person) throws Exception {
        String actorImageFilename = person.getNameForStorage();
        if (StringUtils.isBlank((CharSequence)actorImageFilename)) {
            return;
        }
        Path actorsDir = this.mediaEntity.getPathNIO().resolve(".actors");
        if (!Files.isDirectory(actorsDir, new LinkOption[0])) {
            Files.createDirectory(actorsDir, new FileAttribute[0]);
        }
        Path actorImage = actorsDir.resolve(actorImageFilename);
        if (StringUtils.isNotEmpty((CharSequence)person.getThumbUrl())) {
            Path cache = ImageCache.getCachedFile(person.getThumbUrl());
            if (cache != null) {
                LOGGER.debug("using cached version of: {}", (Object)person.getThumbUrl());
                Utils.copyFileSafe(cache, actorImage, true);
                ImageCache.cacheImageSilently(actorImage);
            } else {
                ImageUtils.downloadImage(person.getThumbUrl(), actorImage.getParent(), actorImageFilename);
                ImageCache.invalidateCachedImage(actorImage);
                ImageCache.cacheImageSilently(actorImage);
            }
        }
    }
}

