/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import com.github.kiulian.downloader.downloader.response.Response;
import com.github.kiulian.downloader.model.Extension;
import com.github.kiulian.downloader.model.videos.VideoInfo;
import com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import com.github.kiulian.downloader.model.videos.formats.Format;
import com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import com.github.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import com.github.kiulian.downloader.model.videos.quality.AudioQuality;
import com.github.kiulian.downloader.model.videos.quality.VideoQuality;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmMuxer;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.TrailerQuality;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.http.StreamingUrl;
import org.tinymediamanager.thirdparty.yt.YTDownloader;

public abstract class YTDownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(YTDownloadTask.class);
    private static final int MAX_CHUNK_SIZE = 0xA00000;
    private final MediaTrailer mediaTrailer;
    private final TrailerQuality desiredQuality;
    private VideoInfo video;
    private long timestamp1 = System.nanoTime();
    private long length;
    private long bytesDone = 0L;
    private long bytesDonePrevious = 0L;
    private double speed = 0.0;

    protected YTDownloadTask(MediaTrailer mediaTrailer, TrailerQuality desiredQuality) {
        super(TmmResourceBundle.getString("trailer.download") + " - " + mediaTrailer.getName(), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.mediaTrailer = mediaTrailer;
        this.desiredQuality = desiredQuality;
        this.setTaskDescription(mediaTrailer.getName());
    }

    protected abstract Path getDestinationWoExtension();

    protected abstract MediaEntity getMediaEntityToAdd();

    @Override
    protected void doInBackground() {
        if (!this.isFeatureEnabled()) {
            return;
        }
        try {
            String id = "";
            Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(this.mediaTrailer.getUrl());
            if (matcher.matches()) {
                id = matcher.group(5);
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            YTDownloader downloader = new YTDownloader();
            Response videoInfo = downloader.getVideoInfo(new RequestVideoInfo(id));
            if (!videoInfo.ok()) {
                return;
            }
            this.video = (VideoInfo)videoInfo.data();
            VideoWithAudioFormat audioVideoFormat = this.findCombinedStream();
            if (audioVideoFormat != null) {
                this.downloadCombinedStream(audioVideoFormat);
                return;
            }
            Format[] streams = this.findSeparateStreams();
            if (streams.length == 2) {
                this.downloadSeparateStreams((VideoFormat)streams[0], (AudioFormat)streams[1]);
                return;
            }
            streams = this.findBestStreams();
            if (streams.length == 1 && streams[0] instanceof VideoWithAudioFormat) {
                this.downloadCombinedStream((VideoWithAudioFormat)streams[0]);
            } else if (streams.length == 2) {
                this.downloadSeparateStreams((VideoFormat)streams[0], (AudioFormat)streams[1]);
            }
        }
        catch (Error | Exception e) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"Youtube trailer downloader", "message.trailer.downloadfailed", new String[]{this.getMediaEntityToAdd().getTitle()}));
            this.setState(TmmTaskHandle.TaskState.FAILED);
            LOGGER.error("download of Trailer {} failed", (Object)this.mediaTrailer.getUrl());
            LOGGER.debug("trailer download - '{}'", (Object)e.getMessage());
        }
    }

    private VideoWithAudioFormat findCombinedStream() {
        VideoWithAudioFormat audioVideoFormat;
        block4: {
            String q;
            List audioVideoFormats;
            block5: {
                audioVideoFormat = null;
                audioVideoFormats = this.video.videoWithAudioFormats();
                if ("unknown".equalsIgnoreCase(this.mediaTrailer.getQuality())) break block5;
                for (VideoWithAudioFormat format : audioVideoFormats) {
                    if (format.videoQuality() != this.getVideoQuality(this.mediaTrailer.getQuality()) || Extension.MPEG4 != format.extension()) continue;
                    audioVideoFormat = format;
                    break block4;
                }
                break block4;
            }
            if (this.desiredQuality == null) break block4;
            VideoQuality quality = null;
            Iterator<String> iterator = this.desiredQuality.getPossibleQualities().iterator();
            while (iterator.hasNext() && (quality = this.getVideoQuality(q = iterator.next())) == null) {
            }
            if (quality != null) {
                for (VideoWithAudioFormat format : audioVideoFormats) {
                    if (format.videoQuality() != quality || Extension.MPEG4 != format.extension()) continue;
                    audioVideoFormat = format;
                    break;
                }
            }
        }
        return audioVideoFormat;
    }

    private VideoQuality getVideoQuality(String text) {
        switch (text.toLowerCase(Locale.ROOT)) {
            case "unknown": {
                return VideoQuality.unknown;
            }
            case "3072p": {
                return VideoQuality.highres;
            }
            case "2880p": {
                return VideoQuality.hd2880p;
            }
            case "2160p": {
                return VideoQuality.hd2160;
            }
            case "1440p": {
                return VideoQuality.hd1440;
            }
            case "1080p": {
                return VideoQuality.hd1080;
            }
            case "720p": {
                return VideoQuality.hd720;
            }
            case "480p": {
                return VideoQuality.large;
            }
            case "360p": {
                return VideoQuality.medium;
            }
            case "240p": {
                return VideoQuality.small;
            }
            case "144p": {
                return VideoQuality.tiny;
            }
        }
        return null;
    }

    private Format[] findSeparateStreams() {
        VideoFormat videoFormat = this.findVideo(this.video, this.getVideoQuality(this.mediaTrailer.getQuality()), Extension.MPEG4);
        AudioFormat audioFormat = this.findBestAudio(this.video, Extension.M4A);
        if (videoFormat != null && audioFormat != null) {
            return new Format[]{videoFormat, audioFormat};
        }
        return new Format[0];
    }

    private Format[] findBestStreams() {
        Format videoStreamInBestQuality = null;
        VideoQuality bestQuality = null;
        for (Format format : this.video.formats()) {
            VideoWithAudioFormat audioVideoFormat;
            if (format instanceof VideoWithAudioFormat) {
                audioVideoFormat = (VideoWithAudioFormat)format;
                if (bestQuality == null) {
                    bestQuality = audioVideoFormat.videoQuality();
                    videoStreamInBestQuality = format;
                    continue;
                }
                if (bestQuality.ordinal() > audioVideoFormat.videoQuality().ordinal()) continue;
                bestQuality = audioVideoFormat.videoQuality();
                videoStreamInBestQuality = format;
                continue;
            }
            if (!(format instanceof VideoFormat)) continue;
            audioVideoFormat = (VideoFormat)format;
            if (bestQuality == null) {
                bestQuality = audioVideoFormat.videoQuality();
                videoStreamInBestQuality = format;
                continue;
            }
            if (bestQuality.ordinal() >= audioVideoFormat.videoQuality().ordinal()) continue;
            bestQuality = audioVideoFormat.videoQuality();
            videoStreamInBestQuality = format;
        }
        if (videoStreamInBestQuality != null) {
            AudioFormat audioFormat;
            if (videoStreamInBestQuality instanceof VideoWithAudioFormat) {
                return new Format[]{videoStreamInBestQuality};
            }
            if (videoStreamInBestQuality instanceof VideoFormat && (audioFormat = this.findBestAudio(this.video, Extension.M4A)) != null) {
                return new Format[]{videoStreamInBestQuality, audioFormat};
            }
        }
        return new Format[0];
    }

    private VideoFormat findVideo(VideoInfo video, VideoQuality videoQuality, Extension extension) {
        for (VideoFormat format : video.videoFormats()) {
            if (format.videoQuality() != videoQuality || !format.extension().equals(extension)) continue;
            return format;
        }
        LOGGER.debug("could not find video with quality {} and format {}", (Object)videoQuality, (Object)extension);
        return null;
    }

    private AudioFormat findBestAudio(VideoInfo video, Extension extension) {
        for (AudioQuality quality : this.getAudioQualityList()) {
            for (AudioFormat format : video.audioFormats()) {
                if (format.audioQuality() != quality || !format.extension().equals(extension)) continue;
                return format;
            }
        }
        LOGGER.debug("Could not find audio format for extension {}", (Object)extension);
        return null;
    }

    private List<AudioQuality> getAudioQualityList() {
        ArrayList<AudioQuality> list = new ArrayList<AudioQuality>();
        list.add(AudioQuality.high);
        list.add(AudioQuality.medium);
        list.add(AudioQuality.low);
        return list;
    }

    private List<VideoQuality> getVideoQualityList() {
        ArrayList<VideoQuality> list = new ArrayList<VideoQuality>();
        list.add(VideoQuality.highres);
        list.add(VideoQuality.hd2880p);
        list.add(VideoQuality.hd2160);
        list.add(VideoQuality.hd1440);
        list.add(VideoQuality.hd1080);
        list.add(VideoQuality.hd720);
        list.add(VideoQuality.large);
        list.add(VideoQuality.medium);
        list.add(VideoQuality.small);
        list.add(VideoQuality.tiny);
        return list;
    }

    private void downloadCombinedStream(VideoWithAudioFormat audioVideoFormat) throws Exception {
        MediaEntity mediaEntity = this.getMediaEntityToAdd();
        Path tempFile = this.download((Format)audioVideoFormat);
        if (tempFile != null) {
            Path trailer = this.getDestinationWoExtension().getParent().resolve(this.getDestinationWoExtension().getFileName() + ".mp4");
            Utils.deleteFileSafely(trailer);
            if (!Files.exists(trailer.getParent(), new LinkOption[0])) {
                Files.createDirectory(trailer.getParent(), new FileAttribute[0]);
            }
            Utils.moveFileSafe(tempFile, trailer);
            MediaFile mf = new MediaFile(trailer, MediaFileType.TRAILER);
            mf.gatherMediaInformation();
            mediaEntity.removeFromMediaFiles(mf);
            mediaEntity.addToMediaFiles(mf);
            mediaEntity.saveToDb();
        }
    }

    private void downloadSeparateStreams(VideoFormat videoFormat, AudioFormat audioFormat) throws Exception {
        Path trailer;
        TmmMuxer muxer;
        MediaEntity mediaEntity = this.getMediaEntityToAdd();
        if (videoFormat == null || audioFormat == null) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"Youtube trailer downloader", "message.trailer.unsupported", new String[]{mediaEntity.getTitle()}));
            LOGGER.error("Could not download movieTrailer for {}", (Object)mediaEntity.getTitle());
            this.setState(TmmTaskHandle.TaskState.FAILED);
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Path> futureVideo = executorService.submit(() -> {
            try {
                LOGGER.debug("Downloading video....");
                return this.download((Format)videoFormat);
            }
            catch (Exception e) {
                LOGGER.error("Could not download video stream: {}", (Object)e.getMessage());
                this.setState(TmmTaskHandle.TaskState.FAILED);
                return null;
            }
        });
        Future<Path> futureAudio = executorService.submit(() -> {
            try {
                LOGGER.debug("Downloading audio....");
                return this.download((Format)audioFormat);
            }
            catch (Exception e) {
                LOGGER.error("Could not download audio stream: {}", (Object)e.getMessage());
                this.setState(TmmTaskHandle.TaskState.FAILED);
                return null;
            }
        });
        Path videoFile = futureVideo.get();
        Path audioFile = futureAudio.get();
        if (videoFile != null && audioFile != null) {
            LOGGER.trace("Muxing...");
            muxer = new TmmMuxer(audioFile, videoFile);
            trailer = this.getDestinationWoExtension().getParent().resolve(this.getDestinationWoExtension().getFileName() + ".mp4");
            if (!Files.exists(trailer.getParent(), new LinkOption[0])) {
                Files.createDirectory(trailer.getParent(), new FileAttribute[0]);
            }
        } else {
            this.setState(TmmTaskHandle.TaskState.FAILED);
            return;
        }
        muxer.mergeAudioVideo(trailer);
        LOGGER.trace("Muxing finished");
        MediaFile mf = new MediaFile(trailer, MediaFileType.TRAILER);
        mf.gatherMediaInformation();
        mediaEntity.removeFromMediaFiles(mf);
        mediaEntity.addToMediaFiles(mf);
        mediaEntity.saveToDb();
        Utils.deleteFileSafely(videoFile);
        Utils.deleteFileSafely(audioFile);
    }

    private Path download(Format format) throws IOException, InterruptedException {
        Path tempDir = Paths.get(Utils.getTempFolder(), new String[0]);
        if (!Files.exists(tempDir, new LinkOption[0])) {
            Files.createDirectory(tempDir, new FileAttribute[0]);
        }
        String fileName = format.itag().isVideo() ? this.video.details().title() + "(V)." + format.extension().value() : this.video.details().title() + "(A)." + format.extension().value();
        Path outputFile = tempDir.resolve(Utils.cleanFilename(fileName));
        this.addContentLength(format.contentLength());
        int rangeStart = 0;
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile.toFile());){
            while ((long)rangeStart < format.contentLength() - 1L) {
                StreamingUrl url = new StreamingUrl(format.url());
                int remaining = (int)(format.contentLength() - (long)rangeStart - 1L);
                int chunkSize = remaining > 0xA00000 ? ThreadLocalRandom.current().nextInt(0x980000, 0x9E6666) : remaining;
                url.addHeader("Range", "bytes=" + rangeStart + "-" + (rangeStart + chunkSize));
                try (InputStream is = url.getInputStream();
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    int count;
                    byte[] buffer = new byte[2048];
                    while ((count = bis.read(buffer, 0, buffer.length)) != -1) {
                        if (this.cancel) {
                            Thread.currentThread().interrupt();
                            LOGGER.info("download of {} aborted", (Object)url);
                            Path path = null;
                            return path;
                        }
                        fileOutputStream.write(buffer, 0, count);
                        this.addBytesDone(count);
                    }
                }
                rangeStart = rangeStart + chunkSize + 1;
            }
            Utils.flushFileOutputStreamToDisk(fileOutputStream);
        }
        return outputFile;
    }

    private synchronized void addContentLength(long length) {
        this.length += length;
    }

    private synchronized void addBytesDone(long count) {
        this.bytesDone += count;
        long timestamp2 = System.nanoTime();
        if (timestamp2 - this.timestamp1 > 250000000L) {
            this.speed = (this.speed + (double)(this.bytesDone - this.bytesDonePrevious) / ((double)(timestamp2 - this.timestamp1) / 1.0E9)) / 2.0;
            this.timestamp1 = timestamp2;
            this.bytesDonePrevious = this.bytesDone;
            if (this.length > 0L) {
                this.publishState(this.formatBytesForOutput(this.bytesDone) + "/" + this.formatBytesForOutput(this.length) + " @" + this.formatSpeedForOutput(this.speed), (int)(this.bytesDone * 100L / this.length));
            } else {
                this.setWorkUnits(0);
                this.publishState(this.formatBytesForOutput(this.bytesDone) + " @" + this.formatSpeedForOutput(this.speed), 0);
            }
        }
    }

    private String formatBytesForOutput(long bytes) {
        return String.format("%.2fM", (double)bytes / 1000000.0);
    }

    private String formatSpeedForOutput(double speed) {
        return String.format("%.2fkB/s", speed / 1000.0);
    }
}

