/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowExtraImageFetcherTask;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.thirdparty.FFmpeg;
import org.tinymediamanager.thirdparty.VSMeta;

public class TvShowArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowArtworkHelper.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile(".*?(\\d+)$");

    private TvShowArtworkHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadArtwork(TvShow show, MediaFileType type) {
        if (type == MediaFileType.EXTRAFANART) {
            TvShowArtworkHelper.downloadExtraArtwork(show, type);
            return;
        }
        String url = show.getArtworkUrl(type);
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            ArrayList<Enum> fileNamings = new ArrayList<Enum>();
            switch (type) {
                case FANART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getFanartFilenames());
                    break;
                }
                case POSTER: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getPosterFilenames());
                    break;
                }
                case BANNER: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getBannerFilenames());
                    break;
                }
                case LOGO: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getLogoFilenames());
                    break;
                }
                case CLEARLOGO: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames());
                    break;
                }
                case CHARACTERART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames());
                    break;
                }
                case CLEARART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getClearartFilenames());
                    break;
                }
                case THUMB: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getThumbFilenames());
                    break;
                }
                case KEYART: {
                    fileNamings.addAll(TvShowModuleManager.getInstance().getSettings().getKeyartFilenames());
                    break;
                }
                default: {
                    return;
                }
            }
            ArrayList<String> filenames = new ArrayList<String>();
            for (IFileNaming iFileNaming : fileNamings) {
                String filename = iFileNaming.getFilename("", Utils.getArtworkExtensionFromUrl(url));
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                filenames.add(filename);
            }
            if (!filenames.isEmpty()) {
                MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(show, url, MediaFileType.getMediaArtworkType(type), filenames);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
        finally {
            if (url.startsWith("file:")) {
                show.removeArtworkUrl(type);
            }
        }
    }

    public static void downloadMissingArtwork(TvShow tvShow, List<MediaArtwork> artwork) {
        artwork.sort(new MediaArtwork.MediaArtworkComparator(TvShowModuleManager.getInstance().getSettings().getScraperLanguage().name()));
        if (tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.POSTER);
        }
        if (tvShow.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            TvShowArtworkHelper.setBestFanart(tvShow, artwork);
        }
        if (tvShow.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (tvShow.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (tvShow.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (tvShow.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (tvShow.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        if (tvShow.getMediaFiles(MediaFileType.CHARACTERART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CHARACTERART);
        }
        if (tvShow.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.KEYART);
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER))) {
                for (MediaArtwork art : artwork) {
                    if (art.getSeason() != season.getSeason()) continue;
                    tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                    TvShowArtworkHelper.downloadSeasonPoster(tvShow, art.getSeason());
                }
            }
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_FANART))) {
                for (MediaArtwork art : artwork) {
                    if (art.getSeason() != season.getSeason()) continue;
                    tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_FANART);
                    TvShowArtworkHelper.downloadSeasonFanart(tvShow, art.getSeason());
                }
            }
            if (StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER))) {
                for (MediaArtwork art : artwork) {
                    if (art.getSeason() != season.getSeason()) continue;
                    tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                    TvShowArtworkHelper.downloadSeasonBanner(tvShow, art.getSeason());
                }
            }
            if (!StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB))) continue;
            for (MediaArtwork art : artwork) {
                if (art.getSeason() != season.getSeason()) continue;
                tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                TvShowArtworkHelper.downloadSeasonThumb(tvShow, art.getSeason());
            }
        }
        tvShow.saveToDb();
    }

    private static void setBestArtwork(TvShow tvShow, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            tvShow.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.getMediaFileType(type));
            break;
        }
    }

    private static void setBestFanart(TvShow tvShow, List<MediaArtwork> artwork) {
        ArrayList<MediaArtwork> sortedArtwork = new ArrayList<MediaArtwork>(artwork);
        MediaArtwork fanartWoText = null;
        for (MediaArtwork art : sortedArtwork) {
            if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals("")) continue;
            fanartWoText = art;
            break;
        }
        if (fanartWoText != null) {
            sortedArtwork.add(0, fanartWoText);
        }
        for (MediaArtwork art : sortedArtwork) {
            if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            tvShow.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.BACKGROUND));
            TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.BACKGROUND));
            break;
        }
    }

    public static boolean hasMissingArtwork(TvShow tvShow, List<TvShowScraperMetadataConfig> config) {
        if (config.contains(TvShowScraperMetadataConfig.POSTER) && !TvShowModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.FANART) && !TvShowModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.BANNER) && !TvShowModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.DISCART) && !TvShowModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.LOGO) && !TvShowModuleManager.getInstance().getSettings().getLogoFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARLOGO) && !TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARART) && !TvShowModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.THUMB) && !TvShowModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.CHARACTERART) && !TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.CHARACTERART).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.KEYART) && !TvShowModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            return true;
        }
        if (config.contains(TvShowScraperMetadataConfig.EXTRAFANART) && TvShowModuleManager.getInstance().getSettings().isImageExtraFanart() && !TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty() && tvShow.getMediaFiles(MediaFileType.EXTRAFANART).isEmpty()) {
            return true;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            if (config.contains(TvShowScraperMetadataConfig.SEASON_POSTER) && !TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER))) {
                return true;
            }
            if (config.contains(TvShowScraperMetadataConfig.SEASON_FANART) && !TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_FANART))) {
                return true;
            }
            if (config.contains(TvShowScraperMetadataConfig.SEASON_BANNER) && !TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames().isEmpty() && StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER))) {
                return true;
            }
            if (!config.contains(TvShowScraperMetadataConfig.SEASON_THUMB) || TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames().isEmpty() || !StringUtils.isBlank((CharSequence)season.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMissingArtwork(TvShowEpisode episode, List<TvShowEpisodeScraperMetadataConfig> config) {
        return config.contains(TvShowEpisodeScraperMetadataConfig.THUMB) && !TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames().isEmpty() && episode.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void downloadSeasonArtwork(TvShow show, int season, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                TvShowArtworkHelper.downloadSeasonPoster(show, season);
                break;
            }
            case SEASON_FANART: {
                TvShowArtworkHelper.downloadSeasonFanart(show, season);
                break;
            }
            case SEASON_BANNER: {
                TvShowArtworkHelper.downloadSeasonBanner(show, season);
                break;
            }
            case SEASON_THUMB: {
                TvShowArtworkHelper.downloadSeasonThumb(show, season);
                break;
            }
        }
    }

    private static void downloadSeasonPoster(TvShow show, int season) {
        String seasonPosterUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_POSTER);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonPosterNaming seasonPosterNaming : TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames()) {
            String filename = seasonPosterNaming.getFilename(show, season, Utils.getArtworkExtensionFromUrl(seasonPosterUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonPosterNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = show.getPathNIO().resolve(filename);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonPosterUrl, MediaArtwork.MediaArtworkType.SEASON_POSTER);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonPosterUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        }
    }

    private static void downloadSeasonFanart(TvShow show, int season) {
        String seasonFanartUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_FANART);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonFanartNaming seasonFanartNaming : TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames()) {
            String filename = seasonFanartNaming.getFilename(show, season, Utils.getArtworkExtensionFromUrl(seasonFanartUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonFanartNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = show.getPathNIO().resolve(filename);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonFanartUrl, MediaArtwork.MediaArtworkType.SEASON_FANART);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonFanartUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_FANART);
        }
    }

    private static void downloadSeasonBanner(TvShow show, int season) {
        String seasonBannerUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_BANNER);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonBannerNaming seasonBannerNaming : TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames()) {
            String filename = seasonBannerNaming.getFilename(show, season, Utils.getArtworkExtensionFromUrl(seasonBannerUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonBannerNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = Paths.get(show.getPathNIO() + File.separator + filename, new String[0]);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonBannerUrl, MediaArtwork.MediaArtworkType.SEASON_BANNER);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonBannerUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        }
    }

    private static void downloadSeasonThumb(TvShow show, int season) {
        String seasonThumbUrl = show.getSeasonArtworkUrl(season, MediaArtwork.MediaArtworkType.SEASON_THUMB);
        TvShowSeason tvShowSeason = null;
        for (TvShowSeason s : show.getSeasons()) {
            if (s.getSeason() != season) continue;
            tvShowSeason = s;
            break;
        }
        for (TvShowSeasonThumbNaming seasonThumbNaming : TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames()) {
            String filename = seasonThumbNaming.getFilename(show, season, Utils.getArtworkExtensionFromUrl(seasonThumbUrl));
            if (StringUtils.isBlank((CharSequence)filename)) {
                LOGGER.warn("empty filename for artwork: {} - {}", (Object)seasonThumbNaming.name(), (Object)show);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                continue;
            }
            Path destFile = show.getPathNIO().resolve(filename);
            if (!Files.exists(destFile.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectory(destFile.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("could not create folder: {} - {}", (Object)destFile.getParent(), (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, show, "tvshow.seasondownload.failed"));
                    continue;
                }
            }
            SeasonArtworkImageFetcher task = new SeasonArtworkImageFetcher(show, destFile, tvShowSeason, seasonThumbUrl, MediaArtwork.MediaArtworkType.SEASON_THUMB);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (tvShowSeason != null && seasonThumbUrl.startsWith("file:")) {
            tvShowSeason.removeArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        }
    }

    public static void setArtwork(TvShow tvShow, List<MediaArtwork> artwork, List<TvShowScraperMetadataConfig> config, boolean overwrite) {
        String url;
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        artwork.sort(new MediaArtwork.MediaArtworkComparator(TvShowModuleManager.getInstance().getSettings().getScraperLanguage().name()));
        if (config.contains(TvShowScraperMetadataConfig.POSTER) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.POSTER)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.POSTER);
        }
        if (config.contains(TvShowScraperMetadataConfig.FANART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.FANART)))) {
            TvShowArtworkHelper.setBestFanart(tvShow, artwork);
        }
        if (config.contains(TvShowScraperMetadataConfig.BANNER) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.BANNER)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (config.contains(TvShowScraperMetadataConfig.LOGO) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.LOGO)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARLOGO) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.CLEARLOGO)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (config.contains(TvShowScraperMetadataConfig.CLEARART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.CLEARART)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (config.contains(TvShowScraperMetadataConfig.THUMB) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.THUMB)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (config.contains(TvShowScraperMetadataConfig.CHARACTERART)) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.CHARACTERART);
        }
        if (config.contains(TvShowScraperMetadataConfig.KEYART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.KEYART)))) {
            TvShowArtworkHelper.setBestArtwork(tvShow, artwork, MediaArtwork.MediaArtworkType.KEYART);
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_POSTER)) {
            HashMap<Integer, String> seasonPosters = new HashMap<Integer, String>();
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.SEASON_POSTER || art.getSeason() < 0 || !overwrite && !StringUtils.isBlank((CharSequence)tvShow.getSeasonArtwork(art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_POSTER)) || !StringUtils.isBlank((CharSequence)(url = (String)seasonPosters.get(art.getSeason())))) continue;
                tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                TvShowArtworkHelper.downloadSeasonArtwork(tvShow, art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                seasonPosters.put(art.getSeason(), art.getDefaultUrl());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_FANART)) {
            HashMap<Integer, String> seasonFanarts = new HashMap<Integer, String>();
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.SEASON_FANART || art.getSeason() < 0 || !overwrite && !StringUtils.isBlank((CharSequence)tvShow.getSeasonArtwork(art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_FANART)) || !StringUtils.isBlank((CharSequence)(url = (String)seasonFanarts.get(art.getSeason())))) continue;
                tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_FANART);
                TvShowArtworkHelper.downloadSeasonArtwork(tvShow, art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_FANART);
                seasonFanarts.put(art.getSeason(), art.getDefaultUrl());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_BANNER)) {
            HashMap<Integer, String> seasonBanners = new HashMap<Integer, String>();
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.SEASON_BANNER || art.getSeason() < 0 || !overwrite && !StringUtils.isBlank((CharSequence)tvShow.getSeasonArtwork(art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_BANNER)) || !StringUtils.isBlank((CharSequence)(url = (String)seasonBanners.get(art.getSeason())))) continue;
                tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                TvShowArtworkHelper.downloadSeasonArtwork(tvShow, art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                seasonBanners.put(art.getSeason(), art.getDefaultUrl());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.SEASON_THUMB)) {
            HashMap<Integer, String> seasonThumbs = new HashMap<Integer, String>();
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.SEASON_THUMB || art.getSeason() < 0 || !overwrite && !StringUtils.isBlank((CharSequence)tvShow.getSeasonArtwork(art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_THUMB)) || !StringUtils.isBlank((CharSequence)(url = (String)seasonThumbs.get(art.getSeason())))) continue;
                tvShow.setSeasonArtworkUrl(art.getSeason(), art.getDefaultUrl(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                TvShowArtworkHelper.downloadSeasonArtwork(tvShow, art.getSeason(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                seasonThumbs.put(art.getSeason(), art.getDefaultUrl());
            }
        }
        if (config.contains(TvShowScraperMetadataConfig.EXTRAFANART) && (overwrite || StringUtils.isBlank((CharSequence)tvShow.getArtworkFilename(MediaFileType.EXTRAFANART)))) {
            ArrayList<String> extrafanarts = new ArrayList<String>();
            if (TvShowModuleManager.getInstance().getSettings().isImageExtraFanart() && TvShowModuleManager.getInstance().getSettings().getImageExtraFanartCount() > 0) {
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                    extrafanarts.add(art.getDefaultUrl());
                    if (extrafanarts.size() < TvShowModuleManager.getInstance().getSettings().getImageExtraFanartCount()) continue;
                    break;
                }
                tvShow.setExtraFanartUrls(extrafanarts);
                if (!extrafanarts.isEmpty()) {
                    TvShowArtworkHelper.downloadArtwork(tvShow, MediaFileType.EXTRAFANART);
                }
            }
        }
        tvShow.saveToDb();
        tvShow.writeNFO();
    }

    private static void downloadExtraArtwork(TvShow tvShow, MediaFileType type) {
        TvShowExtraImageFetcherTask task = new TvShowExtraImageFetcherTask(tvShow, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static boolean extractArtworkFromVsmeta(TvShow tvShow, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        return TvShowArtworkHelper.extractArtworkFromVsmetaInternal(tvShow, vsMetaFile, artworkType);
    }

    public static boolean extractArtworkFromVsmeta(TvShowEpisode tvShowEpisode, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        return TvShowArtworkHelper.extractArtworkFromVsmetaInternal(tvShowEpisode, vsMetaFile, artworkType);
    }

    private static boolean extractArtworkFromVsmetaInternal(MediaEntity mediaEntity, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        byte[] bytes;
        List<Enum> fileNamings;
        block11: {
            VSMeta vsmeta;
            block10: {
                vsmeta = new VSMeta(vsMetaFile.getFileAsPath());
                if (!(mediaEntity instanceof TvShow)) break block10;
                switch (artworkType) {
                    case POSTER: {
                        fileNamings = TvShowModuleManager.getInstance().getSettings().getPosterFilenames();
                        bytes = vsmeta.getShowImageBytes();
                        break block11;
                    }
                    case BACKGROUND: {
                        fileNamings = TvShowModuleManager.getInstance().getSettings().getFanartFilenames();
                        bytes = vsmeta.getBackdropBytes();
                        break block11;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (mediaEntity instanceof TvShowEpisode && artworkType == MediaArtwork.MediaArtworkType.THUMB) {
                fileNamings = TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames();
                bytes = vsmeta.getPosterBytes();
            } else {
                return false;
            }
        }
        if (fileNamings.isEmpty() || bytes.length == 0) {
            return false;
        }
        String basename = FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)vsMetaFile.getFilename()));
        for (IFileNaming iFileNaming : fileNamings) {
            try {
                String filename = iFileNaming.getFilename(basename, "jpg");
                MediaFile mf = new MediaFile(vsMetaFile.getFileAsPath().getParent().resolve(filename), MediaFileType.getMediaFileType(artworkType));
                Files.write(mf.getFileAsPath(), bytes, new OpenOption[0]);
                mediaEntity.addToMediaFiles(mf);
            }
            catch (Exception e) {
                LOGGER.warn("could not extract VSMETA artwork: {}", (Object)e.getMessage());
            }
        }
        return true;
    }

    public static int getIndexOfArtwork(String filename) {
        String basename = FilenameUtils.getBaseName((String)filename);
        Matcher matcher = INDEX_PATTERN.matcher(basename);
        if (matcher.find() && matcher.groupCount() == 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                LOGGER.debug("could not parse index of '{}'- {}", (Object)filename, (Object)e.getMessage());
            }
        }
        return -1;
    }

    public static void createThumbWithFfmpeg(TvShowEpisode episode) throws Exception {
        if (episode.isDisc()) {
            throw new UnsupportedOperationException("This cannot be done for disc images");
        }
        Path tempFile = Paths.get(Utils.getTempFolder(), "ffmpeg-still." + System.currentTimeMillis() + ".jpg");
        MediaFile mf = episode.getMainVideoFile();
        String fileType = "." + FilenameUtils.getExtension((String)mf.getFilename().toLowerCase(Locale.ROOT));
        int seconds = Settings.getInstance().getFfmpegPercentage() * mf.getDuration() / 100;
        if (!Settings.getInstance().getAllSupportedFileTypes().contains(fileType)) {
            throw new UnsupportedOperationException("invalid video file for FFmpeg");
        }
        FFmpeg.createStill(mf.getFileAsPath(), tempFile, seconds);
        if (Files.exists(tempFile, new LinkOption[0])) {
            episode.removeAllMediaFiles(MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.THUMB));
            boolean first = true;
            String basename = FilenameUtils.getBaseName((String)mf.getFilename());
            for (TvShowEpisodeThumbNaming thumbNaming : TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames()) {
                Path thumb = episode.getPathNIO().resolve(thumbNaming.getFilename(basename, "jpg"));
                if (Files.exists(thumb, new LinkOption[0])) {
                    Utils.deleteFileSafely(thumb);
                }
                Utils.copyFileSafe(tempFile, thumb);
                if (first) {
                    episode.setArtwork(thumb, MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.THUMB));
                    episode.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.THUMB);
                    first = false;
                }
                MediaFile artwork = new MediaFile(thumb, MediaFileType.getMediaFileType(MediaArtwork.MediaArtworkType.THUMB));
                artwork.gatherMediaInformation();
                episode.addToMediaFiles(artwork);
            }
            episode.saveToDb();
        }
    }

    private static class SeasonArtworkImageFetcher
    implements Runnable {
        private TvShow tvShow;
        private TvShowSeason tvShowSeason;
        private MediaArtwork.MediaArtworkType artworkType;
        private Path destinationPath;
        private String filename;
        private String url;

        SeasonArtworkImageFetcher(TvShow show, Path destFile, TvShowSeason tvShowSeason, String url, MediaArtwork.MediaArtworkType type) {
            this.tvShow = show;
            this.destinationPath = destFile.getParent();
            this.filename = destFile.getFileName().toString();
            this.artworkType = type;
            this.tvShowSeason = tvShowSeason;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldFilename = "";
            if (this.tvShowSeason != null) {
                oldFilename = this.tvShow.getSeasonArtwork(this.tvShowSeason.getSeason(), this.artworkType);
                this.tvShowSeason.clearArtwork(this.artworkType);
            }
            LOGGER.debug("writing season artwork {}", (Object)this.filename);
            try {
                Path oldFile;
                Path destFile = ImageUtils.downloadImage(this.url, this.destinationPath, this.filename);
                if (StringUtils.isNotBlank((CharSequence)oldFilename) && !(oldFile = Paths.get(oldFilename, new String[0])).equals(destFile)) {
                    ImageCache.invalidateCachedImage(oldFile);
                    Utils.deleteFileSafely(oldFile);
                }
                if (this.tvShowSeason != null) {
                    MediaFile mf = new MediaFile(destFile, MediaFileType.getMediaFileType(this.artworkType));
                    mf.gatherMediaInformation();
                    this.tvShowSeason.setArtwork(mf);
                }
                ImageCache.invalidateCachedImage(destFile);
                ImageCache.cacheImageSilently(destFile);
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("fetch image {} - {}", (Object)this.url, (Object)e);
                if (this.tvShowSeason != null && !oldFilename.isEmpty()) {
                    MediaFile mf = new MediaFile(Paths.get(oldFilename, new String[0]), MediaFileType.getMediaFileType(this.artworkType));
                    mf.gatherMediaInformation();
                    this.tvShowSeason.setArtwork(mf);
                }
                ImageCache.invalidateCachedImage(Paths.get(oldFilename, new String[0]));
                ImageCache.cacheImageSilently(Paths.get(oldFilename, new String[0]));
            }
            finally {
                this.tvShow.saveToDb();
            }
        }
    }
}

