/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowEpisodePostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodePostProcessExecutor.class);

    public TvShowEpisodePostProcessExecutor(PostProcess postProcess) {
        super(postProcess);
    }

    @Override
    public void execute() {
        List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        for (TvShowEpisode episode : selectedEpisodes) {
            LOGGER.info("PostProcessing: START {}", (Object)this.postProcess);
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            mappings.put("tvShow", episode.getTvShow());
            mappings.put("season", episode.getTvShowSeason());
            mappings.put("episode", episode);
            String[] command = this.substituteTokens(mappings);
            try {
                this.executeCommand(command, episode);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Problem executing post process", (Throwable)e);
            }
        }
    }

    private String[] substituteTokens(Map<String, Object> mappings) {
        Engine engine = Engine.createEngine();
        engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new TvShowRenamer.TvShowNamedFirstCharacterRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        if (this.postProcess.getPath() == null) {
            String transformed = engine.transform(JmteUtils.morphTemplate(this.postProcess.getCommand(), TvShowRenamer.getTokenMap()), mappings);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(JmteUtils.morphTemplate(splitted[i], TvShowRenamer.getTokenMap()), mappings);
        }
        return splitted;
    }
}

