/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CustomNullStringSerializerProvider;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.NullKeySerializer;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public final class TvShowModuleManager
implements ITmmModule {
    private static final String MODULE_TITLE = "TV show management";
    private static final String TV_SHOW_DB = "tvshows.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowModuleManager.class);
    private static final int COMMIT_DELAY = 2000;
    private static TvShowModuleManager instance;
    private final List<String> startupMessages = new ArrayList<String>();
    private final Map<MediaEntity, Long> pendingChanges = new HashMap<MediaEntity, Long>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean enabled = false;
    private int autoCommitBufferSize = 8192;
    private MVStore mvStore;
    private ObjectWriter tvShowObjectWriter;
    private ObjectReader tvShowObjectReader;
    private ObjectWriter episodeObjectWriter;
    private ObjectReader episodeObjectReader;
    private MVMap<UUID, String> tvShowMap;
    private MVMap<UUID, String> episodeMap;
    private Timer databaseTimer;

    private TvShowModuleManager() {
        int bufferSize = Integer.getInteger("tmm.mvstore.buffersize", 8);
        if (2 <= bufferSize && bufferSize <= 64) {
            this.autoCommitBufferSize = 1024 * bufferSize;
        }
    }

    public static TvShowModuleManager getInstance() {
        if (instance == null) {
            instance = new TvShowModuleManager();
        }
        return instance;
    }

    public TvShowSettings getSettings() {
        return TvShowSettings.getInstance();
    }

    public TvShowList getTvShowList() {
        return TvShowList.getInstance();
    }

    @Override
    public String getModuleTitle() {
        return MODULE_TITLE;
    }

    @Override
    public void startUp() {
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.AUTO_DETECT_GETTERS, false)).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false)).configure(MapperFeature.AUTO_DETECT_SETTERS, false)).configure(MapperFeature.AUTO_DETECT_FIELDS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).addModule((Module)new BlackbirdModule())).build();
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializerProvider((DefaultSerializerProvider)new CustomNullStringSerializerProvider());
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        this.tvShowObjectWriter = objectMapper.writerFor(TvShow.class);
        this.tvShowObjectReader = objectMapper.readerFor(TvShow.class);
        this.episodeObjectWriter = objectMapper.writerFor(TvShowEpisode.class);
        this.episodeObjectReader = objectMapper.readerFor(TvShowEpisode.class);
        this.openDatabaseAndLoadTvShows();
        this.enabled = true;
        TimerTask databaseWriteTask = new TimerTask(){

            @Override
            public void run() {
                TvShowModuleManager.this.writePendingChanges();
            }
        };
        this.databaseTimer = new Timer();
        this.databaseTimer.schedule(databaseWriteTask, 2000L, 2000L);
    }

    private void openDatabaseAndLoadTvShows() {
        Path databaseFile = Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB);
        try {
            this.loadDatabase(databaseFile);
            return;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && e.getMessage().contains("file is locked")) {
                throw e;
            }
            if (this.mvStore != null && !this.mvStore.isClosed()) {
                this.mvStore.close();
            }
            LOGGER.error("Could not open database file: {}", (Object)e.getMessage());
            try {
                Utils.deleteFileSafely(Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.corrupted"));
                Utils.moveFileSafe(databaseFile, Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.corrupted"));
            }
            catch (Exception e2) {
                LOGGER.error("Could not move corrupted database to '{}' - '{}", (Object)"tvshows.db.corrupted", (Object)e2.getMessage());
            }
            LOGGER.info("try to restore the database from the backups");
            List<Path> backups = Utils.listFiles(Paths.get(Globals.BACKUP_FOLDER, new String[0]));
            backups.sort(Comparator.reverseOrder());
            boolean first = true;
            for (Path backup : backups) {
                if (!backup.getFileName().toString().startsWith("data.")) continue;
                if (first) {
                    first = false;
                    continue;
                }
                try {
                    Utils.unzipFile(backup, Paths.get("/", "data", TV_SHOW_DB), databaseFile);
                    this.loadDatabase(databaseFile);
                    this.startupMessages.add(TmmResourceBundle.getString("tvshow.loaddb.failed.restore"));
                    return;
                }
                catch (Exception e3) {
                    if (this.mvStore != null && !this.mvStore.isClosed()) {
                        this.mvStore.close();
                    }
                    LOGGER.error("Could not open database file from backup: {}", (Object)e3.getMessage());
                }
            }
            LOGGER.info("starting over with an empty database file");
            try {
                Utils.deleteFileSafely(databaseFile);
                this.loadDatabase(databaseFile);
                this.startupMessages.add(TmmResourceBundle.getString("tvshow.loaddb.failed"));
            }
            catch (Exception e1) {
                LOGGER.error("could not move old database file and create a new one: {}", (Object)e1.getMessage());
            }
            return;
        }
    }

    private void loadDatabase(final Path databaseFile) {
        Thread.UncaughtExceptionHandler exceptionHandler = new Thread.UncaughtExceptionHandler(){
            private int counter = 0;

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof IllegalStateException) {
                    if (this.counter < 10) {
                        ++this.counter;
                        return;
                    }
                    LOGGER.error("database corruption detected - try to recover");
                    TvShowModuleManager.this.mvStore.close();
                    try {
                        Utils.deleteFileSafely(Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.corrupted"));
                        Utils.moveFileSafe(databaseFile, Paths.get(Globals.BACKUP_FOLDER, "tvshows.db.corrupted"));
                    }
                    catch (Exception e1) {
                        LOGGER.error("Could not move corrupted database to '{}' - '{}", (Object)"tvshows.db.corrupted", (Object)e1.getMessage());
                    }
                    TvShowModuleManager.this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(TvShowModuleManager.this.autoCommitBufferSize).backgroundExceptionHandler((Thread.UncaughtExceptionHandler)this).open();
                    TvShowModuleManager.this.mvStore.setAutoCommitDelay(2000);
                    TvShowModuleManager.this.mvStore.setRetentionTime(0);
                    TvShowModuleManager.this.mvStore.setReuseSpace(true);
                    TvShowModuleManager.this.mvStore.setCacheSize(8);
                    TvShowModuleManager.this.tvShowMap = TvShowModuleManager.this.mvStore.openMap("tvshows");
                    TvShowModuleManager.this.episodeMap = TvShowModuleManager.this.mvStore.openMap("episodes");
                    for (TvShow tvShow : TvShowModuleManager.this.getTvShowList().getTvShows()) {
                        TvShowModuleManager.this.persistTvShow(tvShow);
                        for (TvShowEpisode episode : tvShow.getEpisodes()) {
                            TvShowModuleManager.this.persistEpisode(episode);
                        }
                    }
                    this.counter = 0;
                }
            }
        };
        this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(this.autoCommitBufferSize).backgroundExceptionHandler(exceptionHandler).open();
        this.mvStore.setAutoCommitDelay(2000);
        this.mvStore.setRetentionTime(0);
        this.mvStore.setReuseSpace(true);
        this.mvStore.setCacheSize(8);
        this.tvShowMap = this.mvStore.openMap("tvshows");
        this.episodeMap = this.mvStore.openMap("episodes");
        this.getTvShowList().loadTvShowsFromDatabase(this.tvShowMap, this.episodeMap);
        this.getTvShowList().initDataAfterLoading();
    }

    @Override
    public synchronized void shutDown() throws Exception {
        if (!this.isEnabled()) {
            return;
        }
        this.enabled = false;
        this.databaseTimer.cancel();
        if (this.mvStore != null && !this.mvStore.isClosed()) {
            this.writePendingChanges(true);
            this.mvStore.compactMoveChunks();
            this.mvStore.close();
        }
        if (Settings.getInstance().isDeleteTrashOnExit()) {
            for (String ds : this.getSettings().getTvShowDataSource()) {
                Path file = Paths.get(ds, ".deletedByTMM");
                Utils.deleteDirectoryRecursive(file);
            }
        }
    }

    private void writePendingChanges() {
        this.writePendingChanges(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writePendingChanges(boolean force) {
        if (force) {
            this.lock.writeLock().lock();
        } else if (!this.lock.writeLock().tryLock()) {
            return;
        }
        try {
            HashMap<MediaEntity, Long> pending = new HashMap<MediaEntity, Long>(this.pendingChanges);
            long now = System.currentTimeMillis();
            for (Map.Entry entry : pending.entrySet()) {
                if (!force && (Long)entry.getValue() >= now - 2000L) continue;
                try {
                    TvShowEpisode episode;
                    String newValue;
                    String oldValue;
                    if (entry.getKey() instanceof TvShow) {
                        TvShow tvShow = (TvShow)entry.getKey();
                        oldValue = (String)this.tvShowMap.get((Object)tvShow.getDbId());
                        if (StringUtils.equals((CharSequence)oldValue, (CharSequence)(newValue = this.tvShowObjectWriter.writeValueAsString((Object)tvShow)))) continue;
                        this.tvShowMap.put((Object)tvShow.getDbId(), (Object)newValue);
                        continue;
                    }
                    if (!(entry.getKey() instanceof TvShowEpisode) || StringUtils.equals((CharSequence)(oldValue = (String)this.episodeMap.get((Object)(episode = (TvShowEpisode)entry.getKey()).getDbId())), (CharSequence)(newValue = this.episodeObjectWriter.writeValueAsString((Object)episode)))) continue;
                    this.episodeMap.put((Object)episode.getDbId(), (Object)newValue);
                }
                catch (Exception e) {
                    LOGGER.warn("could not store '{}' - '{}'", (Object)((MediaEntity)entry.getKey()).getClass().getName(), (Object)e.getMessage());
                }
                finally {
                    this.pendingChanges.remove(entry.getKey());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void dump(TvShow tvshow) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = (ObjectNode)mapper.readValue((String)this.tvShowMap.get((Object)tvshow.getDbId()), ObjectNode.class);
            ArrayNode episodes = JsonNodeFactory.instance.arrayNode();
            for (TvShowEpisode ep : tvshow.getEpisodes()) {
                ObjectNode epNode = (ObjectNode)mapper.readValue((String)this.episodeMap.get((Object)ep.getDbId()), ObjectNode.class);
                episodes.add((JsonNode)epNode);
            }
            node.set("episodes", (JsonNode)episodes);
            String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
            LOGGER.info("Dumping TvShow: {}\n{}", (Object)tvshow.getDbId(), (Object)s);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    void persistTvShow(TvShow tvShow) {
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.put(tvShow, System.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeTvShowFromDb(TvShow tvShow) {
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.remove(tvShow);
            this.tvShowMap.remove((Object)tvShow.getDbId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void persistEpisode(TvShowEpisode episode) {
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.put(episode, System.currentTimeMillis());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void removeEpisodeFromDb(TvShowEpisode episode) {
        try {
            this.lock.writeLock().lock();
            this.pendingChanges.remove(episode);
            this.episodeMap.remove((Object)episode.getDbId());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void initializeDatabase() {
        Utils.deleteFileSafely(Paths.get(Settings.getInstance().getSettingsFolder(), TV_SHOW_DB));
    }

    @Override
    public void saveSettings() {
        this.getSettings().saveSettings();
    }

    @Override
    public List<String> getStartupMessages() {
        return this.startupMessages;
    }

    public ObjectReader getTvShowObjectReader() {
        return this.tvShowObjectReader;
    }

    public ObjectReader getEpisodeObjectReader() {
        return this.episodeObjectReader;
    }
}

