/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.template.OutputAppender;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.TmmOutputAppender;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowRenamer.class);
    private static final TvShowSettings SETTINGS = TvShowModuleManager.getInstance().getSettings();
    private static final Map<String, String> TOKEN_MAP = TvShowRenamer.createTokenMap();
    private static final String[] seasonNumbers = new String[]{"seasonNr", "seasonNr2", "seasonNrDvd", "seasonNrDvd2", "episode.season", "episode.dvdSeason"};
    private static final String[] episodeNumbers = new String[]{"episodeNr", "episodeNr2", "episodeNrDvd", "episodeNrDvd2", "episode.episode", "episode.dvdEpisode"};
    private static final String[] episodeTitles = new String[]{"title", "originalTitle", "titleSortable", "episode.title", "episode.originalTitle", "episode.titleSortable"};
    private static final String[] episodeAired = new String[]{"airedDate", "episode.firstAired"};
    private static final Pattern epDelimiter = Pattern.compile("(\\s?(folge|episode|[epx]+)\\s?)\\$\\{.*?\\}", 2);
    private static final Pattern seDelimiter = Pattern.compile("((staffel|season|s)\\s?)\\$\\{.*?\\}", 2);
    private static final List<String> DISC_FOLDERS = Arrays.asList("bdmv", "video_ts", "hvdvd_ts");

    private TvShowRenamer() {
        throw new IllegalAccessError();
    }

    private static Map<String, String> createTokenMap() {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("showTitle", "tvShow.title");
        tokenMap.put("showOriginalTitle", "tvShow.originalTitle");
        tokenMap.put("showTitleSortable", "tvShow.titleSortable");
        tokenMap.put("showYear", "tvShow.year");
        tokenMap.put("parent", "tvShow.parent");
        tokenMap.put("showNote", "tvShow.note");
        tokenMap.put("showStatus", "tvShow.status");
        tokenMap.put("showImdb", "tvShow.imdbId");
        tokenMap.put("showTmdb", "tvShow.tmdbId");
        tokenMap.put("showTvdb", "tvShow.tvdbId");
        tokenMap.put("showTags", "tvShow.tags");
        tokenMap.put("seasonName", "season.title");
        tokenMap.put("episodeNr", "episode.episode");
        tokenMap.put("episodeNr2", "episode.episode;number(%02d)");
        tokenMap.put("episodeNrDvd", "episode.dvdEpisode");
        tokenMap.put("episodeNrDvd2", "episode.dvdEpisode;number(%02d)");
        tokenMap.put("seasonNr", "episode.season;number(%d)");
        tokenMap.put("seasonNr2", "episode.season;number(%02d)");
        tokenMap.put("seasonNrDvd", "episode.dvdSeason;number(%d)");
        tokenMap.put("seasonNrDvd2", "episode.dvdSeason;number(%02d)");
        tokenMap.put("title", "episode.title");
        tokenMap.put("originalTitle", "episode.originalTitle");
        tokenMap.put("originalFilename", "episode.originalFilename");
        tokenMap.put("titleSortable", "episode.titleSortable");
        tokenMap.put("year", "episode.year");
        tokenMap.put("airedDate", "episode.firstAired;date(yyyy-MM-dd)");
        tokenMap.put("episodeImdb", "episode.imdbId");
        tokenMap.put("episodeTmdb", "episode.tmdbId");
        tokenMap.put("episodeTvdb", "episode.tvdbId");
        tokenMap.put("episodeTags", "episode.tags");
        tokenMap.put("videoCodec", "episode.mediaInfoVideoCodec");
        tokenMap.put("videoFormat", "episode.mediaInfoVideoFormat");
        tokenMap.put("videoResolution", "episode.mediaInfoVideoResolution");
        tokenMap.put("aspectRatio", "episode.mediaInfoAspectRatioAsString");
        tokenMap.put("aspectRatio2", "episode.mediaInfoAspectRatio2AsString");
        tokenMap.put("videoBitDepth", "episode.mediaInfoVideoBitDepth");
        tokenMap.put("videoBitRate", "episode.mediaInfoVideoBitrate;bitrate");
        tokenMap.put("audioCodec", "episode.mediaInfoAudioCodec");
        tokenMap.put("audioCodecList", "episode.mediaInfoAudioCodecList");
        tokenMap.put("audioCodecsAsString", "episode.mediaInfoAudioCodecList;array");
        tokenMap.put("audioChannels", "episode.mediaInfoAudioChannels");
        tokenMap.put("audioChannelList", "episode.mediaInfoAudioChannelList");
        tokenMap.put("audioChannelsAsString", "episode.mediaInfoAudioChannelList;array");
        tokenMap.put("audioLanguage", "episode.mediaInfoAudioLanguage");
        tokenMap.put("audioLanguageList", "episode.mediaInfoAudioLanguageList");
        tokenMap.put("audioLanguagesAsString", "episode.mediaInfoAudioLanguageList;array");
        tokenMap.put("subtitleLanguageList", "episode.mediaInfoSubtitleLanguageList");
        tokenMap.put("subtitleLanguagesAsString", "episode.mediaInfoSubtitleLanguageList;array");
        tokenMap.put("3Dformat", "episode.video3DFormat");
        tokenMap.put("hdr", "episode.videoHDR");
        tokenMap.put("hdrformat", "episode.videoHDRFormat");
        tokenMap.put("filesize", "episode.videoFilesize;filesize");
        tokenMap.put("mediaSource", "episode.mediaSource");
        tokenMap.put("note", "episode.note");
        return tokenMap;
    }

    public static Map<String, String> getTokenMap() {
        return Collections.unmodifiableMap(TOKEN_MAP);
    }

    private static String lz(int num) {
        return String.format("%02d", num);
    }

    public static void renameTvShow(TvShow tvShow) {
        TvShowRenamer.renameTvShowRoot(tvShow);
        TvShowRenamer.renameTvShowMediaFiles(tvShow);
        TvShowRenamer.renameSeasonArtwork(tvShow);
        tvShow.saveToDb();
    }

    private static void renameTvShowRoot(TvShow show) {
        if (SETTINGS.getRenamerFilename().isEmpty() && SETTINGS.getRenamerSeasonFoldername().isEmpty() && SETTINGS.getRenamerTvShowFoldername().isEmpty()) {
            LOGGER.info("NOT renaming TvShow '{}' - renaming patterns are empty!", (Object)show.getTitle());
            return;
        }
        LOGGER.debug("TV show year: {}", (Object)show.getYear());
        LOGGER.debug("TV show path: {}", (Object)show.getPathNIO());
        String newPathname = TvShowRenamer.getTvShowFoldername(SETTINGS.getRenamerTvShowFoldername(), show);
        String oldPathname = show.getPathNIO().toString();
        if (!newPathname.isEmpty()) {
            Path srcDir = Paths.get(oldPathname, new String[0]);
            Path destDir = Paths.get(newPathname, new String[0]);
            if (!srcDir.toAbsolutePath().toString().equals(destDir.toAbsolutePath().toString())) {
                try {
                    boolean ok;
                    for (MediaFile gfx : show.getMediaFiles()) {
                        ImageCache.invalidateCachedImage(gfx);
                    }
                    if (!Files.exists(destDir.getParent(), new LinkOption[0])) {
                        Files.createDirectory(destDir.getParent(), new FileAttribute[0]);
                    }
                    if (ok = Utils.moveDirectorySafe(srcDir, destDir)) {
                        show.updateMediaFilePath(srcDir, destDir);
                        show.setPath(newPathname);
                        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                            episode.replacePathForRenamedFolder(srcDir, destDir);
                            episode.updateMediaFilePath(srcDir, destDir);
                        }
                        if (Settings.getInstance().isImageCache()) {
                            for (MediaFile gfx : show.getMediaFiles()) {
                                ImageCache.cacheImageSilently(gfx);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("error moving folder: {}", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)srcDir, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void renameTvShowMediaFiles(TvShow tvShow) {
        void var5_13;
        Object newMFs;
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>(tvShow.getMediaFiles());
        cleanup.removeAll(Collections.singleton(null));
        MediaFile nfo = new MediaFile();
        for (MediaFile mediaFile : tvShow.getMediaFiles(MediaFileType.NFO)) {
            if (mediaFile.getFiledate() < nfo.getFiledate()) continue;
            nfo = new MediaFile(mediaFile);
        }
        if (nfo.getFiledate() > 0L) {
            newMFs = TvShowRenamer.generateFilename(tvShow, nfo);
            Iterator<MediaFile> iterator = newMFs.iterator();
            while (iterator.hasNext()) {
                MediaFile newMF = iterator.next();
                boolean ok = TvShowRenamer.copyFile(nfo.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    needed.add(newMF);
                    continue;
                }
                needed.add(nfo);
            }
        } else {
            LOGGER.trace("No valid NFO found for this TV show");
        }
        for (MediaFile mediaFile : tvShow.getMediaFiles()) {
            if (mediaFile == null) continue;
            LOGGER.trace("Rename 1:N {} {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            List<MediaFile> newMFs2 = TvShowRenamer.generateFilename(tvShow, mediaFile);
            for (MediaFile newMF : newMFs2) {
                boolean ok = TvShowRenamer.copyFile(mediaFile.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    needed.add(newMF);
                    continue;
                }
                needed.add(mediaFile);
            }
        }
        for (MediaFile mediaFile : tvShow.getMediaFiles()) {
            ImageCache.invalidateCachedImage(mediaFile);
        }
        newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll((Collection<MediaFile>)newMFs);
        LOGGER.info("Cleanup...");
        int n = cleanup.size() - 1;
        while (var5_13 >= 0) {
            if (!needed.contains(cleanup.get((int)var5_13))) {
                MediaFile cl = (MediaFile)cleanup.get((int)var5_13);
                if (Files.exists(cl.getFileAsPath(), new LinkOption[0])) {
                    LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                    Utils.deleteFileWithBackup(cl.getFileAsPath(), tvShow.getDataSource());
                }
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                    if (!directoryStream.iterator().hasNext()) {
                        LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                        Files.delete(cl.getFileAsPath().getParent());
                    }
                }
                catch (IOException e) {
                    LOGGER.error("cleanup of {} - {}", (Object)cl.getFileAsPath(), (Object)e.getMessage());
                }
            }
            --var5_13;
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(tvShow.getPathNIO());
        }
        catch (Exception exception) {
            LOGGER.warn("could not delete empty subfolders: {}", (Object)exception.getMessage());
        }
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : tvShow.getMediaFiles()) {
                ImageCache.cacheImageSilently(gfx);
            }
        }
        tvShow.removeAllMediaFiles();
        tvShow.addToMediaFiles(needed);
    }

    public static List<MediaFile> generateFilename(TvShow tvShow, MediaFile original) {
        ArrayList<MediaFile> neededMediaFiles = new ArrayList<MediaFile>();
        boolean spaceSubstitution = SETTINGS.isRenamerFilenameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerFilenameSpaceReplacement();
        String cleanedShowTitle = TvShowRenamer.cleanupDestination(tvShow.getTitle(), spaceSubstitution, spaceReplacement);
        List<Enum> filenamings = null;
        switch (original.getType()) {
            case POSTER: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getPosterFilenames();
                break;
            }
            case FANART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getFanartFilenames();
                break;
            }
            case BANNER: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getBannerFilenames();
                break;
            }
            case LOGO: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getLogoFilenames();
                break;
            }
            case CLEARLOGO: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getClearlogoFilenames();
                break;
            }
            case CLEARART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getClearartFilenames();
                break;
            }
            case THUMB: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getThumbFilenames();
                break;
            }
            case DISC: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getDiscartFilenames();
                break;
            }
            case CHARACTERART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getCharacterartFilenames();
                break;
            }
            case KEYART: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getKeyartFilenames();
                break;
            }
            case TRAILER: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getTrailerFilenames();
                break;
            }
            case NFO: {
                filenamings = TvShowModuleManager.getInstance().getSettings().getNfoFilenames();
                break;
            }
            case EXTRAFANART: {
                neededMediaFiles.addAll(TvShowRenamer.generateExtrafanartFilename(tvShow, original));
                break;
            }
            default: {
                neededMediaFiles.add(original);
            }
        }
        if (filenamings != null) {
            for (IFileNaming iFileNaming : filenamings) {
                String newFilename = iFileNaming.getFilename(cleanedShowTitle, TvShowRenamer.getMediaFileExtension(original));
                if (!StringUtils.isNotBlank((CharSequence)newFilename)) continue;
                MediaFile newMediaFile = new MediaFile(original);
                newMediaFile.setFile(tvShow.getPathNIO().resolve(newFilename));
                neededMediaFiles.add(newMediaFile);
            }
        }
        return neededMediaFiles;
    }

    private static List<MediaFile> generateExtrafanartFilename(TvShow tvShow, MediaFile original) {
        TvShowExtraFanartNaming name;
        Object newFilename;
        if (TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
            return Collections.emptyList();
        }
        int index = TvShowArtworkHelper.getIndexOfArtwork(original.getFilename());
        if (index > 0 && StringUtils.isNotBlank((CharSequence)(newFilename = (name = TvShowModuleManager.getInstance().getSettings().getExtraFanartFilenames().get(0)).getFilename("", TvShowRenamer.getMediaFileExtension(original))))) {
            String basename = FilenameUtils.getBaseName((String)newFilename);
            newFilename = basename + index + "." + TvShowRenamer.getMediaFileExtension(original);
            Path folder = name == TvShowExtraFanartNaming.FOLDER_EXTRAFANART ? tvShow.getPathNIO().resolve("extrafanart") : tvShow.getPathNIO();
            MediaFile newMediaFile = new MediaFile(original);
            newMediaFile.setFile(folder.resolve((String)newFilename));
            return Collections.singletonList(newMediaFile);
        }
        return Collections.emptyList();
    }

    private static void renameSeasonArtwork(TvShow tvShow) {
        LinkedHashSet<MediaFile> needed = new LinkedHashSet<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        List<MediaArtwork.MediaArtworkType> types = Arrays.asList(MediaArtwork.MediaArtworkType.SEASON_POSTER, MediaArtwork.MediaArtworkType.SEASON_FANART, MediaArtwork.MediaArtworkType.SEASON_BANNER, MediaArtwork.MediaArtworkType.SEASON_THUMB);
        for (MediaArtwork.MediaArtworkType type : types) {
            Map<Integer, MediaFile> artwork = tvShow.getSeasonArtworks(type);
            block16: for (Map.Entry<Integer, MediaFile> entry : artwork.entrySet()) {
                Integer season = entry.getKey();
                MediaFile mf = entry.getValue();
                cleanup.add(mf);
                switch (type) {
                    case SEASON_POSTER: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonPosterNaming tvShowSeasonPosterNaming : SETTINGS.getSeasonPosterFilenames()) {
                            filename = tvShowSeasonPosterNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block16;
                    }
                    case SEASON_FANART: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonFanartNaming tvShowSeasonFanartNaming : SETTINGS.getSeasonFanartFilenames()) {
                            filename = tvShowSeasonFanartNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block16;
                    }
                    case SEASON_BANNER: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonBannerNaming tvShowSeasonBannerNaming : SETTINGS.getSeasonBannerFilenames()) {
                            filename = tvShowSeasonBannerNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block16;
                    }
                    case SEASON_THUMB: {
                        boolean ok;
                        MediaFile newMf;
                        String filename;
                        for (TvShowSeasonThumbNaming tvShowSeasonThumbNaming : SETTINGS.getSeasonThumbFilenames()) {
                            filename = tvShowSeasonThumbNaming.getFilename(tvShow, season, mf.getExtension());
                            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                            newMf = new MediaFile(mf);
                            newMf.setFile(Paths.get(tvShow.getPath(), filename));
                            ok = TvShowRenamer.copyFile(mf.getFileAsPath(), newMf.getFileAsPath());
                            if (!ok) continue;
                            needed.add(newMf);
                        }
                        continue block16;
                    }
                    default: {
                        continue block16;
                    }
                }
            }
        }
        for (MediaFile gfx : tvShow.getMediaFiles()) {
            ImageCache.invalidateCachedImage(gfx);
        }
        LOGGER.info("Cleanup...");
        List<Path> existingFiles = Utils.listFilesRecursive(tvShow.getPathNIO());
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            if (needed.contains(cleanup.get(i))) continue;
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (existingFiles.contains(cl.getFileAsPath())) {
                LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                Utils.deleteFileWithBackup(cl.getFileAsPath(), tvShow.getDataSource());
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                if (directoryStream.iterator().hasNext()) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.error("cleanup of {} - {}", (Object)cl.getFileAsPath(), (Object)e.getMessage());
            }
        }
        try {
            Utils.deleteEmptyDirectoryRecursive(tvShow.getPathNIO());
        }
        catch (Exception e) {
            LOGGER.warn("could not delete empty subfolders: {}", (Object)e.getMessage());
        }
        if (Settings.getInstance().isImageCache()) {
            for (MediaFile gfx : tvShow.getMediaFiles()) {
                ImageCache.cacheImageSilently(gfx);
            }
        }
        tvShow.addToMediaFiles(new ArrayList<MediaFile>(needed));
    }

    /*
     * WARNING - void declaration
     */
    public static void renameEpisode(TvShowEpisode episode) {
        void var9_22;
        void var7_11;
        if (SETTINGS.getRenamerFilename().isEmpty() && SETTINGS.getRenamerSeasonFoldername().isEmpty()) {
            LOGGER.info("NOT renaming TvShow '{}' Episode {} - renaming patterns are empty!", (Object)episode.getTvShow().getTitle(), (Object)episode.getEpisode());
            return;
        }
        MediaFile originalVideoMediaFile = new MediaFile(episode.getMainVideoFile());
        if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
            LOGGER.warn("failed to rename episode {} (TV show {}) - invalid season/episode number", (Object)episode.getTitle(), (Object)episode.getTvShow().getTitle());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)episode.getTvShow().getTitle(), "tvshow.renamer.failedrename", new String[]{episode.getTitle()}));
            return;
        }
        LOGGER.debug("Renaming TvShow '{}', Episode {}", (Object)episode.getTvShow().getTitle(), (Object)episode.getEpisode());
        if (episode.isDisc()) {
            TvShowRenamer.renameEpisodeAsDisc(episode);
            return;
        }
        episode.reEvaluateStacking();
        ArrayList<MediaFile> needed = new ArrayList<MediaFile>();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>(episode.getMediaFiles());
        cleanup.removeAll(Collections.singleton(null));
        String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
        Path seasonFolder = episode.getTvShow().getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonFoldername) && !Files.exists(seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername), new LinkOption[0])) {
            try {
                Files.createDirectory(seasonFolder, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.VIDEO)) {
            LOGGER.trace("Rename 1:1 {} {}", (Object)mediaFile.getType(), (Object)mediaFile.getFileAsPath());
            MediaFile newMF = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile, originalVideoMediaFile).get(0);
            boolean bl = TvShowRenamer.moveFile(mediaFile.getFileAsPath(), newMF.getFileAsPath());
            if (bl) {
                mediaFile.setFile(newMF.getFileAsPath());
                episode.setPath(newMF.getPath());
            }
            needed.add(mediaFile);
        }
        ArrayList<Object> mfs = new ArrayList<MediaFile>();
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.FANART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.POSTER));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.BANNER));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CLEARART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.THUMB));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.LOGO));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CLEARLOGO));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.DISC));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.CHARACTERART));
        mfs.add(episode.getNewestMediaFilesOfType(MediaFileType.KEYART));
        mfs.removeAll(Collections.singleton(null));
        for (Object mf : mfs) {
            LOGGER.trace("Rename 1:N {} {}", (Object)((MediaFile)mf).getType(), (Object)((MediaFile)mf).getFileAsPath());
            List<MediaFile> list = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), (MediaFile)mf, originalVideoMediaFile);
            for (MediaFile newMF : list) {
                boolean ok = TvShowRenamer.copyFile(((MediaFile)mf).getFileAsPath(), newMF.getFileAsPath());
                if (!ok) continue;
                needed.add(newMF);
            }
        }
        MediaFile mediaFile = new MediaFile();
        for (MediaFile mediaFile2 : episode.getMediaFiles(MediaFileType.NFO)) {
            if (mediaFile2.getFiledate() < var7_11.getFiledate()) continue;
            MediaFile mediaFile3 = new MediaFile(mediaFile2);
        }
        if (var7_11.getFiledate() > 0L) {
            List<MediaFile> newNFOs = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), (MediaFile)var7_11, originalVideoMediaFile);
            if (!newNFOs.isEmpty()) {
                Iterator<MediaFile> iterator = newNFOs.iterator();
                while (iterator.hasNext()) {
                    MediaFile newNFO = iterator.next();
                    boolean ok = TvShowRenamer.copyFile(var7_11.getFileAsPath(), newNFO.getFileAsPath());
                    if (!ok) continue;
                    needed.add(newNFO);
                }
            } else {
                cleanup.add((MediaFile)var7_11);
            }
        } else {
            LOGGER.trace("No valid NFO found for this episode");
        }
        for (MediaFile mediaFile4 : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
            LOGGER.trace("Rename 1:1 {} {}", (Object)mediaFile4.getType(), (Object)mediaFile4.getFileAsPath());
            MediaFile sub = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile4, originalVideoMediaFile).get(0);
            boolean ok = TvShowRenamer.moveFile(mediaFile4.getFileAsPath(), sub.getFileAsPath());
            if (ok) {
                if (sub.getFilename().endsWith(".sub")) {
                    try {
                        Path oldidx = mediaFile4.getFileAsPath().resolveSibling(mediaFile4.getFilename().replaceFirst("sub$", "idx"));
                        Path newidx = sub.getFileAsPath().resolveSibling(sub.getFilename().replaceFirst("sub$", "idx"));
                        Utils.moveFileSafe(oldidx, newidx);
                    }
                    catch (Exception oldidx) {
                        // empty catch block
                    }
                }
                mediaFile4.setFile(sub.getFileAsPath());
            }
            needed.add(mediaFile4);
        }
        mfs = new ArrayList<MediaFile>(episode.getMediaFilesExceptType(MediaFileType.VIDEO, MediaFileType.NFO, MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.DISC, MediaFileType.CHARACTERART, MediaFileType.KEYART, MediaFileType.SUBTITLE));
        mfs.removeAll(Collections.singleton(null));
        for (MediaFile mediaFile5 : mfs) {
            LOGGER.trace("Rename 1:1 {} - {}", (Object)mediaFile5.getType(), (Object)mediaFile5.getFileAsPath());
            List<MediaFile> newMFs = TvShowRenamer.generateEpisodeFilenames(episode.getTvShow(), mediaFile5, originalVideoMediaFile);
            newMFs.removeAll(Collections.singleton(null));
            for (MediaFile newMF : newMFs) {
                boolean ok = TvShowRenamer.copyFile(mediaFile5.getFileAsPath(), newMF.getFileAsPath());
                if (ok) {
                    needed.add(newMF);
                    continue;
                }
                needed.add(mediaFile5);
            }
        }
        for (MediaFile mediaFile6 : episode.getMediaFiles()) {
            ImageCache.invalidateCachedImage(mediaFile6);
        }
        LinkedHashSet newMFs = new LinkedHashSet(needed);
        needed.clear();
        needed.addAll(newMFs);
        LOGGER.debug("Cleanup...");
        int n = cleanup.size() - 1;
        while (var9_22 >= 0) {
            if (!needed.contains(cleanup.get((int)var9_22))) {
                MediaFile cl = (MediaFile)cleanup.get((int)var9_22);
                if (Files.exists(cl.getFileAsPath(), new LinkOption[0])) {
                    LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
                    Utils.deleteFileWithBackup(cl.getFileAsPath(), episode.getTvShow().getDataSource());
                }
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(cl.getFileAsPath().getParent());){
                    if (!directoryStream.iterator().hasNext()) {
                        LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                        Files.delete(cl.getFileAsPath().getParent());
                    }
                }
                catch (IOException e) {
                    LOGGER.error("cleanup of {} - {}", (Object)cl.getFileAsPath(), (Object)e.getMessage());
                }
            }
            --var9_22;
        }
        ArrayList<TvShowEpisode> arrayList = new ArrayList<TvShowEpisode>();
        arrayList.add(episode);
        arrayList.addAll(TvShowList.getTvEpisodesByFile(episode.getTvShow(), originalVideoMediaFile.getFile()));
        for (TvShowEpisode e : arrayList) {
            e.removeAllMediaFiles();
            e.addToMediaFiles(needed);
            e.setPath(episode.getPath());
            e.gatherMediaFileInformation(false);
            e.saveToDb();
            if (!Settings.getInstance().isImageCache()) continue;
            for (MediaFile gfx : e.getMediaFiles()) {
                ImageCache.cacheImageSilently(gfx);
            }
        }
    }

    private static void renameEpisodeAsDisc(TvShowEpisode episode) {
        block16: {
            String newFoldername;
            Path epFolder;
            Path disc;
            MediaFile mf = episode.getMainVideoFile();
            List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(episode.getTvShow(), mf.getFile());
            if (!episode.isDisc() || !mf.isDiscFile()) {
                return;
            }
            if (DISC_FOLDERS.contains(mf.getFileAsPath().getFileName().toString().toLowerCase(Locale.ROOT))) {
                disc = mf.getFileAsPath();
                epFolder = disc.getParent();
            } else if (DISC_FOLDERS.contains(mf.getFileAsPath().getParent().getFileName().toString().toLowerCase(Locale.ROOT))) {
                disc = mf.getFileAsPath().getParent();
                epFolder = disc.getParent();
            } else {
                LOGGER.error("Episode is labeled as 'on BD/DVD', but structure seems not to match. Better exit and do nothing... o_O");
                return;
            }
            String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
            Path seasonFolder = episode.getTvShow().getPathNIO();
            if (StringUtils.isNotBlank((CharSequence)seasonFoldername) && !Files.exists(seasonFolder = episode.getTvShow().getPathNIO().resolve(seasonFoldername), new LinkOption[0])) {
                try {
                    Files.createDirectory(seasonFolder, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank((CharSequence)(newFoldername = FilenameUtils.getBaseName((String)TvShowRenamer.generateFoldername(episode.getTvShow(), mf))))) {
                LOGGER.warn("empty disc folder name - exiting");
                return;
            }
            Path newEpFolder = seasonFolder.resolve(newFoldername);
            Path newDisc = newEpFolder.resolve(disc.getFileName());
            try {
                if (epFolder.toAbsolutePath().toString().equals(newEpFolder.toAbsolutePath().toString())) break block16;
                boolean ok = false;
                try {
                    if (!Files.exists(newEpFolder.getParent(), new LinkOption[0])) {
                        Files.createDirectory(newEpFolder.getParent(), new FileAttribute[0]);
                    }
                    ok = Utils.moveDirectorySafe(epFolder, newEpFolder);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)epFolder, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
                }
                if (ok) {
                    LOGGER.debug("updating *all* MFs for new path -> {}", (Object)newEpFolder);
                    for (TvShowEpisode e : eps) {
                        e.updateMediaFilePath(disc, newDisc);
                        e.setPath(newEpFolder.toAbsolutePath().toString());
                        e.saveToDb();
                    }
                }
                TvShowRenamer.cleanEmptyDir(epFolder);
            }
            catch (Exception e) {
                LOGGER.error("error moving video file " + disc + " to " + newFoldername, (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf.getFilename(), "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    private static void cleanEmptyDir(Path dir) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            if (!directoryStream.iterator().hasNext()) {
                LOGGER.debug("Deleting empty Directory - {}", (Object)dir);
                Files.delete(dir);
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String generateFoldername(TvShow tvShow, MediaFile mf) {
        List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile());
        if (ListUtils.isEmpty(eps)) {
            return "";
        }
        return TvShowRenamer.createDestination(SETTINGS.getRenamerFilename(), eps);
    }

    public static List<MediaFile> generateEpisodeFilenames(TvShow tvShow, MediaFile mf, MediaFile originalVideoFile) {
        return TvShowRenamer.generateEpisodeFilenames("", tvShow, mf, originalVideoFile);
    }

    /*
     * Unable to fully structure code
     */
    public static List<MediaFile> generateEpisodeFilenames(String template, TvShow tvShow, MediaFile mf, MediaFile originalVideoFile) {
        newFiles = new ArrayList<MediaFile>();
        eps = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile());
        if (ListUtils.isEmpty(eps)) {
            return newFiles;
        }
        eps.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$generateEpisodeFilenames$0(org.tinymediamanager.core.tvshow.entities.TvShowEpisode org.tinymediamanager.core.tvshow.entities.TvShowEpisode ), (Lorg/tinymediamanager/core/tvshow/entities/TvShowEpisode;Lorg/tinymediamanager/core/tvshow/entities/TvShowEpisode;)I)());
        newFilename = StringUtils.isBlank((CharSequence)template) != false ? TvShowRenamer.createDestination(TvShowRenamer.SETTINGS.getRenamerFilename(), eps) : TvShowRenamer.createDestination(template, eps);
        if (newFilename.endsWith(mf.getExtension())) {
            newFilename = FilenameUtils.getBaseName((String)newFilename);
        }
        seasonFoldername = TvShowRenamer.getSeasonFoldername(tvShow, eps.get(0));
        seasonFolder = tvShow.getPathNIO();
        if (StringUtils.isNotBlank((CharSequence)seasonFoldername)) {
            seasonFolder = tvShow.getPathNIO().resolve(seasonFoldername);
        }
        if (StringUtils.isBlank((CharSequence)newFilename)) {
            mediaFile = new MediaFile(mf);
            mediaFile.setFile(seasonFolder.resolve(mf.getFilename()));
            newFiles.add(mediaFile);
            return newFiles;
        }
        switch (2.$SwitchMap$org$tinymediamanager$core$MediaFileType[mf.getType().ordinal()]) {
            case 14: {
                video = new MediaFile(mf);
                newFilename = (String)newFilename + TvShowRenamer.getStackingString(mf);
                newFilename = (String)newFilename + "." + mf.getExtension();
                video.setFile(seasonFolder.resolve((String)newFilename));
                newFiles.add(video);
                break;
            }
            case 12: {
                nfo = new MediaFile(mf);
                newFilename = (String)newFilename + "." + mf.getExtension();
                nfo.setFile(seasonFolder.resolve((String)newFilename));
                newFiles.add(nfo);
                break;
            }
            case 7: {
                for (TvShowEpisodeThumbNaming thumbNaming : TvShowRenamer.SETTINGS.getEpisodeThumbFilenames()) {
                    thumbFilename = thumbNaming.getFilename((String)newFilename, TvShowRenamer.getMediaFileExtension(mf));
                    thumb = new MediaFile(mf);
                    thumb.setFile(seasonFolder.resolve(thumbFilename));
                    newFiles.add(thumb);
                }
                break;
            }
            case 15: {
                subtitles = mf.getSubtitles();
                subtitleFilename = "";
                if (subtitles != null && !subtitles.isEmpty() && (mfs = mf.getSubtitles().get(0)) != null) {
                    if (!mfs.getLanguage().isEmpty()) {
                        lang = LanguageStyle.getLanguageCodeForStyle(mfs.getLanguage(), TvShowModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = mfs.getLanguage();
                        }
                        subtitleFilename = (String)newFilename + "." + lang;
                    }
                    additional = "";
                    if (StringUtils.isNotBlank((CharSequence)mfs.getTitle())) {
                        additional = "(" + mfs.getTitle().strip() + ")";
                    }
                    if (mfs.isForced()) {
                        additional = (String)additional + ".forced";
                    }
                    if (mfs.has(MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED)) {
                        additional = (String)additional + ".sdh";
                    }
                    subtitleFilename = (String)subtitleFilename + (String)additional;
                }
                if (!StringUtils.isBlank((CharSequence)subtitleFilename)) ** GOTO lbl84
                shortname = mf.getBasename().toLowerCase(Locale.ROOT).replace(eps.get(0).getVideoBasenameWithoutStacking(), "");
                originalLang = "";
                lang = "";
                forced = "";
                if (mf.getFilename().toLowerCase(Locale.ROOT).contains("forced")) {
                    forced = ".forced";
                    shortname = shortname.replaceAll("\\p{Punct}*forced", "");
                }
                try {
                    for (String s : LanguageUtils.KEY_TO_LOCALE_MAP.keySet()) {
                        if (!LanguageUtils.doesStringEndWithLanguage(shortname, s)) continue;
                        originalLang = s;
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                lang = LanguageStyle.getLanguageCodeForStyle(originalLang, TvShowModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                if (StringUtils.isBlank((CharSequence)lang)) {
                    lang = originalLang;
                }
                if (StringUtils.isNotBlank((CharSequence)lang)) {
                    subtitleFilename = (String)newFilename + "." + lang;
                }
                if (StringUtils.isNotBlank((CharSequence)forced)) {
                    subtitleFilename = (String)subtitleFilename + forced;
                }
lbl84:
                // 4 sources

                if (StringUtils.isBlank((CharSequence)subtitleFilename)) {
                    subtitleFilename = newFilename;
                }
                if (!StringUtils.isNotBlank((CharSequence)subtitleFilename)) break;
                subtitle = new MediaFile(mf);
                subtitle.setFile(seasonFolder.resolve((String)subtitleFilename + "." + mf.getExtension()));
                newFiles.add(subtitle);
                break;
            }
            case 2: {
                fanart = new MediaFile(mf);
                fanart.setFile(seasonFolder.resolve((String)newFilename + "-fanart." + TvShowRenamer.getMediaFileExtension(mf)));
                newFiles.add(fanart);
                break;
            }
            case 11: {
                trailer = new MediaFile(mf);
                trailer.setFile(seasonFolder.resolve((String)newFilename + "-trailer." + mf.getExtension()));
                newFiles.add(trailer);
                break;
            }
            case 16: {
                mediainfo = new MediaFile(mf);
                mediainfo.setFile(seasonFolder.resolve((String)newFilename + "-mediainfo." + mf.getExtension()));
                newFiles.add(mediainfo);
                break;
            }
            case 17: {
                vsmeta = new MediaFile(mf);
                videoExt = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)mf.getFilename()));
                newFilename = (String)newFilename + "." + videoExt + ".vsmeta";
                vsmeta.setFile(seasonFolder.resolve((String)newFilename));
                newFiles.add(vsmeta);
                break;
            }
            case 18: 
            case 19: {
                extra = new MediaFile(mf);
                result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(mf.getFilename(), tvShow.getTitle());
                extra.setFile(seasonFolder.resolve("extras/" + (String)newFilename + "-" + result.cleanedName + "." + mf.getExtension()));
                newFiles.add(extra);
                break;
            }
            case 20: {
                sample = new MediaFile(mf);
                sample.setFile(seasonFolder.resolve((String)newFilename + "-sample." + mf.getExtension()));
                newFiles.add(sample);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                other = new MediaFile(mf);
                spaceSubstitution = TvShowRenamer.SETTINGS.isRenamerFilenameSpaceSubstitution();
                spaceReplacement = TvShowRenamer.SETTINGS.getRenamerFilenameSpaceReplacement();
                destination = TvShowRenamer.cleanupDestination((String)newFilename + StringUtils.difference((String)FilenameUtils.getBaseName((String)originalVideoFile.getFilename()), (String)FilenameUtils.getBaseName((String)mf.getFilename())), spaceSubstitution, spaceReplacement);
                other.setFile(seasonFolder.resolve(destination + "." + mf.getExtension()));
                newFiles.add(other);
                break;
            }
        }
        return newFiles;
    }

    public static String getSeasonFoldername(TvShow show, TvShowEpisode episode) {
        return TvShowRenamer.getSeasonFoldername(SETTINGS.getRenamerSeasonFoldername(), show, episode);
    }

    public static String getSeasonFoldername(String template, TvShow show, TvShowEpisode episode) {
        Object seasonFolderName = template;
        TvShowSeason tvShowSeason = show.getSeason(episode.getSeason());
        if (tvShowSeason == null) {
            return "";
        }
        seasonFolderName = tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() ? "Specials" : TvShowRenamer.createDestination((String)seasonFolderName, tvShowSeason, episode);
        if (StringUtils.isBlank((CharSequence)seasonFolderName) && !TvShowRenamer.isRecommended(template, TvShowModuleManager.getInstance().getSettings().getRenamerFilename())) {
            seasonFolderName = "Season " + tvShowSeason.getSeason();
        }
        return seasonFolderName;
    }

    public static String getTvShowFoldername(TvShow tvShow) {
        return TvShowRenamer.getTvShowFoldername(SETTINGS.getRenamerTvShowFoldername(), tvShow);
    }

    public static String getTvShowFoldername(String template, TvShow tvShow) {
        String newPathname = StringUtils.isNotBlank((CharSequence)SETTINGS.getRenamerTvShowFoldername()) ? Paths.get(tvShow.getDataSource(), TvShowRenamer.createDestination(template, tvShow)).toString() : tvShow.getPathNIO().toString();
        return newPathname;
    }

    public static String getTokenValue(TvShow show, TvShowEpisode episode, String token) {
        try {
            Engine engine = Engine.createEngine();
            engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
            engine.registerNamedRenderer((NamedRenderer)new TvShowNamedFirstCharacterRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
            engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
            engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
            engine.setOutputAppender((OutputAppender)new TmmOutputAppender(){

                @Override
                protected String replaceInvalidCharacters(String text) {
                    return TvShowRenamer.replaceInvalidCharacters(text);
                }
            });
            HashMap<String, AbstractModelObject> root = new HashMap<String, AbstractModelObject>();
            if (episode != null) {
                root.put("episode", episode);
                root.put("season", episode.getTvShowSeason());
            }
            root.put("tvShow", show);
            return engine.transform(JmteUtils.morphTemplate(token, TOKEN_MAP), root);
        }
        catch (Exception e) {
            LOGGER.warn("unable to process token: {}", (Object)token);
            return token;
        }
    }

    public static String createDestination(String template, TvShow show) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        boolean spaceSubstitution = SETTINGS.isRenamerShowPathnameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerShowPathnameSpaceReplacement();
        return TvShowRenamer.cleanupDestination(TvShowRenamer.getTokenValue(show, null, template), spaceSubstitution, spaceReplacement);
    }

    public static String createDestination(String template, TvShowSeason season, TvShowEpisode episode) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        String newDestination = TvShowRenamer.getTokenValue(season.getTvShow(), episode, template);
        boolean spaceSubstitution = SETTINGS.isRenamerSeasonPathnameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerSeasonPathnameSpaceReplacement();
        newDestination = TvShowRenamer.cleanupDestination(newDestination, spaceSubstitution, spaceReplacement);
        return newDestination;
    }

    public static String createDestination(String template, List<TvShowEpisode> episodes) {
        TvShowEpisode firstEp;
        if (StringUtils.isBlank((CharSequence)template)) {
            return "";
        }
        String newDestination = template;
        if (episodes.size() == 1) {
            firstEp = episodes.get(0);
            newDestination = TvShowRenamer.getTokenValue(firstEp.getTvShow(), firstEp, template);
        } else {
            Pattern pattern;
            Matcher matcher;
            Object pattern2;
            Matcher matcher2;
            String episodeToken;
            firstEp = episodes.get(0);
            Object loopNumbers = "";
            String seasonToken = TvShowRenamer.getTokenFromTemplate(newDestination, seasonNumbers);
            if (StringUtils.isNotBlank((CharSequence)seasonToken)) {
                String seasonPart = "";
                Matcher matcher3 = seDelimiter.matcher(newDestination);
                if (matcher3.find()) {
                    seasonPart = matcher3.group(0);
                } else {
                    Pattern pattern3 = Pattern.compile("\\$\\{" + Pattern.quote(seasonToken) + ".*?\\}");
                    matcher3 = pattern3.matcher(newDestination);
                    if (matcher3.find()) {
                        seasonPart = matcher3.group(0);
                    }
                }
                loopNumbers = (String)loopNumbers + seasonPart;
            }
            if (StringUtils.isNotBlank((CharSequence)(episodeToken = TvShowRenamer.getTokenFromTemplate(newDestination, episodeNumbers)))) {
                Object episodePart = "";
                Object matcher4 = epDelimiter.matcher(newDestination);
                if (((Matcher)matcher4).find()) {
                    episodePart = (String)episodePart + ((Matcher)matcher4).group(0);
                } else {
                    Pattern pattern4 = Pattern.compile("\\$\\{" + Pattern.quote(episodeToken) + ".*?\\}");
                    matcher4 = pattern4.matcher(newDestination);
                    if (((Matcher)matcher4).find()) {
                        episodePart = ((Matcher)matcher4).group(0);
                    }
                }
                loopNumbers = (String)loopNumbers + (String)episodePart;
            }
            loopNumbers = ((String)loopNumbers).trim();
            StringBuilder episodeParts = new StringBuilder();
            for (TvShowEpisode episode : episodes) {
                String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, (String)loopNumbers);
                episodeParts.append(" ").append(episodePart);
            }
            if (StringUtils.isNotBlank((CharSequence)loopNumbers)) {
                newDestination = newDestination.replace((CharSequence)loopNumbers, episodeParts.toString());
            }
            Object loopTitles = "";
            String titleToken = TvShowRenamer.getTokenFromTemplate(template, episodeTitles);
            if (StringUtils.isNotBlank((CharSequence)titleToken) && (matcher2 = ((Pattern)(pattern2 = Pattern.compile("\\$\\{" + Pattern.quote(titleToken) + ".*?\\}", 2))).matcher(template)).find()) {
                loopTitles = (String)loopTitles + matcher2.group(0);
            }
            if (StringUtils.isNotBlank((CharSequence)(loopTitles = ((String)loopTitles).trim()))) {
                episodeParts = new StringBuilder();
                for (TvShowEpisode episode : episodes) {
                    String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, (String)loopTitles);
                    if (StringUtils.isNotBlank((CharSequence)episodeParts.toString())) {
                        episodeParts.append(" -");
                    }
                    episodeParts.append(" ").append(episodePart);
                }
                newDestination = newDestination.replace((CharSequence)loopTitles, episodeParts.toString());
            }
            Object loopAired = "";
            String airedToken = TvShowRenamer.getTokenFromTemplate(template, episodeAired);
            if (StringUtils.isNotBlank((CharSequence)airedToken) && (matcher = (pattern = Pattern.compile("\\$\\{" + Pattern.quote(airedToken) + ".*?\\}", 2)).matcher(template)).find()) {
                loopAired = (String)loopAired + matcher.group(0);
            }
            if (StringUtils.isNotBlank((CharSequence)(loopAired = ((String)loopAired).trim()))) {
                episodeParts = new StringBuilder();
                for (TvShowEpisode episode : episodes) {
                    String episodePart = TvShowRenamer.getTokenValue(episode.getTvShow(), episode, (String)loopAired);
                    if (StringUtils.isNotBlank((CharSequence)episodeParts.toString())) {
                        episodeParts.append(" -");
                    }
                    episodeParts.append(" ").append(episodePart);
                }
                newDestination = newDestination.replace((CharSequence)loopAired, episodeParts.toString());
            }
            newDestination = TvShowRenamer.getTokenValue(firstEp.getTvShow(), firstEp, newDestination);
        }
        boolean spaceSubstitution = SETTINGS.isRenamerFilenameSpaceSubstitution();
        String spaceReplacement = SETTINGS.getRenamerFilenameSpaceReplacement();
        newDestination = TvShowRenamer.cleanupDestination(newDestination, spaceSubstitution, spaceReplacement);
        return newDestination;
    }

    private static String cleanupDestination(String destination, Boolean spaceSubstitution, String spaceReplacement) {
        destination = destination.replaceAll("\\([ ]?\\)", "");
        destination = destination.replaceAll("\\[[ ]?\\]", "");
        destination = destination.replaceAll("\\{[ ]?\\}", "");
        if (SystemUtils.IS_OS_WINDOWS) {
            destination = destination.replaceAll("\\\\{2,}", "\\\\");
            destination = destination.replaceAll("^\\\\", "");
            destination = destination.replaceAll("\\s+\\\\", "\\\\");
            destination = destination.replaceAll("\\\\\\s+", "\\\\");
            destination = destination.replaceAll("[ \\.\\-_]+\\\\", "\\\\");
        } else {
            destination = destination.replaceAll(File.separator + "{2,}", File.separator);
            destination = destination.replaceAll("^" + File.separator, "");
            destination = destination.replaceAll("\\s+/", "/");
            destination = destination.replaceAll("/\\s+", "/");
            destination = destination.replaceAll("[ \\.\\-_]+/", "/");
        }
        if (spaceSubstitution.booleanValue()) {
            destination = destination.replace(" ", spaceReplacement);
            destination = destination.replaceAll(Pattern.quote(spaceReplacement) + "+", spaceReplacement);
        }
        if (SETTINGS.isAsciiReplacement()) {
            destination = StrgUtils.convertToAscii(destination, false);
        }
        destination = destination.replaceAll("^[ \\.\\-_]+", "");
        destination = destination.replaceAll("[ \\.\\-_]+$", "");
        destination = destination.replace(": ", " - ");
        destination = destination.replace(":", "-");
        destination = destination.replaceAll(" +", " ").trim();
        return destination.trim();
    }

    public static boolean isRecommended(String seasonPattern, String filePattern) {
        int epCnt = TvShowRenamer.count(filePattern, episodeNumbers);
        int titleCnt = TvShowRenamer.count(filePattern, episodeTitles);
        int seCnt = TvShowRenamer.count(filePattern, seasonNumbers);
        int seFolderCnt = TvShowRenamer.count(seasonPattern, seasonNumbers);
        if (epCnt != 1 || titleCnt != 1 || seCnt > 1 || seFolderCnt > 1 || seCnt + seFolderCnt == 0) {
            LOGGER.debug("Too many/less episode/season/title replacer patterns");
            return false;
        }
        int epPos = TvShowRenamer.getPatternPos(filePattern, episodeNumbers);
        int sePos = TvShowRenamer.getPatternPos(filePattern, seasonNumbers);
        int titlePos = TvShowRenamer.getPatternPos(filePattern, episodeTitles);
        if (sePos > epPos) {
            LOGGER.debug("Season pattern should be before episode pattern!");
            return false;
        }
        if (titleCnt == 1 && seCnt == 1 && titlePos < epPos && titlePos > sePos) {
            LOGGER.debug("Title should not be between season/episode pattern");
            return false;
        }
        return true;
    }

    private static int count(String pattern, String[] possibleValues) {
        int count = 0;
        for (String r : possibleValues) {
            if (!TvShowRenamer.containsToken(pattern, r)) continue;
            ++count;
        }
        return count;
    }

    private static int getPatternPos(String pattern, String[] possibleValues) {
        int pos = -1;
        for (String r : possibleValues) {
            if (!TvShowRenamer.containsToken(pattern, r)) continue;
            pos = pattern.indexOf(r);
        }
        return pos;
    }

    private static String getTokenFromTemplate(String template, String[] possibleTokens) {
        for (String token : possibleTokens) {
            if (!TvShowRenamer.containsToken(template, token)) continue;
            return token;
        }
        return "";
    }

    private static boolean containsToken(String template, String token) {
        Pattern pattern = Pattern.compile("\\$\\{" + token + "[\\[\\};]");
        Matcher matcher = pattern.matcher(template);
        return matcher.find();
    }

    private static String getMediaFileExtension(MediaFile mf) {
        String ext = mf.getExtension().replace("jpeg", "jpg");
        if (ext.equalsIgnoreCase("tbn")) {
            String cont = mf.getContainerFormat();
            if (cont.equalsIgnoreCase("PNG")) {
                ext = "png";
            } else if (cont.equalsIgnoreCase("JPEG")) {
                ext = "jpg";
            }
        }
        return ext;
    }

    private static boolean moveFile(Path oldFilename, Path newFilename) {
        try {
            boolean ok;
            if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
            }
            if (ok = Utils.moveFileSafe(oldFilename, newFilename)) {
                return true;
            }
            LOGGER.error("Could not move MF '{}' to '{}'", (Object)oldFilename, (Object)newFilename);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("error moving file", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)oldFilename, "message.renamer.failedrename", new String[]{":", e.getLocalizedMessage()}));
            return false;
        }
    }

    private static boolean copyFile(Path oldFilename, Path newFilename) {
        if (!oldFilename.toAbsolutePath().toString().equals(newFilename.toAbsolutePath().toString())) {
            LOGGER.debug("copy file " + oldFilename + " to " + newFilename);
            if (oldFilename.equals(newFilename)) {
                return TvShowRenamer.moveFile(oldFilename, newFilename);
            }
            try {
                if (!Files.exists(newFilename.getParent(), new LinkOption[0])) {
                    Files.createDirectory(newFilename.getParent(), new FileAttribute[0]);
                }
                Utils.copyFileSafe(oldFilename, newFilename, true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static String getStackingString(MediaFile mf) {
        String delimiter = ".";
        if (TvShowModuleManager.getInstance().getSettings().isRenamerFilenameSpaceSubstitution()) {
            delimiter = TvShowModuleManager.getInstance().getSettings().getRenamerFilenameSpaceReplacement();
        }
        if (!mf.getStackingMarker().isEmpty()) {
            return delimiter + mf.getStackingMarker();
        }
        if (mf.getStacking() != 0) {
            return delimiter + "CD" + mf.getStacking();
        }
        return "";
    }

    public static String replaceInvalidCharacters(String source) {
        String result = source;
        if ("-".equals(TvShowModuleManager.getInstance().getSettings().getRenamerColonReplacement())) {
            result = result.replace(": ", " - ");
            result = result.replace(":", "-");
        } else {
            result = result.replace(":", TvShowModuleManager.getInstance().getSettings().getRenamerColonReplacement());
        }
        return result.replaceAll("([\":<>|?*])", "");
    }

    public static String isPatternValid(String pattern) {
        Object err = "";
        Pattern p = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = p.matcher(pattern);
        while (matcher.find()) {
            String tok;
            String fulltoken = matcher.group(1);
            String token = "";
            if (fulltoken.contains(",")) {
                String[] split = fulltoken.split(",");
                token = split[1];
            } else if (fulltoken.contains("[")) {
                token = fulltoken.substring(0, fulltoken.indexOf(91));
            } else if (fulltoken.contains(";")) {
                token = fulltoken.substring(0, fulltoken.indexOf(59));
                String first = fulltoken.substring(fulltoken.indexOf(59) + 1);
                if (!first.equals("first")) {
                    err = (String)err + "  " + matcher.group();
                }
            } else {
                token = fulltoken;
            }
            if ((tok = TOKEN_MAP.get(token.trim())) != null) continue;
            err = (String)err + "  " + matcher.group();
        }
        return err;
    }

    private static /* synthetic */ int lambda$generateEpisodeFilenames$0(TvShowEpisode ep1, TvShowEpisode ep2) {
        if (ep1.getSeason() != ep2.getSeason()) {
            return Integer.compare(ep1.getSeason(), ep2.getSeason());
        }
        return Integer.compare(ep1.getEpisode(), ep2.getEpisode());
    }

    public static class TvShowNamedFirstCharacterRenderer
    implements NamedRenderer {
        private static final Pattern FIRST_ALPHANUM_PATTERN = Pattern.compile("[\\p{L}\\d]");

        public String render(Object o, String s, Locale locale, Map<String, Object> map) {
            String source;
            Matcher matcher;
            if (o instanceof String && StringUtils.isNotBlank((CharSequence)((String)o)) && (matcher = FIRST_ALPHANUM_PATTERN.matcher(source = StrgUtils.convertToAscii((String)o, false))).find()) {
                String first = matcher.group();
                if (first.matches("\\p{L}")) {
                    return first.toUpperCase(Locale.ROOT);
                }
                return TvShowModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
            }
            if (o instanceof Number) {
                return TvShowModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
            }
            if (o instanceof Date) {
                return TvShowModuleManager.getInstance().getSettings().getRenamerFirstCharacterNumberReplacement();
            }
            return "";
        }

        public String getName() {
            return "first";
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{Date.class, String.class, Integer.class, Long.class};
        }
    }
}

