/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToKodiConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.w3c.dom.Element;

public class TvShowEpisodeToEmbyConnector
extends TvShowEpisodeToKodiConnector {
    public TvShowEpisodeToEmbyConnector(List<TvShowEpisode> episodes) {
        super(episodes);
    }

    @Override
    protected void addOwnTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        super.addOwnTags(episode, parser);
        this.addLockdata(episode, parser);
        if (episode.isMultiEpisode()) {
            TvShowEpisode highest = new TvShowEpisode();
            for (TvShowEpisode tvShowEpisode : this.episodes) {
                if (tvShowEpisode.getSeason() > highest.getSeason()) {
                    highest = tvShowEpisode;
                }
                if (tvShowEpisode.getSeason() != highest.getSeason() || tvShowEpisode.getEpisode() <= highest.getEpisode()) continue;
                highest = tvShowEpisode;
            }
            this.addEpisodeNumberEnd(highest, parser);
        }
    }

    protected void addEpisodeNumberEnd(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element episodenumberend = this.document.createElement("episodenumberend");
        episodenumberend.setTextContent(String.valueOf(episode.getEpisode()));
        this.root.appendChild(episodenumberend);
    }

    protected void addLockdata(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element lockdata = this.document.createElement("lockdata");
        lockdata.setTextContent("true");
        this.root.appendChild(lockdata);
    }

    @Override
    protected void addDirectors(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (Person director : episode.getDirectors()) {
            int tmdbid;
            Element element = this.document.createElement("director");
            String imdbId = director.getIdAsString("imdb");
            if (StringUtils.isNotBlank((CharSequence)imdbId)) {
                element.setAttribute("imdbid", imdbId);
            }
            if ((tmdbid = director.getIdAsInt("tmdb")) > 0) {
                element.setAttribute("tmdbid", String.valueOf(tmdbid));
            }
            element.setTextContent(director.getName());
            this.root.appendChild(element);
        }
    }
}

