/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowToKodiConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.w3c.dom.Element;

public class TvShowToEmbyConnector
extends TvShowToKodiConnector {
    public TvShowToEmbyConnector(TvShow tvShow) {
        super(tvShow);
    }

    @Override
    protected void addOwnTags() {
        super.addOwnTags();
        this.addEnddate();
        this.addLockdata();
    }

    protected void addEnddate() {
        if (!TvShowModuleManager.getInstance().getSettings().isNfoWriteDateEnded() || this.tvShow.getStatus() != MediaAiredStatus.ENDED) {
            return;
        }
        Date latestAiredDate = null;
        for (TvShowEpisode episode : this.tvShow.getEpisodes()) {
            if (episode.getFirstAired() == null || latestAiredDate != null && !latestAiredDate.before(episode.getFirstAired())) continue;
            latestAiredDate = episode.getFirstAired();
        }
        for (TvShowEpisode episode : this.tvShow.getDummyEpisodes()) {
            if (episode.getFirstAired() == null || latestAiredDate != null && !latestAiredDate.before(episode.getFirstAired())) continue;
            latestAiredDate = episode.getFirstAired();
        }
        if (latestAiredDate != null) {
            Element enddate = this.document.createElement("enddate");
            enddate.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(latestAiredDate));
            this.root.appendChild(enddate);
        }
    }

    protected void addLockdata() {
        Element lockdata = this.document.createElement("lockdata");
        lockdata.setTextContent("true");
        this.root.appendChild(lockdata);
    }
}

