/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;

public class TvShowEpisodeScrapeTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeScrapeTask.class);
    private final List<TvShowEpisode> episodes;
    private final TvShowEpisodeSearchAndScrapeOptions scrapeOptions;
    private final List<TvShowEpisodeScraperMetadataConfig> config;
    private final boolean overwrite;

    public TvShowEpisodeScrapeTask(List<TvShowEpisode> episodes, TvShowEpisodeSearchAndScrapeOptions options, List<TvShowEpisodeScraperMetadataConfig> config, boolean overwrite) {
        super(TmmResourceBundle.getString("tvshow.scraping"), episodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.episodes = episodes;
        this.scrapeOptions = options;
        this.config = config;
        this.overwrite = overwrite;
    }

    @Override
    public void doInBackground() {
        MediaScraper mediaScraper = this.scrapeOptions.getMetadataScraper();
        if (!mediaScraper.isEnabled()) {
            return;
        }
        for (TvShowEpisode tvShowEpisode : this.episodes) {
            if (tvShowEpisode.getTvShow().getIds().isEmpty()) {
                LOGGER.info("we cannot scrape (no ID): {} - {}", (Object)tvShowEpisode.getTvShow().getTitle(), (Object)tvShowEpisode.getTitle());
                continue;
            }
            TvShowEpisodeSearchAndScrapeOptions options = new TvShowEpisodeSearchAndScrapeOptions(this.scrapeOptions);
            options.setTvShowIds(tvShowEpisode.getTvShow().getIds());
            MediaMetadata md = new MediaMetadata(mediaScraper.getMediaProvider().getProviderInfo().getId());
            md.setReleaseDate(tvShowEpisode.getFirstAired());
            options.setMetadata(md);
            options.setIds(tvShowEpisode.getIds());
            if (tvShowEpisode.isDvdOrder()) {
                options.setId("dvdSeasonNr", String.valueOf(tvShowEpisode.getDvdSeason()));
                options.setId("dvdEpisodeNr", String.valueOf(tvShowEpisode.getDvdEpisode()));
            } else {
                options.setId("seasonNr", String.valueOf(tvShowEpisode.getAiredSeason()));
                options.setId("episodeNr", String.valueOf(tvShowEpisode.getAiredEpisode()));
            }
            try {
                LOGGER.info("=====================================================");
                LOGGER.info("Scrape metadata with scraper: {}", (Object)mediaScraper.getMediaProvider().getProviderInfo().getId());
                LOGGER.info(options.toString());
                LOGGER.info("=====================================================");
                MediaMetadata metadata = ((ITvShowMetadataProvider)mediaScraper.getMediaProvider()).getMetadata(options);
                if (!StringUtils.isNotBlank((CharSequence)metadata.getTitle())) continue;
                tvShowEpisode.setMetadata(metadata, this.config, this.overwrite);
                tvShowEpisode.setLastScraperId(this.scrapeOptions.getMetadataScraper().getId());
                tvShowEpisode.setLastScrapeLanguage(this.scrapeOptions.getLanguage().name());
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, tvShowEpisode, "scraper.error.missingid"));
            }
            catch (NothingFoundException ignored) {
                LOGGER.debug("nothing found");
            }
            catch (ScrapeException e) {
                LOGGER.error("searchMovieFallback", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShowEpisode, "message.scrape.metadataepisodefailed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
            HashSet<TvShow> tvShows = new HashSet<TvShow>();
            for (TvShowEpisode episode : this.episodes) {
                tvShows.add(episode.getTvShow());
            }
            TvShowSyncTraktTvTask tvShowSyncTraktTvTask = new TvShowSyncTraktTvTask(new ArrayList<TvShow>(tvShows));
            tvShowSyncTraktTvTask.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
            tvShowSyncTraktTvTask.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
            tvShowSyncTraktTvTask.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
            TmmTaskManager.getInstance().addUnnamedTask(tvShowSyncTraktTvTask);
        }
    }
}

