/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.SubtitleDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowSubtitleProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class TvShowSubtitleSearchAndDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSubtitleSearchAndDownloadTask.class);
    private final List<TvShowEpisode> episodes;
    private final List<MediaScraper> subtitleScrapers;
    private final MediaLanguages language;
    private boolean forceBestMatch;

    public TvShowSubtitleSearchAndDownloadTask(List<TvShowEpisode> episodes, MediaLanguages language) {
        super(TmmResourceBundle.getString("tvshow.download.subtitles"));
        this.episodes = episodes;
        this.language = language;
        this.subtitleScrapers = new ArrayList<MediaScraper>(TvShowModuleManager.getInstance().getTvShowList().getDefaultSubtitleScrapers());
    }

    public TvShowSubtitleSearchAndDownloadTask(List<TvShowEpisode> episodes, List<MediaScraper> subtitleScrapers, MediaLanguages language) {
        super(TmmResourceBundle.getString("tvshow.download.subtitles"));
        this.episodes = episodes;
        this.subtitleScrapers = subtitleScrapers;
        this.language = language;
    }

    public void setForceBestMatch(boolean forceBestMatch) {
        this.forceBestMatch = forceBestMatch;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "searchAndDownloadSubtitles");
        this.start();
        for (TvShowEpisode episode : this.episodes) {
            this.submitTask(new Worker(episode));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done searching and downloading subtitles");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private final TvShowEpisode episode;

        Worker(TvShowEpisode episode) {
            this.episode = episode;
        }

        @Override
        public void run() {
            try {
                for (MediaScraper scraper : TvShowSubtitleSearchAndDownloadTask.this.subtitleScrapers) {
                    if (!scraper.isEnabled()) continue;
                    try {
                        List<SubtitleSearchResult> searchResults;
                        MediaFile mf = this.episode.getMediaFiles(MediaFileType.VIDEO).get(0);
                        ITvShowSubtitleProvider subtitleProvider = (ITvShowSubtitleProvider)scraper.getMediaProvider();
                        SubtitleSearchAndScrapeOptions options = new SubtitleSearchAndScrapeOptions(MediaType.TV_EPISODE);
                        options.setFile(mf.getFileAsPath().toFile());
                        options.setLanguage(TvShowSubtitleSearchAndDownloadTask.this.language);
                        options.setSeason(this.episode.getSeason());
                        options.setEpisode(this.episode.getEpisode());
                        String imdbId = this.episode.getTvShow().getImdbId();
                        if (StringUtils.isBlank((CharSequence)imdbId)) {
                            MediaIdUtil.getImdbIdFromTvdbId(this.episode.getTvShow().getTvdbId());
                        }
                        if (StringUtils.isNotBlank((CharSequence)imdbId)) {
                            options.setImdbId(imdbId);
                        }
                        if ((searchResults = subtitleProvider.search(options)).isEmpty()) continue;
                        Collections.sort(searchResults);
                        Collections.reverse(searchResults);
                        SubtitleSearchResult result = this.getBestResult(searchResults);
                        if (result == null) continue;
                        String lang = LanguageStyle.getLanguageCodeForStyle(TvShowSubtitleSearchAndDownloadTask.this.language.name(), TvShowModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = TvShowSubtitleSearchAndDownloadTask.this.language.name();
                        }
                        String filename = FilenameUtils.getBaseName((String)mf.getFilename()) + "." + lang;
                        TmmTaskManager.getInstance().addDownloadTask(new SubtitleDownloadTask(result.getUrl(), this.episode.getPathNIO().resolve(filename), this.episode));
                    }
                    catch (MissingIdException mf) {
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getSubtitles", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.episode, "message.scrape.subtitlefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"SubtitleDownloader", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }

        private SubtitleSearchResult getBestResult(List<SubtitleSearchResult> searchResults) {
            if (ListUtils.isEmpty(searchResults)) {
                return null;
            }
            SubtitleSearchResult hashMatch = searchResults.stream().filter(result -> result.getScore() == 1.0f && StringUtils.isNotBlank((CharSequence)result.getUrl())).findFirst().orElse(null);
            if (hashMatch != null || !TvShowSubtitleSearchAndDownloadTask.this.forceBestMatch) {
                return hashMatch;
            }
            List filteredResults = searchResults.stream().filter(result -> {
                if (this.episode.isStacked() && result.getStackCount() > 1) {
                    return true;
                }
                return !this.episode.isStacked() && result.getStackCount() == 1;
            }).collect(Collectors.toList());
            if (filteredResults.isEmpty()) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)this.episode.getOriginalFilename())) {
                String basename = FilenameUtils.getBaseName((String)this.episode.getOriginalFilename());
                for (SubtitleSearchResult result2 : filteredResults) {
                    float score = MetadataUtil.calculateScore(result2.getReleaseName(), basename);
                    if (!(score > 0.8f)) continue;
                    return result2;
                }
            }
            return (SubtitleSearchResult)filteredResults.get(0);
        }
    }
}

