/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.http.Url;

public class TvShowThemeDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowThemeDownloadTask.class);
    private final List<TvShow> tvShows = new ArrayList<TvShow>();
    private final boolean overwrite;

    public TvShowThemeDownloadTask(List<TvShow> tvShows, boolean overwrite) {
        super(TmmResourceBundle.getString("theme.download"));
        this.tvShows.addAll(tvShows);
        this.overwrite = overwrite;
    }

    @Override
    protected void doInBackground() {
        this.initThreadPool(3, "themeDownload");
        this.start();
        for (TvShow tvShow : this.tvShows) {
            this.submitTask(new Worker(tvShow, this.overwrite));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done downloading themes");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private static class Worker
    implements Runnable {
        private final TvShow tvShow;
        private final boolean overwrite;

        Worker(TvShow tvShow, boolean overwrite) {
            this.tvShow = tvShow;
            this.overwrite = overwrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block26: {
                try {
                    Path tempFile;
                    Path destFile;
                    String filename;
                    block28: {
                        if (!this.overwrite && !this.tvShow.getMediaFiles(MediaFileType.THEME).isEmpty()) {
                            return;
                        }
                        int tvdbId = this.tvShow.getIdAsInt("tvdb");
                        if (tvdbId <= 0) break block26;
                        LOGGER.debug("found tvdbId '{}' - try to download the theme for it", (Object)tvdbId);
                        filename = "theme.mp3";
                        destFile = this.tvShow.getPathNIO().resolve(filename);
                        tempFile = null;
                        try {
                            Url url;
                            long timestamp = System.currentTimeMillis();
                            try {
                                Path tempFolder = Paths.get(Utils.getTempFolder(), new String[0]);
                                if (!Files.exists(tempFolder, new LinkOption[0])) {
                                    Files.createDirectory(tempFolder, new FileAttribute[0]);
                                }
                                tempFile = tempFolder.resolve("theme." + tvdbId + "." + timestamp + ".part");
                            }
                            catch (Exception e) {
                                LOGGER.debug("could not write to temp folder: {}", (Object)e.getMessage());
                                tempFile = destFile.resolveSibling("theme." + tvdbId + "." + timestamp + ".part");
                            }
                            String urlAsString = "http://tvthemes.plexapp.com/" + tvdbId + ".mp3";
                            try {
                                url = new Url(urlAsString);
                            }
                            catch (Exception e) {
                                LOGGER.error("downloading {} - {}", (Object)urlAsString, (Object)e.getMessage());
                                throw e;
                            }
                            try (InputStream is = url.getInputStreamWithRetry(5);
                                 FileOutputStream outputStream = new FileOutputStream(tempFile.toFile());){
                                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                                Utils.flushFileOutputStreamToDisk(outputStream);
                            }
                            if (Files.exists(tempFile, new LinkOption[0]) && Files.size(tempFile) != 0L) break block28;
                            FileUtils.deleteQuietly((File)tempFile.toFile());
                        }
                        catch (Throwable throwable) {
                            if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                                Utils.deleteFileSafely(tempFile);
                            }
                            throw throwable;
                        }
                        if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                            Utils.deleteFileSafely(tempFile);
                        }
                        return;
                    }
                    Utils.deleteFileSafely(destFile);
                    if (!Utils.moveFileSafe(tempFile, destFile)) {
                        throw new IOException("renaming temp file failed: " + filename);
                    }
                    MediaFile mediaFile = new MediaFile(destFile);
                    mediaFile.gatherMediaInformation();
                    this.tvShow.addToMediaFiles(mediaFile);
                    this.tvShow.saveToDb();
                    if (tempFile != null && Files.exists(tempFile, new LinkOption[0])) {
                        Utils.deleteFileSafely(tempFile);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"ThemeDownloader", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }
    }
}

