/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.VSMeta;
import org.tinymediamanager.thirdparty.trakttv.TvShowSyncTraktTvTask;

public class TvShowUpdateDatasourceTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowUpdateDatasourceTask.class);
    private static final List<String> SKIP_FOLDERS = Arrays.asList(".", "..", "CERTIFICATE", "$RECYCLE.BIN", "RECYCLER", "SYSTEM VOLUME INFORMATION", "@EADIR", "ADV_OBJ", "EXTRAS", "EXTRA", "EXTRATHUMB", "PLEX VERSIONS");
    private static final String SKIP_REGEX = "^[.][\\w@]+.*";
    private static final Pattern seasonNumber = Pattern.compile("(?i)season([0-9]{1,4}).*");
    private static long preDir = 0L;
    private static long postDir = 0L;
    private static long visFile = 0L;
    private final List<String> dataSources;
    private final List<String> skipFolders;
    private final List<Path> tvShowFolders = new ArrayList<Path>();
    private final TvShowList tvShowList;
    private final Set<Path> filesFound = ConcurrentHashMap.newKeySet();

    public TvShowUpdateDatasourceTask() {
        super(TmmResourceBundle.getString("update.datasource"));
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.dataSources = new ArrayList<String>(TvShowModuleManager.getInstance().getSettings().getTvShowDataSource());
        this.skipFolders = new ArrayList<String>(TvShowModuleManager.getInstance().getSettings().getSkipFolder());
    }

    public TvShowUpdateDatasourceTask(String datasource) {
        super(TmmResourceBundle.getString("update.datasource") + " (" + datasource + ")");
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.dataSources = new ArrayList<String>(1);
        this.dataSources.add(datasource);
        this.skipFolders = new ArrayList<String>(TvShowModuleManager.getInstance().getSettings().getSkipFolder());
    }

    public TvShowUpdateDatasourceTask(List<Path> tvShowFolders) {
        super(TmmResourceBundle.getString("update.datasource"));
        this.tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        this.dataSources = new ArrayList<String>(0);
        this.skipFolders = new ArrayList<String>(TvShowModuleManager.getInstance().getSettings().getSkipFolder());
        this.tvShowFolders.addAll(tvShowFolders);
    }

    @Override
    public void doInBackground() {
        Utils.removeEmptyStringsFromList(this.dataSources);
        if (this.dataSources.isEmpty() && this.tvShowFolders.isEmpty()) {
            LOGGER.info("no datasource to update");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "update.datasource.nonespecified"));
            return;
        }
        TvShowUpdateDatasourceTask.resetCounters();
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.start();
            ArrayList<Path> existing = new ArrayList<Path>();
            for (TvShow show : this.tvShowList.getTvShows()) {
                existing.add(show.getPathNIO());
            }
            if (this.tvShowFolders.isEmpty()) {
                for (String ds : this.dataSources) {
                    if (this.skipFolders.contains(ds)) {
                        LOGGER.debug("datasource '{}' is also a skipfolder - skipping", (Object)ds);
                        continue;
                    }
                    LOGGER.info("Start UDS on datasource: {}", (Object)ds);
                    this.initThreadPool(3, "update");
                    this.setTaskName(TmmResourceBundle.getString("update.datasource") + " '" + ds + "'");
                    this.publishState();
                    Path dsAsPath = Paths.get(ds, new String[0]);
                    if (!Files.exists(dsAsPath, new LinkOption[0])) {
                        LOGGER.warn("Datasource not available/empty {}", (Object)ds);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    this.publishState();
                    ArrayList<Path> newTvShowDirs = new ArrayList<Path>();
                    ArrayList<Path> existingTvShowDirs = new ArrayList<Path>();
                    List<Path> rootList = this.listFilesAndDirs(dsAsPath);
                    if (rootList.isEmpty() && !SystemUtils.IS_OS_WINDOWS) {
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{ds}));
                        continue;
                    }
                    for (Path path : rootList) {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (path.getFileName().toString().length() == 1) {
                                List<Path> subList = this.listFilesAndDirs(path);
                                for (Path sub : subList) {
                                    if (!Files.isDirectory(sub, new LinkOption[0])) continue;
                                    if (existing.contains(sub)) {
                                        existingTvShowDirs.add(sub);
                                        continue;
                                    }
                                    newTvShowDirs.add(sub);
                                }
                                continue;
                            }
                            if (existing.contains(path)) {
                                existingTvShowDirs.add(path);
                                continue;
                            }
                            newTvShowDirs.add(path);
                            continue;
                        }
                        String ext = FilenameUtils.getExtension((String)path.getFileName().toString()).toLowerCase(Locale.ROOT);
                        if (!Settings.getInstance().getVideoFileType().contains("." + ext)) continue;
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.episodeinroot", new String[]{path.getFileName().toString()}));
                    }
                    for (Path subdir : newTvShowDirs) {
                        this.submitTask(new FindTvShowTask(subdir, dsAsPath.toAbsolutePath()));
                    }
                    for (Path subdir : existingTvShowDirs) {
                        this.submitTask(new FindTvShowTask(subdir, dsAsPath.toAbsolutePath()));
                    }
                    this.waitForCompletionOrCancel();
                    LOGGER.info("FilesFound: {}", (Object)this.filesFound.size());
                    LOGGER.info("tvShowsFound: {}", (Object)this.tvShowList.getTvShowCount());
                    LOGGER.info("episodesFound: {}", (Object)this.tvShowList.getEpisodeCount());
                    LOGGER.debug("PreDir: {}", (Object)preDir);
                    LOGGER.debug("PostDir: {}", (Object)postDir);
                    LOGGER.debug("VisFile: {}", (Object)visFile);
                    if (!this.cancel) {
                        this.cleanupDatasource(ds);
                        this.waitForCompletionOrCancel();
                        if (!this.cancel) continue;
                    }
                    break;
                }
            } else {
                this.initThreadPool(3, "update");
                for (Path path : this.tvShowFolders) {
                    if (!Files.exists(path, new LinkOption[0])) {
                        LOGGER.warn("Datasource not available/empty - {}", (Object)path.toAbsolutePath());
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"update.datasource", "update.datasource.unavailable", new String[]{path.toAbsolutePath().toString()}));
                        continue;
                    }
                    this.submitTask(new FindTvShowTask(path, path.getParent().toAbsolutePath()));
                }
                this.waitForCompletionOrCancel();
                LOGGER.info("FilesFound: {}", (Object)this.filesFound.size());
                LOGGER.info("tvShowsFound: {}", (Object)this.tvShowList.getTvShowCount());
                LOGGER.info("episodesFound: {}", (Object)this.tvShowList.getEpisodeCount());
                LOGGER.debug("PreDir: {}", (Object)preDir);
                LOGGER.debug("PostDir: {}", (Object)postDir);
                LOGGER.debug("VisFile: {}", (Object)visFile);
                if (!this.cancel) {
                    this.cleanupShows();
                    this.waitForCompletionOrCancel();
                }
            }
            if (this.cancel) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                KodiRPC.getInstance().updateTvShowMappings();
            }
            LOGGER.info("getting Mediainfo...");
            this.initThreadPool(1, "mediainfo");
            this.setTaskName(TmmResourceBundle.getString("update.mediainfo"));
            this.setTaskDescription(null);
            this.setProgressDone(0);
            if (!this.cancel) {
                TvShow tvShow;
                int i;
                if (this.tvShowFolders.isEmpty()) {
                    for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (!this.dataSources.contains(tvShow.getDataSource())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                } else {
                    for (i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
                        tvShow = this.tvShowList.getTvShows().get(i);
                        if (!this.tvShowFolders.contains(tvShow.getPathNIO())) continue;
                        this.gatherMediaInformationForUngatheredMediaFiles(tvShow);
                    }
                }
                this.waitForCompletionOrCancel();
            }
            if (this.cancel) {
                return;
            }
            if (TvShowModuleManager.getInstance().getSettings().getSyncTrakt()) {
                TvShowSyncTraktTvTask task = new TvShowSyncTraktTvTask(TvShowModuleManager.getInstance().getTvShowList().getTvShows());
                task.setSyncCollection(TvShowModuleManager.getInstance().getSettings().getSyncTraktCollection());
                task.setSyncWatched(TvShowModuleManager.getInstance().getSettings().getSyncTraktWatched());
                task.setSyncRating(TvShowModuleManager.getInstance().getSettings().getSyncTraktRating());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            stopWatch.stop();
            LOGGER.info("Done updating datasource :) - took {}", (Object)stopWatch);
            TvShowUpdateDatasourceTask.resetCounters();
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "update.datasource", "message.update.threadcrashed"));
        }
    }

    private void cleanupShows() {
        this.setTaskName(TmmResourceBundle.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned movies/files...");
        for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            TvShow tvShow = this.tvShowList.getTvShows().get(i);
            if (!this.tvShowFolders.contains(tvShow.getPathNIO())) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanupDatasource(String datasource) {
        this.setTaskName(TmmResourceBundle.getString("update.cleanup"));
        this.setTaskDescription(null);
        this.setProgressDone(0);
        this.setWorkUnits(0);
        this.publishState();
        LOGGER.info("removing orphaned tv shows/files...");
        for (int i = this.tvShowList.getTvShows().size() - 1; i >= 0 && !this.cancel; --i) {
            TvShow tvShow = this.tvShowList.getTvShows().get(i);
            if (!Paths.get(datasource, new String[0]).toAbsolutePath().equals(Paths.get(tvShow.getDataSource(), new String[0]).toAbsolutePath())) continue;
            if (!Files.exists(tvShow.getPathNIO(), new LinkOption[0])) {
                this.tvShowList.removeTvShow(tvShow);
                continue;
            }
            this.cleanup(tvShow);
        }
    }

    private void cleanup(TvShow tvShow) {
        boolean dirty = false;
        if (!tvShow.isNewlyAdded() || tvShow.hasNewlyAddedEpisodes()) {
            ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>(tvShow.getMediaFiles());
            for (MediaFile mf : mediaFiles) {
                if (this.filesFound.contains(mf.getFileAsPath())) continue;
                LOGGER.debug("removing orphaned file: {}", (Object)mf.getFileAsPath());
                tvShow.removeFromMediaFiles(mf);
                if (mf.isGraphic()) {
                    ImageCache.invalidateCachedImage(mf);
                    tvShow.removeSeasonArtwork(mf);
                }
                dirty = true;
            }
            ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(tvShow.getEpisodes());
            for (TvShowEpisode episode : episodes) {
                mediaFiles = new ArrayList<MediaFile>(episode.getMediaFiles());
                for (MediaFile mf : mediaFiles) {
                    if (this.filesFound.contains(mf.getFileAsPath())) continue;
                    LOGGER.debug("removing orphaned file: {}", (Object)mf.getFileAsPath());
                    episode.removeFromMediaFiles(mf);
                    if (mf.isGraphic()) {
                        ImageCache.invalidateCachedImage(mf);
                    }
                    dirty = true;
                }
                List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                if (!mfs.isEmpty()) continue;
                tvShow.removeEpisode(episode);
                dirty = true;
            }
        }
        if (dirty) {
            tvShow.saveToDb();
        }
    }

    private void gatherMediaInformationForUngatheredMediaFiles(TvShow tvShow) {
        boolean dirty = false;
        for (MediaFile mf : tvShow.getMediaFiles()) {
            if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                this.submitTask(new MediaFileInformationFetcherTask(mf, tvShow, false));
                continue;
            }
            if (MediaFileHelper.gatherFileInformation(mf)) {
                this.submitTask(new MediaFileInformationFetcherTask(mf, tvShow, true));
            }
            dirty = true;
        }
        if (dirty) {
            tvShow.saveToDb();
        }
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(tvShow.getEpisodes())) {
            dirty = false;
            for (MediaFile mf : episode.getMediaFiles()) {
                if (StringUtils.isBlank((CharSequence)mf.getContainerFormat())) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, episode, false));
                    continue;
                }
                if (MediaFileHelper.gatherFileInformation(mf)) {
                    this.submitTask(new MediaFileInformationFetcherTask(mf, episode, true));
                }
                dirty = true;
            }
            if (!dirty) continue;
            episode.saveToDb();
        }
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private List<Path> listFilesAndDirs(Path directory) {
        ArrayList<Path> fileNames = new ArrayList();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory);){
            for (Path path : directoryStream) {
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(SKIP_FOLDERS.contains(fn) || fn.matches(SKIP_REGEX) || this.skipFolders.contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: {}", (Object)path);
            }
        }
        catch (IOException e) {
            LOGGER.error("error on listFilesAndDirs", (Throwable)e);
            LOGGER.debug("falling back to the alternate coding");
            fileNames = this.listFilesAndDirs2(directory);
        }
        return fileNames;
    }

    private List<Path> listFilesAndDirs2(Path directory) {
        ArrayList<Path> fileNames = new ArrayList<Path>();
        try (Stream<Path> directoryStream = Files.walk(directory, 1, FileVisitOption.FOLLOW_LINKS);){
            List allElements = directoryStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            for (Path path : allElements) {
                if (directory.toAbsolutePath().equals(path.toAbsolutePath())) continue;
                String fn = path.getFileName().toString().toUpperCase(Locale.ROOT);
                if (!(SKIP_FOLDERS.contains(fn) || fn.matches(SKIP_REGEX) || this.skipFolders.contains(path.toFile().getAbsolutePath()))) {
                    fileNames.add(path.toAbsolutePath());
                    continue;
                }
                LOGGER.debug("Skipping: {}", (Object)path);
            }
        }
        catch (Exception e) {
            LOGGER.error("error on listFilesAndDirs2", (Throwable)e);
        }
        return fileNames;
    }

    private static void resetCounters() {
        visFile = 0L;
        preDir = 0L;
        postDir = 0L;
    }

    private static synchronized void incVisFile() {
        ++visFile;
    }

    private static synchronized void incPreDir() {
        ++preDir;
    }

    private static synchronized void incPostDir() {
        ++postDir;
    }

    private static class AllFilesRecursive
    extends AbstractFileVisitor {
        private final Set<Path> fFound = new HashSet<Path>();
        private final List<String> skipFolders;

        public AllFilesRecursive(List<String> skipFolders) {
            this.skipFolders = new ArrayList<String>(skipFolders);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            TvShowUpdateDatasourceTask.incVisFile();
            if (file.getFileName() == null) {
                return FileVisitResult.CONTINUE;
            }
            String filename = file.getFileName().toString();
            String path = "";
            if (file.getParent() != null && file.getParent().getFileName() != null) {
                path = file.getParent().getFileName().toString();
            }
            if (Utils.isRegularFile(attr) && path.matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                if (FilenameUtils.getExtension((String)filename).equalsIgnoreCase("nfo")) {
                    this.fFound.add(file.toAbsolutePath());
                }
                return FileVisitResult.CONTINUE;
            }
            if (MediaFileHelper.isMainDiscIdentifierFile(filename)) {
                this.fFound.add(file.toAbsolutePath());
                return FileVisitResult.CONTINUE;
            }
            if (Utils.isRegularFile(attr) && !filename.matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) {
                this.fFound.add(file.toAbsolutePath());
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            TvShowUpdateDatasourceTask.incPreDir();
            if (dir.getFileName() != null && (Files.exists(dir.resolve(".tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve("tmmignore"), new LinkOption[0]) || Files.exists(dir.resolve(".nomedia"), new LinkOption[0]) || SKIP_FOLDERS.contains(dir.getFileName().toString().toUpperCase(Locale.ROOT)) || dir.getFileName().toString().matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) || this.skipFolders.contains(dir.toFile().getAbsolutePath())) {
                LOGGER.debug("Skipping dir: {}", (Object)dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (dir.getFileName() != null && dir.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                this.fFound.add(dir.toAbsolutePath());
                return FileVisitResult.CONTINUE;
            }
            if (dir.getParent() != null && dir.getParent().getFileName() != null && dir.getParent().getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            TvShowUpdateDatasourceTask.incPostDir();
            return FileVisitResult.CONTINUE;
        }
    }

    private class FindTvShowTask
    implements Callable<Object> {
        private final Path showDir;
        private final Path datasource;
        private final long uniqueId;

        public FindTvShowTask(Path showDir, Path datasource) {
            this.showDir = showDir;
            this.datasource = datasource;
            this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
        }

        @Override
        public String call() throws Exception {
            Object name = Thread.currentThread().getName();
            if (!((String)name).contains("-G")) {
                name = (String)name + "-G0";
            }
            name = ((String)name).replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName((String)name);
            if (this.showDir.getFileName().toString().matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) {
                LOGGER.debug("Skipping dir: {}", (Object)this.showDir);
                return "";
            }
            Set<Path> allFiles = this.getAllFilesRecursive(this.showDir, Integer.MAX_VALUE);
            if (allFiles == null || allFiles.isEmpty()) {
                LOGGER.info("skip empty directory: {}", (Object)this.showDir);
                return "";
            }
            LOGGER.info("start parsing {}", (Object)this.showDir);
            TvShowUpdateDatasourceTask.this.filesFound.add(this.showDir.toAbsolutePath());
            TvShowUpdateDatasourceTask.this.filesFound.addAll(allFiles);
            ArrayList<MediaFile> mfs = new ArrayList<MediaFile>();
            for (Path file : allFiles) {
                if (file.getFileName().toString().matches(TvShowUpdateDatasourceTask.SKIP_REGEX)) continue;
                MediaFile mf = new MediaFile(file);
                if (mf.getType() == MediaFileType.POSTER && !mf.getFileAsPath().getParent().equals(this.showDir)) {
                    if (mf.getFileAsPath().getParent().getParent().equals(this.showDir)) {
                        mf.setType(MediaFileType.SEASON_POSTER);
                    } else {
                        mf.setType(MediaFileType.GRAPHIC);
                    }
                }
                mfs.add(mf);
            }
            allFiles.clear();
            if (this.getMediaFiles(mfs, MediaFileType.VIDEO).isEmpty()) {
                LOGGER.info("no video file found in directory {}", (Object)this.showDir);
                return "";
            }
            TvShow tvShow = TvShowUpdateDatasourceTask.this.tvShowList.getTvShowByPath(this.showDir);
            MediaFile showNFO = new MediaFile(this.showDir.resolve("tvshow.nfo"), MediaFileType.NFO);
            if (tvShow == null) {
                if (Files.exists(showNFO.getFileAsPath(), new LinkOption[0])) {
                    try {
                        TvShowNfoParser parser = TvShowNfoParser.parseNfo(showNFO.getFileAsPath());
                        tvShow = parser.toTvShow();
                    }
                    catch (Exception e) {
                        LOGGER.warn("problem parsing NFO: {}", (Object)e.getMessage());
                    }
                }
                if (tvShow == null) {
                    tvShow = new TvShow();
                }
                if (StringUtils.isBlank((CharSequence)tvShow.getTitle()) || tvShow.getYear() <= 0) {
                    String[] ty = ParserUtils.detectCleanTitleAndYear(this.showDir.getFileName().toString(), TvShowModuleManager.getInstance().getSettings().getBadWord());
                    if (StringUtils.isBlank((CharSequence)tvShow.getTitle()) && StringUtils.isNotBlank((CharSequence)ty[0])) {
                        tvShow.setTitle(ty[0]);
                    }
                    if (tvShow.getYear() <= 0 && !ty[1].isEmpty()) {
                        try {
                            tvShow.setYear(Integer.parseInt(ty[1]));
                        }
                        catch (Exception e) {
                            LOGGER.trace("could not parse int: {}", (Object)e.getMessage());
                        }
                    }
                }
                if ((tvShow.getImdbId().isEmpty() || tvShow.getTmdbId() == 0) && Files.exists(showNFO.getFileAsPath(), new LinkOption[0])) {
                    try {
                        String content = Utils.readFileToString(showNFO.getFileAsPath());
                        Iterator<AbstractModelObject> imdb = ParserUtils.detectImdbId(content);
                        if (!((String)((Object)imdb)).isEmpty()) {
                            LOGGER.debug("| Found IMDB id: {}", (Object)imdb);
                            tvShow.setImdbId((String)((Object)imdb));
                        }
                        String tmdb = StrgUtils.substr(content, "themoviedb\\.org\\/tv\\/(\\d+)");
                        if (tvShow.getTmdbId() == 0 && !tmdb.isEmpty()) {
                            LOGGER.debug("| Found TMDB id: {}", (Object)tmdb);
                            tvShow.setTmdbId(MetadataUtil.parseInt(tmdb, 0));
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("| couldn't read NFO {}", (Object)showNFO);
                    }
                }
                tvShow.setPath(this.showDir.toAbsolutePath().toString());
                tvShow.setDataSource(this.datasource.toString());
                tvShow.setNewlyAdded(true);
                TvShowUpdateDatasourceTask.this.tvShowList.addTvShow(tvShow);
            }
            HashSet<Path> discFolders = new HashSet<Path>();
            for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.VIDEO)) {
                List<TvShowEpisode> episodes;
                List<MediaFile> epFiles = new ArrayList<MediaFile>();
                if (mf.isDiscFile()) {
                    Path discRoot = mf.getFileAsPath().toAbsolutePath();
                    if (!discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                        discRoot = discRoot.getParent();
                    }
                    if (discFolders.contains(discRoot)) continue;
                    discFolders.add(discRoot);
                    for (MediaFile em : mfs) {
                        if (!em.getFileAsPath().startsWith(discRoot) || em.getType() == MediaFileType.UNKNOWN) continue;
                        epFiles.add(em);
                    }
                } else {
                    String basename = Utils.cleanStackingMarkers(FilenameUtils.getBaseName((String)mf.getFilename()));
                    LOGGER.trace("UDS: basename - {}", (Object)basename);
                    for (MediaFile em : mfs) {
                        String emBasename = FilenameUtils.getBaseName((String)em.getFilename());
                        String epNameRegexp = Pattern.quote(basename) + "[\\s.,_-].*";
                        if (!emBasename.equals(basename) && !emBasename.matches(epNameRegexp)) continue;
                        if (em.getType() == MediaFileType.GRAPHIC) {
                            em.setType(MediaFileType.THUMB);
                        }
                        epFiles.add(em);
                        LOGGER.trace("UDS: found matching MF - {}", (Object)em.getFile());
                    }
                }
                if ((episodes = TvShowList.getTvEpisodesByFile(tvShow, mf.getFile())).isEmpty()) {
                    Object eps;
                    TvShowEpisode episode2;
                    Iterator<Integer> meta = this.getMediaFile(epFiles, MediaFileType.VSMETA);
                    TvShowEpisode vsMetaEP = null;
                    if (meta != null) {
                        VSMeta vsmeta = new VSMeta(((MediaFile)((Object)meta)).getFileAsPath());
                        vsmeta.parseFile();
                        vsMetaEP = vsmeta.getTvShowEpisode();
                    }
                    TvShowEpisode xmlEP = null;
                    for (MediaFile xmlMf : epFiles) {
                        if (!"xml".equalsIgnoreCase(xmlMf.getExtension())) continue;
                        try {
                            TvShowEpisodeNfoParser nfoParser = TvShowEpisodeNfoParser.parseNfo(xmlMf.getFileAsPath());
                            List<TvShowEpisode> epsInXml = nfoParser.toTvShowEpisodes();
                            if (epsInXml.isEmpty()) continue;
                            xmlEP = epsInXml.get(0);
                        }
                        catch (Exception nfoParser) {}
                    }
                    MediaFile epNfo = this.getMediaFile(epFiles = epFiles.stream().filter(mediaFile -> mediaFile.getType() != MediaFileType.UNKNOWN).collect(Collectors.toList()), MediaFileType.NFO);
                    if (epNfo != null) {
                        LOGGER.debug("found episode NFO - try to parse '{}'", (Object)this.showDir.relativize(epNfo.getFileAsPath()));
                        ArrayList<TvShowEpisode> episodesInNfo = new ArrayList<TvShowEpisode>();
                        try {
                            TvShowEpisodeNfoParser parser = TvShowEpisodeNfoParser.parseNfo(epNfo.getFileAsPath());
                            if (parser.isValidNfo()) {
                                episodesInNfo.addAll(parser.toTvShowEpisodes());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("could not parse episode NFO: {}", (Object)e.getMessage());
                        }
                        if (!episodesInNfo.isEmpty()) {
                            for (TvShowEpisode episode2 : episodesInNfo) {
                                episode2.setPath(mf.getPath());
                                episode2.setTvShow(tvShow);
                                if (episode2.getMediaSource() == MediaSource.UNKNOWN) {
                                    episode2.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                                }
                                episode2.setNewlyAdded(true);
                                if (StringUtils.isBlank((CharSequence)episode2.getOriginalFilename())) {
                                    episode2.setOriginalFilename(mf.getFilename());
                                }
                                episode2.addToMediaFiles(epFiles);
                                if (mf.isDiscFile()) {
                                    episode2.setDisc(true);
                                    Path discRoot = mf.getFileAsPath().toAbsolutePath();
                                    if (!discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                                        discRoot = discRoot.getParent();
                                    }
                                    episode2.setPath(discRoot.getParent().toString());
                                }
                                if (episodesInNfo.size() > 1) {
                                    episode2.setMultiEpisode(true);
                                } else {
                                    episode2.setMultiEpisode(false);
                                }
                                episode2.merge(vsMetaEP);
                                episode2.merge(xmlEP);
                                episode2.saveToDb();
                                tvShow.addEpisode(episode2);
                            }
                            continue;
                        }
                    }
                    String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                    TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                    if (result.episodes.size() == 1 && result.season > -1 && result.stackingMarkerFound && !(eps = tvShow.getEpisode(result.season, result.episodes.get(0))).isEmpty()) {
                        boolean found = false;
                        Iterator iterator = eps.iterator();
                        while (iterator.hasNext()) {
                            String mfBasenameWoStackingMarker;
                            TvShowEpisode ep = (TvShowEpisode)iterator.next();
                            String episodeBasenameWoStackingMarker = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(ep.getMainVideoFile().getFilename()));
                            if (!episodeBasenameWoStackingMarker.equals(mfBasenameWoStackingMarker = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename())))) continue;
                            ep.setNewlyAdded(true);
                            if (StringUtils.isBlank((CharSequence)ep.getOriginalFilename())) {
                                ep.setOriginalFilename(mf.getFilename());
                            }
                            ep.addToMediaFiles(mf);
                            found = true;
                            break;
                        }
                        if (found) continue;
                    }
                    if (!result.episodes.isEmpty()) {
                        eps = result.episodes.iterator();
                        while (eps.hasNext()) {
                            int ep = eps.next();
                            TvShowEpisode episode3 = new TvShowEpisode();
                            episode3.setDvdOrder(TvShowModuleManager.getInstance().getSettings().isDvdOrder());
                            episode3.setEpisode(ep);
                            episode3.setSeason(result.season);
                            episode3.setFirstAired(result.date);
                            if (result.name.isEmpty()) {
                                result.name = FilenameUtils.getBaseName((String)mf.getFilename());
                            }
                            episode3.setTitle(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(result.name, tvShow.getTitle()));
                            episode3.setPath(mf.getPath());
                            episode3.setTvShow(tvShow);
                            episode3.addToMediaFiles(epFiles);
                            if (episode3.getMediaSource() == MediaSource.UNKNOWN) {
                                episode3.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                            }
                            episode3.setNewlyAdded(true);
                            if (StringUtils.isBlank((CharSequence)episode3.getOriginalFilename())) {
                                episode3.setOriginalFilename(mf.getFilename());
                            }
                            if (mf.isDiscFile()) {
                                episode3.setDisc(true);
                                Path discRoot = mf.getFileAsPath().toAbsolutePath();
                                if (!discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                                    discRoot = discRoot.getParent();
                                }
                                episode3.setPath(discRoot.getParent().toString());
                            }
                            if (result.episodes.size() > 1) {
                                episode3.setMultiEpisode(true);
                            } else {
                                episode3.setMultiEpisode(false);
                            }
                            episode3.merge(vsMetaEP);
                            if (xmlEP != null && StringUtils.isNotBlank((CharSequence)xmlEP.getTitle())) {
                                episode3.merge(xmlEP);
                                episode3.setTitle(xmlEP.getTitle());
                            }
                            episode3.saveToDb();
                            tvShow.addEpisode(episode3);
                        }
                        continue;
                    }
                    episode2 = new TvShowEpisode();
                    episode2.setDvdOrder(TvShowModuleManager.getInstance().getSettings().isDvdOrder());
                    episode2.setEpisode(-1);
                    episode2.setSeason(-1);
                    episode2.setPath(mf.getPath());
                    if (mf.isDiscFile()) {
                        episode2.setDisc(true);
                        Path discRoot = mf.getFileAsPath().toAbsolutePath();
                        if (!discRoot.getFileName().toString().matches("(?i)(VIDEO_TS|BDMV|HVDVD_TS)$")) {
                            discRoot = discRoot.getParent();
                        }
                        episode2.setPath(discRoot.getParent().toString());
                    }
                    episode2.setTitle(TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(FilenameUtils.getBaseName((String)mf.getFilename()), tvShow.getTitle()));
                    episode2.setTvShow(tvShow);
                    episode2.setFirstAired(result.date);
                    episode2.addToMediaFiles(epFiles);
                    if (episode2.getMediaSource() == MediaSource.UNKNOWN) {
                        episode2.setMediaSource(MediaSource.parseMediaSource(mf.getFile().toString()));
                    }
                    episode2.setNewlyAdded(true);
                    if (StringUtils.isBlank((CharSequence)episode2.getOriginalFilename())) {
                        episode2.setOriginalFilename(mf.getFilename());
                    }
                    episode2.merge(vsMetaEP);
                    if (xmlEP != null && StringUtils.isNotBlank((CharSequence)xmlEP.getTitle())) {
                        episode2.merge(xmlEP);
                        episode2.setTitle(xmlEP.getTitle());
                    }
                    episode2.saveToDb();
                    tvShow.addEpisode(episode2);
                    continue;
                }
                for (TvShowEpisode episode : episodes) {
                    episode.addToMediaFiles(epFiles);
                    episode.setDisc(mf.isDiscFile());
                    if (episodes.size() > 1) {
                        episode.setMultiEpisode(true);
                    } else {
                        episode.setMultiEpisode(false);
                    }
                    episode.saveToDb();
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            for (MediaFile mf : mfs) {
                if (mf.getType() == MediaFileType.SEASON_POSTER || mf.getType() == MediaFileType.SEASON_FANART || mf.getType() == MediaFileType.SEASON_BANNER || mf.getType() == MediaFileType.SEASON_THUMB) continue;
                String relativePath = this.showDir.relativize(mf.getFileAsPath()).toString();
                TvShowEpisodeAndSeasonParser.EpisodeMatchingResult result = TvShowEpisodeAndSeasonParser.detectEpisodeFromFilenameAlternative(relativePath, tvShow.getTitle());
                if (result.season <= 0 || result.episodes.isEmpty()) continue;
                block22: for (int epnr : result.episodes) {
                    List<TvShowEpisode> eps = tvShow.getEpisode(result.season, epnr);
                    if (eps.size() == 1) {
                        eps.get(0).addToMediaFiles(mf);
                        continue;
                    }
                    if (eps.size() <= 1) continue;
                    for (TvShowEpisode ep : eps) {
                        String episodeBasenameWoStackingMarker = FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(ep.getMainVideoFile().getFilename()));
                        if (FilenameUtils.getBaseName((String)Utils.cleanStackingMarkers(mf.getFilename())).startsWith(episodeBasenameWoStackingMarker)) {
                            ep.addToMediaFiles(mf);
                            continue block22;
                        }
                        if (!episodeBasenameWoStackingMarker.equals(mf.getFileAsPath().getParent().getFileName().toString())) continue;
                        ep.addToMediaFiles(mf);
                        continue block22;
                    }
                }
            }
            mfs.removeAll(tvShow.getEpisodesMediaFiles());
            tvShow.addToMediaFiles(mfs);
            for (MediaFile mf : this.getMediaFiles(mfs, MediaFileType.SEASON_POSTER, MediaFileType.SEASON_FANART, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB)) {
                try {
                    int season;
                    if (mf.getFilename().startsWith("season-specials")) {
                        season = 0;
                    } else if (mf.getFilename().startsWith("season-all")) {
                        season = -1;
                    } else {
                        Matcher matcher = seasonNumber.matcher(mf.getFilename());
                        if (matcher.matches()) {
                            season = Integer.parseInt(matcher.group(1));
                        } else {
                            throw new IllegalStateException("did not find a season number");
                        }
                    }
                    LOGGER.debug("found {} - {}", (Object)mf.getType(), (Object)mf.getFileAsPath());
                    tvShow.setSeasonArtwork(season, mf);
                }
                catch (Exception e) {
                    LOGGER.warn("could not parse season number: {} MF: {}", (Object)e.getMessage(), (Object)mf.getFileAsPath().toAbsolutePath());
                }
            }
            for (TvShowEpisode episode : tvShow.getEpisodes()) {
                episode.reEvaluateDiscfolder();
                episode.reEvaluateStacking();
                episode.saveToDb();
            }
            if (!TvShowModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
                boolean missingTvShowPosters = tvShow.getMediaFiles(MediaFileType.POSTER).isEmpty();
                boolean missingTvShowFanarts = tvShow.getMediaFiles(MediaFileType.FANART).isEmpty();
                for (TvShowEpisode episode : tvShow.getEpisodes()) {
                    boolean ok;
                    List<MediaFile> episodeVsmetas = episode.getMediaFiles(MediaFileType.VSMETA);
                    if (episodeVsmetas.isEmpty()) continue;
                    if (episode.getMediaFiles(MediaFileType.THUMB).isEmpty() && !TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames().isEmpty()) {
                        LOGGER.debug("extracting episode THUMBs from VSMETA for {}", (Object)episode.getMainFile().getFileAsPath());
                        ok = TvShowArtworkHelper.extractArtworkFromVsmeta(episode, episodeVsmetas.get(0), MediaArtwork.MediaArtworkType.THUMB);
                        if (ok) {
                            episode.saveToDb();
                        }
                    }
                    if (missingTvShowFanarts && !TvShowModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                        LOGGER.debug("extracting TV show FANARTs from VSMETA for {}", (Object)episode.getMainFile().getFileAsPath());
                        ok = TvShowArtworkHelper.extractArtworkFromVsmeta(tvShow, episodeVsmetas.get(0), MediaArtwork.MediaArtworkType.BACKGROUND);
                        if (ok) {
                            missingTvShowFanarts = false;
                        }
                    }
                    if (!missingTvShowPosters || TvShowModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) continue;
                    LOGGER.debug("extracting TV show POSTERs from VSMETA for {}", (Object)episode.getMainFile().getFileAsPath());
                    ok = TvShowArtworkHelper.extractArtworkFromVsmeta(tvShow, episodeVsmetas.get(0), MediaArtwork.MediaArtworkType.POSTER);
                    if (!ok) continue;
                    missingTvShowPosters = false;
                }
            }
            tvShow.saveToDb();
            return this.showDir.getFileName().toString();
        }

        private MediaFile getMediaFile(List<MediaFile> mfs, MediaFileType ... types) {
            MediaFile mf = null;
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (!match) continue;
                mf = new MediaFile(mediaFile);
            }
            return mf;
        }

        private List<MediaFile> getMediaFiles(List<MediaFile> mfs, MediaFileType ... types) {
            ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (!match) continue;
                mf.add(new MediaFile(mediaFile));
            }
            return mf;
        }

        private List<MediaFile> getMediaFilesExceptType(List<MediaFile> mfs, MediaFileType ... types) {
            ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
            for (MediaFile mediaFile : mfs) {
                boolean match = false;
                for (MediaFileType type : types) {
                    if (!mediaFile.getType().equals((Object)type)) continue;
                    match = true;
                }
                if (match) continue;
                mf.add(new MediaFile(mediaFile));
            }
            return mf;
        }

        private Set<Path> getAllFilesRecursive(Path path, int deep) {
            Path folder = path.toAbsolutePath();
            AllFilesRecursive visitor = new AllFilesRecursive(TvShowUpdateDatasourceTask.this.skipFolders);
            try {
                Files.walkFileTree(folder, EnumSet.of(FileVisitOption.FOLLOW_LINKS), deep, visitor);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return visitor.fFound;
        }
    }
}

