/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.net.URL;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.config.MediaProviderConfig;

public class MediaProviderInfo {
    private static final URL EMPTY_LOGO = MediaProviderInfo.class.getResource("emtpyLogo.png");
    private final String id;
    private final String subId;
    private final String name;
    private final String description;
    private final URL providerLogo;
    private final MediaProviderConfig config;
    private String version = "";

    public MediaProviderInfo(String id, String subId, String name, String description) {
        this(id, subId, name, description, null);
    }

    public MediaProviderInfo(String id, String subId, String name, String description, URL providerLogo) {
        this.id = id;
        this.subId = subId;
        this.name = name;
        this.description = description;
        this.providerLogo = providerLogo;
        this.config = new MediaProviderConfig(this);
    }

    public String getId() {
        return this.id;
    }

    public String getSubId() {
        return this.subId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProviderLogo() {
        if (this.providerLogo != null) {
            return this.providerLogo;
        }
        return EMPTY_LOGO;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public MediaProviderConfig getConfig() {
        return this.config;
    }
}

