/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.interfaces.IKodiMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSubtitleProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowSubtitleProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;

public class MediaScraper {
    private final IMediaProvider mediaProvider;
    private String id;
    private String version;
    private String name;
    private String summary;
    private String description;
    private URL logoUrl;
    private ScraperType type;

    public MediaScraper(ScraperType type, IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
        this.type = type;
        MediaProviderInfo mpi = mediaProvider.getProviderInfo();
        this.id = mpi.getId();
        this.name = mpi.getName();
        this.version = mpi.getVersion();
        this.description = mpi.getDescription();
        this.summary = mpi.getDescription();
        this.logoUrl = mpi.getProviderLogo();
    }

    public String toString() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScraperType getType() {
        return this.type;
    }

    public void setType(ScraperType type) {
        this.type = type;
    }

    public boolean isActive() {
        if (this.mediaProvider == null) {
            return false;
        }
        return this.mediaProvider.isActive();
    }

    public boolean isEnabled() {
        if (this.mediaProvider == null) {
            return false;
        }
        return this.mediaProvider.isFeatureEnabled();
    }

    public IMediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public URL getLogoURL() {
        return this.logoUrl;
    }

    public static List<MediaScraper> getMediaScrapers(ScraperType type) {
        ArrayList<MediaScraper> scraper = new ArrayList<MediaScraper>();
        ArrayList<? extends IMediaProvider> plugins = new ArrayList<IMediaProvider>();
        Class<? extends IMediaProvider> clazz = MediaScraper.getClassForType(type);
        if (clazz != null) {
            plugins.addAll(MediaProviders.getProvidersForInterface(clazz));
        }
        for (IMediaProvider iMediaProvider : plugins) {
            scraper.add(new MediaScraper(type, iMediaProvider));
        }
        for (IKodiMetadataProvider iKodiMetadataProvider : MediaProviders.getProvidersForInterface(IKodiMetadataProvider.class)) {
            try {
                for (IMediaProvider p : iKodiMetadataProvider.getPluginsForType(MediaType.toMediaType(type.name()))) {
                    scraper.add(new MediaScraper(type, p));
                }
            }
            catch (Exception exception) {
            }
        }
        return scraper;
    }

    public static MediaScraper getMediaScraperById(String id, ScraperType type) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        IMediaProvider mediaProvider = MediaProviders.getProviderById(id, MediaScraper.getClassForType(type));
        if (mediaProvider != null) {
            return new MediaScraper(type, mediaProvider);
        }
        return null;
    }

    private static Class<? extends IMediaProvider> getClassForType(ScraperType type) {
        switch (type) {
            case MOVIE: {
                return IMovieMetadataProvider.class;
            }
            case TV_SHOW: {
                return ITvShowMetadataProvider.class;
            }
            case MOVIE_SET: {
                return IMovieSetMetadataProvider.class;
            }
            case MOVIE_ARTWORK: {
                return IMovieArtworkProvider.class;
            }
            case TVSHOW_ARTWORK: {
                return ITvShowArtworkProvider.class;
            }
            case MOVIE_TRAILER: {
                return IMovieTrailerProvider.class;
            }
            case TVSHOW_TRAILER: {
                return ITvShowTrailerProvider.class;
            }
            case MOVIE_SUBTITLE: {
                return IMovieSubtitleProvider.class;
            }
            case TVSHOW_SUBTITLE: {
                return ITvShowSubtitleProvider.class;
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaScraper other = (MediaScraper)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }
}

