/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.davestrailer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.UrlUtil;

public class DavesTrailerPageProvider
implements IMovieTrailerProvider {
    private static final String ID = "davesTrailer";
    private static final Logger LOGGER = LoggerFactory.getLogger(DavesTrailerPageProvider.class);
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    private MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, "movie_trailer", "davestrailerpage.co.uk", "<html><h3>Dave's Trailer Page</h3>Scraper for Dave's Trailer Page</html>", DavesTrailerPageProvider.class.getResource("/org/tinymediamanager/scraper/daves_trailer_page_logo.jpg"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getTrailers() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        MediaMetadata md = options.getMetadata();
        if (md == null) {
            return Collections.emptyList();
        }
        String title = md.getTitle();
        String firstChar = title.substring(0, 1).toLowerCase(Locale.ROOT);
        String url = firstChar.matches("[xyz]") ? this.getApiKey() + "trailers_xyz.html" : (firstChar.matches("[0-9]") ? this.getApiKey() + "trailers_0to9.html" : this.getApiKey() + "trailers_" + firstChar + ".html");
        try {
            Document doc = UrlUtil.parseDocumentFromUrl(url);
            Element table = doc.select("table").last();
            Elements rows = table.select("tr");
            block3: for (Element row : rows) {
                for (Element anchor : row.getElementsByTag("a")) {
                    if (!anchor.attr("href").contains(options.getImdbId())) continue;
                    Element li = anchor.parent();
                    if (li == null) continue block3;
                    while (li.nextElementSibling() != null) {
                        Element nextLi = li.nextElementSibling();
                        String trailerName = nextLi.select("b").first().text();
                        for (Element trailerAnchor : nextLi.getElementsByTag("a")) {
                            MediaTrailer trailer = new MediaTrailer();
                            trailer.setName(trailerName);
                            trailer.setUrl(trailerAnchor.attr("href"));
                            trailer.setQuality(trailerAnchor.childNode(0).toString());
                            trailer.setProvider(DavesTrailerPageProvider.getProviderFromUrl(trailerAnchor.attr("href")));
                            trailers.add(trailer);
                        }
                        li = nextLi;
                    }
                    continue block3;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("cannot parse Dave's Trailer Page movie: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        return trailers;
    }

    private static String getProviderFromUrl(String url) {
        url = url.toLowerCase(Locale.ROOT);
        String source = "unknown";
        if (url.contains("youtube.com")) {
            source = "youtube";
        } else if (url.contains("apple.com")) {
            source = "apple";
        }
        return source;
    }
}

