/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum CountryCode {
    AU("Australia", "AUS", 36),
    CA("Canada", "CAN", 124),
    CH("Switzerland", "CHE", 756),
    CZ("Czech Republic", "CZE", 203),
    DE("Germany", "DEU", 276),
    DK("Denmark", "DNK", 208),
    EE("Estonia", "EST", 233),
    ES("Spain", "ESP", 724),
    FI("Finland", "FIN", 246),
    FR("France", "FRA", 250),
    GB("United Kingdom", "GBR", 826),
    GR("Greece", "GRC", 300),
    HK("Hong Kong", "HKG", 344),
    HU("Hungary", "HUN", 348),
    IE("Ireland", "IRL", 372),
    IN("India", "IND", 356),
    IS("Iceland", "ISL", 352),
    IT("Italy", "ITA", 380),
    JP("Japan", "JPN", 392),
    MX("Mexico", "MEX", 484),
    NL("Netherlands", "NLD", 528),
    NO("Norway", "NOR", 578),
    NZ("New Zealand", "NZL", 554),
    PL("Poland", "POL", 616),
    PT("Portugal", "PRT", 620),
    RO("Romania", "ROU", 642),
    RU("Russian Federation", "RUS", 643),
    SE("Sweden", "SWE", 752),
    TH("Thailand", "THA", 764),
    US("United States", "USA", 840);

    private static final Map<String, CountryCode> alpha3Map;
    private static final Map<Integer, CountryCode> numericMap;
    private final String name;
    private final String alpha3;
    private final int numeric;
    private final Locale locale;

    private CountryCode(String name, String alpha3, int numeric) {
        this.name = name;
        this.alpha3 = alpha3;
        this.numeric = numeric;
        this.locale = new Locale("", this.name());
    }

    public String getName() {
        return this.name;
    }

    public String getAlpha2() {
        return this.name();
    }

    public String getAlpha3() {
        return this.alpha3;
    }

    public int getNumeric() {
        return this.numeric;
    }

    public static CountryCode getByCode(String code) {
        if (code == null) {
            return null;
        }
        switch (code.length()) {
            case 2: {
                return CountryCode.getByAlpha2Code(code);
            }
            case 3: {
                return CountryCode.getByAlpha3Code(code);
            }
        }
        return null;
    }

    private static CountryCode getByAlpha2Code(String code) {
        try {
            return Enum.valueOf(CountryCode.class, code);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static CountryCode getByAlpha3Code(String code) {
        return alpha3Map.get(code);
    }

    public static CountryCode getByCode(int code) {
        return numericMap.get(code);
    }

    public static CountryCode getDefault() {
        Locale defaultLocale = Locale.getDefault();
        CountryCode countryCode = CountryCode.getByCode(defaultLocale.getCountry());
        if (countryCode == null) {
            countryCode = US;
        }
        return countryCode;
    }

    public String toString() {
        return this.name() + " - " + this.locale.getDisplayCountry();
    }

    static {
        alpha3Map = new HashMap<String, CountryCode>();
        numericMap = new HashMap<Integer, CountryCode>();
        for (CountryCode cc : CountryCode.values()) {
            alpha3Map.put(cc.getAlpha3(), cc);
            numericMap.put(cc.getNumeric(), cc);
        }
    }
}

