/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ffmpeg;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.addon.FFmpegAddon;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.thirdparty.FFmpeg;

abstract class FFmpegArtworkProvider
implements IMediaProvider {
    static final String ID = "ffmpeg";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    FFmpegArtworkProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), ID, "<html><h3>FFmpeg</h3><br />The FFmpeg artwork provider is a meta provider which uses the local FFmpeg installation to extract several stills from your video files</html>", FFmpegArtworkProvider.class.getResource("/org/tinymediamanager/scraper/ffmpeg.svg"));
    }

    @Override
    public String getId() {
        return this.providerInfo.getId();
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getMediaFramework()) || new FFmpegAddon().isAvailable());
    }

    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (Settings.getInstance().isUseInternalMediaFramework() && !new FFmpegAddon().isAvailable()) {
            throw new MissingIdException(new String[]{"FFmpeg"});
        }
        if (!Settings.getInstance().isUseInternalMediaFramework() && StringUtils.isBlank((CharSequence)Settings.getInstance().getMediaFramework())) {
            throw new MissingIdException(new String[]{"FFmpeg"});
        }
        Object mf = options.getIds().get("mediaFile");
        if (!(mf instanceof MediaFile)) {
            throw new ScrapeException(new FileNotFoundException());
        }
        MediaFile mediaFile = (MediaFile)mf;
        if (mediaFile.isISO() || mediaFile.getDuration() == 0) {
            return Collections.emptyList();
        }
        if (mediaFile.isDiscFile()) {
            return this.createStillsFromDiscFiles(mediaFile);
        }
        return this.createStillsFromPlainFile(mediaFile);
    }

    private List<MediaArtwork> createStillsFromPlainFile(MediaFile mediaFile) throws ScrapeException {
        int duration = mediaFile.getDuration();
        int count = this.providerInfo.getConfig().getValueAsInteger("count");
        int start = this.providerInfo.getConfig().getValueAsInteger("start");
        int end = this.providerInfo.getConfig().getValueAsInteger("end");
        if (count <= 0 || start <= 0 || end >= 100 || start > end) {
            throw new ScrapeException(new IllegalArgumentException());
        }
        float increment = (float)(end - start) / (100.0f * (float)count);
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        for (int i = 0; i < count; ++i) {
            int second = (int)((float)duration * ((float)start / 100.0f + (float)i * increment));
            try {
                Path tempFile = Paths.get(Utils.getTempFolder(), "ffmpeg-still." + System.currentTimeMillis() + ".jpg");
                FFmpeg.createStill(mediaFile.getFile(), tempFile, second);
                MediaArtwork still = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                still.addImageSize(mediaFile.getVideoWidth(), mediaFile.getVideoHeight(), "file:/" + tempFile.toAbsolutePath());
                still.setDefaultUrl("file:/" + tempFile.toAbsolutePath());
                still.setOriginalUrl("file:/" + tempFile.toAbsolutePath());
                artworks.add(still);
                continue;
            }
            catch (Exception e) {
                return artworks;
            }
        }
        return artworks;
    }

    private List<MediaArtwork> createStillsFromDiscFiles(MediaFile mediaFile) throws ScrapeException {
        int duration = mediaFile.getDuration();
        int count = this.providerInfo.getConfig().getValueAsInteger("count");
        int start = this.providerInfo.getConfig().getValueAsInteger("start");
        int end = this.providerInfo.getConfig().getValueAsInteger("end");
        if (count <= 0 || start <= 0 || end >= 100 || start > end) {
            throw new ScrapeException(new IllegalArgumentException());
        }
        float increment = (float)(end - start) / (100.0f * (float)count);
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        List<Path> files = MediaFileHelper.getVideoFiles(mediaFile);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        int countPerFile = (int)Math.ceil((double)count / (double)files.size());
        int fileDuration = duration / files.size();
        for (int fileIndex = 0; fileIndex < files.size(); ++fileIndex) {
            Path path = files.get(fileIndex);
            for (int i = 0; i < countPerFile; ++i) {
                int second = (int)((float)fileDuration * ((float)start / 100.0f + (float)i * increment));
                try {
                    Path tempFile = Paths.get(Utils.getTempFolder(), "ffmpeg-still." + System.currentTimeMillis() + ".jpg");
                    FFmpeg.createStill(path, tempFile, second);
                    MediaArtwork still = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                    still.addImageSize(mediaFile.getVideoWidth(), mediaFile.getVideoHeight(), "file:/" + tempFile.toAbsolutePath());
                    still.setDefaultUrl("file:/" + tempFile.toAbsolutePath());
                    still.setOriginalUrl("file:/" + tempFile.toAbsolutePath());
                    artworks.add(still);
                    continue;
                }
                catch (Exception e) {
                    return artworks;
                }
            }
        }
        return artworks;
    }
}

