/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ffmpeg;

import java.util.Collections;
import java.util.List;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.ffmpeg.FFmpegArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;

public class FFmpegMovieArtworkProvider
extends FFmpegArtworkProvider
implements IMovieArtworkProvider {
    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = super.createMediaProviderInfo();
        providerInfo.getConfig().addInteger("start", "", 5);
        providerInfo.getConfig().addInteger("end", "", 95);
        providerInfo.getConfig().addInteger("count", "", 10);
        providerInfo.getConfig().addLabel("type", "");
        providerInfo.getConfig().addBoolean("thumb", "mediafiletype.thumb", true);
        providerInfo.getConfig().addBoolean("fanart", "mediafiletype.fanart", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        if (options.getMediaType() == MediaType.MOVIE_SET || options.getMediaType() == MediaType.TV_SHOW) {
            return Collections.emptyList();
        }
        switch (options.getArtworkType()) {
            case ALL: {
                if (!Boolean.FALSE.equals(this.getProviderInfo().getConfig().getValueAsBool("fanart")) || !Boolean.FALSE.equals(this.getProviderInfo().getConfig().getValueAsBool("thumb"))) break;
                return Collections.emptyList();
            }
            case BACKGROUND: {
                if (!Boolean.FALSE.equals(this.getProviderInfo().getConfig().getValueAsBool("fanart"))) break;
                return Collections.emptyList();
            }
            case THUMB: {
                if (!Boolean.FALSE.equals(this.getProviderInfo().getConfig().getValueAsBool("thumb"))) break;
                return Collections.emptyList();
            }
            default: {
                return Collections.emptyList();
            }
        }
        return super.getArtwork(options);
    }
}

