/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.hdtrailersnet;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.UrlUtil;

public class HdTrailersNetMovieTrailerProvider
implements IMovieTrailerProvider {
    private static final String ID = "hd-trailers";
    private static final Logger LOGGER = LoggerFactory.getLogger(HdTrailersNetMovieTrailerProvider.class);
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    private MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, "movie_trailer", "hd-trailers.net", "<html><h3>hd-trailers.net</h3>Scraper for hd-trailers.net which is able to scrape trailers</html>", HdTrailersNetMovieTrailerProvider.class.getResource("/org/tinymediamanager/scraper/hd-trailers_net.png"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getTrailers() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        MediaMetadata md = options.getMetadata();
        if (md == null || StringUtils.isEmpty((CharSequence)md.getOriginalTitle())) {
            LOGGER.warn("no originalTitle served");
            throw new MissingIdException(new String[]{"originalTitle"});
        }
        String ot = md.getOriginalTitle();
        try {
            String search = this.getApiKey() + ot.replaceAll("[^a-zA-Z0-9]", "-").replace("--", "-").toLowerCase(Locale.ROOT) + "/";
            LOGGER.debug("Guessed HD-Trailers Url: {}", (Object)search);
            Document doc = UrlUtil.parseDocumentFromUrl(search);
            Elements tr = doc.getElementsByAttributeValue("itemprop", "trailer");
            for (Element t : tr) {
                try {
                    String date = t.select("td.bottomTableDate").first().text();
                    String title = t.select("td.bottomTableName > span").first().text();
                    String tr0qual = ((Element)t.select("td.bottomTableResolution > a").get(0)).text();
                    String tr0url = ((Element)t.select("td.bottomTableResolution > a").get(0)).attr("href");
                    MediaTrailer trailer = new MediaTrailer();
                    trailer.setName(title + " (" + date + ")");
                    trailer.setDate(date);
                    trailer.setUrl(tr0url);
                    trailer.setQuality(tr0qual);
                    trailer.setProvider(HdTrailersNetMovieTrailerProvider.getProviderFromUrl(tr0url));
                    LOGGER.trace("found trailer: {}", (Object)trailer);
                    trailers.add(trailer);
                    String tr1qual = ((Element)t.select("td.bottomTableResolution > a").get(1)).text();
                    String tr1url = ((Element)t.select("td.bottomTableResolution > a").get(1)).attr("href");
                    trailer = new MediaTrailer();
                    trailer.setName(title + " (" + date + ")");
                    trailer.setDate(date);
                    trailer.setUrl(tr1url);
                    trailer.setQuality(tr1qual);
                    trailer.setProvider(HdTrailersNetMovieTrailerProvider.getProviderFromUrl(tr1url));
                    LOGGER.debug("found trailer: {}", (Object)trailer);
                    trailers.add(trailer);
                    String tr2qual = ((Element)t.select("td.bottomTableResolution > a").get(2)).text();
                    String tr2url = ((Element)t.select("td.bottomTableResolution > a").get(2)).attr("href");
                    trailer = new MediaTrailer();
                    trailer.setName(title + " (" + date + ")");
                    trailer.setDate(date);
                    trailer.setUrl(tr2url);
                    trailer.setQuality(tr2qual);
                    trailer.setProvider(HdTrailersNetMovieTrailerProvider.getProviderFromUrl(tr2url));
                    LOGGER.debug("found trailer: {}", (Object)trailer);
                    trailers.add(trailer);
                }
                catch (IndexOutOfBoundsException i) {
                    LOGGER.debug("Error parsing HD-Trailers line. Possible missing quality.");
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (HttpException e) {
            LOGGER.debug("could not find a trailer on hd-trailers.net");
        }
        catch (Exception e) {
            LOGGER.debug("cannot parse HD-Trailers movie: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        return trailers;
    }

    private static String getProviderFromUrl(String url) {
        url = url.toLowerCase(Locale.ROOT);
        String source = "unknown";
        if (url.contains("youtube.com")) {
            source = "youtube";
        } else if (url.contains("apple.com")) {
            source = "apple";
        } else if (url.contains("aol.com")) {
            source = "aol";
        } else if (url.contains("yahoo.com")) {
            source = "yahoo";
        } else if (url.contains("hd-trailers.net")) {
            source = "hdtrailers";
        } else if (url.contains("moviefone.com")) {
            source = "moviefone";
        } else if (url.contains("mtv.com")) {
            source = "mtv";
        } else if (url.contains("ign.com")) {
            source = "ign";
        }
        return source;
    }
}

