/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.Headers;
import org.apache.commons.io.IOUtils;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.Pair;

public class InMemoryCachedUrl
extends Url {
    public static final CacheMap<CachedRequest, CachedResponse> CACHE = new CacheMap(60L, 10L);

    public InMemoryCachedUrl(String url) throws MalformedURLException {
        this.url = url;
        if (url.contains("|")) {
            this.splitHeadersFromUrl();
        }
        try {
            this.uri = this.morphStringToUri(url);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(url);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, InterruptedException {
        CachedRequest cachedRequest = new CachedRequest(this.url, this.headersRequest);
        CachedResponse cachedResponse = CACHE.get(cachedRequest);
        if (cachedResponse == null) {
            Url url = new Url(this.url);
            url.headersRequest = this.headersRequest;
            try (InputStream is = url.getInputStream();
                 ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                 GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
                if (is == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                IOUtils.copy((InputStream)is, (OutputStream)gzip);
                gzip.finish();
                cachedResponse = new CachedResponse(url, outputStream.toByteArray());
                if (url.responseCode >= 200 && url.responseCode < 300) {
                    CACHE.put(cachedRequest, cachedResponse);
                }
            }
        }
        this.responseCode = cachedResponse.responseCode;
        this.responseMessage = cachedResponse.responseMessage;
        this.responseCharset = cachedResponse.responseCharset;
        this.responseContentType = cachedResponse.responseContentType;
        this.responseContentLength = cachedResponse.responseContentLength;
        this.headersResponse = cachedResponse.headersResponse;
        this.headersRequest.addAll(cachedResponse.headersRequest);
        return new GZIPInputStream(new ByteArrayInputStream(cachedResponse.content));
    }

    public static void clearCache() {
        CACHE.cleanup(true);
    }

    public boolean isCached() {
        CachedRequest cachedRequest = new CachedRequest(this.url, this.headersRequest);
        return CACHE.get(cachedRequest) != null;
    }

    private static class CachedResponse {
        final byte[] content;
        final int responseCode;
        final String responseMessage;
        final Charset responseCharset;
        final String responseContentType;
        final long responseContentLength;
        final Headers headersResponse;
        final List<Pair<String, String>> headersRequest = new ArrayList<Pair<String, String>>();

        CachedResponse(Url url, byte[] content) {
            this.content = content;
            this.responseCode = url.responseCode;
            this.responseMessage = url.responseMessage;
            this.responseCharset = url.responseCharset;
            this.responseContentType = url.responseContentType;
            this.responseContentLength = url.responseContentLength;
            this.headersResponse = url.headersResponse;
            this.headersRequest.addAll(url.headersRequest);
        }
    }

    private static class CachedRequest {
        final String url;
        final List<Pair<String, String>> headersRequest;

        public CachedRequest(String url, List<Pair<String, String>> headersRequest) {
            this.url = url;
            this.headersRequest = headersRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedRequest that = (CachedRequest)o;
            return this.url.equals(that.url) && this.headersRequest.equals(that.headersRequest);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.headersRequest);
        }
    }
}

