/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmmHttpLoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmHttpLoggingInterceptor.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        block36: {
            Request request = chain.request();
            try {
                RequestBody requestBody = request.body();
                boolean hasRequestBody = requestBody != null;
                Connection connection = chain.connection();
                String requestStartMessage = "--> " + request.method() + " " + request.url() + (String)(connection != null ? " " + connection.protocol() : "");
                LOGGER.trace(requestStartMessage);
                if (hasRequestBody) {
                    if (requestBody.contentType() != null) {
                        LOGGER.trace("Content-Type: {}", (Object)requestBody.contentType());
                    }
                    if (requestBody.contentLength() != -1L) {
                        LOGGER.trace("Content-Length: {}", (Object)requestBody.contentLength());
                    }
                }
                Headers headersRequest = request.headers();
                int count = headersRequest.size();
                for (int i = 0; i < count; ++i) {
                    String name = headersRequest.name(i);
                    if ("Content-Type".equalsIgnoreCase(name) || "Content-Length".equalsIgnoreCase(name)) continue;
                    LOGGER.trace("{} : {}", (Object)headersRequest.name(i), (Object)headersRequest.value(i));
                }
                if (!hasRequestBody || TmmHttpLoggingInterceptor.bodyHasUnknownEncoding(request.headers())) {
                    LOGGER.trace("--> END {}", (Object)request.method());
                } else {
                    Buffer buffer = new Buffer();
                    requestBody.writeTo((BufferedSink)buffer);
                    Charset charset = UTF8;
                    MediaType contentType = requestBody.contentType();
                    if (contentType != null) {
                        charset = contentType.charset(UTF8);
                    }
                    LOGGER.trace("");
                    if (TmmHttpLoggingInterceptor.isPlaintext(buffer)) {
                        String content = buffer.readString(charset);
                        if (content.length() > 1000) {
                            LOGGER.trace("{}...", (Object)content.substring(0, 1000));
                        } else {
                            LOGGER.trace(content);
                        }
                        LOGGER.trace("--> END {} ({}-byte body)", (Object)request.method(), (Object)requestBody.contentLength());
                    } else {
                        LOGGER.trace("--> END {}", (Object)request.method());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Problem in HTTP logging detected: {}", (Object)e.getMessage());
            }
            long startNs = System.nanoTime();
            try {
                response = chain.proceed(request);
            }
            catch (Exception e) {
                LOGGER.trace("<-- HTTP FAILED: {}", (Object)e.getMessage());
                throw e;
            }
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            try (Buffer buffer = null;){
                ResponseBody responseBody = response.body();
                long contentLength = responseBody.contentLength();
                Object bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
                String logUrl = response.request().url().toString().replaceAll("api_key=\\w+", "api_key=<API_KEY>").replaceAll("api/\\d+\\w+", "api/<API_KEY>").replaceAll("apikey=\\w+", "apikey=<API_KEY>");
                LOGGER.debug("<-- " + response.code() + (String)(response.message().isEmpty() ? "" : " " + response.message()) + " " + logUrl + " (" + tookMs + "ms, " + (String)bodySize + " body)");
                Headers headersResponse = response.headers();
                int count = headersResponse.size();
                for (int i = 0; i < count; ++i) {
                    LOGGER.trace("{} : {}", (Object)headersResponse.name(i), (Object)headersResponse.value(i));
                }
                if (!HttpHeaders.hasBody((Response)response) || TmmHttpLoggingInterceptor.bodyHasUnknownEncoding(response.headers())) {
                    LOGGER.trace("<-- END HTTP");
                    break block36;
                }
                if (!TmmHttpLoggingInterceptor.isTextResponse(response)) break block36;
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                buffer = source.buffer();
                Long gzippedLength = null;
                if ("gzip".equalsIgnoreCase(headersResponse.get("Content-Encoding"))) {
                    gzippedLength = buffer.size();
                    try (GzipSource gzippedResponseBody = null;){
                        gzippedResponseBody = new GzipSource((Source)buffer.clone());
                        buffer = new Buffer();
                        buffer.writeAll((Source)gzippedResponseBody);
                    }
                }
                Charset charset = UTF8;
                MediaType contentType = responseBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(UTF8);
                }
                if (!TmmHttpLoggingInterceptor.isPlaintext(buffer)) {
                    LOGGER.trace("");
                    LOGGER.trace("<-- END HTTP (binary {}-byte body omitted)", (Object)buffer.size());
                    Response response2 = response;
                    return response2;
                }
                if (contentLength != 0L) {
                    LOGGER.trace("");
                    String content = buffer.clone().readString(charset);
                    if (content.length() > 10000) {
                        LOGGER.trace("{}...", (Object)content.substring(0, 10000));
                    } else {
                        LOGGER.trace(content);
                    }
                }
                if (gzippedLength != null) {
                    LOGGER.trace("<-- END HTTP ({}-byte, {}-gzipped-byte body)", (Object)buffer.size(), (Object)gzippedLength);
                } else {
                    LOGGER.trace("<-- END HTTP ({}-byte body)", (Object)buffer.size());
                }
            }
        }
        return response;
    }

    private static boolean bodyHasUnknownEncoding(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !contentEncoding.equalsIgnoreCase("identity") && !contentEncoding.equalsIgnoreCase("gzip");
    }

    private static boolean isTextResponse(Response response) {
        MediaType type = response.body().contentType();
        switch (type.subtype().toLowerCase(Locale.ROOT)) {
            case "json": 
            case "xml": {
                return true;
            }
        }
        return false;
    }

    static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }
}

